/***************************************************************
 File:		ShramErrorHand.c
 Module:	  	Shram
 Purpose: 	Allocation of required Error Handler variables on Shram
 Description:  holds the allocation in memory of the error handler related variables 
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramErrorHandler.h"
#include "shram.h"

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
MAP_TO_SECTION(bss, ".SHARED_RAM_ERROR_HANDLER")
FW_CORE_CONTROL_DESCRIPTOR u32FwCoreControlDesc;
ErrorHandleEventDetails_t  ErrorHandler_EventDetails[MAX_NUM_OF_FW_CORES];
CoreNum_e errorHandlerTriggerCore;


bool	ErrorHandlerLm0InAssert;
#ifdef ENET_INC_ARCH_WAVE600
bool	ErrorHandlerLm1InAssert;
K_MSG	lastKmsgUM;
K_MSG	lastKmsgLM0;
K_MSG	lastKmsgLM1;

#endif
MAP_TO_DEFAULT_SECTION(bss)


