/***************************************************************
 File:		ShramGenriscMailboxes.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the  Tx sender, Rx Handler and Host interface - FW interface structures 
 Description:  This file contains the allocation of the  Tx sender, Rx Handler and Host interface- FW interface structures
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramGenRiscMailboxes.h"
#include "HostInterface_MailboxApi.h"
#include "RxHandler_MailboxApi.h"
#include "TxSender_MailboxApi.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#ifdef ENET_INC_ARCH_WAVE600

MAP_TO_SECTION(bss, ".SHARED_RAM_GENRISC_MAILBOXES")

// Mailboxes for band 0
uint32 FwRxHandlerMailboxFifoInBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwRxHandlerMailboxFifoOutBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

uint32 FwTxSenderMailboxFifoInBuffer[FW_GENRISC_TX_SENDER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwTxSenderMailboxFifoOutBuffer[FW_GENRISC_TX_SENDER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

uint32 FwHostGenRiscInterfaceMailboxFifoInBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwHostGenRiscInterfaceMailboxFifoOutBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_GENRISC_MAILBOXES_B1")

// Mailboxes for band 1
uint32 FwRxHandlerMailboxFifoInBuffer_B1[FW_GENRISC_RX_HANDLER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwRxHandlerMailboxFifoOutBuffer_B1[FW_GENRISC_RX_HANDLER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

uint32 FwTxSenderMailboxFifoInBuffer_B1[FW_GENRISC_TX_SENDER_MAILBOX_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwTxSenderMailboxFifoOutBuffer_B1[FW_GENRISC_TX_SENDER_MAILBOX_OUT_BUFFER_SIZE_IN_WORDS];

MAP_TO_DEFAULT_SECTION(bss)

#else // not wave600

MAP_TO_SECTION(bss, ".SHARED_RAM_GENRISC_MAILBOXES")

#ifdef FW_RX_HANDLER_MAILBOX_0_ENABLED
uint32 FwRxHandlerMailbox0FifoInBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwRxHandlerMailbox0FifoOutBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_RX_HANDLER_MAILBOX_1_ENABLED
uint32 FwRxHandlerMailbox1FifoInBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwRxHandlerMailbox1FifoOutBuffer[FW_GENRISC_RX_HANDLER_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_TX_SENDER_MAILBOX_0_ENABLED
uint32 FwTxSenderMailbox0FifoInBuffer[FW_GENRISC_TX_SENDER_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwTxSenderMailbox0FifoOutBuffer[FW_GENRISC_TX_SENDER_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_TX_SENDER_MAILBOX_1_ENABLED
uint32 FwTxSenderMailbox1FifoInBuffer[FW_GENRISC_TX_SENDER_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwTxSenderMailbox1FifoOutBuffer[FW_GENRISC_TX_SENDER_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_HOST_INTERFACE_MAILBOX_0_ENABLED
uint32 FwHostGenRiscInterfaceMailbox0FifoInBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_0_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwHostGenRiscInterfaceMailbox0FifoOutBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_0_OUT_BUFFER_SIZE_IN_WORDS];
#endif

#ifdef FW_HOST_INTERFACE_MAILBOX_1_ENABLED
uint32 FwHostGenRiscInterfaceMailbox1FifoInBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_1_IN_BUFFER_SIZE_IN_WORDS];
uint32 FwHostGenRiscInterfaceMailbox1FifoOutBuffer[FW_GENRISC_HOST_INTERFACE_MAILBOX_1_OUT_BUFFER_SIZE_IN_WORDS];
#endif

MAP_TO_DEFAULT_SECTION(bss)

#endif //ENET_INC_ARCH_WAVE600


