/***************************************************************
 File:		ShramHim.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory Him fifo's
 Description:  This file contains the shram allocation allocation of the  Host Interface 
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "mhi_umi_propr.h"
#include "ShramHim.h"


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
PRAGMA_START_DATA
MAP_TO_SECTION(bss, ".SHARED_RAM_NEW_DELIA_RECIPES_B1")
SHRAM_MAN_MSG asHIMmanReqSecured[NUM_MAN_REQS];
SHRAM_DBG_MSG asHIMdbgReqSecured[NUM_DBG_REQS];
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_DRIVER_INTERFACE")

/* Message pools used by the Host for Request messages. */
SHRAM_MAN_MSG asHIMmanReq[NUM_MAN_REQS];
SHRAM_BSS_REQ_MSG asHIMBssReq[NUM_BSS_REQS];
SHRAM_DBG_MSG asHIMdbgReq[NUM_DBG_REQS];
SHRAM_DBG_MSG asHIMdbgInd[NUM_DBG_INDS];

/* Buffer descriptor of dat ind */
RXDAT_IND_MSG_DESC asHIMdatIndDesc[NUM_DAT_INDS];

/* Buffer descriptor of BSS ind */
 RX_BSS_IND_MSG_DESC asHIMBssIndDesc[NUM_BSS_INDS]; 

/* UMI BSS indications */
SHRAM_IND_MSG asMAN_IndData[NUM_MAN_INDS];  

/* Areas for message passing. */
uint32  au32FIFOReqResQ[HIM_CIRCULAR_BUFFER_SIZE];  /* Host to HIM queue */
uint32  au32FIFOCfmIndQ[HIM_CIRCULAR_BUFFER_SIZE];  /* HIM to Host queue */

/*
 * Initialisation vectors - on target these are overlayed onto the base
 * address of shared RAM i.e. the circular buffer.
 */

#if defined (ENET_CFG_ALLOC_SEPARATE_FORWARD_POOL)
uint8 au8ApFwdPayload[MSDU_MAX_LENGTH * ENET_AP_FORWARD_POOL_SIZE]; /* variable length */
#endif

uint32  loggerActiveMode;  // LogAgentStateActive_e


MAP_TO_DEFAULT_SECTION(bss)
PRAGMA_END_DATA
