/***************************************************************
 File:		ShramVapDatabase.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the Vap database 
 Description:  This file contains the allocation of the Vap database block
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "linkAdaptation_api.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "TxSequencerReport_Descriptors.h"
#endif //ENET_INC_ARCH_WAVE600

#if !defined (ENET_INC_ARCH_WAVE600)
#include "TxSequencer_Api.h"
#endif //#if !defined (ENET_INC_ARCH_WAVE600)


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#if defined (ENET_INC_ARCH_WAVE600)
MAP_TO_SECTION(bss, ".SHARED_RAM_TX_SEQUENCER_DATA_BASE")
TxSequencerReport_t SequencerFifoReport[MAX_TX_SEQUENCER_FIFO_SIZE]; 
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_TX_SEQUENCER_DATA_BASE_B1")
TxSequencerReport_t SequencerFifoReport_B1[MAX_TX_SEQUENCER_FIFO_SIZE];
MAP_TO_DEFAULT_SECTION(bss)
#endif //ENET_INC_ARCH_WAVE600

#if !defined (ENET_INC_ARCH_WAVE600)

MAP_TO_SECTION(bss, ".SHARED_RAM_TX_SEQUENCER_DATA_BASE")
SequencerTxReport_t SequencerFifoReport[MAX_TX_SEQUENCER_FIFO_SIZE]; 
MAP_TO_DEFAULT_SECTION(bss)

#endif //#if !defined (ENET_INC_ARCH_WAVE600)



