/***************************************************************
 File:		ShramNewDeliaRecipes.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the new Delia recipes 
 Description:  This file contains the allocation of the new Delia recipes
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramNewDeliaRecipes.h"
#include "DeliaRecipes.h" //patch till the files of the shram are changed
#include "VapDb.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

MAP_TO_SECTION(bss, ".SHARED_RAM_NEW_DELIA_RECIPES")

#if defined (ENET_INC_ARCH_WAVE600)

DeliaRecipes_t DeliaRecipes;
Tcr_t DeliaAutoResponseTcrs;
#if defined (ENET_INC_ARCH_WAVE600B)
SuTcrs_t MbfmTcrs; //this address must be word aligned - we get it now since all the structs above are word-aligned
#endif //ENET_INC_ARCH_WAVE600B
#else

uint32 DeliaRecipe0[DELIA_INSTRUCTION_LEGACY_VHT_LAST_COMMAND];
uint32 DeliaRecipesLookupTable[DELIA_RECIPE_LOOKUP_TABLE_SIZE];
uint32 DeliaRecipeAck[DELIA_INSTRUCTION_ACK_LAST_COMMAND];
uint32 DeliaRecipeBa[DELIA_INSTRUCTION_BA_LAST_COMMAND];
uint32 DeliaRecipeCtsAutoResponse[DELIA_INSTRUCTION_CTS_AUTO_RESPONSE_LAST_COMMAND];
uint32 DeliaRecipeBfReport[DELIA_INSTRUCTION_BF_REPORT_LAST_COMMAND];
Tcr0_t DeliaAutoResponseTcr0;
Tcr2_t DeliaAutoResponseTcr2;
Tcr2_t DeliaAutoResponseCtsTcr2;

#endif //ENET_INC_ARCH_WAVE600

MAP_TO_DEFAULT_SECTION(bss)

#if defined (ENET_INC_ARCH_WAVE600)

MAP_TO_SECTION(bss, ".SHARED_RAM_NEW_DELIA_RECIPES_B1")
DeliaRecipes_t DeliaRecipes_B1;
Tcr_t DeliaAutoResponseTcrs_B1;
#if defined (ENET_INC_ARCH_WAVE600B)
SuTcrs_t MbfmTcrs_B1; //this address must be word aligned - we get it now since all the structs above are word-aligned
#endif //ENET_INC_ARCH_WAVE600B

MAP_TO_DEFAULT_SECTION(bss)

#endif //ENET_INC_ARCH_WAVE600





