/***************************************************************
 File:		ShramPhyStatDb.c
 Module:	  	Shram
 Purpose: 	holds the declerations of shram phy stat DB
 Description:  This file contains the allocation of the phy stat DB
			 structure in the SHRAM
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "ShramPhyStatDb.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "PacExtrapolator_api.h"
#endif
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
MAP_TO_SECTION(bss, ".SHARED_RAM_PHY_STAT_DB")
#if !defined (ENET_INC_ARCH_WAVE600)

#ifdef CPU_MIPS
#pragma alignvar (4)
#endif
// TBD CDB - in CDB do we need this duplicated? 

uint32 phyMetricFifo[SIZE_OF_METRICS_FIFO*PHY_STATUS_NUMBER_OF_WORDS + 2/*read and write counters */];

#ifdef CPU_ARC
#pragma Align_to(4,phyMetricFifo)
#endif

#endif

wholePhyRxStatusDb_t phyRxStatusDb;

#if defined (ENET_INC_ARCH_WAVE600)
AlphaFilterStatistics_t 			pacExtrapolatorRssi;
pacExtrapolator_AlphaFactorWlan_t 	pacExtrapolatorAlphaFactorWlan;
pacExtrapolator_AlphaFactorSta_t 	pacExtrapolatorAlphaFactorSta;
pacExtrapolator_LnBetaValue_t 		pacExtrapolatorLnBetaValue;	



#endif

MAP_TO_DEFAULT_SECTION(bss)

