/***************************************************************
 File:		ShramPsManager.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the  PsSettings Hw module Fifo 
 Description:  This file contains the allocation in memory of the  PsSettings Hw module Fifo
 			in the SHRAM
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramPsManager.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "PsSettingFifoShram_Descriptors.h"
#endif //ENET_INC_ARCH_WAVE600
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
#if !defined (ENET_INC_ARCH_WAVE600)
MAP_TO_SECTION(bss, ".SHARED_RAM_PS_SETTINGS")
PsManagerStatusFifoEntry_t PsManagerStatusFifo[PS_MANAGER_STATUS_FIFO_SIZE];
MAP_TO_DEFAULT_SECTION(bss)

#else

MAP_TO_SECTION(bss, ".SHARED_RAM_PS_SETTINGS")
PsSettingFifoShram_t PsManagerStatusFifo[PS_MANAGER_STATUS_FIFO_SIZE];
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_PS_SETTINGS_B1")
PsSettingFifoShram_t PsManagerStatusFifo_B1[PS_MANAGER_STATUS_FIFO_SIZE];
MAP_TO_DEFAULT_SECTION(bss)
#endif



