/***************************************************************
 File:		ShramRxDescriptors.c
 Module:	Shram
 Purpose: 	holds the declerations of the Rx descriptors pools sections
 Description:  This file contains the allocation of the Rx descriptors pools
 			   section in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RxDescriptor.h"
#include "ShramRxDescriptors.h"
#include "HwQManager_API.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

// In Gen5 those pools are actually in SHRAM. In gen4 it should be in the IRAM/DDR
// In Gen6 those pools are in the Descriptors RAM (it's only called SHRAM for backward compatability with Gen5/4).
MAP_TO_SECTION(bss, ".SHARED_RAM_RX_DESCRIPTORS")

Rd_t  FwRxDescriptorsPool[NUM_OF_FW_RX_DESCRIPTORS];
Rd_t  HostRxDescriptorsPool[NUM_OF_HOST_RX_DESCRIPTORS]; //initiate it in order to map it to data section 
Rd_t  DummyRxDescriptorsPool[NUM_OF_DUMMY_RX_DESCRIPTORS];

MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_TEST_BUS")

#if defined (ENET_INC_ARCH_WAVE600)
#ifndef	ENET_INC_HW_FPGA
b0RxTxMpduDesc_u B0_MpduDescriptorsDump;
b1RxTxMpduDesc_u B1_MpduDescriptorsDump;
#endif
#endif

MAP_TO_DEFAULT_SECTION(bss)



