/***************************************************************
 File:		ShramRxDescriptorsPayload.c
 Module:	Shram
 Purpose: 	holds the declerations of FW Rx descriptors payload section 
 Description:  This file contains the allocation of the FW Rx descriptors payload
 			   section in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramRxDescriptorsPayload.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

MAP_TO_SECTION(bss, ".SHARED_RAM_FW_RX_DESCRIPTORS_PAYLOAD")
uint8 FwRxDescriptorsPayload[NUM_OF_FW_RX_DESCRIPTORS][FW_RD_PAYLOAD_SIZE];
#ifdef CPU_ARC
#pragma Align_to(16,FwRxDescriptorsPayload)
#endif
MAP_TO_DEFAULT_SECTION(bss)



