/***************************************************************
 File:		ShramRxH.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the  RxH - FW interface structures 
 Description:  This file contains the allocation of the  RxH - FW interface structures
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RxHandler_InitApi.h"
#include "RxHandler_SnifferApi.h"
#include "RxManager_Api.h"
#include "ShramRxH.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "RxhGenriscInitVector_Descriptors.h"
#endif
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

// Init vector for band0 (or gen5)
MAP_TO_SECTION(bss, ".SHARED_RAM_MAC_GENRISC_INIT_VECTORS")
#if defined (ENET_INC_ARCH_WAVE600)
volatile RxhGenriscInitVector_t RxhInitializationStructure;
#else
volatile RxHParams_t RxhInitializationStructure; 
#endif 
MAP_TO_DEFAULT_SECTION(bss)

// Init vector for band 1
#if defined (ENET_INC_ARCH_WAVE600)
MAP_TO_SECTION(bss, ".SHARED_RAM_MAC_GENRISC_INIT_VECTORS_B1")
volatile RxhGenriscInitVector_t RxhInitializationStructure_B1; 
MAP_TO_DEFAULT_SECTION(bss)
#endif

#if defined (CLIENT_MODE_MULTICAST_FILTER_SUPPORT)
// Multicast filter ring for STA mode. Not supported in Gen6 yet.
MAP_TO_SECTION(bss, ".SHARED_RAM_CLIENT_MODE_MCAST_FILTER")
clientModeMcastFilterRingElement_t clientModeMcastFilterRing[CLIENT_MODE_MCAST_FILTER_RING_SIZE];/* Defines the ring between RX Handler and RX Manager used to filter localy originated MCAST packets */
MAP_TO_DEFAULT_SECTION(bss)
#endif // defined (CLIENT_MODE_MULTICAST_FILTER_SUPPORT)


#if !defined (ENET_INC_ARCH_WAVE600)
// Sniffer params for gen5
MAP_TO_SECTION(bss, ".SHARED_RAM_RXHSNIFFER")
FwRxHandlerSnifferParams_t RxhSnifferParams;
MAP_TO_DEFAULT_SECTION(bss)
#endif //!defined (ENET_INC_ARCH_WAVE600)


#if defined (ENET_INC_ARCH_WAVE600)
// Ring of headers for band 0 (sniffer)
MAP_TO_SECTION(bss, ".SHARED_RAM_SNIFFER_HDR_RING")
uint8  snifferHdrTemplatesRing[SNIFFER_TEMPLATE_RING_NUM_OF_ENTRIES][SNIFFER_HDR_TEMPLATE_SIZE_IN_BYTES]; // TBD CDB - what about band 1? Is it needed?
MAP_TO_DEFAULT_SECTION(bss)
#endif

#if defined (ENET_INC_ARCH_WAVE600) && defined (SNIFFER_MU_ENABLED)
// Trigger frame params (sniffer)
MAP_TO_SECTION(bss, ".SHARED_RAM_SNIFFER_TRIGGER_FRAME_PARAMS")
snifferTriggerFrameParams_t	   snifferTriggerFrameParams;
MAP_TO_DEFAULT_SECTION(bss)
#endif //#if defined (ENET_INC_ARCH_WAVE600) && defined (SNIFFER_MU_ENABLED)

