/***************************************************************
 File:		ShramRxfFifo.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of Rxf fifo.
 			Fifo line indicates recive of an A-MPDU frame with no BA agreement open.
 Description:  This file contains the allocation of the RXF fifo block
 			in the SHRAM (Or in Iram for Gen4)
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramRxfFifo.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

MAP_TO_SECTION(bss, ".SHARED_RAM_RXF_A_MPDU_NO_BA_AGGREMENT_FIFO")
RegRxfFifoLine_u RxfAmpduNoBaAggrementFifo[RXF_FIFO_AMPDU_NO_BA_AGGREMENT_DEPTH];
MAP_TO_DEFAULT_SECTION(bss)

#if defined (ENET_INC_ARCH_WAVE600)
MAP_TO_SECTION(bss, ".SHARED_RAM_RXF_A_MPDU_NO_BA_AGGREMENT_FIFO_B1")
RegRxfFifoLine_u RxfAmpduNoBaAggrementFifo_B1[RXF_FIFO_AMPDU_NO_BA_AGGREMENT_DEPTH];
MAP_TO_DEFAULT_SECTION(bss)
#endif




