/***************************************************************
 File:		ShramSender.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the  sender - FW interface structures 
 Description:  This file contains the allocation of the  sender - FW interface structures
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramSecurity.h"



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/


#ifndef ENET_INC_ARCH_WAVE600 // In gen6 there are no SCPAD for Muted header and there are no security dscriptors

MAP_TO_SECTION(bss, ".SHARED_RAM_SECURITY_NEW")

volatile SecurityDescriptor_t txSecurityDescriptors[4][NUMBER_OF_TX_SECURITY_DESCRIPTOR];

// Scratch pad for AAD for CCMP should be 4 bytes aligned.
uint8 mutedHeaderScratchPad[4][ALIGN4(CCMP_AAD_MAX_LENGTH)];

MAP_TO_DEFAULT_SECTION(bss)

#endif


MAP_TO_SECTION(bss, ".SHARED_RAM_SECURITY")

#ifndef ENET_INC_ARCH_WAVE600 // In gen6 there are no security dscriptors
volatile SecurityDescriptor_t rxSecurityDescriptors[NUMBER_OF_RX_SECURITY_DESCRIPTOR];
#endif
/* Security Keys database holds the 4 key values for every station */
KeyValuesEntry KeysDatabase[HW_NUM_OF_VAPS + HW_NUM_OF_STATIONS];

// DB for handling TKIP fragments. needed by security HW.
uint8 tkipFragmentDb[HW_NUM_OF_STATIONS * SIZE_OF_TKIP_FRAGMENT_DB_ENTRY];

MAP_TO_DEFAULT_SECTION(bss)



