/***************************************************************
 File:		ShramSender.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the  sender - FW interface structures 
 Description:  This file contains the allocation of the  sender - FW interface structures
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramSender.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

#if defined (ENET_INC_ARCH_WAVE600)

MAP_TO_SECTION(bss, ".SHARED_RAM_MAC_GENRISC_INIT_VECTORS")
volatile TxSenderInitVector_t SenderInitializationStructure; 
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_MAC_GENRISC_INIT_VECTORS_B1")
volatile TxSenderInitVector_t SenderInitializationStructure_B1; 
MAP_TO_DEFAULT_SECTION(bss)

#else

MAP_TO_SECTION(bss, ".SHARED_RAM_MAC_GENRISC_INIT_VECTORS")
volatile SenderInterfaceParams_t SenderInitializationStructure; 
MAP_TO_DEFAULT_SECTION(bss)

#endif //ENET_INC_ARCH_WAVE600



