/***************************************************************
 File:		ShramStationDatabase.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the station database 
 Description:  This file contains the allocation of the station database block
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramStationDatabase.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

// In Gen5 the hw STA DB is actually in SHRAM. In gen4 it should be in the IRAM/DDR
MAP_TO_SECTION(bss, ".SHARED_RAM_STATION_DATA_BASE")

StaDb_t StaDbHwEntries[HW_NUM_OF_STATIONS];

MAP_TO_DEFAULT_SECTION(bss)



