/***************************************************************
 File:		ShramStatistics.c
 Module:	  	Shram
 Purpose: 	holds the declerations of shram statistics buffer
 Description:  This file contains the allocation of the shram
			 statistics buffer which is used for DMA
***************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "ShramStatistics.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

MAP_TO_SECTION(bss, ".SHARED_RAM_STATISTIC_MANAGER")
#ifdef CPU_MIPS
#pragma alignvar (4)
#endif

uint8 StatisticsShramBuffer[STATISTICS_MANAGER_SHRAM_BUFFER_SIZE]; // Temporery buffer in Shared ram, use as a middle-man to copy Iram\HW to Host.

#ifdef CPU_ARC
#pragma Align_to(4,StatisticsShramBuffer)
#endif

MAP_TO_DEFAULT_SECTION(bss)


MAP_TO_SECTION(bss, ".SHARED_RAM_STATISTIC_MANAGER")

DynamicBwStatistics_t DynamicBwStatistics;

#ifdef ENET_INC_ARCH_WAVE600
uint32 CyclicBufferOverflowCounter[GEN6_NUM_OF_BANDS];
#else
uint32 CyclicBufferOverflowCounter;
#endif

/*Link Adaptation needs to update these two error counters based on the BAA report*/
uint32 LinkAdaptationVapFrameErrorCountBaseAddress;
uint32 LinkAdaptationWlanFrameErrorCountBaseAddress;

LinkAdaptationStatistics_t LinkAdaptationStatistics;			   	// Link Adaptation statistics
LinkAdaptationMuStatistics_t LinkAdaptationMuStatistics;			// Link Adaptation Mu statistics

PerClientStatistics_t PerClientStatistics;			   				// per client statistics



#ifdef CPU_ARC
#pragma Align_to(4,LinkAdaptationStatistics)
#endif

MAP_TO_DEFAULT_SECTION(bss)

