/***************************************************************
 File:		ShramStd.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the Std 
 Description:  This file contains the allocation of the Std structure
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramStd.h"
#include "Std.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#ifndef ENET_INC_ARCH_WAVE600
#define STD_OFFSET_FROM_SENDER_SCPAD_START  0x300
#endif //ENET_INC_ARCH_WAVE600

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/


MAP_TO_SECTION(bss, ".GENRISC_TX_STD")
#ifdef ENET_INC_ARCH_WAVE600

#else

uint32 StdOffset[STD_OFFSET_FROM_SENDER_SCPAD_START];
Std_t Std;

#endif //ENET_INC_ARCH_WAVE600

MAP_TO_DEFAULT_SECTION(bss)


