/***************************************************************
 File:		ShramTxHandlerTimingParams.c
 Module:	  	Shram
 Purpose: 	holds the declerations the Tx handler timing parameters section
 Description:  This file contains the allocation of the Tx handler timing parameters structure
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramTxHandlerTimingParams.h"
#include "HwGlobalDefinitions.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/

MAP_TO_SECTION(bss, ".TX_HANDLER_TIMING_PARAMS")
HwAcTimingParams_t HwVapsAcsTimingParameters[HW_NUM_OF_VAPS][HW_AC_NUM_OF_PRIORITIES];
MAP_TO_DEFAULT_SECTION(bss)

#if defined (ENET_INC_ARCH_WAVE600)
MAP_TO_SECTION(bss, ".TX_HANDLER_TIMING_PARAMS_B1")
HwAcTimingParams_t HwVapsAcsTimingParameters_B1[HW_NUM_OF_VAPS][HW_AC_NUM_OF_PRIORITIES];
MAP_TO_DEFAULT_SECTION(bss)
#endif



