
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "System_Information.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "OSAL_Api.h"
#include "HostInterface_API.h"
#include "SenderInterface_Api.h"
#include "shram_interruptSection.h"
#include "SharedDbTypes.h"
#include "stringLibApi.h"
#include "MacRabRegs.h"
#include "RegAccess_Api.h"
#include "Utils_Api.h"

#define LOG_LOCAL_GID GLOBAL_GID_SHARED_RAM 
#define LOG_LOCAL_FID 0

MAP_TO_SECTION(bss, ".SHARED_RAM_SHRAM_INT");

#pragma alignvar (64)
uint32 SharedRamIntSection[NUM_OF_SHRAM_INT];

MAP_TO_DEFAULT_SECTION(bss);

#if defined(ENET_INC_UMAC)
extern void TxApp_HandleShramErrorIsr(void); 

typedef void (*SharedRamIntHandler)(void);

const SharedRamIntHandler ShramHandler[NUM_OF_SHRAM_INT] = {
	NULL, 
	NULL,
	NULL,
	NULL, 
	NULL, 
	TxApp_HandleShramErrorIsr
};

ISR_VOID SharedRamInt_ISR()
{
	int intIndex = 0;
	uint32 shramStatusReg;
	RegMacRabShramMonIntMask_u shramMonIntMaskReg;
	RegMacRabShramMonStatusReg_u shramMonStatusRegReg;
	RegMacRabShramMonStatusClear_u shramMonStatusClearReg;

	// Take a copy of the status register and mask out interrupts which are not enabled (the status is still set, but we didn't want to get this interrupt)
	RegAccess_Read(REG_MAC_RAB_SHRAM_MON_INT_MASK, &shramMonIntMaskReg.val);
	RegAccess_Read(REG_MAC_RAB_SHRAM_MON_STATUS_REG, &shramMonStatusRegReg.val);


	shramStatusReg = shramMonStatusRegReg.val & shramMonIntMaskReg.val;

	ASSERT(shramStatusReg != 0);
	
	while(shramStatusReg != 0)
	{
		intIndex = Utils_FindFirstSet(shramStatusReg); 	// Get the index of the next interrupt
		ASSERT(intIndex < NUM_OF_SHRAM_INT);
		shramMonStatusClearReg.bitFields.shramMonStatusClear  = (1 << intIndex);
		RegAccess_Write(REG_MAC_RAB_SHRAM_MON_STATUS_CLEAR, shramMonStatusClearReg.val); // Clean interrupt in RAB
		shramStatusReg &= ~(1 << intIndex);				// Clear bit in local copy of status register
		ShramHandler[intIndex]();						// Activate relevant ISR
	}
}

void SharedRamInt_EnableInt(ShRamIntIsr_e intIndex)
{
	TX_INTERRUPT_SAVE_AREA;
	RegMacRabShramMonIntMask_u shramMonIntMaskReg;
		
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	// Read - Modify - Write
	RegAccess_Read(REG_MAC_RAB_SHRAM_MON_INT_MASK, &shramMonIntMaskReg.val);
	shramMonIntMaskReg.bitFields.shramMonIntMask |= (1 << intIndex);
	RegAccess_Write(REG_MAC_RAB_SHRAM_MON_INT_MASK, shramMonIntMaskReg.val);	

	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

void SharedRamInt_DisableInt(ShRamIntIsr_e intIndex)
{
	TX_INTERRUPT_SAVE_AREA;
	RegMacRabShramMonIntMask_u shramMonIntMaskReg;

	OSAL_DISABLE_INTERRUPTS(&interrupt_save);

	// Read - Modify - Write
	RegAccess_Read(REG_MAC_RAB_SHRAM_MON_INT_MASK, &shramMonIntMaskReg.val);
	shramMonIntMaskReg.bitFields.shramMonIntMask &= ~(1 << intIndex);
	RegAccess_Write(REG_MAC_RAB_SHRAM_MON_INT_MASK, shramMonIntMaskReg.val);
	
	OSAL_ENABLE_INTERRUPTS(interrupt_save);
}

void SharedRamInt_Init(void)
{
	RegMacRabShramMonIntMask_u shramMonIntMaskReg;
	RegMacRabShramMonBaseAddr_u shramMonBaseAddrReg;
	RegMacRabShramMonStatusClear_u shramMonStatusClearReg;

	shramMonIntMaskReg.bitFields.shramMonIntMask = 0;
	RegAccess_Write(REG_MAC_RAB_SHRAM_MON_INT_MASK, shramMonIntMaskReg.val);	 

	memset(SharedRamIntSection,0,NUM_OF_SHRAM_INT*4);

	shramMonBaseAddrReg.bitFields.shramMonBaseAddr = (uint32)&SharedRamIntSection[0];
	RegAccess_Write(REG_MAC_RAB_SHRAM_MON_BASE_ADDR, shramMonBaseAddrReg.val);

	shramMonStatusClearReg.bitFields.shramMonStatusClear = (0xffff); 
	RegAccess_Write(REG_MAC_RAB_SHRAM_MON_STATUS_CLEAR, shramMonStatusClearReg.val); // clean interrupt
}

#endif //defined(ENET_INC_UMAC) 



