/***************************************************************
 File:		ShramOtfAggregator.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of Rxf fifo.
 			Fifo line indicates recive of an A-MPDU frame with no BA agreement open.
 Description:  This file contains the allocation of the RXF fifo block
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramOtfAggregator.h"
#include "OtfaErrFifo_Descriptors.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/


MAP_TO_SECTION(bss, ".SHARED_RAM_OTF_AGGR_REPORTS_FIFO")
OtfaErrFifo_t otfAggrFifoReport[NUM_OF_OTF_AGGR_REPORTS];
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_OTF_AGGR_REPORTS_FIFO_B1")
OtfaErrFifo_t otfAggrFifoReport_B1[NUM_OF_OTF_AGGR_REPORTS];
MAP_TO_DEFAULT_SECTION(bss)




