/***************************************************************
 File:		ShramPlannerResources.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the HE MU Plans and the Phases.
 Description:  This file contains the allocation of the HE MU Plans and the Phases
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramPlannerResources.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/



MAP_TO_SECTION(bss, ".SHARED_RAM_HE_MU_PLAN_PHASE_ARRAY")
CommonPlan_t			heMuPlansArray[MAX_NUMBER_OF_PLANS];
DataPhase_t				heMuDataPhaseArray[MAX_NUMBER_OF_DATA_PHASES];
SoundingPhase_t			heMuSoundingPhaseArray[MAX_NUMBER_OF_SOUNDING_PHASES];
ProtectionPhase_t		heMuProtectionPhaseArray[MAX_NUMBER_OF_PROTECTION_PHASES];
#ifdef ENET_INC_ARCH_WAVE600D2
NfrpPhase_t				heMuNfrpPhaseArray[MAX_NUMBER_OF_NFRP_PHASES];
#endif
MAP_TO_DEFAULT_SECTION(bss)

// Struct used by the Sender and filled by FW used to define NDPA parameters in Sounding phase
MAP_TO_SECTION(bss, ".SHARED_RAM_HE_MU_SOUNDING_PHASE_STRUCT")
HeSoundingNdpaPointer_t heSoundingNdpaArray[MAX_NUMBER_OF_SOUNDING_PHASES];
MAP_TO_DEFAULT_SECTION(bss)

// Look Up Table used by the Pre-Aggregator and filled by FW to map Plan Indexes to Plan pointers
MAP_TO_SECTION(bss, ".SHARED_RAM_PLAN_LUT_TRANSLATION")
PlanDbBaseAddrCommon_t 	heMuPlanLUT[MAX_NUMBER_OF_PLANS];
MAP_TO_DEFAULT_SECTION(bss)

// Descriptor RAM buffer for missing mem in fpga
MAP_TO_SECTION(bss, ".DESCRIPTOR_RAM_BUFFER_FOR_MISSING_MEM_IN_FPGA")
#ifdef ENET_INC_HW_FPGA
uint32 DescriptorRamBufferForMissingMemInFpga[(DESCRIPTOR_RAM_SIZE - REDUCED_DESCRIPTOR_RAM_SIZE) >> 0x2]; //SIZE OF DESC RAM in FPGA is only 0x00080000
#endif //ENET_INC_HW_FPGA
MAP_TO_DEFAULT_SECTION(bss)







