/***************************************************************
 File:		ShramPreAggregator.c
 Module:	  	Shram
 Purpose: 	holds the allocation in memory of the new Delia recipes 
 Description:  This file contains the allocation of the new Delia recipes
 			in the SHRAM
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ShramPreAggregator.h"
#include "HwGlobalDefinitions.h"
#include "AggrDb.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Global Variables									
/----------------------------------------------------------------------------------*/
MAP_TO_SECTION(bss, ".SHARED_RAM_PRE_AGGREGATOR")
Tcr_t TxPreAggregatorGeneratedTcrsDataStructure1;
Tcr_t TxPreAggregatorGeneratedTcrsDataStructure2;
Rcr_t TxPreAggregatorGeneratedRcrsDataStructure;
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_PRE_AGGREGATOR_B1")
Tcr_t TxPreAggregatorGeneratedTcrsDataStructure1_B1;
Tcr_t TxPreAggregatorGeneratedTcrsDataStructure2_B1;
Rcr_t TxPreAggregatorGeneratedRcrsDataStructure_B1;
MAP_TO_DEFAULT_SECTION(bss)


MAP_TO_SECTION(bss, ".SHARED_RAM_PRE_AGG_DB")

AggrDb_t PreAggregatorConfigurationDb[HW_NUM_OF_VAPS];

MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_PRE_AGG_REPORTS_FIFO")
PreAggCommonReportFifo_t TxPreAggregatorCommonFifo[PRE_AGG_COMMON_FIFO_SIZE];
PreAggUserReportFifo_t	TxPreAggregatorUserFifo[PRE_AGG_USER_FIFO_SIZE];

MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_PRE_AGG_REPORTS_FIFO_B1")
PreAggCommonReportFifo_t TxPreAggregatorCommonFifoB1[PRE_AGG_COMMON_FIFO_SIZE];
PreAggUserReportFifo_t	TxPreAggregatorUserFifoB1[PRE_AGG_USER_FIFO_SIZE];

MAP_TO_DEFAULT_SECTION(bss)




