/*******************************************************************************
*    
*   Source File: shram_hw_logger.c
*	
*	AUTHOR: Omer Gazit		
*
*   Description: SHRAM allocation of the HW logger module buffers
*       
*   Copyright: 
*       
*   Revision History:
*
*******************************************************************************/
#include "shram_hw_logger.h"

MAP_TO_SECTION(bss, ".SHARED_RAM_HW_LOGGER_BUFFERS")
#ifdef CPU_MIPS
#pragma alignvar (16)
#endif

HwLoggerShramBuffer_t HwLoggerShramBuffers;

#ifdef CPU_ARC
#pragma Align_to(16,HwLoggerShramBuffers)
#endif
MAP_TO_DEFAULT_SECTION(bss)

MAP_TO_SECTION(bss, ".SHARED_RAM_LOGGER_DESC")
LoggerBd_t	HwLoggerShramBDs[NUM_OF_HW_LOGGER_SHRAM_BUFFERS];

#ifdef CPU_ARC
#pragma Align_to(8,HwLoggerShramBDs)
#endif

#ifdef CPU_MIPS
#pragma alignvar (4)
#endif
MAP_TO_DEFAULT_SECTION(bss)


