#ifndef STRINGLIB_API_H
#define STRINGLIB_API_H


#include "System_GlobalDefinitions.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "safe_mem_lib.h"
#endif

#if !defined (ENET_INC_ARCH_WAVE600)
#ifdef ENET_INC_LMAC
void memmove (void *dst, const void * src, uint32 count);
void memset (void *dst,	int val, uint32 count);
void memcpy (void *destaddr, void const *srcaddr, uint32 len);
int memcmp (const void * buf1,	const void * buf2,	uint32 count);
int32 strcmp (const char * src, const char * dst);
void strcpy(char * dst, const char * src);
uint32 strlen(const char * str);
#endif 
#endif

void memset32 (void *dst,	int val, uint32 count);
void memcpy32(void *destaddr, void const *srcaddr, uint32 len);

#if defined (ENET_INC_ARCH_WAVE600)
	#define MEMCPY(dest, src, size)  memcpy_s((void *)dest, size, (const void  *)src, size)
	#define MEMCPY32(dest, src, size) memcpy32_s((void *)dest, size, (const void *)src, size)
#else
	#define MEMCPY(dest, src, size)  memcpy((void *)dest, (const void  *)src, size)
	#define MEMCPY32(dest, src, size) memcpy32((void *)dest, (const void *)src, size)
	#define STRCPY(dst,src) strcpy((char *) dst, (const char *) src)
#endif
#endif /* STRINGLIB_API_H */

