/* CMSynergyVer %full_filespec: mt_cnfg.h;18.1.1.1.1:incl:20 % */
/*****************************************************************************
*   Source File:
*       mt_cnfg.h
*   Product Name:
*       Metalink Chip Software
*   Description: 							   
*       Controller chip configuration file
*   Copyright: 
*       (C) Metalink Ltd. 
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*****************************************************************************/

#ifndef __MT_CNFG_H__								  
#define __MT_CNFG_H__

//#ifdef  MT_GLOBAL
//#define extern  
//#define MT_I(x) x
//#else
//#define extern extern
//#define MT_I(x)
//#endif						  



/* defines for shared modules between host and mips, to differentiate between MIPS code and host code.
These two defines are identical, and some shared modules use one and some the other */
#define MT_ENV_MIPS
#define MT_CPU_MIPS

#define REG_MIPS_ADD_OFFSET   0x00
/* MACROS for MIPS usage only.  */

#define HW_CREG_U32(I)                       *((volatile uint32*)(I))
#define HW_CREG_U32_NEW(I)                   *((volatile uint32*)(I))

#define HW_CREG_U16(I)                       *((volatile uint16*)(I))

#define HW_CREG(I)                           *((volatile uint32*)(I))
#define HW_C_REG(I)                          *((volatile uint16*)(I))


#define HW_CREG_UNIT(UNIT, REG)         ( ((uint32)UNIT) | \
                                           (((uint32)REG) << REG_MIPS_ADD_OFFSET) | \
                                            ((uint32)0x2) )	 /* 2- for Accessing the system 16-bits data */



                
/* MIPS access to its internal modules */  /*FOR RMS*/
#define NONE_TRUNK_REG(UNIT, REG)                 (HW_CREG_U32((uint32)UNIT | (uint32)REG )) /* (HW_C_REG(HW_CREG_UNIT(UNIT, REG)))*/







/*****************************************************************************
*       Build Configuration
*****************************************************************************/
#ifdef MT_USE_GENERATED_HEADER
#define LED_OR_RMS 0	 /* [1 -led 0 - Rms]  Alex Debug led */
//#include "mt_acnfg.h"  /* this include file is relevant only for internal Metalink build when using automatic build tool  */

#else


#endif







/*****************************************************************************/


/* type definitions for the MIPS controller */
#define XDATA        
//#define MT_INLINE                       inline
//#define uint8                        unsigned char      /*  8 bit */
//#define int8                         signed char        /*  8 bit */
//#define uint16                       unsigned short int /* 16 bit */
//#define int16                        signed short int   /* 16 bit */
////#define MT_UINT32                       unsigned long int  /* 32 bit */
////#define int32                        signed long int    /* 32 bit */
//#define int64                        long long          /* 64 bit */  /* <O.H> - new type */
//#define uint64                       unsigned long long /* 64 bit */  /* <O.H> - new type */
//#define MT_CODE                         const              
//#define void                         void
//#define static                       static	


				

/* A type definition for a general enum, which can be used when casting enums, to ensure that 
   all enums have the same size (instead of relying on the enum size to be a byte or int). */
typedef enum {
    MT_DUMMY_ENUM_0
} MT_ENUM_T;



/*****************************************************************************/

//#undef extern  
//#undef MT_I

#endif	//__MT_CNFG_H__
