/* CMSynergyVer %full_filespec: MT_MAC_HT_extensions.c;2.1.1.2.2:csrc:2 % */
/*******************************************************************
 *
 *    DESCRIPTION:	MAC Extention
 *	  MODULE:	 	develop/src/sys/common/MT_MAC_HT_extentions.c
 *    AUTHOR:		Lior Hadad
 *	  CREATED:		31-01-2006
 *    HISTORY:
 *******************************************************************/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Api.h"
#include <ieee80211.h>
#include <protocol.h>
#include <lmi.h>
#include "enet_pas.h"
#ifndef ENET_INC_ARCH_WAVE600
#include "MT_MAC_HT_extensions_regs.h"
#endif
#include "MacHtExtensionsRegs.h"
#include "MT_MAC_HT_extensions.h"
#include "RegAccess_Api.h"
//#include "enet_sw.h"
#include "lm.h"



#include "loggerAPI.h"
 
 /*****************************************************************************
 *        Local Definitions
 *****************************************************************************/
#define LOG_LOCAL_GID   GLOBAL_GID_SYS
#define LOG_LOCAL_FID 1



#define BA_CONFIG_ENABLE_BAR_COMPRESSED				(1)
#define BA_CONFIG_ENABLE_FLUSH_ON_ERROR_NEGATIVE	(1)

#define REG_MODE2          0x200
#define REG_MODE2_MASK     0x00000001


/*Duration Table*/
    /* reset delinator module */


/*---------------------------------------------
 ** Author: 		Lior Hadad
 *  FunctionName:	vConfigFDC
 *  DESCRIPTION:	reset and config default FDC settings
 --------------------------------------------*/
#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=".initialization"
#endif 

void vConfigFDC(void)
{
#ifndef ENET_INC_ARCH_WAVE600 // There is no deliniator in Gen6
	RegMacHtExtensionsSwResetsAssert_u htExtensionSwResetsAssertReg;
	RegMacHtExtensionsSwResetsRelease_u htExtensionSwResetsReleaseReg;
	RegMacHtExtensionsFc2Mode_u htExtensionFc2Mode;

	htExtensionSwResetsAssertReg.val = 0;
	htExtensionSwResetsReleaseReg.val = 0;
    //Delineator reset
	htExtensionSwResetsAssertReg.bitFields.delineatorSwResetAssert = HW_RESET_BLOCK;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_ASSERT,htExtensionSwResetsAssertReg.val);
    htExtensionSwResetsReleaseReg.bitFields.delineatorSwResetRel = HW_RESET_BLOCK;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_RELEASE,htExtensionSwResetsReleaseReg.val);
	/*Minimal subframe lenght is disabled by efault*/
	htExtensionFc2Mode.val = REGISTER(REG_MAC_HT_EXTENSIONS_FC2_MODE);
	RegAccess_Read(REG_MAC_HT_EXTENSIONS_FC2_MODE, &htExtensionFc2Mode.val);
	htExtensionFc2Mode.bitFields.checkMinimalSubframeLengthInDelimiter = 1;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_FC2_MODE, htExtensionFc2Mode.val);

    /*Config Min sub frame length  TH*/
	MT_WrReg(MAC_HT_EXTENSIONS_BASE_ADDR, REG_DEL_MIN_SUBFRAME_LENGTH, MIN_PACKET_LENGTH);
    /* Set FDC to FC2 mode */
  	MT_WrReg(MAC_HT_EXTENSIONS_BASE_ADDR, REG_MODE2, REG_MODE2_MASK /* look at excel register and rename if need */ );
#endif
}

/*---------------------------------------------
 ** Author: 		Lior Hadad
 *  FunctionName:	vFC2_CRC_INIT
 *  DESCRIPTION:	config default CRC settings
 *					for FC2 module.
 --------------------------------------------*/
void vFC2_CRC_INIT(void)
{
#ifndef ENET_INC_ARCH_WAVE600
    /* struct of FC2_CRC_INIT register */
	struct sFC2_CRC_INIT_reg sFC2init;
    uint32 *uint_sFC2init;

	/* SW init value taken from VLSI */
	sFC2init.fc2_unique_pattern = 'N';  /* 0x4e */
	sFC2init.fc2_crc_init_val = 0xff;
	sFC2init.fc2_crc_type = 0x60;
	sFC2init.fc2_crc_byte_swap = 0x0;
	sFC2init.fc2_crc_msb_first = 0x0;
	sFC2init.fc2_crc_out_invert = 0x1;
	sFC2init.fc2_crc_out_reflect = 0x0;
	sFC2init.unused = 0x0;
	uint_sFC2init = (uint32 *)&sFC2init;
	/* set hardware */
	MT_WrReg(MAC_HT_EXTENSIONS_BASE_ADDR, REG_FC2_UNIQUE_PATTERN, *uint_sFC2init);
#endif
}

/*---------------------------------------------
 ** Author: 		Lior Hadad
 *  FunctionName:	vBA_INIT
 *  DESCRIPTION:	reset and config default Block Ack settings.
 *					 
 --------------------------------------------*/
void vBA_INIT(void)
{
#ifndef ENET_INC_ARCH_WAVE600
	RegMacHtExtensionsSwResetsAssert_u htExtensionSwResetsAssertReg;
	RegMacHtExtensionsSwResetsRelease_u htExtensionSwResetsReleaseReg;
	RegMacHtExtensionsBackConfig_u htExtensionBaConfigReg;

	htExtensionSwResetsAssertReg.val = 0;
	htExtensionSwResetsReleaseReg.val = 0;
	htExtensionBaConfigReg.val = 0;
	htExtensionSwResetsAssertReg.bitFields.macBlockAckSwResetAssert = HW_RESET_BLOCK;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_ASSERT,htExtensionSwResetsAssertReg.val);
    htExtensionSwResetsReleaseReg.bitFields.macBlockAckSwResetRel = HW_RESET_BLOCK;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_RELEASE,htExtensionSwResetsReleaseReg.val);
	htExtensionBaConfigReg.bitFields.barCompressed= BA_CONFIG_ENABLE_BAR_COMPRESSED;
	htExtensionBaConfigReg.bitFields.flushOnErrorNegative= BA_CONFIG_ENABLE_FLUSH_ON_ERROR_NEGATIVE;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_BACK_CONFIG,htExtensionBaConfigReg.val);

#endif
}

#if defined (ENET_INC_LMAC) && !defined (ENET_INC_ARCH_WAVE600)
#pragma ghs section text=default
#endif 

