/* CMSynergyVer %full_filespec: mt_osutl.h;2.1.1:incl:17 % */
/*****************************************************************************
*   MODULE NAME:
*       MT_OSUTL.H
*   DESCRIPTION: 
*       Inline assembler utilities function for the MIPS Operating system
*       The functions are implemented in the .h file, because it is Macro 
*       assembler inline functions.
*   AUTHOR:  
*       Ziv Avital
*   DATE: 
*       24/04/2000
*   COPYRIGHT: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*****************************************************************************/
 
#ifndef __MT_OSUTL_H__
#define __MT_OSUTL_H__

#if defined(MT_GLOBAL)
   #define MT_EXTERN
   #define I(x) x
#else
   #define MT_EXTERN extern
   #define I(x)
#endif

/*****************************************************************************
*                  global functions prototypes  								 *
*****************************************************************************/

void  __SetStatusReg( int s );
int  __GetStatusReg();
void  __SetCauseReg( int s );
int  __GetCauseReg();
int  __GetEpcReg();
int  __GetSrsCtlReg();
void  __SetCountReg( int s );
int  __GetCountReg();
void  __SetCompareReg( int s );
int  __GetCompareReg();
void  __EnableInt(int mask);
void  __wait();
void  __nop();

/*****************************************************************************
* Function Name:    __GetStackPointer
* Description: 
*   returns the value of SP, to be examined by the caller
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: (in $2)
*****************************************************************************/
asm int __GetStackPointer( void )
{
%
   move  $2, $sp
%error
}

/* old code by AdiM for this function */
/*    lui   $2, %hi(__ghsbegin_stack) 
    movn  $2, $sp, $2 */


/*****************************************************************************
* Function Name:    __CheckStackOverflow
* Description: 
*   Check if the stack pointer overflow (less than stack begin)
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: (in $2)
*   1 = overflow
*   0 = no oveflow
*****************************************************************************/
asm int __CheckStackOverflow( void )
{
%
    lui   $2, %hi(__ghsbegin_stack) 
    addiu $2, $2, %lo(__ghsbegin_stack) 
    slt   $2, $sp, $2
%error
}


/*****************************************************************************
* Function Name:    __SetStatusReg
* Description: 
*   Set Status Register of CP0
* Input Parameters: 
*   Status register new value. Register (C varible) only, not constants.
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void __SetStatusReg( s )
{
%reg s
    mtc0    s, $12
    nop
%error
}

/*****************************************************************************
* Function Name:    __GetStatusReg
* Description: 
*   Get Status Register of CP0
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   The value of the status register
*****************************************************************************/
asm int __GetStatusReg( void )
{
%
    mfc0    $2, $12
    nop
%error
}

/*****************************************************************************
* Function Name:    __SetCauseReg
* Description: 
*   Set Cause Register of CP0
* Input Parameters: 
*   Cause register new value. Register (C varible) only, not constants.
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void __SetCauseReg( s )
{
%reg s
    mtc0    s, $13
    nop
%error
}

/*****************************************************************************
* Function Name:    __GetCauseReg
* Description: 
*   Get Cause Register of CP0
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   The value of the Cause register
*****************************************************************************/
asm int __GetCauseReg( void )
{
%
    mfc0    $2, $13
    nop
%error
}

/*****************************************************************************
* Function Name:    __GetEpcReg
* Description: 
*   Get EPC Register of CP0
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   The value of the Cause register
*****************************************************************************/
asm int __GetEpcReg( void )
{
%
    mfc0    $2, $14
    nop
%error
}

/*****************************************************************************
* Function Name:    __GetSrsCtlReg
* Description: 
*   Get SRSCtl Register of CP0
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   The value of the SRSCtl register
*****************************************************************************/
asm int __GetSrsCtlReg(void)
{
%
	mfc0    $2,$12,2
	nop
%error
}

/*****************************************************************************
* Function Name:    __SetCountReg
* Description: 
*   Set Count Register of CP0
* Input Parameters: 
*   Count register new value. Register (C varible) only, not constants.
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void __SetCountReg( s )
{
%reg s
    mtc0    s, $9
    nop
%con s
    li      $1,s
    mtc0    $1, $9
    nop
%error
}

/*****************************************************************************
* Function Name:    __GetCountReg
* Description: 
*   Get Count Register of CP0
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   The value of the Count register
*****************************************************************************/
asm int __GetCountReg( void )
{
%
    mfc0    $2, $9
    nop
%error
}

/*****************************************************************************
* Function Name:    __SetCompareReg
* Description: 
*   Set Compare Register of CP0
* Input Parameters: 
*   Compare register new value. Register (C varible) only, not constants.
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void __SetCompareReg( s )
{
%reg s
    mtc0    s, $11
    nop
%con s
    li      $1,s
    mtc0    $1, $11
    nop
%error
}

/*****************************************************************************
* Function Name:    __GetCompareReg
* Description: 
*   Get Compare Register of CP0
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   The value of the Compare register
*****************************************************************************/
asm int __GetCompareReg( void )
{
%
    mfc0    $2, $11
    nop
%error
}

/*****************************************************************************
* Function Name:    __EI
* Description: 
*   Enable all interrupts of the MIPS
* Input Parameters: 
*   mask - 8 bits masking for the interrupts
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void __EnableInt(mask)
{
%con mask
        lui  $8,0xf000             
        ori  $8,0x0001 
        lui  $9,0
        ori  $9,mask
        sll  $9,$9,8
        or   $8,$8,$9
        mtc0 $8,$12             
        nop
%error
}

/*****************************************************************************
* Function Name:    __wait
* Description: 
*   Wait for Interrupts - power down
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void __wait(void)
{
%
    wait
    nop
    nop
%error
}

/*****************************************************************************
* Function Name:    __nop
* Description: 
*   No operation
* Input Parameters: 
*   none
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void __nop(void)
{
%
    nop
%error
}

/*****************************************************************************
* Function Name:    __DisAllint
* Description: 
*   
* Input Parameters: 
*   
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void  __DisAllint(void)
{
%
        mfc0   $8, $12

        lui  $9,0xffff             
        ori  $9,0xfffd

        and  $8,$8,$9
        mtc0 $8,$12             
        nop
%error
}

/*****************************************************************************
* Function Name:    __RestoreInt
* Description: 
*   
* Input Parameters: 
*   
* Output Parameters: 
*   none
* Return Value: 
*   none
*****************************************************************************/
asm void  __RestoreInt(void)
{
%
        mfc0 $8, $12
        ori  $8,0x0002 
        mtc0 $8,$12             
        nop
%error
}
         
#undef MT_EXTERN
#undef I
#endif /* __MT_OSUTL_H__ */
