/* CMSynergyVer %full_filespec: um_interface.h;4.2.1.1.1.2.4.1.1.2.6:incl:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      Upper MAC (UMAC) Task interface
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/um_interface.h $
 **
 ** VERSION:        $Revision: #1 $
 **
 ** DATED:          $Date: 2003/10/27 $
 **
 ** AUTHOR:         Ivan Oakes
 **
 ** DESCRIPTION:    Upper MAC interface to lower MAC.
 **
 ** LAST MODIFIED BY:   $Author: njk $
 **                     $Modtime:   $
 **
 ****************************************************************************
 *
 *  (c) Copyright 2001, TTPCom.
 *
 ****************************************************************************/
#ifndef	__UM_INTERFACE_H
#define	__UM_INTERFACE_H

#include "queue_utility.h"



void vUM_IF_Init(void);
void vUM_IF_Task(K_MSG *psMsg);
void vUMI_SendToMC(K_MSG_TYPE msgType, K_MSG *psKmsg);

void vUM_MAN_GET_MIB_REQ(K_MSG *psMsg);
void vUM_MAN_SET_MIB_REQ(K_MSG *psMsg);
void vUM_MAN_SET_KEY_REQ(K_MSG *psMsg);
void vUM_MAN_GET_GROUP_PN_REQ(K_MSG *psMsg);
void vUM_SET_CHAN_REQ(K_MSG *psMsg);
void vMC_MAN_GET_GROUP_PN_CFM(K_MSG *psMsg);
void vUM_DOWNLOAD_PROG_MODEL_REQ(K_MSG *psMsg);
void vUM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_REQ(K_MSG *psMsg);
void vUM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_REQ(K_MSG *psMsg);
void vUM_MAN_SET_BCL_VALUE_REQ(K_MSG *psMsg);
void vUM_MAN_QUERY_BCL_VALUE_REQ(K_MSG *psMsg);
void vUMI_AllocAndSendToMC(FwUtils_queue_t *psFreeQueue, K_MSG_TYPE msgType, K_MSG *psKmsg);
void vUM_ACTIVATE_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_SET_KEY_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_SET_MIB_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_GET_MIB_CFM(K_MSG *psMsg);
void vUM_SET_CHAN_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_SET_BCL_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_QUERY_BCL_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_GET_MAC_VERSION_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_SW_RESET_MAC_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_GENERIC_MAC_CFM(K_MSG *psMsg);
void vUM_DOWNLOAD_PROG_MODEL_CFM(K_MSG *psMsg);
void vUMI_DOWNLOAD_PROG_MODEL_DIFFS_CFM(K_MSG* psMsg);
void vUM_LM_STOP_CFM(K_MSG *psMsg);
void vUM_MAN_GET_SW_VERSION_REQ(K_MSG *psMsg);

#if defined (ENET_INC_UMAC)
extern FwUtils_queue_t  sUmiIndFreeQueue;   /* Holds the UMI ind/res while free */
#endif
extern uint32* p32PsdProgmodelShramAddress;



void MT_CheckBclOnException(void);
void MT_vUM_CommonManSetBclValueReq(UMI_BCL_REQUEST *psbcl);
void MT_vUM_CommonManQueryBclValueReq(UMI_BCL_REQUEST *psbcl);
#if defined (ENET_INC_UMAC)
void MT_BclOnExceptionInit(void);
#endif

/***************************************************************************/
/***						Debug Section 											***/
/***************************************************************************/
/***************************************************************************/
/***						Debug Section 											***/
/***************************************************************************/
#if defined (HOST_MESSAGES_STATISTICS)

/* Management Messages */
/***********************/

//All host to mac messages are advanced in the functions related

/* Request and Confirms */
#define UMSTAT_MAN_TOTAL_REQS_CFMS							0	//total request/confirms
#define UMSTAT_MAN_SET_MIB_REQ_CFM							1	//vUM_MAN_SET_MIB_REQ
#define UMSTAT_MAN_GET_MIB_REQ_CFM							2	//vUM_MAN_GET_MIB_REQ
#define UMSTAT_MAN_ACTIVATE_REQ_CFM							3	//vUM_MAN_ACTIVATE_REQ/CFM
#define UMSTAT_MAN_LM_STOP_REQ_CFM							4	//vUM_LM_STOP_REQ/CFM
#define	UMSTAT_MAN_STOP_TRAFFIC_REQ_CFM						5
#define UMSTAT_MAN_SET_CHAN_REQ_CFM							6	//Mt11h_SetChannelRequestFromDriver
#define UMSTAT_MAN_ENABLE_RADIO_REQ_CFM						7
#define UMSTAT_MAN_SW_RESET_MAC_REQ_CFM						8	//vUM_MAN_SW_RESET_MAC_REQ
#define UMSTAT_MAN_SET_KEY_REQ_CFM							9	//vUM_MAN_SET_KEY_REQ
#define UMSTAT_MAN_GET_GROUP_PN_REQ_CFM						10	//vUM_MAN_GET_GROUP_PN_REQ
#define UMSTAT_DOWNLOAD_PROG_MODEL_REQ_CFM					11	//vUM_DOWNLOAD_PROG_MODEL_REQ/CFM
#define UMSTAT_MAN_SET_POWER_LIMIT_REQ_CFM					12
#define UMSTAT_MAN_SET_BCL_VALUE_REQ_CFM					13	//vUM_MAN_SET_BCL_VALUE_REQ
#define UMSTAT_MAN_QUERY_BCL_VALUE_REQ_CFM					14	//vUM_MAN_QUERY_BCL_VALUE_REQ
#define UMSTAT_MAN_GET_MAC_VERSION_REQ_CFM					15	//vUM_MAN_GET_SW_VERSION_REQ
#define UMSTAT_MAN_GENERIC_MAC_REQ_CFM						16	//vUM_MAN_GENERIC_MAC_REQ
#define UMSTAT_MAN_SET_INTERFERER_DETECTION_PARAMS_REQ_CFM	17
#define UMSTAT_MAN_ENABLE_RADAR_INDICATION_REQ_CFM          18
#define UMSTAT_MAN_PREPARE_ANT_CFG_REQ_CFM					19
#define UMSTAT_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ_CFM 	20 //vUM_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ/CFM
#define UMSTAT_MAN_SET_ANT_CFG_REQ_CFM						21
#define UMSTAT_MAN_SET_BSS_REQ_CFM							22 // vUM_MAN_SET_BSS_REQ
#define UMSTAT_MAN_ADD_VAP_REQ_CFM							23 // vUM_MAN_ADD_VAP_REQ
#define UMSTAT_MAN_REMOVE_VAP_REQ_CFM						24 // vUM_MAN_DEACTIVATE_VAP_REQ
#define	UMSTAT_MAN_REQUEST_SID_REQ_CFM						25
#define	UMSTAT_MAN_REMOVE_SID_REQ_CFM						26
#define UMSTAT_MAN_HW_DEPENDENT_CONFIG_CFM					27 // vUM_MAN_HW_DEPENDENT_CONFIG_REQ
#define UMSTAT_MAN_SET_AGG_RATE_LIMIT_REQ_CFM				28
#define UMSTAT_MAN_SEND_11B_SET_ANT_REQ_CFM					29
#define UMSTAT_MAN_COC_SET_ANTENNAS_REQ_CFM					30
#define UMSTAT_MAN_STA_ADD_REQ_CFM							31
#define UMSTAT_MAN_STA_REMOVE_REQ_CFM						32
#define UMSTAT_MAN_SET_BEACON_TEMPLATE_REQ_CFM				33
#define UMSTAT_MAN_SET_RX_TH_REQ_CFM						34
#define UMSTAT_MAN_SET_RX_DUTY_CYCLE_CFM					35
#define UMSTAT_MAN_SET_ADMISSION_CAPACITY_REQ_CFM			36
#define UMSTAT_MAN_SET_WMM_PARAMETERS_REQ_CFM				37
#define UMSTAT_MAN_SET_DEFAULT_KEY_INDEX_REQ_CFM			38
#define UMSTAT_MAN_SET_802_1X_FILTER_REQ_CFM				39
#define UMSTAT_MAN_HW_LOGGER_ADD_STREAM_REQ_CFM				40
#define UMSTAT_MAN_HW_LOGGER_REMOVE_STREAM_REQ_CFM			41
#define UMSTAT_MAN_HW_LOGGER_ADD_FILTER_REQ_CFM				42
#define UMSTAT_MAN_HW_LOGGER_REMOVE_FILTER_REQ_CFM			43
#define UMSTAT_MAN_HW_LOGGER_SET_TRIGGER_REQ_CFM			44
#define UMSTAT_MAN_HW_LOGGER_RESET_TRIGGER_REQ_CFM			45
#define UMSTAT_MAN_DATA_PATH_INIT_REQ_CFM					46
#define UMSTAT_MAN_SET_TPC_ANT_PARAMS_REQ_CFM				47
#define UMSTAT_MAN_SET_TPC_CONFIG_REQ_CFM					48
#define UMSTAT_MAN_HDK_CONFIG_REQ_CFM						49
#define UMSTAT_MAN_STOP_VAP_TRAFFIC_REQ_CFM					50
#define UMSTAT_MAN_PRE_ACTIVATE_REQ_CFM						51
#define UMSTAT_MAN_DOWNLOAD_PROG_MODEL_DIFFS_REQ_CFM 		52
#define UMSTAT_MAN_PLATFORM_DATA_FIELDS_REQ_CFM 			53
#define UMSTAT_MAN_PLATFORM_TABLE_REQ_CFM 					54
#define UMSTAT_MAN_POLL_CLIENT_REQ_CFM            			55
#define UMSTAT_MAN_GET_CHANNEL_LOAD_REQ_CFM        			56
#define UMSTAT_MAN_SET_AFE_CAL_DATA_REQ_CFM					57
#define UMSTAT_MAN_SET_RFIC_CAL_DATA_REQ_CFM				58
#define UMSTAT_MAN_SET_MULTICAST_MODE_REQ_CFM       		59
#define UMSTAT_MAN_SET_MULTICAST_ACTION_REQ_CFM     		60
#define UMSTAT_MAN_SET_RSSI_CAL_REQ_CFM						61
#define UMSTAT_MAN_GET_STATISTICS_REQ_CFM					62
#define UMSTAT_MAN_DOWNLOAD_PROGMODEL_ANT_DEPENDENT_TX_REQ_CFM	63
#define UMSTAT_MAN_DOWNLOAD_PROGMODEL_ANT_DEPENDENT_RX_REQ_CFM	64
#define UMSTAT_MAN_CALIBRATE_REQ_CFM						65
#define UMSTAT_MAN_USER_DEMAND_REQ_CFM						66
#define UMSTAT_MAN_QAMPLUS_REQ_CFM							67
#define UMSTAT_MAN_TS_VAP_CONFIGURE_REQ_CFM					68
#define UMSTAT_MAN_MSDU_IN_AMSDU_CONFIG_REQ_CFM				69
#define UMSTAT_MAN_MU_OPERATION_CONFIG_REQ_CFM				70
#define UMSTAT_MAN_CCA_TH_CFM								71
#define UMSTAT_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_REQ_CFM   72
#define UMSTAT_MAN_RTS_MODE_CONFIG_REQ_CFM					73
#define UMSTAT_MAN_MAX_MPDU_LEN_REQ_CFM				   		74
#define UMSTAT_MAN_BF_MODE_CONFIG_REQ_CFM				   	75
#define UMSTAT_MAN_CPU_LOAD_REQ_CFM							76
#define UMSTAT_MAN_IRE_SWITCH_B_REQ_CFM						77
#define UMSTAT_MAN_FIXED_RATE_CONFIG_REQ_CFM				78
#define UMSTAT_MAN_SSB_MODE_REQ_CFM							79
#define UMSTAT_MAN_BEACON_BLOCKING_INTERVAL_REQ_CFM			80
#define UMSTAT_MAN_GET_CCA_TH_CFM							81
#define UMSTAT_MAN_FREQ_JUMP_MODE_REQ_CFM					82
#define UMSTAT_MAN_SET_TXOP_CONFIG_REQ_CFM					83
#define UMSTAT_MAN_SET_BEACON_INTERVAL_REQ_CFM				84
#define UMSTAT_MAN_2_4GHZ_COEX_REQ_CFM						85
#define UMSTAT_MAN_ATF_QUOTAS_REQ_CFM				    	86
#define UMSTAT_MAN_STATIC_PLAN_CONFIG_REQ_CFM				87
#define UMSTAT_MAN_TEST_BUS_ENABLE_REQ_CFM					88
#define UMSTAT_MAN_HE_MU_OPERATION_CONFIG_REQ_CFM			89
#define UMSTAT_MAN_FIXED_POWER_REQ_CFM				    	90
#define UMSTAT_MAN_OPERATING_MODE_REQ_CFM					91
#define UMSTAT_MAN_SET_QOS_PD_THRESH_REQ_CFM				92
#define UMSTAT_MAN_RESTRICTED_AC_MODE_REQ_CFM				93
#define UMSTAT_MAN_FAST_DROP_CONFIG_REQ_CFM					94
#define UMSTAT_MAN_ERP_SET_REQ_CFM							95
#define UMSTAT_MAN_DMR_CONFIG_REQ_CFM						96
#define UMSTAT_MAN_FIXED_LTF_AND_GI_REQ_CFM					97
#define UMSTAT_MAN_SET_REG_DOMAIN_CONFIG_REQ_CFM			98
#define UMSTAT_MAN_PVT_READ_REQ_CFM							99
#define UMSTAT_MAN_PROTECTION_RATE_CONFIG_REQ_CFM			100
#define UMSTAT_MAN_SLOW_PROBING_MASK_REQ_CFM				101
#define UMSTAT_MAN_NFRP_CONFIG_REQ_CFM						102
#define	UMSTAT_MAN_DUTY_CYCLE_SET_REQ_CFM					103
#define UMSTAT_MAN_SET_HE_DYNAMIC_MU_TYPE_REQ_CFM			104
#define UMSTAT_MAN_SET_HE_MU_FIXED_PARAMETERS_REQ_CFM		105
#define UMSTAT_MAN_SET_HE_MU_DURATION_REQ_CFM				106
#define UMSTAT_MAN_GET_TWT_PARAMS_REQ_CFM					107
#define UMSTAT_MAN_GET_AX_DEFAULT_PARAMS_REQ_CFM			108
#define UMSTAT_MAN_ETSI_PPDU_DURATION_LIMITS_REQ			109
#define UMSTAT_MAN_SET_TXOP_DURATION_REQ_CFM				110
#define UMSTAT_MAN_SET_RTS_THRESHOLD_REQ_CFM				111
#define UMSTAT_MAN_SET_RETRY_LIMIT_REQ_CFM					112
#define UMSTAT_MAN_SET_AP_BEACON_INFO_REQ_CFM				113
#define UMSTAT_TOTAL_MAN_REQ_CFM							114




/* Indications and Responses */
#define UMSTAT_MAN_TOTAL_INDS_RESS					0	//total indications/responses
#define UMSTAT_MAN_NETWORK_EVENT_IND_RES			1	//vUM_NETWORK_EVENT_IND/RES
#define UMSTAT_MAN_BEACON_TEMPLATE_WAS_SET_IND_RES	2 	// vUMI_MAN_WAS_BEACON_SET_IND/RES
#define UMSTAT_MAN_CLASS3_ERROR_IND_RES				3 	// vUMI_MAN_CLASS3_ERROR_IND/RES
#define UMSTAT_MAN_MAC_EVENT_IND_RES				4	//vUM_MAC_EVENT_IND/RES
#define UMSTAT_MAN_TKIP_MIC_FAILURE_IND_RES   	    5 	// vUMI_MAN_TKIP_MIC_FAILURE_IND/RES
#define UMSTAT_MAN_CONTINUOUS_INTERFERER_IND_RES   	6 	// UMI_CONTINUOUS_INTERFERER_IND/RES
#define UMSTAT_MAN_RADAR_IND_RES                	7 	// UMI_RADAR_IND/RES
#define UMSTAT_MAN_BEACON_IND_RES					8
#define UMSTAT_MAN_HE_MU_DBG_IND_RES				9

#define UMSTAT_TOTAL_MAN_IND_RES					10





	
/* Debug Messages */
/******************/

/* Request and Confirms */
#define UMSTAT_DBG_TOTAL_REQS_CFMS					0	//total request/confirms
#define UMSTAT_DBG_MAC_WATCHDOG_REQ_CFM				1	//vUM_DBG_MAC_WATCHDOG_REQ/CFM
#define UMSTAT_DBG_LOGGER_FLUSH_BUF_REQ_CFM         2   //vMC_DBG_LOGGER_FLUSH_BUF_REQ/CFM
#define UMSTAT_DBG_LOGGER_SET_MODE_REQ_CFM          3   //vUM_DBG_LOGGER_SET_MODE_REQ/CFM
#define UMSTAT_DBG_LOGGER_SET_SEVERITY_REQ_CFM      4   //vUM_DBG_LOGGER_SET_SEVERITY_REQ/CFM
#define UMSTAT_DBG_LOGGER_SET_FILTER_REQ_CFM        5   //vUM_DBG_LOGGER_SET_FILTER_REQ/CFM
#define UMSTAT_DBG_CLI_REQ_CFM                      6  //UmDbgCliReq/Cfm
#define UMSTAT_DBG_FW_DBG_REQ_CFM					7	// 
#define UMSTAT_TOTAL_DBG_REQ_CFM                    8


/* Indications and Responses */
#define UMSTAT_DBG_TOTAL_INDS_RESS					0	//total indications/responses
#define UMSTAT_DBG_TRACE_IND_RES                    1
#define UMSTAT_TOTAL_DBG_IND_RES                    2


/* a struct to hold all messages arrays to take less space in the chipvar file */
typedef struct  
{
	/* Management messages between Host and UM */
	uint16 manMsgsReqArr[UMSTAT_TOTAL_MAN_REQ_CFM];
	uint16 manMsgsCfmArr[UMSTAT_TOTAL_MAN_REQ_CFM];

	uint16 manMsgsIndArr[UMSTAT_TOTAL_MAN_IND_RES];
	uint16 manMsgsResArr[UMSTAT_TOTAL_MAN_IND_RES];

	/* Debug messages between Host and UM */
	uint16 debugMsgsReqArr[UMSTAT_TOTAL_DBG_REQ_CFM];
	uint16 debugMsgsCfmArr[UMSTAT_TOTAL_DBG_REQ_CFM];
	
	uint16 debugMsgsIndArr[UMSTAT_TOTAL_DBG_IND_RES];
	uint16 debugMsgsResArr[UMSTAT_TOTAL_DBG_IND_RES];
}	HostIFStatisticsArrays_T;


/* a struct with all messages arrays besides UM<-->Host interrupts */
extern HostIFStatisticsArrays_T UMSTAT_HostIFStats;


/* macros for incrementing Management messages arrays */
#define UMSTAT_INC_MAN_REQ_ARR(reqIdx)	(UMSTAT_HostIFStats.manMsgsReqArr[reqIdx]++)
#define UMSTAT_INC_MAN_CFM_ARR(cfmIdx)	(UMSTAT_HostIFStats.manMsgsCfmArr[cfmIdx]++)
#define UMSTAT_INC_MAN_IND_ARR(indIdx)	(UMSTAT_HostIFStats.manMsgsIndArr[indIdx]++)
#define UMSTAT_INC_MAN_RES_ARR(resIdx)	(UMSTAT_HostIFStats.manMsgsResArr[resIdx]++)

/* macros for incrementing Debug messages arrays */
#define UMSTAT_INC_DBG_REQ_ARR(reqIdx)	(UMSTAT_HostIFStats.debugMsgsReqArr[reqIdx]++)
#define UMSTAT_INC_DBG_CFM_ARR(cfmIdx)	(UMSTAT_HostIFStats.debugMsgsCfmArr[cfmIdx]++)
#define UMSTAT_INC_DBG_IND_ARR(indIdx)	(UMSTAT_HostIFStats.debugMsgsIndArr[indIdx]++)
#define UMSTAT_INC_DBG_RES_ARR(resIdx)	(UMSTAT_HostIFStats.debugMsgsResArr[resIdx]++)

	
#else /* #ifndef HOST_MESSAGES_STATISTICS */

#define UMSTAT_INC_MAN_REQ_ARR(reqIdx)
#define UMSTAT_INC_MAN_CFM_ARR(cfmIdx)
#define UMSTAT_INC_MAN_IND_ARR(indIdx)
#define UMSTAT_INC_MAN_RES_ARR(resIdx)

#define UMSTAT_INC_DBG_REQ_ARR(reqIdx)
#define UMSTAT_INC_DBG_CFM_ARR(cfmIdx)
#define UMSTAT_INC_DBG_IND_ARR(indIdx)
#define UMSTAT_INC_DBG_RES_ARR(resIdx)	
#endif

#endif	//__UM_INTERFACE_H
