/* CMSynergyVer %full_filespec: um_interface_task.c;37.1.3.1.7.1.3:csrc:1 % */
/****************************************************************************
 ****************************************************************************
 **
 ** COMPONENT:      ENET Upper MAC SW
 **
 ** MODULE:         $File: //bwp/enet/demo153_sw/develop/src/mac_upper/um_interface_task.c $
 **
 ** VERSION:        $Revision: #9 $
 **
 ** DATED:          $Date: 2004/03/22 $
 **
 ** AUTHOR:         S Sondergaard
 **
 ** DESCRIPTION:    Upper MAC interface task
 **
 ** LAST MODIFIED BY:   $Author: prh $
 **
 ****************************************************************************
 **
 **  (c) Copyright 2001, TTPCom Limited
 **
 ****************************************************************************/
/*************************************************************************/
/***                        Include Files                              ***/
/*************************************************************************/
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "Utils_Api.h"
#include "mt_cachedefs.h"
#include "System_Information.h"
#include "ieee80211.h"
#include "frame.h"
#include "msgid.h"
#include "stringLibApi.h"
#include "umi.h"
#include "mib_id.h"
#include "mib_ms.h"
#include "database.h"       /* MAC internal */
#include "queue_utility.h"
#include "um_interface.h"
#include "mt_addr_sharing.h"
#include "mhi_mac_event.h"
#include "HostInterface_API.h"
#include "init_ifmsg.h"
#include "Debug_Trace.h"
#include "shram_man_msgs.h"
#include "mt_bcl_task.h"
#include "ProgModelLoader.h"
#include "lm_interface.h"
#include "Pac_Api.h"
#include "enet_pas.h"
#include "bss_manage_task.h"
#include "TxSelector_Api.h"
#include "RficDriver_API.h"
#include "mt_phy_statistics.h"
#include "PhyDriver_API.h"
#include "Dut_Api.h"
#include "mhi_umi.h"
#include "TsManager_API.h"
#include "Mac2index_Api.h"
#include "HwMemoryMap.h"
#include "HostInterfaceAcc_Api.h"
#include "HostInterface_API.h"
#include "TxPacketsClassifier_API.h"
#include "StaDatabase_Api.h"
#include "VapDatabase_Api.h"
#include "HwQManager_API.h"
#include "ShramRxDescriptors.h"
#include "StaDb.h"
#include "HostGenRiscInterface_Api.h"
#include "LinkAdaptation.h"
#include "RxPp_Api.h"
#include "HwLoggerAPI.h"
#include "RegAccess_Api.h"
#include "DummyPhyRegs.h"
#include "PhyDriver_API.h"
#include "Qos_Api.h"
#include "tx_application_Api.h" 
#include "TsManager_API.h"
#include "BSSmanager_API.h"
#include "StatisticsManager_api.h"
#include "StatisticsHandler.h"
#include "TsManager_API.h"
#include "StatisticsManager.h"
#include "HwSemaphore_API.h"
#include "RxManager_Api.h"
#include "PhyDriver_API.h"
#include "Qos_Api.h"
#include "Dut_Api.h"
#include "PSD.h"
#include "TsManagerCommonDefinitions.h"
#include "RxHandler_ScratchPadApi.h"
#include "RxHandler_InitApi.h"

#if defined (ENET_INC_ARCH_WAVE600)
#include "PreAggregator_Api.h"
#include "HeGroupManager_API.h"
#include "PlanManager_API.h"
#include "TwtManager_API.h"
#include "ConfigurationManager_api.h"
#else
#include "RxClassifier_Api.h"
#include "AggregationBuilder_Api.h"
#endif 
#include "HdkCdbManagerTask_api.h"
#include "PacketTrafficArbitrator_api.h"

/******************************************/
/*        DO NOT REMOVE THIS LINE!        */
/******************************************/
#include "loggerAPI.h"
/*temporary - untill set channel is implemented*/
#include "ProcessManager_Api.h"
#include "ServicesHandler_Api.h"
#include "Locker_Api.h"
#include "GroupDatabase_Api.h"
#include "GroupManager_API.h"
#include "TrainingManager_Api.h"

#ifndef TRAINING_WAVE600_Z0
#include "NdpaManager_Api.h"
#endif

#include "TxSender_ScratchPadApi.h"
#include "Atf_Api.h"
#include "EmeraldEnvRegs.h"
#include "RxDcOffsetClbrHndlr.h"
#include "RadarDetection.h"
#include "PacManager_api.h"

#if defined (ENABLE_PIE_TEST)
#include "mt_sysrst.h"
#endif


#ifdef ENET_INC_ARCH_WAVE600B
#include "HostIfAccRegs.h"
#endif //ENET_INC_ARCH_WAVE600B
#include "stringLibApi.h"

#define LOG_LOCAL_GID   GLOBAL_GID_UPPER_MAC_INTERFACE
#define LOG_LOCAL_FID 0
 
 
/***************************************************************************/
/***                  Local Constants                                    ***/
/***************************************************************************/
#define BIT_ERROR_RATE_1_TO_100000 		2778
#define BER_TYPE_VA  					0x80000003

#define MT_REQUEST_GET          0
#define MT_REQUEST_SET          1


#define 	CPU_SYSTEM_IF_BASE_ADDR UPPER_BBCPU_SYSTEM_IF_BASE_ADDR
#define		DUMMY_PHY_BAND1_OFFSET	0x400000 // 4M 

#define 	MIN_RETRY_LIMIT		0
#define 	MAX_RETRY_LIMIT		0xF


//#define NFRP_DEBUG
/***************************************************************************/
/*                    External Definitions                               ***/
/***************************************************************************/

/***************************************************************************/
/***                  Function prototypes                                ***/
/***************************************************************************/
static uint16 u16UM_TaskBody(K_MSG *psMsg);
void vUM_ACTIVATE_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_SET_MIB_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_GET_MIB_CFM(K_MSG *psMsg);
void vUM_SET_CHAN_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_SET_BCL_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_QUERY_BCL_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_GET_MAC_VERSION_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_SW_RESET_MAC_CFM(K_MSG *psMsg);
void vUMI_MC_MAN_GENERIC_MAC_CFM(K_MSG *psMsg);
void vUM_LM_STOP_CFM(K_MSG *psMsg);
static void vUM_GET_CHANNEL_LOAD_REQ(K_MSG* psMsg);
static void vMC_GET_CHANNEL_LOAD_CFM(K_MSG* psMsg);
static void vUM_MAN_GET_STATISTICS_REQ(K_MSG *psMsg);
static void vUM_MAN_GET_STATISTICS_CFM(K_MSG *psMsg);
static void vUM_MAN_QAMPLUS_ACTIVATE_REQ(K_MSG *psMsg);
static void vUM_MAN_QAMPLUS_ACTIVATE_CFM(K_MSG *psMsg);
static void vUM_MAN_TS_VAP_CONFIGURE_REQ(K_MSG *psMsg);
static void vUM_MAN_TS_VAP_CONFIGURE_CFM(K_MSG *psMsg);
static void vUM_MAN_MSDU_IN_AMSDU_CONFIG_REQ(K_MSG *psMsg);
static void vUM_MAN_MSDU_IN_AMSDU_CONFIG_CFM(K_MSG *psMsg);
static void vUM_MAN_MU_OPERATION_CONFIG_REQ(K_MSG *psMsg);
static void vUM_MAN_SET_RTS_MODE_REQ(K_MSG *psMsg);
static void vMC_MAN_MU_OPERATION_CONFIG_CFM(K_MSG *psMsg);
static void vUM_MAN_SET_RTS_MODE_CFM(K_MSG *psMsg);
static void vUM_MAN_PMCU_FREQ_CHANGE_REQ(K_MSG *psMsg);
static void vUM_MAN_PMCU_FREQ_CHANGE_CFM(K_MSG *psMsg);
static void vUM_MAN_ACTIVATE_REQ(K_MSG *psMsg);
static void vUM_MAN_NETWORK_EVENT_RES(K_MSG *psMsg);
static void vUM_MAN_FW_DBG_REQ(K_MSG *psMsg);
static void vUM_LM_STOP_REQ(K_MSG *psMsg);
static void vUM_MAN_GENERIC_MAC_REQ(K_MSG *psMsg);
static void vUM_MAN_SW_RESET_MAC_REQ(K_MSG *psMsg);
static void vUM_MAN_MAC_VARS_REQ(K_MSG *psMsg);
#ifndef DISABLE_EEPROM_FW_SUPPORT
static void vUM_MAN_MAC_EEPROM_REQ(K_MSG *psMsg);
#endif
void  vUMI_MC_MAN_SET_KEY_CFM(K_MSG *psMsg);
static void vUM_MAC_EVENT_IND(K_MSG *psMsg);
static void vUM_MAC_EVENT_RES(K_MSG *psMsg);
static void vUM_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ(K_MSG *psMsg);
static void vMC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM(K_MSG *psMsg);
static void vUM_MAN_HW_DEPENDENT_CONFIG_REQ(K_MSG *psMsg);
static void vMC_MAN_HW_DEPENDENT_CONFIG_CFM(K_MSG *psMsg);
static void vUM_MAN_SetDataPathParams(K_MSG *psMsg);
static void vUM_DBG_MAC_WATCHDOG_REQ( K_MSG* psMsg );
static void UMI_SET_ANTENNAS_REQ(K_MSG* psMsg);
static void UMI_SET_ANTENNAS_CFM(K_MSG* psMsg);
static void UMI_ADD_VAP_REQ(K_MSG* psMsg);
static void UMI_ADD_VAP_CFM(K_MSG* psMsg);
static void UMI_REMOVE_VAP_REQ(K_MSG* psMsg);
static void UMI_REMOVE_VAP_CFM(K_MSG* psMsg);
static void UMI_STOP_VAP_TRAFFIC_REQ(K_MSG* psMsg);
static void UMI_STOP_VAP_TRAFFIC_CFM(K_MSG* psMsg);
static void UMI_VAP_DB_REQ(K_MSG* psMsg);
static void MC_VAP_DB_CFM(K_MSG* psMsg);
static void UMI_SET_BSS_REQ(K_MSG* psMsg);
static void UMI_SET_BSS_CFM(K_MSG* psMsg);
static void UMI_SET_INTERFERER_DETECTION_PARAMS_REQ(K_MSG* psMsg);
static void UMI_SET_INTERFERER_DETECTION_PARAMS_CFM(K_MSG* psMsg);
static void UMI_ENABLE_RADAR_INDICATION_REQ(K_MSG* psMsg);
static void UMI_ENABLE_RADAR_INDICATION_CFM(K_MSG* psMsg);
static void UMI_CONTINUOUS_INTERFERER_IND(K_MSG* psMsg);
static void UMI_CONTINUOUS_INTERFERER_RES(K_MSG* psMsg);
static void UMI_RADAR_IND(K_MSG* psMsg);
static void UMI_RADAR_RES(K_MSG* psMsg);
static void UMI_POLL_CLIENT_REQ(K_MSG* psMsg);
static void UMI_POLL_CLIENT_CFM(K_MSG* psMsg);
/* Logger messages functions */
static void vUM_DBG_LOGGER_FLUSH_BUF_REQ(K_MSG *psMsg);
static void vMC_DBG_LOGGER_FLUSH_BUF_CFM(K_MSG *psMsg);
static void vUM_DBG_LOGGER_SET_MODE_REQ(K_MSG *psMsg);
static void vMC_DBG_LOGGER_SET_MODE_CFM(K_MSG *psMsg);
static void vUM_DBG_LOGGER_SET_SEVERITY_REQ(K_MSG *psMsg);
static void vMC_DBG_LOGGER_SET_SEVERITY_CFM(K_MSG *psMsg);
static void vUM_DBG_LOGGER_SET_FILTER_REQ(K_MSG *psMsg);
static void vMC_DBG_LOGGER_SET_FILTER_CFM(K_MSG *psMsg);
static void vUM_MAN_BA_AGREEMENT_PARAMS_REQ(K_MSG *psMsg);
static void vUM_DBG_DUT_MSG_REQ(K_MSG *psMsg);
static void vMC_DBG_DUT_MSG_CFM(K_MSG *psMsg);
static void UmDbgCliReq(K_MSG *kMsg_p);
static void McDbgTraceInd(K_MSG *kMsg_p);
static void UmDbgTraceRes(K_MSG *kMsg_p);
static void vUMI_MAN_SET_11B_ANT_REQ(K_MSG* psMsg);
static void vUMI_MAN_SET_11B_ANT_CFM(K_MSG* psMsg);
static void vUMI_MAN_STA_ADD_REQ(K_MSG *psMsg);
static void vUMI_MAN_STA_ADD_CFM(K_MSG *psMsg);
static void vUMI_MAN_STA_REMOVE_REQ(K_MSG *psMsg);
static void vUMI_MAN_STA_REMOVE_CFM(K_MSG *psMsg);
static void vUMI_MAN_SET_BEACON_TEMPLATE_REQ(K_MSG *psMsg);
static void vUMI_MAN_SET_BEACON_TEMPLATE_CFM(K_MSG *psMsg);
static void vUMI_MAN_BEACON_TEMPLATE_WAS_SET_IND(K_MSG *psMsg);
static void vUMI_MAN_BEACON_TEMPLATE_WAS_SET_RES(K_MSG *psMsg);	
static void vUMI_MAN_REQUEST_SID_REQ(K_MSG* psMsg);
static void vUMI_MAN_REQUEST_SID_CFM(K_MSG* psMsg);
static void vUMI_MAN_REMOVE_SID_REQ(K_MSG* psMsg);
static void vUMI_MAN_REMOVE_SID_CFM(K_MSG* psMsg);
static void vUMI_MAN_STOP_TRAFFIC_REQ(K_MSG* psMsg);
static void vUMI_MAN_STOP_TRAFFIC_CFM(K_MSG* psMsg);
static void vUMI_MAN_CLASS3_ERROR_IND(K_MSG *psMsg);
static void vUMI_MAN_CLASS3_ERROR_RES(K_MSG *psMsg);
static void vUMI_MAN_TKIP_MIC_FAILURE_IND(K_MSG *psMsg);
static void vUMI_MAN_TKIP_MIC_FAILURE_RES(K_MSG *psMsg);
static void vUMI_MAN_SET_WMM_PARAMETERS_REQ(K_MSG* psMsg);
static void vUMI_MAN_SET_WMM_PARAMETERS_CFM(K_MSG* psMsg);	
static void vUMI_MAN_SET_DEFAULT_KEY_INDEX_REQ(K_MSG* psMsg);
static void vUMI_MAN_SET_DEFAULT_KEY_INDEX_CFM(K_MSG* psMsg);
static void vUMI_MAN_SET_802_1X_FILTER_REQ(K_MSG* psMsg);
static void vUMI_MAN_SET_802_1X_FILTER_CFM(K_MSG* psMsg);
static void vUMI_ERROR_FUNC(K_MSG* psMsg);
static void vUMI_MAN_HW_LOGGER_ADD_STREAM_REQ(K_MSG *psMsg);
static void vUMI_MAN_HW_LOGGER_ADD_STREAM_CFM(K_MSG *psMsg);
static void vUMI_MAN_HW_LOGGER_REMOVE_STREAM_REQ(K_MSG *psMsg); 
static void umiDbgSetFixedRateCfm(K_MSG * psMsg);
static void vUMI_MAN_HW_LOGGER_ADD_FILTER_REQ(K_MSG *psMsg); 
static void vUMI_MAN_HW_LOGGER_REMOVE_FILTER_REQ(K_MSG *psMsg);
static void vUMI_MAN_HW_LOGGER_SET_TRIGGER_REQ(K_MSG *psMsg); 
static void vUMI_MAN_HW_LOGGER_RESET_TRIGGER_REQ(K_MSG *psMsg);
#if !defined (ENET_INC_ARCH_WAVE600)
static void PhyDrv_SetBer(uint32 factor); 
#endif //#if !defined (ENET_INC_ARCH_WAVE600)
#if defined (ENET_INC_ARCH_WAVE600)
#ifdef DEBUG_UM_INTERFACE
static void PhyDrv_SetBer(uint32 berVal, uint32 user, uint32 clearAllUsers,BandId_e band);
#endif
#endif
static void	UMI_SET_TPC_ANT_PARAMS_REQ(K_MSG* psMsg);
static void UMI_SET_TPC_ANT_PARAMS_CFM(K_MSG* psMsg);
static void UMI_SET_TPC_CONFIG_REQ(K_MSG* psMsg);
static void UMI_SET_TPC_CONFIG_CFM(K_MSG* psMsg);
static void UMI_SET_HDK_CONFIG_REQ(K_MSG* psMsg);
static void UMI_SET_HDK_CONFIG_CFM(K_MSG* psMsg);
static void UMI_CALIBRATE_REQ(K_MSG* psMsg);
static void UMI_CALIBRATE_CFM(K_MSG * psMsg);
static void UMI_PRE_ACTIVATE_REQ(K_MSG* psMsg);
static void UMI_PRE_ACTIVATE_CFM(K_MSG* psMsg);
static void UMI_DOWNLOAD_PROG_MODEL_DIFFS_REQ(K_MSG* psMsg);
static void UMI_PLATFORM_DATA_FIELDS_REQ(K_MSG* psMsg);
static void vUMI_PLATFORM_DATA_FIELDS_CFM(K_MSG* psMsg);
static void UMI_PLATFORM_TABLE_REQ(K_MSG* psMsg);
static void vUMI_PLATFORM_TABLE_CFM(K_MSG* psMsg);
static void UMI_SET_AFE_CALIBRATION_DATA_REQ(K_MSG* psMsg);
static void UMI_SET_AFE_CALIBRATION_DATA_CFM(K_MSG* psMsg);
static void UMI_SET_RFIC_CALIBRATION_DATA_REQ(K_MSG* psMsg);
static void UMI_SET_RFIC_CALIBRATION_DATA_CFM(K_MSG* psMsg);
static void vUMI_MAN_SET_MULTICAST_MODE_REQ(K_MSG* psMsg);
static void vUMI_MAN_SET_MULTICAST_MODE_CFM(K_MSG* psMsg);
static void vUMI_MAN_SET_MULTICAST_ACTION_REQ(K_MSG* psMsg);
static void vUMI_MAN_SET_MULTICAST_ACTION_CFM(K_MSG* psMsg);
static void UMI_SET_RSSI_CAL_PARAMS_REQ(K_MSG * psMsg);
static void UMI_SET_RSSI_CAL_DATA_CFM(K_MSG * psMsg);
static void UMI_ENABLE_RADIO_REQ(K_MSG* psMsg);
static void UMI_ENABLE_RADIO_CFM(K_MSG * psMsg);
static void UMI_SET_AGG_RATE_LIMIT_REQ(K_MSG * psMsg);
static void UMI_SET_AGG_RATE_LIMIT_CFM(K_MSG * psMsg);
static void UMI_SET_POWER_LIMIT_REQ(K_MSG * psMsg);
static void UMI_SET_POWER_LIMIT_CFM(K_MSG * psMsg);
static void UMI_SET_RX_TH_REQ(K_MSG* psMsg);
static void UMI_SET_RX_TH_CFM(K_MSG* psMsg);
static void UMI_SET_RX_DUTY_CYCLE_REQ(K_MSG* psMsg);
static void UMI_SET_RX_DUTY_CYCLE_CFM(K_MSG* psMsg);
static void UMI_SET_ADMISSION_CAPACITY_REQ(K_MSG * psMsg);
static void UMI_SET_ADMISSION_CAPACITY_CFM(K_MSG * psMsg);
static void UMI_HDK_USER_DEMAND_REQ(K_MSG * psMsg);
static void UMI_HDK_USER_DEMAND_CFM(K_MSG * psMsg);
static void UMI_CCA_TH_REQ(K_MSG* psMsg);
static void UMI_CCA_TH_CFM(K_MSG* psMsg);
static void vUM_MAN_SET_MAX_MPDU_LENGTH_REQ(K_MSG *psMsg);
static void vUMI_MAN_SET_MAX_MPDU_LENGTH_CFM(K_MSG *psMsg);
static void vUM_MAN_BF_MODE_CONFIG_REQ(K_MSG *psMsg);
static void vUM_MAN_FIXED_RATE_CONFIG_REQ(K_MSG *psMsg);
static void vUM_MAN_FIXED_RATE_CONFIG_CFM(K_MSG *psMsg);
static void vUM_MAN_LTF_AND_GI_CONFIG_CFM(K_MSG *psMsg);
#ifdef DEBUG_UM_INTERFACE
static void vUM_MAN_SET_IRE_SWITCH_B_CFM(K_MSG *psMsg);
static void UMI_SLOW_PROBING_MASK_CFM(K_MSG *psMsg);
#endif
static void vUM_MAN_SET_IRE_SWITCH_B_REQ(K_MSG *psMsg);
static void UMI_MAN_SSB_MODE_REQ(K_MSG* psMsg);
static void UMI_MAN_SSB_MODE_CFM(K_MSG * psMsg);
static void vUM_MAN_BEACON_IND(K_MSG *psMsg);
static void vUM_MAN_BEACON_RES(K_MSG *psMsg);
static void vUM_MAN_BEACON_BLOCKED_INTERVAL_REQ(K_MSG *psMsg);
static void vMC_MAN_BEACON_BLOCKED_INTERVAL_CFM(K_MSG* psMsg);
static void UMI_GET_CCA_TH_REQ(K_MSG *psMsg);
static void UMI_GET_CCA_TH_CFM(K_MSG* psMsg);
static void UMI_SLOW_PROBING_MASK_REQ(K_MSG *psMsg);
static void UMI_ERP_SET_REQ(K_MSG *psMsg);
static void UMI_ERP_SET_CFM(K_MSG *psMsg);
static void UMI_DMR_CONFIG_REQ(K_MSG *psMsg);
static void UMI_DMR_CONFIG_CFM(K_MSG *psMsg);
static void UMI_DUTY_CYCLE_SET_REQ(K_MSG *psMsg);
static void UMI_DUTY_CYCLE_SET_CFM(K_MSG *psMsg);
static void UMI_REG_DOMAIN_CONFIG_REQ(K_MSG *psMsg);
static void UMI_REG_DOMAIN_CONFIG_CFM(K_MSG *psMsg);

static void UMI_FAST_DROP_CONFIG_REQ(K_MSG *psMsg);
static void UMI_FAST_DROP_CONFIG_CFM(K_MSG *psMsg);
static void UMI_FIXED_POWER_REQ(K_MSG *psMsg);
static void UMI_OPERATING_MODE_REQ(K_MSG *psMsg);
static void  vUM_MAN_SET_QOS_PD_THRESH_REQ(K_MSG *psMsg);
static void  vUM_MAN_SET_QOS_PD_THRESH_CFM(K_MSG *psMsg);
static void  vUM_MAN_SET_RESTRICTED_AC_MODE_REQ(K_MSG *psMsg);
static void  vUM_MAN_SET_RESTRICTED_AC_MODE_CFM(K_MSG *psMsg);
static void UMI_FREQ_JUMP_MODE_REQ(K_MSG * psMsg);
static void UMI_FREQ_JUMP_MODE_CFM(K_MSG * psMsg);
static void vUM_MAN_SET_TXOP_CONFIG_REQ(K_MSG *psMsg);
static void vUM_MAN_SET_TXOP_CONFIG_CFM(K_MSG *psMsg);
static void vUM_MAN_SET_BEACON_INTERVAL_REQ(K_MSG *psMsg);
static void vUM_MAN_SET_AP_BEACON_INFO_REQ(K_MSG *psMsg);
static void vUM_MAN_SET_AP_BEACON_INFO_CFM(K_MSG *psMsg);
static void UMI_MAN_2_4GHZ_COEX_REQ(K_MSG *psMsg);
static void vUM_MAN_ATF_QUOTAS_REQ(K_MSG *psMsg);
static void vUM_MAN_ATF_QUOTAS_CFM(K_MSG *psMsg);
static void vUM_MAN_MU_STATIC_PLAN_CONFIG_REQ(K_MSG *psMsg);
#ifdef ENET_INC_ARCH_WAVE600
static void vUM_MAN_MU_STATIC_PLAN_CONFIG_CFM(K_MSG *psMsg);
static void vUM_MAN_HE_MU_OPERATION_CONFIG_CFM(K_MSG *psMsg);
static void vUM_MAN_HE_MU_DBG_IND(K_MSG *psMsg);
#endif
static void vUM_MAN_HE_MU_DBG_RES(K_MSG *psMsg);
 
static void UMI_SET_ANT_CONFIG_REQ(K_MSG * psMsg);
static void UMI_SET_ANT_CONFIG_CFM(K_MSG * psMsg);
static void UMI_PREPARE_ANT_CONFIG_REQ(K_MSG * psMsg);
static void UMI_PREPARE_ANT_CONFIG_CFM(K_MSG * psMsg);
static void vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM(K_MSG* psMsg);
static void vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM(K_MSG* psMsg);

static void vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG(K_MSG *psMsg);
static void vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM(K_MSG *psMsg);

static void UMI_FIXED_LTF_AND_GI_REQ(K_MSG *psMsg);

static void UMI_TEST_BUS_EN_REQ(K_MSG* psMsg);
#ifdef ENET_INC_ARCH_WAVE600
#ifdef DEBUG_UM_INTERFACE
static void UMI_TEST_BUS_EN_CFM(K_MSG* psMsg);
#endif
static void UMI_PVT_CFM(K_MSG* psMsg);
#endif
static void UMI_PVT_REQ(K_MSG* psMsg);

static void UMI_PROTECTION_RATE_CONFIG_REQ(K_MSG* psMsg);
static void UMI_PROTECTION_RATE_CONFIG_CFM(K_MSG* psMsg);

static void UMI_MAN_2_4GHZ_COEX_CFM(K_MSG *psMsg);
static void UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_REQ(K_MSG *psMsg);
static void UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_CFM(K_MSG *psMsg);

static void UMI_MAN_SET_HE_MU_FIXED_PARAMETERS_REQ(K_MSG *psMsg);
static void UMI_MAN_SET_HE_MU_FIXED_PARAMETERS_CFM(K_MSG *psMsg);

static void UMI_MAN_SET_HE_MU_DURATION_REQ(K_MSG *psMsg);
static void UMI_MAN_SET_HE_MU_DURATION_CFM(K_MSG *psMsg);

static void UMI_MAN_GET_TWT_PARAMS_REQ(K_MSG *psMsg);

static void UMI_MAN_GET_AX_DEFAULT_PARAMS_REQ(K_MSG *psMsg);

static void UMI_MAN_SET_ETSI_PPDU_DURATION_LIMITS_REQ(K_MSG *psMsg);

static void UMI_MAN_SET_RTS_THRESHOLD_REQ(K_MSG* psMsg);
static void UMI_MAN_SET_RTS_THRESHOLD_CFM(K_MSG* psMsg);

static void UMI_MAN_SET_RETRY_LIMIT_REQ(K_MSG* psMsg);
static void UMI_MAN_SET_RETRY_LIMIT_CFM(K_MSG* psMsg);


void UMI_IPC_TEST(K_MSG *pMsg);
#ifdef RXH_MAILBOX_TEST
void UMI_RXH_MAILBOX_TEST(K_MSG *pMsg);
#endif //RXH_MAILBOX_TEST
void UMI_SetPsdProgmodelShramAddress(void);
static void UMI_MAN_CPU_LOAD_REQ(K_MSG *pMsg);
static void UMI_MAN_CPU_LOAD_CFM(K_MSG *pMsg);
static void UMI_NFRP_CONFIG_REQ(K_MSG *pMsg);
static void UMI_NFRP_CONFIG_CFM(K_MSG *pMsg);
/***************************************************************************/
/***                  Static data                                        ***/
/***************************************************************************/
static const FunctionEntry_t afpTaskTable_reqres[UMI_TOTAL_NUM_MSGS]=
{
	{vUM_MAN_SET_MIB_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_MIB_REQ)},
	{vUM_MAN_GET_MIB_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_MIB_REQ)},
	{vUM_DOWNLOAD_PROG_MODEL_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_DOWNLOAD_PROG_MODEL_REQ)},
	{vUM_MAN_ACTIVATE_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_ACTIVATE_REQ)},
	{vUMI_MAN_CLASS3_ERROR_RES,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_CLASS3_ERROR_RES)},	
	{vUM_MAN_SET_KEY_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_KEY_REQ)},
	{vUM_MAN_SET_BCL_VALUE_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_BCL_VALUE)},
	{vUM_MAN_QUERY_BCL_VALUE_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_QUERY_BCL_VALUE)},
	{vUM_MAN_GET_SW_VERSION_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_MAC_VERSION_REQ)},
	{vUM_MAN_BA_AGREEMENT_PARAMS_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_BA_PARAMS_REQ)},
	{vUMI_MAN_SET_WMM_PARAMETERS_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_WMM_PARAMETERS_REQ)},
	{vUM_MAN_GENERIC_MAC_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GENERIC_MAC_REQ)}, 
	{vUM_MAN_SW_RESET_MAC_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SW_RESET_MAC_REQ)}, 
	{vUM_LM_STOP_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_LM_STOP_REQ)}, 
	{vUM_MAN_SetDataPathParams,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DATA_PATH_INIT_REQ)}, 
	{UMI_PVT_REQ,										DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_PVT_READ_REQ)},
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_CONFIG_GPIO_REQ)}, 	
	{vUM_MAN_GET_GROUP_PN_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_GROUP_PN_REQ)}, 	
	{vUM_SET_CHAN_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_SET_CHAN_REQ)},
	{vUM_GET_CHANNEL_LOAD_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_CHANNEL_LOAD_REQ)}, 	
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_LED_REQ)}, 	
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_DEF_RF_MGMT_DATA_REQ)}, 	
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_DEF_RF_MGMT_DATA_REQ)}, 	
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SEND_MTLK_VSAF_REQ)}, 	
	{UMI_SET_ANTENNAS_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(MC_MAN_SET_ANTENNAS_REQ)}, 	
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_RF_MGMT_SET_TYPE_REQ)}, 	
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_RF_MGMT_GET_TYPE_REQ)}, 	
	{vUM_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ,		DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ)}, 	
	{vUM_MAN_HW_DEPENDENT_CONFIG_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HW_DEPENDENT_CONFIG_REQ)}, 			
	{UMI_STOP_VAP_TRAFFIC_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_STOP_VAP_TRAFFIC_REQ)}, 
	{UMI_VAP_DB_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_VAP_DB_REQ)}, 
	{UMI_ADD_VAP_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_ADD_VAP_REQ)}, 
	{UMI_REMOVE_VAP_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_REMOVE_VAP_REQ)},
	{UMI_SET_BSS_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_BSS_SET_BSS_REQ)}, 
	{UMI_SET_INTERFERER_DETECTION_PARAMS_REQ,			DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_INTERFERER_DETECTION_PARAMS_REQ)}, 
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_CHANGE_11B_THRESHOLD_REQ)}, 
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_11B_THRESHOLD_REQ)}, 
	{vUMI_MAN_SET_11B_ANT_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SEND_11B_SET_ANT_REQ)}, 
	{vUM_MAN_NETWORK_EVENT_RES,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_NETWORK_EVENT_RES)}, 
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DYNAMIC_PARAM_RES)}, 
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_PM_UPDATE_RES)}, 
	{UmDbgTraceRes,										DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_TRACE_RES)},
	{UMI_CONTINUOUS_INTERFERER_RES,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_CONTINUOUS_INTERFERER_RES)}, 
	{UMI_RADAR_RES,							            DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_RADAR_RES)},		
    {UMI_HDK_USER_DEMAND_REQ,                           DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HDK_USER_DEMAND_REQ)}, 
    {vUM_MAN_QAMPLUS_ACTIVATE_REQ,                      DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_QAMPLUS_ACTIVATE_REQ)}, 
    {vUM_MAN_GET_STATISTICS_REQ,                 		DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_STATISTICS_REQ)},
    {vUM_DBG_DUT_MSG_REQ,                               DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_DUT_MSG_REQ)},     
    {vUM_MAN_PMCU_FREQ_CHANGE_REQ,                      DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_PMCU_FREQ_CHANGE_REQ)},   
	{vUM_DBG_MAC_WATCHDOG_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_MAC_WATCHDOG_REQ)}, 	
	{vUM_DBG_LOGGER_FLUSH_BUF_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_LOGGER_FLUSH_BUF_REQ)}, 	
	{vUM_DBG_LOGGER_SET_MODE_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_LOGGER_SET_MODE_REQ)}, 	
	{vUM_DBG_LOGGER_SET_SEVERITY_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_LOGGER_SET_SEVERITY_REQ)}, 	
	{vUM_DBG_LOGGER_SET_FILTER_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_LOGGER_SET_FILTER_REQ)}, 	
	{UmDbgCliReq,										DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_CLI_REQ)},
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_BA_TX_STATUS_RES)}, 	
	{vUM_MAC_EVENT_RES,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_MAC_EVENT_RES)}, 		
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_MULTICAST_PS_SIZE_REQ)},
	{vUM_MAN_FW_DBG_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_DBG_FW_DBG_REQ)},
	{vUMI_MAN_STA_ADD_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_STA_ADD_REQ)}, 
	{vUMI_MAN_STA_REMOVE_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_STA_REMOVE_REQ)}, 
	{vUMI_MAN_SET_BEACON_TEMPLATE_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_BEACON_TEMPLATE_REQ)}, 
	{vUMI_MAN_BEACON_TEMPLATE_WAS_SET_RES,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_BEACON_TEMPLATE_WAS_SET_RES)}, 
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_PREAMBLE_MODE_REQ)}, 
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_SLOT_TIME_REQ)}, 
	{vUMI_ERROR_FUNC,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_PROTECTION_REQ)}, 
	{vUMI_MAN_REQUEST_SID_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_REQUEST_SID_REQ)}, 	
	{vUMI_MAN_REMOVE_SID_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_REMOVE_SID_REQ)}, 
	{vUMI_MAN_STOP_TRAFFIC_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_STOP_TRAFFIC_REQ)},
	{vUMI_MAN_SET_DEFAULT_KEY_INDEX_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_DEFAULT_KEY_INDEX_REQ)},
	{vUMI_MAN_SET_802_1X_FILTER_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_802_1X_FILTER_REQ)},	
	{vUMI_MAN_TKIP_MIC_FAILURE_RES,				        DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_TKIP_MIC_FAILURE_RES)},
	{vUMI_MAN_HW_LOGGER_ADD_STREAM_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HW_LOGGER_ADD_STREAM_REQ)},
	{vUMI_MAN_HW_LOGGER_REMOVE_STREAM_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HW_LOGGER_REMOVE_STREAM_REQ)},
	{vUMI_MAN_HW_LOGGER_ADD_FILTER_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HW_LOGGER_ADD_FILTER_REQ)},
	{vUMI_MAN_HW_LOGGER_REMOVE_FILTER_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HW_LOGGER_REMOVE_FILTER_REQ)},
	{vUMI_MAN_HW_LOGGER_SET_TRIGGER_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HW_LOGGER_SET_TRIGGER_REQ)},
	{vUMI_MAN_HW_LOGGER_RESET_TRIGGER_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HW_LOGGER_RESET_TRIGGER_REQ)},
	{UMI_SET_TPC_ANT_PARAMS_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_TPC_ANT_PARAMS_REQ)},
	{UMI_SET_TPC_CONFIG_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_TPC_CONFIG_REQ)},
	{UMI_SET_HDK_CONFIG_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HDK_CONFIG_REQ)},
	{UMI_POLL_CLIENT_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_POLL_CLIENT_REQ)},  
	{UMI_PRE_ACTIVATE_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_MBSS_PRE_ACTIVATE_REQ)},  
	{UMI_CALIBRATE_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_CALIBRATE_REQ)},
	{UMI_DOWNLOAD_PROG_MODEL_DIFFS_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DOWNLOAD_PROG_MODEL_20_40_DIFFS_REQ)},  
	{vUMI_MAN_SET_MULTICAST_MODE_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_MULTICAST_MODE_REQ)},  
	{vUMI_MAN_SET_MULTICAST_ACTION_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_MULTICAST_ACTION_REQ)},  	
	{UMI_PLATFORM_DATA_FIELDS_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_PLATFORM_DATA_FIELDS_REQ)}, 
	{UMI_PLATFORM_TABLE_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_PLATFORM_TABLE_REQ)},
	{UMI_SET_AFE_CALIBRATION_DATA_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_AFE_CALIBRATION_DATA_REQ)},
	{UMI_SET_RFIC_CALIBRATION_DATA_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_RFIC_CALIBRATION_DATA_REQ)},
	{UMI_SET_RSSI_CAL_PARAMS_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_RSSI_CAL_PARAMS_REQ)},
	{UMI_ENABLE_RADIO_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_ENABLE_RADIO_REQ)},
	{UMI_ENABLE_RADAR_INDICATION_REQ,				    DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_ENABLE_RADAR_INDICATION_REQ)},		
	{UMI_SET_AGG_RATE_LIMIT_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_AGG_RATE_LIMIT_REQ)},
	{UMI_SET_POWER_LIMIT_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_POWER_LIMIT_REQ)},
	{UMI_TEST_BUS_EN_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_TEST_BUS_EN_REQ)},
	{UMI_SET_RX_TH_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_RX_TH_REQ)},
	{UMI_SET_RX_DUTY_CYCLE_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_RX_DUTY_CYCLE_REQ)},	
	{UMI_SET_ADMISSION_CAPACITY_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_ADMISSION_CAPACITY_REQ)},
	{UMI_MAN_CPU_LOAD_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_CPU_LOAD_REQ)},
	{vUM_MAN_TS_VAP_CONFIGURE_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_TS_VAP_CONFIGURE_REQ)}, 
	{vUM_MAN_MSDU_IN_AMSDU_CONFIG_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_MSDU_IN_AMSDU_CONFIG_REQ)}, 
	{vUM_MAN_MU_OPERATION_CONFIG_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_MU_OPERATION_CONFIG_REQ)}, 
	{UMI_CCA_TH_REQ,									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_CCA_TH_REQ)},
    {vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG,            DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_REQ)}, 
	{vUM_MAN_SET_RTS_MODE_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_RTS_MODE_CONFIG_REQ)}, 
	{vUM_MAN_SET_MAX_MPDU_LENGTH_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_MAX_MPDU_LENGTH_REQ)}, 
	{vUM_MAN_BF_MODE_CONFIG_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_BF_MODE_CONFIG_REQ)},
	{vUM_MAN_SET_IRE_SWITCH_B_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_IRE_SWITCH_B_REQ)},
	{vUM_MAN_FIXED_RATE_CONFIG_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_FIXED_RATE_CONFIG_REQ)},
	{UMI_MAN_SSB_MODE_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SSB_MODE_REQ)},
	{vUM_MAN_BEACON_RES,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_BEACON_BLOCKED_RES)},
	{vUM_MAN_BEACON_BLOCKED_INTERVAL_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_BEACON_BLOCKED_INTERVAL_REQ)},
	{UMI_GET_CCA_TH_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_CCA_TH_REQ)},
	{UMI_FREQ_JUMP_MODE_REQ, 							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_FREQ_JUMP_MODE_REQ)},
	{UMI_SLOW_PROBING_MASK_REQ,				   			DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SLOW_PROBING_MASK_REQ)},
	{vUM_MAN_SET_TXOP_CONFIG_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_TXOP_CONFIG_REQ)},	
	{vUM_MAN_SET_BEACON_INTERVAL_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_BEACON_INTERVAL_REQ)},	
	{UMI_MAN_2_4GHZ_COEX_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_2_4GHZ_COEX_REQ)},
    {vUM_MAN_ATF_QUOTAS_REQ,                            DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_ATF_QUOTAS_REQ)},
	{vUM_MAN_MU_STATIC_PLAN_CONFIG_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_STATIC_PLAN_CONFIG_REQ)},
	{vUMI_ERROR_FUNC, 									DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HE_MU_OPERATION_CONFIG_REQ)},
	{UMI_FIXED_LTF_AND_GI_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_FIXED_LTF_AND_GI_REQ)},	
	{UMI_FIXED_POWER_REQ,				   				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_FIXED_POWER_REQ)},
	{UMI_OPERATING_MODE_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_OPERATING_MODE_REQ)},
	{UMI_SET_ANT_CONFIG_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HDK_ANT_CONFIG_REQ)},
	{UMI_PREPARE_ANT_CONFIG_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HDK_PREPARE_ANT_CONFIG_CHANGE_REQ)},
	{vUM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_REQ,		DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_REQ)},
	{vUM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_REQ,		DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_REQ)},
    {vUM_MAN_SET_QOS_PD_THRESH_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_QOS_PD_THRESH_REQ)},	
	{vUM_MAN_SET_RESTRICTED_AC_MODE_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_RESTRICTED_AC_MODE_REQ)},
	{UMI_FAST_DROP_CONFIG_REQ, 			 				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_FAST_DROP_CONFIG_REQ)},
	{UMI_ERP_SET_REQ, 			 						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_ERP_SET_REQ)},
	{UMI_DMR_CONFIG_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DMR_CONFIG_REQ)},
	{vUM_MAN_HE_MU_DBG_RES,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_HE_MU_DBG_RES)},
	{UMI_REG_DOMAIN_CONFIG_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_REG_DOMAIN_CONFIG_REQ)},
	{UMI_PROTECTION_RATE_CONFIG_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_RTS_RATE_SET_REQ)},	
	{UMI_NFRP_CONFIG_REQ,								DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_NFRP_CONFIG_REQ)},
	{UMI_DUTY_CYCLE_SET_REQ,							DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_DUTY_CYCLE_SET_REQ)},
	{UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_REQ,				DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_DYNAMIC_MU_TYPE_REQ )}	,
	{UMI_MAN_SET_HE_MU_FIXED_PARAMETERS_REQ,			DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_HE_MU_FIXED_PARAMETERS_REQ )},	
	{UMI_MAN_SET_HE_MU_DURATION_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_HE_MU_DURATION_REQ )},
	{UMI_MAN_GET_TWT_PARAMS_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_TWT_PARAMS_REQ)},	
	{UMI_MAN_GET_AX_DEFAULT_PARAMS_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_GET_AX_DEFAULT_PARAMS_REQ)},
	{UMI_MAN_SET_ETSI_PPDU_DURATION_LIMITS_REQ,			DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_ETSI_PPDU_DURATION_LIMITS_REQ)},
	{UMI_MAN_SET_RTS_THRESHOLD_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_RTS_THRESHOLD_REQ)},
	{UMI_MAN_SET_RETRY_LIMIT_REQ,						DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_RETRY_LIMIT_REQ)},
	{vUM_MAN_SET_AP_BEACON_INFO_REQ,					DOUBLE_CHECK_MSG_TYPE_HIM(UM_MAN_SET_AP_BEACON_INFO_REQ)}
 };

static const FunctionEntry_t afpTaskTable_cfmind[TASK_UMI_END - TASK_UMI_START]=
{
	{vUM_DOWNLOAD_PROG_MODEL_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_UM_DOWNLOAD_PROG_MODEL_CFM)},
	{vUM_LM_STOP_CFM,								DOUBLE_CHECK_MSG_TYPE(UMI_UM_LM_STOP_CFM)},
	{UMI_PRE_ACTIVATE_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_BSS_PRE_ACTIVATE_CFM)},
	{UMI_ADD_VAP_CFM,								DOUBLE_CHECK_MSG_TYPE(UMI_BSS_ADD_VAP_CFM)},
	{UMI_REMOVE_VAP_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_BSS_REMOVE_VAP_CFM)},
	{UMI_STOP_VAP_TRAFFIC_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_BSS_STOP_VAP_TRAFFIC_CFM)},
	{UMI_SET_BSS_CFM,								DOUBLE_CHECK_MSG_TYPE(UMI_BSS_SET_BSS_CFM)},
	{UMI_SET_ANTENNAS_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_UM_SET_ANTENNAS_CFM)},
	{vUMI_MC_MAN_SET_BCL_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_BCL_CFM)},
	{vUMI_MC_MAN_QUERY_BCL_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_QUERY_BCL_CFM)},
 	{vUMI_MC_MAN_GENERIC_MAC_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_GENERIC_MAC_CFM)},
	{vUMI_MC_MAN_SW_RESET_MAC_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SW_RESET_MAC_CFM)},
 	{vUMI_MC_MAN_SET_KEY_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_KEY_CFM)},
	{vMC_GET_CHANNEL_LOAD_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_GET_CHANNEL_LOAD_CFM)},
	{vMC_MAN_GET_GROUP_PN_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_GET_GROUP_PN_CFM)},
 	{vUM_MAC_EVENT_IND,								DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_MAC_EVENT_IND)},
	{vMC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM,	DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM) },
	{vMC_DBG_LOGGER_FLUSH_BUF_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_DBG_LOGGER_FLUSH_BUF_CFM)},
	{vMC_DBG_LOGGER_SET_MODE_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_DBG_LOGGER_SET_MODE_CFM)},
	{vMC_DBG_LOGGER_SET_SEVERITY_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MC_DBG_LOGGER_SET_SEVERITY_CFM)},
	{vMC_DBG_LOGGER_SET_FILTER_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_DBG_LOGGER_SET_FILTER_CFM)},
	{UMI_SET_INTERFERER_DETECTION_PARAMS_CFM,		DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_INTERFERER_DETECTION_PARAMS_CFM)},
	{UMI_CONTINUOUS_INTERFERER_IND,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_CONTINUOUS_INTERFERER_IND)},	
	{UMI_RADAR_IND, 								DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_RADAR_IND)},	
	{UMI_ENABLE_RADAR_INDICATION_CFM, 		        DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_ENABLE_RADAR_INDICATION_CFM)},
	{vMC_MAN_HW_DEPENDENT_CONFIG_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_KMSG_HW_DEPENDENT_CONFIG_CFM)},	
	{McDbgTraceInd,				                	DOUBLE_CHECK_MSG_TYPE(UMI_MC_DBG_TRACE_IND)},
	{vMC_DBG_DUT_MSG_CFM,					    	DOUBLE_CHECK_MSG_TYPE(UMI_DUT_MSG_CFM)},
	{vUM_SET_CHAN_CFM,					    		DOUBLE_CHECK_MSG_TYPE(UMI_UM_SET_CHAN_CFM)},
	{vUMI_MAN_SET_11B_ANT_CFM,			    		DOUBLE_CHECK_MSG_TYPE(UMI_MAN_SEND_11B_SET_ANT_CFM)},
	{vUMI_MAN_STA_ADD_CFM,				    		DOUBLE_CHECK_MSG_TYPE(UMI_STA_ADD_CFM)},
	{vUMI_MAN_STA_REMOVE_CFM,			    		DOUBLE_CHECK_MSG_TYPE(UMI_STA_REMOVE_CFM)},
	{vUMI_MAN_SET_BEACON_TEMPLATE_CFM,	    		DOUBLE_CHECK_MSG_TYPE(UMI_SET_BEACON_TEMPLATE_CFM)},
	{vUMI_MAN_BEACON_TEMPLATE_WAS_SET_IND,	   		DOUBLE_CHECK_MSG_TYPE(UMI_BEACON_TEMPLATE_WAS_SET_IND)},
	{vUMI_MAN_REQUEST_SID_CFM,			    		DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_REQUEST_SID_CFM)},
	{vUMI_MAN_REMOVE_SID_CFM,			    		DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_REMOVE_SID_CFM)},
	{vUMI_MAN_STOP_TRAFFIC_CFM,			    		DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_STOP_TRAFFIC_CFM)},
	{vUMI_MAN_CLASS3_ERROR_IND,	    				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_CLASS3_ERROR_IND)},
	{vUMI_MAN_TKIP_MIC_FAILURE_IND,	                DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_TKIP_MIC_FAILURE_INDICATION)},	
	{vUMI_MAN_SET_WMM_PARAMETERS_CFM,  				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_WMM_PARAMETERS_CFM)},
	{vUMI_MAN_SET_DEFAULT_KEY_INDEX_CFM,			DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_DEFAULT_KEY_INDEX_CFM)},
	{vUMI_MAN_SET_802_1X_FILTER_CFM,  				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_802_1X_FILTER_CFM)},
	{UMI_SET_TPC_ANT_PARAMS_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_TPC_ANT_PARAMS_CFM)},
	{UMI_SET_TPC_CONFIG_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_TPC_CONFIG_CFM)},
	{UMI_SET_HDK_CONFIG_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_HDK_CONFIG_CFM)},
	{vUMI_MAN_HW_LOGGER_ADD_STREAM_CFM, 			DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_ADD_STREAM_CFM)},
	{umiDbgSetFixedRateCfm, 						DOUBLE_CHECK_MSG_TYPE(UMI_DBG_SET_FIXED_RATE_CFM)},
	{vUMI_DOWNLOAD_PROG_MODEL_DIFFS_CFM,			DOUBLE_CHECK_MSG_TYPE(UMI_DOWNLOAD_PROG_MODEL_DIFFS_CFM)},
	{vUMI_PLATFORM_DATA_FIELDS_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_PLATFORM_DATA_FIELDS_CFM)}, 
	{vUMI_PLATFORM_TABLE_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_PLATFORM_TABLE_CFM)}, 
	{UMI_SET_AFE_CALIBRATION_DATA_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_AFE_CALIBRATION_DATA_CFM)},
	{UMI_SET_RFIC_CALIBRATION_DATA_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_RFIC_CALIBRATION_DATA_CFM)},
	{vUMI_MAN_SET_MULTICAST_MODE_CFM, 				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_MULTICAST_MODE_CFM)},	
	{vUMI_MAN_SET_MULTICAST_ACTION_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_MULTICAST_ACTION_CFM)},
	{UMI_SET_RSSI_CAL_DATA_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_RSSI_CAL_DATA_CFM)},
	{UMI_ENABLE_RADIO_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_ENABLE_RADIO_CFM)},
	{UMI_SET_AGG_RATE_LIMIT_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_AGG_RATE_LIMIT_CFM)},
	{UMI_SET_POWER_LIMIT_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_POWER_LIMIT_CFM)},
	{vUM_MAN_GET_STATISTICS_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_GET_STATISTICS_CFM)},
	{UMI_SET_RX_TH_CFM, 							DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_RX_TH_CFM)},
	{UMI_SET_RX_DUTY_CYCLE_CFM, 					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_RX_DUTY_CYCLE_CFM)},
	{UMI_SET_ADMISSION_CAPACITY_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_UPDATE_ADMISSION_CAPACITY_CFM)},
	{UMI_CALIBRATE_CFM,								DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_CALIBRATE_CFM)},	
    {vUM_MAN_PMCU_FREQ_CHANGE_CFM,                  DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_PMCU_FREQ_CHANGE_CFM)},	
	{UMI_HDK_USER_DEMAND_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_HDK_USER_DEMAND_CFM)},
	{vUM_MAN_QAMPLUS_ACTIVATE_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MAN_QAMPLUS_ACTIVATE_CFM)}, 
	{vUM_MAN_TS_VAP_CONFIGURE_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MAN_TS_VAP_CONFIGURE_CFM)}, 
	{vUM_MAN_MSDU_IN_AMSDU_CONFIG_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MAN_MSDU_IN_AMSDU_CONFIG_CFM)},
	{vMC_MAN_MU_OPERATION_CONFIG_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MULTI_USER_OPERATION_SETTING_CFM)},
	{UMI_CCA_TH_CFM,								DOUBLE_CHECK_MSG_TYPE(UMI_MAN_CCA_TH_CFM)},	
	{vUM_MAN_SET_RTS_MODE_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_RTS_MODE_SETTING_CFM)},	
	{vUMI_MAN_SET_MAX_MPDU_LENGTH_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MAX_MPDU_LEN_CFM)},
	{vUM_MAN_FIXED_RATE_CONFIG_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_FIXED_RATE_CONFIG_CFM)},
	{UMI_IPC_TEST,									DOUBLE_CHECK_MSG_TYPE(UMI_DBG_IPC_TEST)},/*IPC test */		
#ifdef RXH_MAILBOX_TEST
	{UMI_RXH_MAILBOX_TEST,							DOUBLE_CHECK_MSG_TYPE(UMI_DBG_RXH_MAILBOX_TEST)},/*RxH Mailbox test */		
#endif //RXH_MAILBOX_TEST
	{vUM_MAN_BEACON_IND,							DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_BEACON_BLOCKING_IND)},
	{vMC_MAN_BEACON_BLOCKED_INTERVAL_CFM,			DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_BEACON_BLOCKING_INTERVAL_CFM)},
	{UMI_GET_CCA_TH_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_MAN_GET_CCA_TH_CFM)},
	{UMI_FREQ_JUMP_MODE_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_FREQ_JUMP_MODE_CFM)},
	{vUM_MAN_SET_TXOP_CONFIG_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_TXOP_CONFIG_CFM)},
    {vUM_MAN_ATF_QUOTAS_CFM,                        DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_ATF_QUOTAS_CFM)},      
#ifdef ENET_INC_ARCH_WAVE600
	{vUM_MAN_MU_STATIC_PLAN_CONFIG_CFM,				DOUBLE_CHECK_MSG_TYPE(UM_MAN_STATIC_PLAN_CONFIG_CFM)},
	{vUM_MAN_HE_MU_OPERATION_CONFIG_CFM,			DOUBLE_CHECK_MSG_TYPE(UM_MAN_HE_MU_OPERATION_CONFIG_CFM)},
#endif 
	{UMI_MAN_SSB_MODE_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SSB_MODE_CFM)},
	{vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM,	DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM)},
	{UMI_SET_ANT_CONFIG_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_ANT_CONFIG_CFM)},
	{UMI_PREPARE_ANT_CONFIG_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_PREPARE_ANT_CONFIG_CFM)},
	{vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM,	DOUBLE_CHECK_MSG_TYPE(UMI_UM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM)},
	{vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM,	DOUBLE_CHECK_MSG_TYPE(UMI_UM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM)},
    {vUM_MAN_SET_QOS_PD_THRESH_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_QOS_PD_THRESH_CFM)},	
    {vUM_MAN_SET_RESTRICTED_AC_MODE_CFM,			DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_SET_RESTRICTED_AC_MODE_CFM)},
	{UMI_FAST_DROP_CONFIG_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_FAST_DROP_CONFIG_CFM)},
	{UMI_ERP_SET_CFM,								DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_ERP_SET_CFM)},
	{UMI_DMR_CONFIG_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_DMR_CONFIG_CFM)},
#ifdef ENET_INC_ARCH_WAVE600
	{vUM_MAN_HE_MU_DBG_IND,							DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_HE_MU_DEBUG_IND)},
#endif 
	{UMI_REG_DOMAIN_CONFIG_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_REG_DOMAIN_CONFIG_CFM)},
#ifdef ENET_INC_ARCH_WAVE600
	{UMI_PVT_CFM,									DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_PVT_CFM)},
#endif
	{UMI_MAN_CPU_LOAD_CFM,						    DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_CPU_LOAD_CFM)},
	{UMI_PROTECTION_RATE_CONFIG_CFM,                DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_PROTECTION_RATE_CONFIG_CFM)},
	{UMI_MAN_2_4GHZ_COEX_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_2_4GHZ_COEX_CFM)},
	{UMI_DUTY_CYCLE_SET_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_DUTY_CYCLE_SET_CFM)},
	{UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_CFM,			DOUBLE_CHECK_MSG_TYPE(UMI_MC_SET_DYNAMIC_MU_TYPE_CFM )},	
	{UMI_MAN_SET_HE_MU_FIXED_PARAMETERS_CFM,		DOUBLE_CHECK_MSG_TYPE(UMI_MC_SET_HE_MU_FIXED_PARAMETERS_CFM )},	
	{UMI_MAN_SET_HE_MU_DURATION_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MC_SET_HE_MU_DURATION_CFM )},
#ifdef DEBUG_UM_INTERFACE
	{vUM_MAN_SET_IRE_SWITCH_B_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_IRE_SWITCH_B_CFM)},
#endif
	{vUM_MAN_LTF_AND_GI_CONFIG_CFM, 				DOUBLE_CHECK_MSG_TYPE(UMI_MC_MAN_LTF_AND_GI_CONFIG_CFM)},
#ifdef DEBUG_UM_INTERFACE
	{UMI_SLOW_PROBING_MASK_CFM,						DOUBLE_CHECK_MSG_TYPE(UMI_MC_SLOW_PROBING_MASK_CFM)},	
#ifdef ENET_INC_ARCH_WAVE600
	{UMI_TEST_BUS_EN_CFM,							DOUBLE_CHECK_MSG_TYPE(UMI_MC_TEST_BUS_EN_CFM)},
#endif
#endif
	{UMI_MAN_SET_RTS_THRESHOLD_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_SET_RTS_THRESHOLD_CFM)},
	{UMI_MAN_SET_RETRY_LIMIT_CFM,					DOUBLE_CHECK_MSG_TYPE(UMI_MC_SET_RETRY_LIMIT_CFM)},
	{vUM_MAN_SET_AP_BEACON_INFO_CFM,				DOUBLE_CHECK_MSG_TYPE(UMI_MC_SET_AP_BEACON_INFO_CFM)}
};


FwUtils_queue_t  sUmiIndFreeQueue;   /* Holds the UMI ind/res while free */
uint8 tempPreActivateFlag = 0; 
UMI_FW_DBG_REQ*	dummyVar = NULL; 
uint32* p32PsdProgmodelShramAddress = (uint32*)(au8RxCircBuf+sizeof(LM_VECTOR_BLOCK));
#ifdef DEBUG_STA_MODE_RSSI
bool PowerManagementIndication = FALSE;
#endif

/***************************************************************************/
/***						Debug Section 								 ***/
/***************************************************************************/
#if defined (HOST_MESSAGES_STATISTICS)
/* a struct with all messages arrays besides UM<-->Host interrupts */
HostIFStatisticsArrays_T UMSTAT_HostIFStats;
#endif /* (HOST_MESSAGES_STATISTICS) */

/***************************************************************************/
/***                  Public Routines                                    ***/
/***************************************************************************/

/****************************************************************************
**
** NAME:           vUM_IF_Init
**
** PARAMETERS:     none
**
** RETURN VALUES:  none
**
** DESCRIPTION:    initialization entry point for task
**
****************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void vUM_IF_Init(void)
{
	/* Initialize the queue that will store the UMI NETWORK/CONNECTION and BSSID_RESPORTS IND/RES messages during action */
    vInit_IFmsg(BSS_IND_COUNT + STA_IND_COUNT, sizeof(UMI_IND), &sUmiIndFreeQueue, (K_MSG *) &asMAN_IndData[0]);
#ifdef HOST_MESSAGES_STATISTICS		
	memset(&UMSTAT_HostIFStats, 0, sizeof(HostIFStatisticsArrays_T));
#endif	//HOST_MESSAGES_STATISTICS
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=default
#endif

/****************************************************************************
**
** NAME:           u16UMIsendMsg
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    API for MAC
**
****************************************************************************/
uint16 u16UMIsendMsg(UMI_MSG *psMsg)
{
	/* Just call task directly */
    return (u16UM_TaskBody((K_MSG *) psMsg ));
}

/****************************************************************************
**
** NAME:           vUM_IF_Task
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Main entry point for task
**
****************************************************************************/
void vUM_IF_Task(K_MSG *psMsg)
{
	vTaskDispatcher(psMsg, afpTaskTable_cfmind, TASK_UMI_START, TASK_UMI_END);
}

/***************************************************************************/
/***                  State handling routines                            ***/
/***************************************************************************/

/****************************************************************************
**
** NAME:           u16UM_TaskBody
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Common body of task used by both calling methods
**
****************************************************************************/

static uint16 u16UM_TaskBody(K_MSG *psMsg)
{

	LOGGER_API_LOG_KERNEL_EVENT(KERNEL_EVENT_RECV_FROM_HOST_MSG, psMsg);
	// Get only the MSG ID (without the information about the direction and type)
	psMsg->header.tKMsgType = MSG_GET_NUM(psMsg->header.tKMsgType);
#ifdef TLOG_FLAG	
	TLOG0(psMsg, TRUE);
#endif
	vTaskDispatcher(psMsg, afpTaskTable_reqres, UMI_MSGS_START, UMI_TOTAL_NUM_MSGS);	
    return (UMI_OK);
}

/****************************************************************************
**
** NAME:           UMI_SET_ANTENNAS_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_SET_ANTENNAS_REQ message
**
****************************************************************************/
static void UMI_SET_ANTENNAS_REQ(K_MSG* psMsg)
{
	UMI_SET_ANTENNAS *umiSetAnt;
	umiSetAnt = (UMI_SET_ANTENNAS*)pK_MSG_DATA(psMsg);
	
	umiSetAnt->status = UMI_OK;
	
	VALIDATE_PARAM(umiSetAnt->TxAntsMask, ANT_PARAMS_TX_MASK_MIN, ANT_PARAMS_TX_MASK_MAX, umiSetAnt->status);
	VALIDATE_PARAM(umiSetAnt->RxAntsMask, ANT_PARAMS_RX_MASK_MIN, ANT_PARAMS_RX_MASK_MAX, umiSetAnt->status);
	
	if (umiSetAnt->status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_COC_SET_ANTENNAS_REQ_CFM);
		OSAL_SEND_MESSAGE(COC_SET_ANTENNAS_REQ, TASK_COC, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(UM_MAN_SET_ANTENNAS_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           SET_ANTENNAS
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Send UM_MAN_SET_ANTENNAS_CFM back to driver
**
****************************************************************************/
static void UMI_SET_ANTENNAS_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_COC_SET_ANTENNAS_REQ_CFM);
	vUMI_SendToMC(UM_MAN_SET_ANTENNAS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           vUM_DBG_MAC_WATCHDOG_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_DBG_MAC_WATCHDOG_REQ message
**
****************************************************************************/
static void vUM_DBG_MAC_WATCHDOG_REQ( K_MSG* psMsg )
{
	UMI_MAC_WATCHDOG *pUmiMacWatchdog = (UMI_MAC_WATCHDOG *)pK_MSG_DATA( psMsg );
		
	UMSTAT_INC_DBG_REQ_ARR(UMSTAT_DBG_MAC_WATCHDOG_REQ_CFM);
	pUmiMacWatchdog->u8Status = UMI_OK;
	UMSTAT_INC_DBG_CFM_ARR(UMSTAT_DBG_MAC_WATCHDOG_REQ_CFM);
	vUMI_SendToMC(MC_DBG_MAC_WATCHDOG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           vUM_MAN_BA_PARAMS_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UMI_AGGR_PARAMS message
**
****************************************************************************/
void vUM_MAN_BA_AGREEMENT_PARAMS_REQ(K_MSG *psMsg)
{
	UMI_AGGR_PARAMS* psBaParams = ( UMI_AGGR_PARAMS* ) pK_MSG_DATA( psMsg );

#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	psBaParams->u8VapId = psMsg->header.vapId;
#endif

	psBaParams->u16Status = UMI_OK;
	vUMI_SendToMC(MC_MAN_BA_PARAMS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_PRE_ACTIVATE_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_MBSS_PRE_ACTIVATE_REQ message
**
****************************************************************************/
static void UMI_PRE_ACTIVATE_REQ(K_MSG* psMsg)
{
	K_MSG *pMsg;
	ProcessRequestParams_t *processRequestParams;

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_PRE_ACTIVATE_REQ_CFM);
	

#if	defined(ENET_INC_ARCH_WAVE600)
	if (tempPreActivateFlag > 1)
#else
	if (tempPreActivateFlag > 0)
#endif
	{
		UMI_PRE_ACTIVATE_CFM(psMsg); 
		return; 
	}
	tempPreActivateFlag++; 
	
	TxApp_EnableTraceX(); 

	/* Schedule Process*/	
	pMsg = OSAL_GET_MESSAGE(sizeof(ProcessRequestParams_t));
	processRequestParams = (ProcessRequestParams_t*)pK_MSG_DATA(pMsg);
	processRequestParams->processId 				= PROCESS_ID_ACTIVATE; 
	processRequestParams->startProcessMsg			= BSS_MANAGE_BSS_START_ACTIVATE_PROCESS;
	processRequestParams->endProcessMsg 			= BSS_MANAGE_BSS_FINALIZE_ACTIVATE_PROCESS;
	processRequestParams->requesterParams			= (void*)psMsg; // Store the MSG from driver for later CFM.
	processRequestParams->preProcessServiceBitmap	= 0;
	processRequestParams->postProcessServiceBitmap	= 0;
	processRequestParams->returnTask				= TASK_BSS_MANAGER;
	processRequestParams->updateParamsBeforeFinalizing = FALSE;
	processRequestParams->serviceData				= 0;
	processRequestParams->vapId						= psMsg->header.vapId;
	processRequestParams->dualBandProcess					= FALSE;
	processRequestParams->processMsgHandledByCdbProcessMan	= FALSE;	
	OSAL_SEND_MESSAGE(PROCESS_MANAGER_SCHEDULE_PROCESS_REQUEST,TASK_PROCESS_MANAGER,pMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:           UM_MAN_MBSS_PRE_ACTIVATE_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_MBSS_PRE_ACTIVATE_CFM message
**
****************************************************************************/
static void UMI_PRE_ACTIVATE_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_PRE_ACTIVATE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_MBSS_PRE_ACTIVATE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_CALIBRATE_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    stub for handling calibrate request
**
****************************************************************************/
static void UMI_CALIBRATE_REQ(K_MSG * psMsg)
{
	uint8 i;
	UMI_CALIBRATE_PARAMS *calibrationRequestParams =  (UMI_CALIBRATE_PARAMS *)pK_MSG_DATA(psMsg);
	calibrationRequestParams->Status = UMI_OK;

	VALIDATE_PARAM(calibrationRequestParams->num_chans, NUM_CHANS_MIN, NUM_CHANS_MAX, calibrationRequestParams->Status);
	VALIDATE_PARAM(calibrationRequestParams->chan_width, CHAN_WIDTH_MIN, CHAN_WIDTH_MAX, calibrationRequestParams->Status);
	
	for(i = 0; i < calibrationRequestParams->num_chans; i++)
	{
		VALIDATE_PARAM(calibrationRequestParams->chan_nums[i], CHAN_NUMS_MIN, CHAN_NUMS_MAX, calibrationRequestParams->Status);
	}
	
	if(calibrationRequestParams->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_CALIBRATE_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_CALIBRATE_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_CALIBRATE_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           UMI_CALIBRATE_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    stub for handling calibrate request
**
****************************************************************************/
static void UMI_CALIBRATE_CFM(K_MSG * psMsg)
{

	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_CALIBRATE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_CALIBRATE_CFM, psMsg);
}

 /****************************************************************************
**
** NAME:           UMI_ADD_VAP_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_ADD_VAP_REQ message
**
****************************************************************************/
static void UMI_ADD_VAP_REQ(K_MSG* psMsg)
{

	UMI_ADD_VAP* addVapStructurePtr; 
	
	addVapStructurePtr = (UMI_ADD_VAP*) pK_MSG_DATA(psMsg);	
	addVapStructurePtr->Status = UMI_OK;
	
	VALIDATE_PARAM(addVapStructurePtr->operationMode, VAP_ADD_OPER_MODE_MIN, VAP_ADD_OPER_MODE_MAX, addVapStructurePtr->Status);

	if(addVapStructurePtr->Status == UMI_OK)
	{
		OSAL_SEND_MESSAGE(BSS_MANAGER_BSS_ADD_VAP_REQ, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[UMI_ADD_VAP_REQ LA]");
#endif
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_ADD_VAP_REQ_CFM);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_ADD_VAP_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           UMI_ADD_VAP_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle BSS_ADD_VAP_CFM message
**
****************************************************************************/
static void UMI_ADD_VAP_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_ADD_VAP_REQ_CFM);
 	vUMI_SendToMC(MC_MAN_ADD_VAP_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_DEACTIVATE_VAP_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_REMOVE_VAP_REQ message
**
****************************************************************************/
static void UMI_REMOVE_VAP_REQ(K_MSG* psMsg)
{
	
    UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_REMOVE_VAP_REQ_CFM);
 	OSAL_SEND_MESSAGE(BSS_MANAGER_BSS_REMOVE_VAP_REQ, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:           UMI_STOP_VAP_TRAFFIC_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_STOP_VAP_TRAFFIC_REQ message
**
****************************************************************************/
static void UMI_STOP_VAP_TRAFFIC_REQ(K_MSG* psMsg)
{
	
    UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_STOP_VAP_TRAFFIC_REQ_CFM);
	OSAL_SEND_MESSAGE(BSS_MANAGER_STOP_VAP_TRAFFIC_REQ, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:           UMI_VAP_DB_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UMI_VAP_DB_REQ message
**
****************************************************************************/
static void UMI_VAP_DB_REQ(K_MSG* psMsg)
{
    UMI_VAP_DB_OP*  vapDbOpPtr; 
    vapDbOpPtr = ((UMI_VAP_DB_OP*)pK_MSG_DATA(psMsg)); 

#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	vapDbOpPtr->u8VAPIdx = psMsg->header.vapId;
#endif


    if (vapDbOpPtr->u8VAPIdx >= HW_NUM_OF_VAPS)
    {
         vapDbOpPtr->u16Status = UMI_VAP_DB_FAIL; /* what kind of Fail message do we need to fill here?  */ 
    }
    MC_VAP_DB_CFM(psMsg);  /* call to send CFM to MC  */
    /* Do nothing at the moment */
}

/****************************************************************************
**
** NAME:           MC_VAP_DB_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_VAP_DB_CFM message
**
****************************************************************************/
static void MC_VAP_DB_CFM(K_MSG* psMsg)
{
	/* send confirm to Mac client */ 
    vUMI_SendToMC(MC_MAN_VAP_DB_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_REMOVE_VAP_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UMI_REMOVE_VAP_CFM message
**
****************************************************************************/
static void UMI_REMOVE_VAP_CFM(K_MSG* psMsg)
{
	UMI_REMOVE_VAP* pRemoveVapMsg = (UMI_REMOVE_VAP*)pK_MSG_DATA(psMsg); 

	pRemoveVapMsg->u16Status = UMI_OK; 
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_REMOVE_VAP_REQ_CFM);
	vUMI_SendToMC(MC_MAN_REMOVE_VAP_CFM, psMsg);	
}

/****************************************************************************
**
** NAME:           UMI_STOP_VAP_TRAFFIC_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UMI_STOP_VAP_TRAFFIC_CFM message
**
****************************************************************************/
static void UMI_STOP_VAP_TRAFFIC_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_STOP_VAP_TRAFFIC_REQ_CFM);
	vUMI_SendToMC(MC_MAN_STOP_VAP_TRAFFIC_CFM, psMsg);	
}

/****************************************************************************
**
** NAME:           UMI_VAP_SET_BSS_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_SET_BSS_REQ message
**
****************************************************************************/
static void UMI_SET_BSS_REQ(K_MSG* psMsg)
{
	UMI_SET_BSS* setBssStructurePtr; 
	setBssStructurePtr =(UMI_SET_BSS*)pK_MSG_DATA(psMsg);	
	
#ifndef ENET_INC_ARCH_WAVE600
    UMI_SET_BSS* setBssStructurePtr;
	UNUSED_PARAM(setBssStructurePtr);
#endif

	setBssStructurePtr->Status = UMI_OK;

	VALIDATE_PARAM(setBssStructurePtr->protectionMode, BSS_SET_PROT_MOD_MIN, BSS_SET_PROT_MOD_MAX, setBssStructurePtr->Status);
	VALIDATE_PARAM(setBssStructurePtr->slotTime, BSS_SET_SLOT_TIME_MIN, BSS_SET_SLOT_TIME_MAX, setBssStructurePtr->Status);
	VALIDATE_PARAM(setBssStructurePtr->twtOpreationMode, BSS_SET_TWT_OP_MOD_MIN, BSS_SET_TWT_OP_MOD_MAX, setBssStructurePtr->Status);

	VALIDATE_PARAM(setBssStructurePtr->fixedMcsVapManagement, BSS_SET_FIXED_MCS_VAPS_MGMT_MIN, BSS_SET_FIXED_MCS_VAPS_MGMT_MAX, setBssStructurePtr->Status);

	if(setBssStructurePtr->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_BSS_REQ_CFM);
		OSAL_SEND_MESSAGE(BSS_MANAGER_BSS_SET_BSS_REQ, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_BSS_SET_BSS_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           UMI_VAP_LIMITS_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_CHECK_AND_SET_VAP_LIMITS_CFM message
**
****************************************************************************/
static void UMI_SET_BSS_CFM(K_MSG* psMsg)
{
	vUMI_SendToMC(MC_BSS_SET_BSS_CFM, psMsg);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_BSS_REQ_CFM);
}

/****************************************************************************
**
** NAME:           vUM_GET_CHANNEL_LOAD_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_GET_CHANNEL_LOAD_REQ message
**
****************************************************************************/
static void vUM_GET_CHANNEL_LOAD_REQ(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_CHANNEL_LOAD_REQ_CFM);
	OSAL_SEND_MESSAGE(CHANNEL_SWITCH_MANAGER_GET_CHANNEL_LOAD, TASK_CHANNEL_SWITCH_MANAGER , psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:           vMC_GET_CHANNEL_LOAD_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_GET_CHANNEL_LOAD_CFM message
**
****************************************************************************/
static void vMC_GET_CHANNEL_LOAD_CFM(K_MSG* psMsg)
{
	vUMI_SendToMC(MC_MAN_GET_CHANNEL_LOAD_CFM, psMsg);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_CHANNEL_LOAD_REQ_CFM);
}

/****************************************************************************
**
** NAME:           UMI_SET_INTERFERER_DETECTION_PARAMS_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_SET_INTERFERER_DETECTION_PARAMS_REQ message
**
****************************************************************************/
static void UMI_SET_INTERFERER_DETECTION_PARAMS_REQ(K_MSG* psMsg)
{
	UMI_INTERFERER_DETECTION_PARAMS *InterfererDetectionParametersMessage = (UMI_INTERFERER_DETECTION_PARAMS *)pK_MSG_DATA(psMsg);

	InterfererDetectionParametersMessage->Status = UMI_OK;
	
	if (InterfererDetectionParametersMessage->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(InterfererDetectionParametersMessage->threshold, INTRFRER_THRSH_MIN, INTRFRER_THRSH_MAX, InterfererDetectionParametersMessage->Status);
	}
	
	if (InterfererDetectionParametersMessage->Status == UMI_OK)
	{
		ILOG2_D("UMI_SET_INTERFERER_DETECTION_PARAMS_REQ: time %u", GET_TSF_TIMER_LOW());
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_INTERFERER_DETECTION_PARAMS_REQ_CFM);
		OSAL_SEND_MESSAGE(INTERFERER_DETECTION_SET_INTERFERER_DETECTION_PARAMETERS, TASK_INTERFERER_DETECTION, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_INTERFERER_DETECTION_PARAMS_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           UMI_SET_INTERFERER_DETECTION_PARAMS_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_ENABLE_DETECTION_CFM message
**
****************************************************************************/
static void UMI_SET_INTERFERER_DETECTION_PARAMS_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_INTERFERER_DETECTION_PARAMS_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_INTERFERER_DETECTION_PARAMS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_ENABLE_RADAR_INDICATION_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_ENABLE_RADAR_INDICATION_REQ message
**
****************************************************************************/
static void UMI_ENABLE_RADAR_INDICATION_REQ(K_MSG* psMsg)
{
	UMI_ENABLE_RADAR_INDICATION* enableRadarIndicationMessage = (UMI_ENABLE_RADAR_INDICATION *)pK_MSG_DATA(psMsg);
	
	enableRadarIndicationMessage->Status = UMI_OK;
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_ENABLE_RADAR_INDICATION_REQ_CFM);
	OSAL_SEND_MESSAGE(INTERFERER_DETECTION_ENABLE_RADAR_INDICATION, TASK_INTERFERER_DETECTION, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:           UMI_ENABLE_RADAR_INDICATION_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_ENABLE_RADAR_INDICATION_CFM message
**
****************************************************************************/
static void UMI_ENABLE_RADAR_INDICATION_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_ENABLE_RADAR_INDICATION_REQ_CFM);
	vUMI_SendToMC(MC_MAN_ENABLE_RADAR_INDICATION_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_POLL_CLIENT_REQ
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_POLL_CLIENT_REQ message
**
****************************************************************************/
static void UMI_POLL_CLIENT_REQ(K_MSG* psMsg)
{
	UMI_POLL_CLIENT_t* pollClientReq = (UMI_POLL_CLIENT_t *)pK_MSG_DATA(psMsg);
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_POLL_CLIENT_REQ_CFM);
	/*  Get activity indication from RXC
		if FALSE - check whether station is in a static group, and if TRUE FW shall mark the station as active
	*/
#ifdef ENET_INC_ARCH_WAVE600
	pollClientReq->Status = UMI_OK;

	VALIDATE_PARAM(pollClientReq->stationIndex, STATION_ID_MIN, STATION_ID_MAX, pollClientReq->Status);
	
	if(pollClientReq->Status == UMI_OK)
	{
		pollClientReq->isActive = Pac_RxcGetAndClearStationActivity(pollClientReq->stationIndex) || heGroupManager_IsStationInStaticPlan(pollClientReq->stationIndex);

		if (pollClientReq->isActive == FALSE)
		{
			ILOG0_D("UMI_POLL_CLIENT_REQ: Station %d is not showing activity", pollClientReq->stationIndex);
		}
	}
#else
	pollClientReq->isActive = Pac_RxcGetAndClearStationActivity(pollClientReq->stationIndex);
#endif
	SLOG0(0, 0, UMI_POLL_CLIENT_t, pollClientReq);

	UMI_POLL_CLIENT_CFM(psMsg);
}

/****************************************************************************
**
** NAME:           UMI_POLL_CLIENT_CFM
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle MC_MAN_POLL_CLIENT_CFM message
**
****************************************************************************/
static void UMI_POLL_CLIENT_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_POLL_CLIENT_REQ_CFM);
	vUMI_SendToMC(MC_MAN_POLL_CLIENT_CFM, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_CONTINUOUS_INTERFERER_IND
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UMI_MC_MAN_CONTINUOUS_INTERFERER_IND message
**
****************************************************************************/
static void UMI_CONTINUOUS_INTERFERER_IND(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_CONTINUOUS_INTERFERER_IND_RES);
	vUMI_AllocAndSendToMC(&sUmiIndFreeQueue, MC_MAN_CONTINUOUS_INTERFERER_IND, psMsg);
}
/****************************************************************************
**
** NAME:           UMI_CONTINUOUS_INTERFERER_RES
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_CONTINUOUS_INTERFERER_RES message
**
****************************************************************************/
static void UMI_CONTINUOUS_INTERFERER_RES(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_CONTINUOUS_INTERFERER_IND_RES);
	OSAL_SEND_NO_DATA_MESSAGE(INTERFERER_DETECTION_CONTINUOUS_INTERFERER_RES_ARRIVED, TASK_INTERFERER_DETECTION, psMsg->header.vapId);
	OSAL_QUEUE_MSG(&sUmiIndFreeQueue, psMsg);
}
/****************************************************************************
**
** NAME:           UMI_RADAR_IND
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UMI_MC_MAN_RADAR_IND message
**
****************************************************************************/
static void UMI_RADAR_IND(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_RADAR_IND_RES);
 	vUMI_AllocAndSendToMC(&sUmiIndFreeQueue, MC_MAN_RADAR_IND, psMsg);
}

/****************************************************************************
**
** NAME:           UMI_RADAR_RES
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_RADAR_RES message
**
****************************************************************************/
static void UMI_RADAR_RES(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_RADAR_IND_RES);
	OSAL_QUEUE_MSG(&sUmiIndFreeQueue, psMsg);
}

/****************************************************************************
**
** NAME:           vUM_SET_CHAN_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_SET_CHAN_CFM message
**
****************************************************************************/
void vUM_SET_CHAN_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_CHAN_REQ_CFM);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[vUM_SET_CHAN_CFM]");
#endif
    vUMI_SendToMC( UM_SET_CHAN_CFM, psMsg );
}

/****************************************************************************
**
** NAME:           vUM_MAN_SET_KEY_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_SET_KEY_REQ message
**
****************************************************************************/
void vUM_MAN_SET_KEY_REQ(K_MSG *psMsg)
{
    UMI_SET_KEY*	pSetKey;
	pSetKey = (UMI_SET_KEY *)pK_MSG_DATA(psMsg);
	
	pSetKey->u16Status = UMI_OK;
	
	//Validate Keyparams.. Actual key not validated
	VALIDATE_PARAM((pSetKey->u16KeyType), KEY_TYPE_MIN, KEY_TYPE_MAX, (pSetKey->u16Status));
	VALIDATE_PARAM((pSetKey->u16CipherSuite), KEY_CIPHER_SUITE_MIN, KEY_CIPHER_SUITE_MAX, (pSetKey->u16Status));
	VALIDATE_PARAM((pSetKey->u16KeyIndex), KEY_IDX_MIN, KEY_IDX_MAX, (pSetKey->u16Status));		

	if(pSetKey->u16Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_KEY_REQ_CFM);
		AAA_DEBUG_KERNEL_SCHEDULER_MACRO(SET_KEY,((pSetKey->u16KeyIndex & 0xf) | (0xf & pSetKey->u16KeyType) << 4), ((pSetKey->u16Sid & 0xff) | (0xff & pSetKey->u16CipherSuite) << 8));
#ifdef ENET_INC_ARCH_WAVE600
		SLOG0(0, 0, UMI_SET_KEY, pSetKey);
#endif
		if (pSetKey->u16KeyType == UMI_RSN_GROUP_KEY)
		{
			OSAL_SEND_MESSAGE(ENCRYPTION_SET_KEY_VAP, TASK_ENCRYPTION, psMsg, psMsg->header.vapId);
		}
		else // UMI_RSN_PAIRWISE_KEY
		{
			OSAL_SEND_MESSAGE(ENCRYPTION_SET_KEY_STA, TASK_ENCRYPTION, psMsg, psMsg->header.vapId);
		}
	}
	else
	{				      
		vUMI_SendToMC(MC_MAN_SET_KEY_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           vUM_MAN_ACTIVATE_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_ACTIVATE_REQ message
**
****************************************************************************/
static void vUM_MAN_ACTIVATE_REQ(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
 	ASSERT(0);
}

/****************************************************************************
**
** NAME:           vUM_ACTIVATE_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_ACTIVATE_CFM message
**
****************************************************************************/
void vUM_ACTIVATE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_ACTIVATE_REQ_CFM);	
    /* Forward to MC */
    vUMI_SendToMC( MC_MAN_ACTIVATE_CFM, psMsg );
}

/****************************************************************************
**
** NAME:           vUM_MAN_NETWORK_EVENT_RES
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_NETWORK_EVENT_RES message
**
****************************************************************************/
static void vUM_MAN_NETWORK_EVENT_RES(K_MSG *psMsg)
{
	byte localPersistant =psMsg->header.bPersistentMsg;
	
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_NETWORK_EVENT_IND_RES);
    /* Forward to BSS manage */
	psMsg->header.tKMsgType = BSS_MANAGE_UM_NETWORK_EVENT_RES;
	vBSS_ReturnUmiResource(psMsg);
	OSAL_FREE_MESSAGE(psMsg,localPersistant);
}

/****************************************************************************
**
** NAME:           vUM_FW_DBG_REQ
**
** PARAMETERS:  UMI_FW_DBG_REQ message which contains the  UmiDebugType_e   
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle vUM_FW_DBG_REQ message
**
****************************************************************************/
static void vUM_MAN_FW_DBG_REQ(K_MSG *psMsg)
{
#ifdef DEBUG_UM_INTERFACE
	UMI_FW_DBG_REQ* psFwDbgReq = (UMI_FW_DBG_REQ *)pK_MSG_DATA(psMsg);
	UmiDebugType_e	debugType = (UmiDebugType_e)psFwDbgReq->debugType; 

	UMSTAT_INC_DBG_REQ_ARR(UMSTAT_DBG_FW_DBG_REQ_CFM);
	UMSTAT_INC_DBG_CFM_ARR(UMSTAT_DBG_FW_DBG_REQ_CFM);
	vUMI_SendToMC(MC_DBG_FW_DBG_CFM, psMsg); /* Send confirmation to host */ 
	switch(debugType)
	{
	case UMI_DEBUG_ASSERT: 
		FATAL("Debug Assert Requested by Host");
		break; 
	case UMI_DEBUG_EXCEPTION: 
		dummyVar->debugType = debugType; 
		break; 
	default:
		ASSERT(0); 
	}
    /* REVISIT - reset not supported */ 
#else
	vUMI_SendToMC(MC_DBG_FW_DBG_CFM, psMsg); /* Send confirmation to host */ 
#endif
}

/****************************************************************************
**
** NAME:           vUM_SET_CHAN_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
void vUM_SET_CHAN_REQ(K_MSG *psMsg)
{
	UM_SET_CHAN_PARAMS *pUmSetChannelParams = (UM_SET_CHAN_PARAMS *)pK_MSG_DATA(psMsg);

	pUmSetChannelParams->Status = UMI_OK;

	VALIDATE_PARAM(pUmSetChannelParams->low_chan_num, CHAN_PARAMS_CHAN_NUM_MIN, CHAN_PARAMS_CHAN_NUM_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->low_chan_num2, CHAN_PARAMS_CHAN_NUM_MIN, CHAN_PARAMS_CHAN_NUM_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->chan_width, CHAN_PARAMS_CHAN_BANDWIDTH_MIN, CHAN_PARAMS_CHAN_BANDWIDTH_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->primary_chan_idx, CHAN_PARAMS_CHAN_NUM_MIN, CHAN_PARAMS_CHAN_NUM_MAX, pUmSetChannelParams->Status);	
	VALIDATE_PARAM(pUmSetChannelParams->chan_switch_time, CHAN_PARAMS_CHAN_SWITCH_TIME_MIN, CHAN_PARAMS_CHAN_SWITCH_TIME_MAX, pUmSetChannelParams->Status);

	VALIDATE_PARAM(pUmSetChannelParams->switch_type, CHAN_PARAMS_CHAN_SWITCH_TYPE_MIN, CHAN_PARAMS_CHAN_SWITCH_TYPE_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->block_tx_pre, CHAN_PARAMS_BLOCK_TX_PRE_MIN, CHAN_PARAMS_BLOCK_TX_PRE_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->block_tx_post, CHAN_PARAMS_BLOCK_TX_POST_MIN, CHAN_PARAMS_BLOCK_TX_POST_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->bg_scan, CHAN_PARAMS_BG_SCAN_MIN, CHAN_PARAMS_BG_SCAN_MAX, pUmSetChannelParams->Status);

	VALIDATE_PARAM(pUmSetChannelParams->isContinuousInterfererDetectionNeeded, CHAN_PARAMS_CONT_INTERFER_MIN, CHAN_PARAMS_CONT_INTERFER_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->isRadarDetectionNeeded, CHAN_PARAMS_RADAR_DET_MIN, CHAN_PARAMS_RADAR_DET_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->antennaMask, CHAN_PARAMS_ANT_MASK_MIN, CHAN_PARAMS_ANT_MASK_MAX, pUmSetChannelParams->Status);
	VALIDATE_PARAM(pUmSetChannelParams->ChannelNotificationMode, CHAN_PARAMS_CHAN_NOTIFICATION_MIN, CHAN_PARAMS_CHAN_NOTIFICATION_MAX, pUmSetChannelParams->Status);

	
	switch(pUmSetChannelParams->RegulationType)
	{
		case REGD_CODE_UNKNOWN:
		case REGD_CODE_FCC:
		case REGD_CODE_DOC:

		case REGD_CODE_ETSI:
		case REGD_CODE_SPAIN:
		case REGD_CODE_FRANCE:
		case REGD_CODE_UAE:
		case REGD_CODE_GERMANY:

		case REGD_CODE_MKK:
		case REGD_CODE_ISRAEL:
		case REGD_CODE_SINGAPORE:
		case REGD_CODE_AUSTRALIA:
		case REGD_CODE_BRAZIL:
		case REGD_CODE_CHINA:

		case REGD_CODE_APAC:
		case REGD_CODE_JAPAN:
			break;

		default:
			pUmSetChannelParams->Status = UMI_BAD_PARAMETER;
			break;
	}

	/* Check that the channel switch timer values are coherent */
	if (pUmSetChannelParams->switch_type == ST_CSA)
	{
		if (((pUmSetChannelParams->csaUcDeAuthVapBitmap != 0) && (pUmSetChannelParams->csaMcDeAuthVapBitmap != 0) && (pUmSetChannelParams->csaTxUcDeauthStartTime >= pUmSetChannelParams->csaTxMcDeauthStartTime))
			||
			(pUmSetChannelParams->csaTxMcDeauthStartTime >= pUmSetChannelParams->chan_switch_time))
		{
				pUmSetChannelParams->Status = UMI_BAD_PARAMETER;
		}
	}

	if(pUmSetChannelParams->Status == UMI_OK)
	{
		uint8 index = 0;		
		
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_CHAN_REQ_CFM);
#ifdef BEEROCK_DEBUG
		ILOG0_V("[vUM_SET_CHAN_REQ]");
#endif

		/* In case we are in dual band, convert VAP ID dependent parameters to actual VAP  */
		if (ConfigurationManager_GetBandConfigurationMode() == BAND_CONFIGURATION_MODE_DUAL_BAND)
		{			
			if (ConfigurationManager_GetBandForVap(psMsg->header.vapId) == CONFIGURATION_MANAGER_BAND_0)
			{
				pUmSetChannelParams->csaUcDeAuthVapBitmap = (pUmSetChannelParams->csaUcDeAuthVapBitmap << 16);
				pUmSetChannelParams->csaMcDeAuthVapBitmap = (pUmSetChannelParams->csaMcDeAuthVapBitmap << 16);
				pUmSetChannelParams->csaIsMcDeauthFrameEncrypted = (pUmSetChannelParams->csaIsMcDeauthFrameEncrypted << 16);

				for (index = 0; index < 16; index++)
				{
					pUmSetChannelParams->csaMcDeauthFramesLocation[index + 16] = pUmSetChannelParams->csaMcDeauthFramesLocation[index];		
					pUmSetChannelParams->csaMcDeauthFrameLength[index + 16] = pUmSetChannelParams->csaMcDeauthFrameLength[index]; 		
				}				
			}
		}

		SLOG0(0, 0, UM_SET_CHAN_PARAMS, pUmSetChannelParams);		

		OSAL_SEND_MESSAGE(CHANNEL_SWITCH_MANAGER_SET_CHANNEL_REQ, TASK_CHANNEL_SWITCH_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		pUmSetChannelParams->result = SET_CHANNEL_RESULT_FAIL; // Mark result as fail since we didn't do this channel switch.
		vUMI_SendToMC(UM_SET_CHAN_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           vUM_MAN_GET_GROUP_PN_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_GET_GROUP_PN_REQ message: request group PN
**
****************************************************************************/
void vUM_MAN_GET_GROUP_PN_REQ(K_MSG *psMsg)
{
	UMI_GROUP_PN *pGroupPN = NULL;
    uint8 isEncryptionEanbled = FALSE;
	uint8 vapId = 0;
	byte localPersistant = psMsg->header.bPersistentMsg;

    pGroupPN = (UMI_GROUP_PN *)pK_MSG_DATA(psMsg);

#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	pGroupPN->vapIndex = psMsg->header.vapId;
#endif
	
	vapId = psMsg->header.vapId;
    isEncryptionEanbled = VapDB_IsDataEncryptionEnabled(vapId);
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_GROUP_PN_REQ_CFM);
	if (isEncryptionEanbled)
	{
		VapDB_GetPn(vapId, pGroupPN->au8TxSeqNum);
		pGroupPN->u16Status = UMI_OK;
	}
	else
	{
		pGroupPN->u16Status = UMI_NOT_INITIALISED;
	}
	SLOG0(0, 0, UMI_GROUP_PN, pGroupPN);
	
	psMsg->header.tKMsgType = UMI_MC_MAN_GET_GROUP_PN_CFM;
	vMC_MAN_GET_GROUP_PN_CFM(psMsg);
	OSAL_FREE_MESSAGE(psMsg,localPersistant);
}

/****************************************************************************
**
** NAME:           vMC_MAN_GET_GROUP_PN_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_GET_GROUP_PN_REQ message: request group PN
**
****************************************************************************/
 void vMC_MAN_GET_GROUP_PN_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_GROUP_PN_REQ_CFM);
    vUMI_SendToMC(MC_MAN_GET_GROUP_PN_CFM, psMsg);
}


/****************************************************************************
**
** NAME:			vUM_MAN_QAMPLUS_ACTIVATE_CFM
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handles the UM_MAN_QAMPLUS_ACTIVATE_CFM message. 
** SION
****************************************************************************/
static void vUM_MAN_QAMPLUS_ACTIVATE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_QAMPLUS_REQ_CFM);
	vUMI_SendToMC(MC_MAN_QAMPLUS_ACTIVATE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_MAN_TS_VAP_CONFIGURE_CFM
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handles the vUM_MAN_TS_VAP_CONFIGURE_CFM message. 
** 
****************************************************************************/
static void vUM_MAN_TS_VAP_CONFIGURE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_TS_VAP_CONFIGURE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_TS_VAP_CONFIGURE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_MAN_MSDU_IN_AMSDU_CONFIG_CFM
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handles the vUM_MAN_MSDU_IN_AMSDU_CONFIG_CFM message. 
** 
****************************************************************************/
static void vUM_MAN_MSDU_IN_AMSDU_CONFIG_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_MSDU_IN_AMSDU_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_MSDU_IN_AMSDU_CONFIG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vMC_MAN_MU_OPERATION_CONFIG_CFM
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handles the vMC_MAN_MU_OPERATION_CONFIG_CFM message. 
** 
****************************************************************************/
static void vMC_MAN_MU_OPERATION_CONFIG_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_MU_OPERATION_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_MU_OPERATION_CONFIG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_MAN_SET_RTS_MODE_CFM
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handles the vUM_MAN_SET_RTS_MODE_CFM message. 
** 
****************************************************************************/
static void vUM_MAN_SET_RTS_MODE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_RTS_MODE_CONFIG_REQ_CFM);
	vUMI_SendToMC(UM_MAN_RTS_MODE_CONFIG_CFM, psMsg);
}


/****************************************************************************
**
** NAME:			vUM_MAN_GET_STATISTICS_REQ
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		
**
****************************************************************************/
static void vUM_MAN_GET_STATISTICS_REQ(K_MSG *psMsg)
{
	UMI_GET_STATISTICS_DATA *GetStatisticsReqMsgData_p	= (UMI_GET_STATISTICS_DATA*)(pK_MSG_DATA(psMsg));
	
	GetStatisticsReqMsgData_p->status = UMI_OK;

	VALIDATE_PARAM(GetStatisticsReqMsgData_p->length, 0, MAX_UINT32, GetStatisticsReqMsgData_p->status);

	
	if (GetStatisticsReqMsgData_p->status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_STATISTICS_REQ_CFM);

		OSAL_SEND_MESSAGE(STATISTICS_MANAGER_GET_STATISTICS_REQ, TASK_STATISTICS_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_GET_STATISTICS_CFM, psMsg);
	}
}


/****************************************************************************
**
** NAME:			vUM_MAN_GET_STATISTICS_CFM
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Holds the UM_GET_STATISTICS_CFM message. Returns
**					Returns the statistics message to the MC
** SION
****************************************************************************/
static void vUM_MAN_GET_STATISTICS_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_STATISTICS_REQ_CFM);
	vUMI_SendToMC(MC_MAN_GET_STATISTICS_CFM, psMsg);
}



/****************************************************************************
**
** NAME:		   vUM_MAN_FREQ_CHANGE_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UMSTAT_MAN_FREQ_CHANGE_REQ_CFM message
**
****************************************************************************/
static void vUM_MAN_PMCU_FREQ_CHANGE_REQ(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
    ASSERT(0);
}

/****************************************************************************
**
** NAME:			vUM_MAN_FREQ_CHANGE_CFM
**
** PARAMETERS:		K_MSG *psMsg
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Holds the UM_GET_STATISTICS_CFM message. Returns
**					Returns the statistics message to the MC
** 
****************************************************************************/
static void vUM_MAN_PMCU_FREQ_CHANGE_CFM(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
    ASSERT(0);
}

/****************************************************************************
 **
 ** NAME:           vUMI_SendToMC
 **
 ** PARAMETERS:     Local interface to MC.
 **
 ** RETURN VALUES:  na
 **
 ** DESCRIPTION:    .
 **
 ***************************************************************************/
void vUMI_SendToMC(K_MSG_TYPE msgType, K_MSG *psKmsg)
{
     /* Return message with result that copy has suceeded */
    psKmsg->header.tKMsgType = msgType;
   	vHIM_SendMsgToHost(psKmsg);
}

		
/****************************************************************************
**
** NAME:           vUM_DOWNLOAD_PROG_MODEL_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle vUM_DOWNLOAD_PROG_MODEL_REQ message(UM only)
**
****************************************************************************/
#if defined(ENET_INC_LMAC)
#elif defined (ENET_INC_UMAC)
void vUM_DOWNLOAD_PROG_MODEL_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_DOWNLOAD_PROG_MODEL_REQ_CFM);
	
#if defined ENET_USE_DUMMY_PHY
	vUM_DOWNLOAD_PROG_MODEL_CFM(psMsg);
#else
	OSAL_SEND_MESSAGE(HDK_DOWNLOAD_PROG_MODEL_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
#endif
}
void vUM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_DOWNLOAD_PROGMODEL_ANT_DEPENDENT_TX_REQ_CFM);
#ifdef ENET_INC_ARCH_WAVE600
	#if defined ENET_USE_DUMMY_PHY
		vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM(psMsg);
	#else
		OSAL_SEND_MESSAGE(HDK_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	#endif
#else
	ASSERT(0);
#endif

}
void vUM_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_DOWNLOAD_PROGMODEL_ANT_DEPENDENT_RX_REQ_CFM);
#ifdef ENET_INC_ARCH_WAVE600
	#if defined ENET_USE_DUMMY_PHY
		vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM(psMsg);
	#else
		OSAL_SEND_MESSAGE(HDK_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	#endif
#else
	ASSERT(0);
#endif
}

/****************************************************************************
**
** NAME:           vLM_DOWNLOAD_PROG_MODEL_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle vLM_DOWNLOAD_PROG_MODEL_CFM message, report to MC if needed. 
**
****************************************************************************/
void vUM_DOWNLOAD_PROG_MODEL_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_DOWNLOAD_PROG_MODEL_REQ_CFM);
	vUMI_SendToMC( MC_DOWNLOAD_PROG_MODEL_CFM, psMsg );
}

/****************************************************************************
**
** NAME:           UMI_DOWNLOAD_PROG_MODEL_DIFFS_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_DOWNLOAD_PROG_MODEL_DIFFS_REQ(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_DOWNLOAD_PROG_MODEL_DIFFS_REQ_CFM);
	OSAL_SEND_MESSAGE(HDK_DOWNLOAD_PROG_MODEL_DIFFS_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}
/****************************************************************************
**
** NAME:           vUMI_DOWNLOAD_PROG_MODEL_DIFFS_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
void vUMI_DOWNLOAD_PROG_MODEL_DIFFS_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_DOWNLOAD_PROG_MODEL_DIFFS_REQ_CFM);
	vUMI_SendToMC(MC_MAN_DOWNLOAD_PROG_MODEL_20_40_DIFFS_CFM, psMsg); 
}
void vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_DOWNLOAD_PROGMODEL_ANT_DEPENDENT_TX_REQ_CFM);

	vUMI_SendToMC(MC_MAN_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_TX_CFM, psMsg); 
}
void vUMI_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_DOWNLOAD_PROGMODEL_ANT_DEPENDENT_RX_REQ_CFM);

	vUMI_SendToMC(MC_MAN_DOWNLOAD_PROG_MODEL_ANT_DEPENDENT_RX_CFM, psMsg); 
}

/****************************************************************************
**
** NAME:           vUM_LM_STOP_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
void vUM_LM_STOP_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_LM_STOP_REQ_CFM);	
	vUM_LM_STOP_CFM(psMsg);
}

/****************************************************************************
**
** NAME:           vUM_LM_STOP_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
void vUM_LM_STOP_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_LM_STOP_REQ_CFM);	
	vUMI_SendToMC( MC_LM_STOP_CFM, psMsg);
}
#endif

/****************************************************************************
**
** NAME:           UMI_PLATFORM_DATA_FIELDS_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_PLATFORM_DATA_FIELDS_REQ(K_MSG* psMsg)
{
	platformDataFields_t *psDataFields = (platformDataFields_t *) pK_MSG_DATA(psMsg);
	
	psDataFields->Status = UMI_OK;
	
	VALIDATE_PARAM(psDataFields->dataFields[0], 0, NUM_PLATFORM_DATA_FIELDS, psDataFields->Status);
	
	if(psDataFields->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_PLATFORM_DATA_FIELDS_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_PLATFORM_DATA_FIELDS_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_PLATFORM_DATA_FIELDS_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           vUMI_PLATFORM_DATA_FIELDS_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_PLATFORM_DATA_FIELDS_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_PLATFORM_DATA_FIELDS_REQ_CFM);
	vUMI_SendToMC(MC_MAN_PLATFORM_DATA_FIELDS_CFM, psMsg); 
}

/****************************************************************************
**
** NAME:           UMI_PLATFORM_TABLE_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_PLATFORM_TABLE_REQ(K_MSG* psMsg)
{
	platformTable_t *psTable_p = (platformTable_t *) pK_MSG_DATA(psMsg);
	uint32 tableID = psTable_p->tableID;
	psTable_p->Status = UMI_OK;
	
	tableID >>= PSD_TABLE_ID_SHIFT;
	
	VALIDATE_PARAM(tableID, 1, PSD_TABLE_FUNC_ARRAY_SIZE -1, psTable_p->Status);
	
	if(psTable_p->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_PLATFORM_TABLE_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_PLATFORM_TABLE_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_PLATFORM_TABLE_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:           vUMI_PLATFORM_TABLE_CFM
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_PLATFORM_TABLE_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_PLATFORM_TABLE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_PLATFORM_TABLE_CFM, psMsg); 
}

/****************************************************************************
**
** NAME:           vUM_MAN_GET_SW_VERSION_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  MAC SW version
**                 A single SW version is used for the UM and LM
**
** DESCRIPTION:    Handle vUM_MAN_GET_SW_VERSION_REQ message, report to MC if needed. 
**
****************************************************************************/
void vUM_MAN_GET_SW_VERSION_REQ(K_MSG *psMsg)
{
    UMI_MAC_VERSION *psSwVer = (UMI_MAC_VERSION *) pK_MSG_DATA(psMsg);
	byte localPersistant =psMsg->header.bPersistentMsg;

	SystemInfo_GetSwVersion(psSwVer->acVer, sizeof(psSwVer->acVer));	 
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_MAC_VERSION_REQ_CFM);
    vUMI_MC_MAN_GET_MAC_VERSION_CFM(psMsg);
	OSAL_FREE_MESSAGE(psMsg,localPersistant);
	/* confirm sent when calling vUM_ReportTransparent inside OSAL_SEND_DIRECT */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_MAC_VERSION_REQ_CFM);
	 
}

/****************************************************************************
**
** NAME:           vUM_MAN_MAC_VARS_REQ
**
** PARAMETERS:
        typedef struct
        {
            unsigned long index;
            unsigned long offset;
            unsigned long data[64];
        } OID_MAC_VARS_REQUEST, *POID_MAC_VARS_REQUEST;

**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_GET_MAC_VARIABLES_REQ message
**
****************************************************************************/
static void vUM_MAN_MAC_VARS_REQ(K_MSG *psMsg)
{
    UMI_GENERIC_MAC_REQUEST  *psVar;
    MT_ADDR_SHARING_VAR_STRUCT* pVarStruct;
    uint32 index;
    uint32  cell_count;
    uint32 offset;
    psVar = (UMI_GENERIC_MAC_REQUEST *) pK_MSG_DATA(psMsg);

    psVar->retStatus = 0;
    /*index and offset are in res0 and res1 accordingly*/
    index = psVar->res0; /*to implement for the ChipVar table*/
    offset = psVar->res1;
    pVarStruct = MT_ADDR_SHARING_GetLocalVariableStruct(index);

    ASSERT(pVarStruct && pVarStruct->ptr);

    cell_count = psVar->size;   
    // check arguments
    if ( cell_count + offset * pVarStruct->cell_size > pVarStruct->cell_count)
    {
        psVar->retStatus = 0x01; /*Error*/
        return;
    }
    if (cell_count == 0)
    {
        cell_count = pVarStruct->cell_count - offset;
    }
    if (cell_count > MAX_GENERIC_REQ_DATA / pVarStruct->cell_size)
        cell_count = MAX_GENERIC_REQ_DATA / pVarStruct->cell_size;
    
    switch (psVar->action)
    {
        case MT_REQUEST_GET:
            /* check args */
            if (psVar->res2 == 0)
            {  
                MEMCPY(psVar->data, (((uint8*)pVarStruct->ptr) + offset * pVarStruct->cell_size), cell_count * pVarStruct->cell_size);
            }else if(psVar->res2 == 1)  // a sign to return the structure, not the data
            {
                ASSERT(pVarStruct && pVarStruct->ptr && pVarStruct->cell_count && pVarStruct->cell_size);
                MEMCPY(psVar->data, pVarStruct, sizeof(MT_ADDR_SHARING_VAR_STRUCT));
            }
            break;

        case MT_REQUEST_SET:
 	       break;    
        default:
            psVar->retStatus = 0x02; /*Error*/
    } /*switch*/
}

/****************************************************************************
**
** NAME:           vUM_MAN_SW_RESET_MAC_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle vUM_MAN_SW_RESET_MAC_REQ message, change to XO clock.
**
****************************************************************************/
static void vUM_MAN_SW_RESET_MAC_REQ(K_MSG *psMsg)
{
	uint32 *psaddr;
    int i, count=0;
	byte localPersistant =psMsg->header.bPersistentMsg;

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SW_RESET_MAC_REQ_CFM);
    psaddr = (uint32*)(REG_EMERALD_ENV_CLOCK_SELECT); 
    while ((*psaddr != 0x00000001) && (count++ < 100))
    {
        psaddr = (uint32*)(REG_EMERALD_ENV_SECURE_WRITE); 
	    *psaddr = 0x0000aaaa;
	    for(i=0; i<1000; i++){};
	    *psaddr = 0x00005555;
	    for(i=0; i<1000; i++){};

	    psaddr = (uint32*)(REG_EMERALD_ENV_CLOCK_SELECT); 
	    *psaddr = 0x00000001;
	    for(i=0; i<1000; i++){};
    }	
    /* Return */
    psMsg->header.tKMsgType = UMI_MC_MAN_SW_RESET_MAC_CFM;
	vUMI_MC_MAN_SW_RESET_MAC_CFM(psMsg);
	OSAL_FREE_MESSAGE(psMsg,localPersistant);
	/* confirm sent when calling vUM_ReportTransparent inside OSAL_SEND_DIRECT */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SW_RESET_MAC_REQ_CFM);
}

/****************************************************************************
**
** NAME:           vUM_MAN_GENERIC_MAC_REQ
**
** PARAMETERS:

**
** RETURN VALUES:  none
**
** DESCRIPTION:    Read 256 bytes of data from EEPROM
**                 If error occures field res2 is filled by byte index
**                 of failed operation
**
****************************************************************************/
#ifndef DISABLE_EEPROM_FW_SUPPORT
static void vUM_MAN_MAC_EEPROM_REQ(K_MSG *psMsg)
{
	TX_INTERRUPT_SAVE_AREA;

    UMI_GENERIC_MAC_REQUEST  *psVar = (UMI_GENERIC_MAC_REQUEST *) pK_MSG_DATA(psMsg);
    uint8 *pucEepromData = NULL;
    unsigned long i;
    uint32 EepromAdress;


    pucEepromData = (uint8 *)psVar->data;    
    for (i = 0,EepromAdress = psVar->res0; i < psVar->size; i++,EepromAdress++)
    {
        OSAL_DISABLE_INTERRUPTS(&interrupt_save);
        if ((Eeprom_Read_Byte(EepromAdress, pucEepromData + i)) == EEPROM_OPERATION_FAIL)
        {
            OSAL_ENABLE_INTERRUPTS(interrupt_save);
           
            psVar->retStatus = EEPROM_ILLEGAL_ADDRESS; /*Error*/
            psVar->res2 = EepromAdress;
            break;
        }
        OSAL_ENABLE_INTERRUPTS(interrupt_save);
    }

}
#endif

/****************************************************************************
**
** NAME:           vUM_MAN_GENERIC_MAC_REQ
**
** PARAMETERS:      
typedef struct
{
unsigned long opcode;
unsigned long size;
unsigned long action;
unsigned long res0;
unsigned long res1;
unsigned long res2;
unsigned long retStatus;
unsigned long data[64];
} OID_GENERIC_MAC_REQUEST, *POID_GENERIC_MAC_REQUEST;
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_GENERIC_MAC_REQ message.
Execute proprietary test messages.
**
****************************************************************************/
static void vUM_MAN_GENERIC_MAC_REQ(K_MSG *psMsg)
{
    UMI_GENERIC_MAC_REQUEST  *psVar = (UMI_GENERIC_MAC_REQUEST *) pK_MSG_DATA(psMsg);
	byte localPersistant =psMsg->header.bPersistentMsg;

    psVar->retStatus = 0x0;
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GENERIC_MAC_REQ_CFM);
    switch (psVar->opcode)
    {
    case MAC_VARIABLES_REQ:
        vUM_MAN_MAC_VARS_REQ(psMsg);
        break;
#ifndef DISABLE_EEPROM_FW_SUPPORT
    case MAC_EEPROM_REQ:
        vUM_MAN_MAC_EEPROM_REQ(psMsg);
        break;
#endif
	case MAC_OCS_TIMER_START:
	case MAC_OCS_TIMER_STOP:
	case MAC_OCS_TIMER_TIMEOUT:
		break;
    case NEW_CASE:
        /*Put here the new function*/;
        break;
    default:
        psVar->retStatus = 0x02;
        break;
    }
    /* Return */
    psMsg->header.tKMsgType = UMI_MC_MAN_GENERIC_MAC_CFM;
	vUMI_MC_MAN_GENERIC_MAC_CFM(psMsg);
	OSAL_FREE_MESSAGE(psMsg,localPersistant);
	/* confirm sent when calling vUM_ReportTransparent inside OSAL_SEND_DIRECT */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GENERIC_MAC_REQ_CFM);
}

/****************************************************************************
**
** NAME:           vUM_MAC_EVENT_IND
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle vUM_MAC_EVENT_IND message
**
****************************************************************************/
static void vUM_MAC_EVENT_IND(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_MAC_EVENT_IND_RES);

    vUMI_SendToMC( MC_MAN_MAC_EVENT_IND, psMsg );
}

/****************************************************************************
**
** NAME:           vUM_MAC_EVENT_RES
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle DYNAMIC_PARAM message
**
****************************************************************************/
static void vUM_MAC_EVENT_RES(K_MSG *psMsg)
{
	byte localPersistant =psMsg->header.bPersistentMsg;

	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_MAC_EVENT_IND_RES);
    /* Forward to BSS manage */
    psMsg->header.tKMsgType = BSS_MANAGE_BSS_RETURN_RESOURCE;
	vBSS_ReturnUmiResource(psMsg);
	OSAL_FREE_MESSAGE(psMsg,localPersistant);
}

/****************************************************************************
**
** NAME:			vUM_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle UM_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ message
**
****************************************************************************/
static void vUM_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ_CFM);
	OSAL_SEND_MESSAGE(HDK_DOWNLOAD_PROG_MODEL_PERMISSION_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:			vMC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle MC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM message
**
****************************************************************************/
static void vMC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_REQ_CFM);
	vUMI_SendToMC(MC_MAN_DOWNLOAD_PROG_MODEL_PERMISSION_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_MAN_HW_DEPENDENT_CONFIG_REQ
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle vUM_MAN_HW_DEPENDENT_CONFIG_REQ message
**
****************************************************************************/
static void vUM_MAN_HW_DEPENDENT_CONFIG_REQ(K_MSG *psMsg)
{
	UmiHwDependentConfig_t* pConfigReq = (UmiHwDependentConfig_t *)pK_MSG_DATA(psMsg);

	pConfigReq->Status = UMI_OK;
	
	VALIDATE_PARAM(pConfigReq->xtal, HW_DEP_CFG_XTAL_MIN, HW_DEP_CFG_XTAL_MAX, pConfigReq->Status);
	
	if(pConfigReq->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HW_DEPENDENT_CONFIG_CFM);
		/*MUST_BE_CALLED BEFORE HDK_CDB_MAN_HW_DEPENDENT_CONFIG_REQ - Update HdkCdbManager on PSD and progmodel shram address*/
		UMI_SetPsdProgmodelShramAddress();

		OSAL_SEND_MESSAGE(HDK_CDB_MAN_HW_DEPENDENT_CONFIG_REQ, TASK_HDK_CDB_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_HW_DEPENDENT_CONFIG_CFM, psMsg);
	}
	
}

/****************************************************************************
**
** NAME:			vUM_MAN_HW_DEPENDENT_CONFIG_CFM
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle vUM_MAN_HW_DEPENDENT_CONFIG_CFM message
**
****************************************************************************/

static void vMC_MAN_HW_DEPENDENT_CONFIG_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HW_DEPENDENT_CONFIG_CFM);
	vUMI_SendToMC(MC_MAN_HW_DEPENDENT_CONFIG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_DBG_LOGGER_FLUSH_BUF_REQ
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle UM_DBG_LOGGER_FLUSH_BUF_REQ message
**
****************************************************************************/
static void vUM_DBG_LOGGER_FLUSH_BUF_REQ(K_MSG *psMsg)
{
	UmiLoggerMsgFlushBuffer_t *flushMsg_p = (UmiLoggerMsgFlushBuffer_t *)pK_MSG_DATA(psMsg);
	flushMsg_p->Status = UMI_OK;
	
	VALIDATE_PARAM(flushMsg_p->targetCPU, LOG_MSG_FLSH_BUF_TARGET_CPU_MIN, LOG_MSG_FLSH_BUF_TARGET_CPU_MAX, flushMsg_p->Status);
	
	if (flushMsg_p->Status == UMI_OK)
	{
	    UMSTAT_INC_DBG_REQ_ARR(UMSTAT_DBG_LOGGER_FLUSH_BUF_REQ_CFM);
    	LoggerApi_FlushBuffer((UmiLoggerMsgFlushBuffer_t *)pK_MSG_DATA(psMsg));
		OSAL_SEND_MESSAGE(UMI_MC_DBG_LOGGER_FLUSH_BUF_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
	}
	else
	{
	    vUMI_SendToMC(MC_DBG_LOGGER_FLUSH_BUF_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:			vMC_DBG_LOGGER_FLUSH_BUF_CFM
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle MC_DBG_LOGGER_FLUSH_BUF_CFM message
**
****************************************************************************/
static void vMC_DBG_LOGGER_FLUSH_BUF_CFM(K_MSG *psMsg)
{
    UMSTAT_INC_DBG_CFM_ARR(UMSTAT_DBG_LOGGER_FLUSH_BUF_REQ_CFM);
    vUMI_SendToMC(MC_DBG_LOGGER_FLUSH_BUF_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_DBG_LOGGER_SET_MODE_REQ
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle UM_DBG_LOGGER_SET_MODE_REQ message
**
****************************************************************************/
static void vUM_DBG_LOGGER_SET_MODE_REQ(K_MSG *psMsg)
{
    UMSTAT_INC_DBG_REQ_ARR(UMSTAT_DBG_LOGGER_SET_MODE_REQ_CFM);
	vMC_DBG_LOGGER_SET_MODE_CFM(psMsg);
    //LoggerApi_SetLogAgentMode(psMsg);
}

/****************************************************************************
**
** NAME:			vMC_DBG_LOGGER_SET_MODE_CFM
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle MC_DBG_LOGGER_SET_MODE_CFM message
**
****************************************************************************/
static void vMC_DBG_LOGGER_SET_MODE_CFM(K_MSG *psMsg)
{
    UMSTAT_INC_DBG_CFM_ARR(UMSTAT_DBG_LOGGER_SET_MODE_REQ_CFM);
    vUMI_SendToMC(MC_DBG_LOGGER_SET_MODE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_DBG_LOGGER_SET_SEVERITY_REQ
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle UM_DBG_LOGGER_SET_SEVERITY_REQ message
**
****************************************************************************/
static void vUM_DBG_LOGGER_SET_SEVERITY_REQ(K_MSG *psMsg)
{
#ifdef DEBUG_UM_INTERFACE
    UMSTAT_INC_DBG_REQ_ARR(UMSTAT_DBG_LOGGER_SET_SEVERITY_REQ_CFM);
    LoggerApi_SetSeverity((UmiLoggerMsgSetSeverity_t *)pK_MSG_DATA(psMsg));
#endif
    OSAL_SEND_MESSAGE(UMI_MC_DBG_LOGGER_SET_SEVERITY_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:			vMC_DBG_LOGGER_SET_SEVERITY_CFM
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle MC_DBG_LOGGER_SET_SEVERITY_CFM message
**
****************************************************************************/
static void vMC_DBG_LOGGER_SET_SEVERITY_CFM(K_MSG *psMsg)
{
    UMSTAT_INC_DBG_CFM_ARR(UMSTAT_DBG_LOGGER_SET_SEVERITY_REQ_CFM);
    vUMI_SendToMC(MC_DBG_LOGGER_SET_SEVERITY_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUM_DBG_LOGGER_SET_FILTER_REQ
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle UM_DBG_LOGGER_SET_FILTER_REQ message
**
****************************************************************************/
static void vUM_DBG_LOGGER_SET_FILTER_REQ(K_MSG *psMsg)
{
    UMSTAT_INC_DBG_REQ_ARR(UMSTAT_DBG_LOGGER_SET_FILTER_REQ_CFM);
    LoggerApi_SetFilter((UmiLoggerMsgSetFilter_t *)pK_MSG_DATA(psMsg));	
    OSAL_SEND_MESSAGE(UMI_MC_DBG_LOGGER_SET_FILTER_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:			vMC_DBG_LOGGER_SET_FILTER_CFM
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		Handle MC_DBG_LOGGER_SET_FILTER_CFM message
**
****************************************************************************/
static void vMC_DBG_LOGGER_SET_FILTER_CFM(K_MSG *psMsg)
{
    UMSTAT_INC_DBG_CFM_ARR(UMSTAT_DBG_LOGGER_SET_FILTER_REQ_CFM);
    vUMI_SendToMC(MC_DBG_LOGGER_SET_FILTER_CFM, psMsg);
}

#if !defined (ENET_INC_ARCH_WAVE600)
static void PhyDrv_SetBer(uint32 factor)
{
	RegDummyPhyDphyReg01B_u dummyPhy01B_Reg;
	RegDummyPhyDphyReg000_u dummyPhy000_Reg; 
	RegDummyPhyDphyReg01C_u dummyPhy01C_Reg; 
	uint32 errorRate = 0; 
	
	dummyPhy01B_Reg.val = 0; 
	dummyPhy000_Reg.val = 0; 
	dummyPhy01C_Reg.val = 0; 
	ASSERT((factor >= 1) && (factor <= 100)); 
	errorRate = (BIT_ERROR_RATE_1_TO_100000*factor)/100; 
	dummyPhy01B_Reg.bitFields.prbsType = BER_TYPE_VA;
	dummyPhy000_Reg.bitFields.byteErrorRate = errorRate; 
	dummyPhy01C_Reg.bitFields.prbsClear = 0x1;	
	RegAccess_Write(REG_DUMMY_PHY_DPHY_REG01B, dummyPhy01B_Reg.val);	
	RegAccess_Write(REG_DUMMY_PHY_DPHY_REG01C, dummyPhy01C_Reg.val); 
	RegAccess_Write(REG_DUMMY_PHY_DPHY_REG000, dummyPhy000_Reg.val); 
}
#endif //#if !defined (ENET_INC_ARCH_WAVE600)

#if defined (ENET_INC_ARCH_WAVE600)
#ifdef DEBUG_UM_INTERFACE
static void PhyDrv_SetBer(uint32 berVal, uint32 user, uint32 clearAllUsers,BandId_e band)
{
	RegDummyPhyDphyReg000_u dummyPhy000_Reg;
	RegDummyPhyDphyReg001_u dummyPhy001_Reg; 

	dummyPhy000_Reg.val = 0; 
	dummyPhy001_Reg.val = 0;

	if (clearAllUsers)
	{
		dummyPhy001_Reg.bitFields.byteErrorClearAll = TRUE;
	}
	else
	{
	
		dummyPhy000_Reg.bitFields.byteErrorRate = berVal; 
		dummyPhy001_Reg.bitFields.byteErrorUser = user;
	
		dummyPhy001_Reg.bitFields.byteErrorUserLoad = TRUE;
	}
	
	if(band == 0) 
	{
		RegAccess_Write(REG_DUMMY_PHY_DPHY_REG000, dummyPhy000_Reg.val);
		RegAccess_Write(REG_DUMMY_PHY_DPHY_REG001, dummyPhy001_Reg.val);
	}
	else
	{
		RegAccess_Write(REG_DUMMY_PHY_DPHY_REG000+DUMMY_PHY_BAND1_OFFSET, dummyPhy000_Reg.val);
		RegAccess_Write(REG_DUMMY_PHY_DPHY_REG001+DUMMY_PHY_BAND1_OFFSET, dummyPhy001_Reg.val);	
	}
	
}
#endif
#endif


#if defined (HW_SEMAPHORE_DEBUG)
static void startLockAttempt()
{
	bool ret = FALSE;
	uint32 loop = 0;

	SERIAL_TRACE("[UmDbgCliReq serial trace]", 0, 0, 0);
	ILOG2_V("[startLockAttempt 1] *** semaphore test start *** ");
	// PRE-TEST: the above FIXED_RATE command is causing lower MAC to hold the semaphor of location 0_16
	// delay: wait until the FIXED_RATE command gets to lower MAC and then start trying to get the same lock (or a free lock) 
	for(loop = 0; loop < 24615384; loop++)
	{
		globalCount++;
	}
	/* TEST 1: try to get the lock using HwSemaphore_TryLock:
		At this point the lower MAC has already got this specific semaphore so upper MAC can't get it.
		Used the FIXED_RATE command to tell lower MAC to lock this specific semaphore */
	for(loop = 0; loop < 10; loop++)
	{
		ret = HW_SEMAPHORE_TRY_LOCK(HW_SEMAPHORE_0_16);
		if (ret == TRUE)
		{					
			HW_SEMAPHORE_FREE(HW_SEMAPHORE_0_16);
		}
		else
		{
			ILOG2_D("[startLockAttempt 2] UM is trying to get the lock -> lock is busy = %d", loop);
		}
	}
	// TEST 2: try to lock a free semaphore (lower MAC is holding a different semaphore)
	ILOG2_V("[startLockAttempt 3] Get a non used lock ");
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_8_24);
	ILOG2_V("[startLockAttempt 4] Got the lock ");
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_8_24);
	ILOG2_V("[startLockAttempt 5] Free the lock ");
	// TEST 3: try to lock a free seamphore using HwSemaphore_TryLock (assert if we can't lock it since the line above just set it to free)
	ILOG2_V("[startLockAttempt 6] Get a non used lock ");
	ret = HW_SEMAPHORE_TRY_LOCK(HW_SEMAPHORE_8_24);
	ASSERT(ret);
	ILOG2_V("[startLockAttempt 7] Got the lock ");
	ILOG2_V("[startLockAttempt 8] Free the lock");
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_8_24);
	ILOG2_V("[startLockAttempt 9] Free ");
	// TEST 4: try to get the lock using HwSemaphore_Lock (now we need to wait until lower MAC releases the lock - there is a 2 seconds delay in lower MAC)			
	ILOG2_V("[startLockAttempt 10] Get a busy lock ");
	HW_SEMAPHORE_LOCK(HW_SEMAPHORE_0_16);
	ILOG2_V("[startLockAttempt 11] Locked ");
	ILOG2_V("[startLockAttempt 12] Free the lock ");
	HW_SEMAPHORE_FREE(HW_SEMAPHORE_0_16);
	ILOG2_V("[startLockAttempt 13] Free ");
}
#endif

/****************************************************************************
**
** NAME:            UmDbgCliReq
**
** PARAMETERS:      psMsg - contains information of the related message
**
** RETURN VALUES:   none
**
** DESCRIPTION:     Handle UM_DBG_CLI_REQ message (iwpriv wlan0 sDoSimpleCLI <action> <data1> <data2> <data3>)
**                            Can add the following calls in future actions: 
**            
** EXAMPLE1:	          Use action 1 as a Utility to set Station DB rates. iwpriv wlan0 sDoSimpleCLI <action> <data1> <data2> <data3>
**				   parameters:
**				   	data1: contains the station Index
**					data2: contains which rates to Set: 0 - DATA, 1 - 802_11 , 2 - BOTH 
**					data3: contains the rate id : 0 -31  
**					example:  Set all 802_11 rates for STA with ID 0 to rate 30
**					action      argc  staID      802_11Rates	   Rate 3	
**				    		1       3      0            1	                 30
**					
****************************************************************************/
#include "DmaManager_Api.h"
#include "ShramGenriscNdpa.h"
//dma test

static void UmDbgCliReq(K_MSG *kMsg_p)
{
	UmiDbgCliReq_t *umiDbgCliReq_p = (UmiDbgCliReq_t *)pK_MSG_DATA(kMsg_p);
#ifdef DEBUG_UM_INTERFACE
	bool sendDbgCliCfm = TRUE; 
	//UMI_SET_ANTENNAS* changePowerStateMsg;
    UMSTAT_INC_DBG_REQ_ARR(UMSTAT_DBG_CLI_REQ_CFM);
    ILOG0_DDDD("UMAC Rx UM_DBG_CLI_REQ from Host, action:%d, data1:%d, data2:%d, data3:%d", 
        umiDbgCliReq_p->action,
        umiDbgCliReq_p->data1,
        umiDbgCliReq_p->data2,
        umiDbgCliReq_p->data3);
    switch (umiDbgCliReq_p->action)
    {
		case 0:
			SERIAL_TRACE("UMAC got UM_DBG_CLI_REQ from Host", umiDbgCliReq_p->data1, umiDbgCliReq_p->data2, umiDbgCliReq_p->data3);
			break;
		case 1:
			TsManager_CloseOrOpenStationBaAgreements(umiDbgCliReq_p->data1, umiDbgCliReq_p->data2, umiDbgCliReq_p->data3);
			break;
		
	case 3:
	{		
		K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(lmGenericMsgType_t));
		lmGenericMsgType_t *lmGenericMsgType_p = (lmGenericMsgType_t *)pK_MSG_DATA(pMsg);
		
		/* Send generic message to lower MAC (the handling function in lower MAC is Lmmain_HandleGenericReq)*/
		lmGenericMsgType_p->data1 = umiDbgCliReq_p->data1; /* set handler*/
		lmGenericMsgType_p->data2 = umiDbgCliReq_p->data2; /* Data*/
		lmGenericMsgType_p->data3 = umiDbgCliReq_p->data3; /* Data*/
		/* Send Generic command to lower MAC */
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_GENERIC_REQ, TASK_LINK_ADAPTATION, pMsg,0);	

		if ((lmGenericMsgType_p->data1 == 12)&&(ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_DUAL_BAND))
		{
			K_MSG *pMsg2 = OSAL_GET_MESSAGE(sizeof(lmGenericMsgType_t));
			lmGenericMsgType_t *lmGenericMsgType_p2 = (lmGenericMsgType_t *)pK_MSG_DATA(pMsg2);			
			
			/* Send generic message to lower MAC (the handling function in lower MAC is Lmmain_HandleGenericReq)*/
			lmGenericMsgType_p2->data1 = umiDbgCliReq_p->data1; /* set handler*/
			lmGenericMsgType_p2->data2 = umiDbgCliReq_p->data2; /* Data*/
			lmGenericMsgType_p2->data3 = umiDbgCliReq_p->data3; /* Data*/
			/* Send Generic command to lower MAC */
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_GENERIC_REQ, TASK_LINK_ADAPTATION, pMsg2,16);	

		}
		/* Perform upper MAC actions */
		switch(lmGenericMsgType_p->data1)
		{
			case 1:
			{
#if defined (HW_SEMAPHORE_DEBUG)
				startLockAttempt();
#endif
				break;
			}
			case 2:
			{
				/* Nothing to do (Handle Action frame before Add STA - see linkAdaptationHandleGenericReq) */
				break;
			}				
			case 3:
			{
				/* Nothing to do (Handle Action frame after Add STA - see linkAdaptationHandleGenericReq) */
				break;
			}
			case 4:
			{
				OperatingModeNotificationPayload_t operatingModeNotificationPayload;
				
				operatingModeNotificationPayload.operatingModeField.channelWidth = lmGenericMsgType_p->data2;
				operatingModeNotificationPayload.operatingModeField.rxNss = lmGenericMsgType_p->data3;
				rxManagerHandleOmnFrame(&operatingModeNotificationPayload, 0,0);
				break;
			}
	        case 5:
			{
	            /* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			case 6:
			{
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			case 7:
			{
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			case 8:
			{
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			case 9:
			{
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			case 10:
			{
				// enable/disable extra logs in LM
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			case 11:
			{
				// Dump RF regs
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			case 12:
			{
				// TestBus mode
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}			
			case 13:
			{
				// TF frequency
				/* Nothing to do (see linkAdaptationHandleGenericReq) */
				break;
			}
			default:
				ILOG0_V("[UmDbgCliReq] Unknown message type");
				break;
		}
		break;
	}
	/*************************************************************************************/
	/*  Start - Debug code for integration team (JIRA WLANG5SW-229). Set TID params for STA index 0.		    */
	/*************************************************************************************/
	case 4: 
		// Set Param (not per TID) in STA DB (STA index = 0)
		//StaDbDebug_SetHwDbParam(0, umiDbgCliReq_p->data1, umiDbgCliReq_p->data2, 0, umiDbgCliReq_p->data3);
		break;
	case 5:
	{
		#include "ConfigurationManager_api.h"
		CARD_CONFIGURATION_MODE *cardConfig_p = PNULL;
		cardConfig_p = ConfigurationManager_GetCardConfiguration();
		UNUSED_PARAM(cardConfig_p);
		SLOG0(0, 0, CARD_CONFIGURATION_MODE, cardConfig_p);
	}
		break;

	/*************************************************************************************/
	/*  End - Debug code for integration team (JIRA WLANG5SW-229). Set TID params for STA index 0.		    */
	/*************************************************************************************/
	/*************************************************************************************/
	/*  Start - Debug code Sniffer CRash Testing	    */
	/*************************************************************************************/
	case 6:
#ifdef DEBUG_STA_MODE_RSSI
		PowerManagementIndication = umiDbgCliReq_p->data1;
#endif
		break;

	case 7:
#if defined (ENET_INC_ARCH_WAVE600)
	{
		K_MSG *preAggMsg = OSAL_GET_MESSAGE(sizeof(UmiDbgCliReq_t));
		UmiDbgCliReq_t *perAggParams_p = (UmiDbgCliReq_t *)pK_MSG_DATA(preAggMsg);
		perAggParams_p->data1 = umiDbgCliReq_p->data1;
		perAggParams_p->data2 = umiDbgCliReq_p->data2;
		perAggParams_p->data3 = umiDbgCliReq_p->data3;			
		OSAL_SEND_MESSAGE(PAC_MANAGER_SET_FORCE_PROTECTION, TASK_PAC_MANAGER, preAggMsg, kMsg_p->header.vapId);
	}
#else
			AggregationBuilder_SetForceProtection(umiDbgCliReq_p->data1,(AggrBuilderForceProtectionMode_e)umiDbgCliReq_p->data2,umiDbgCliReq_p->data3);
#endif //ENET_INC_ARCH_WAVE600
			break;
			
		case 8:
#if !defined (ENET_INC_ARCH_WAVE600)
			PhyDrv_SetBer(umiDbgCliReq_p->data1); 
#endif //#if !defined (ENET_INC_ARCH_WAVE600)
#if defined (ENET_INC_ARCH_WAVE600)
			//PhyDrv_SetBer(uint32 berVal, uint32 user, uint32 clearAllUsers)
			PhyDrv_SetBer(umiDbgCliReq_p->data1, umiDbgCliReq_p->data2, umiDbgCliReq_p->data3,ConfigurationManager_GetBandForVap(kMsg_p->header.vapId));
#endif
			break;
			
		case 9:
		{
			#include "BaAnalyzer.h"
			BaaRateAdaptiveFullFifo_t *baaRateAdaptiveFullFifo_p = NULL;
			UNUSED_PARAM(baaRateAdaptiveFullFifo_p);
			SLOG0(0, 0, BaaRateAdaptiveFullFifo_t, baaRateAdaptiveFullFifo_p);
		}
			break;
		case 10:
			FATAL("NOT SUPPORTED");
			break; 
		
#if (!defined(ENET_USE_DUMMY_PHY) && !defined (ENET_INC_ARCH_WAVE600))
		case 11:
			switch (umiDbgCliReq_p->data1)
			{
				case 1:
					PhyDrv_ResetAndEnable();
					break;
				case 2:
					PhyDrv_DisablePhy();
					PhyDrv_SetTxAntOperationSet((uint8)umiDbgCliReq_p->data2);
					PhyDrv_ResetAndEnable();
					break;
				case 3:
					PhyDrv_DisablePhy();
					PhyDrv_SetRxAntOperationSet((uint8)umiDbgCliReq_p->data2);
					PhyDrv_ResetAndEnable();
					break;
				case 4:
					PhyDrv_DisablePhy();
					PhyDrv_SetTxHalfBand((PhyTxHalfBandType_e)umiDbgCliReq_p->data2);
					PhyDrv_ResetAndEnable();
					break;
				case 5:
					PhyDrv_DisablePhy();
					PhyDrv_SetRxHalfBand((PhyRxHalfBandType_e)umiDbgCliReq_p->data2);
					PhyDrv_ResetAndEnable();
					break;
				case 6:
					PhyDrv_DisablePhy();
					PhyDrv_SetTxPrimary((PhyTxPrimaryChType_e)umiDbgCliReq_p->data2);
					PhyDrv_ResetAndEnable();
					break;
				case 7:
					PhyDrv_DisablePhy();
					PhyDrv_SetRxPrimary((PhyRxPrimaryChType_e)umiDbgCliReq_p->data2);
					PhyDrv_ResetAndEnable();
					break;
				default:
					SERIAL_TRACE("!!!!! Not supported !!!!!!", 0, 0, 0);
					break;
			}
			break;
#endif

	case 12:
	{	
#ifdef PTA_BUILD_IN_PLAT
#ifdef PTA_TEST
		PtaTestHandler((uint8)umiDbgCliReq_p->data1, (uint8)umiDbgCliReq_p->data2, (uint8)umiDbgCliReq_p->data3);		
#endif
#endif
		break;
	}
	case 13:
	{
		K_MSG *laMsg = OSAL_GET_MESSAGE(sizeof(LaGroupFixedRateParams_t));
		K_MSG *gmMsg = OSAL_GET_MESSAGE(sizeof(GroupManagerFixedRateParams_t));
		LaGroupFixedRateParams_t *laGroupFixedRateParams_p = (LaGroupFixedRateParams_t *)pK_MSG_DATA(laMsg);
		GroupManagerFixedRateParams_t *gmGroupFixedRateParams_p = (GroupManagerFixedRateParams_t*)pK_MSG_DATA(gmMsg);
		
		laGroupFixedRateParams_p->fixedRateGroupsFlag = umiDbgCliReq_p->data1;
		gmGroupFixedRateParams_p->fixedRateMuFlag = umiDbgCliReq_p->data1;
		/* notify LA and Group manager about fixed rate*/
		ASSERT(ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_SINGLE_BAND); // This API doesn't support dual band mode
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_MU_GROUP_FIXED_RATE, TASK_LINK_ADAPTATION, laMsg, VAP_ID_DO_NOT_CARE);	
		OSAL_SEND_MESSAGE(GROUP_MANAGER_SET_MU_GROUP_FIXED_RATE, TASK_GROUP_MANAGER, gmMsg, VAP_ID_DO_NOT_CARE);
		break;
	}
	
#ifdef LINK_ADAPTATION_TEST_ENV
		case 14:
		{
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaTestEnvMsgParams_t));
			LaTestEnvMsgParams_t *linkAdaptationTestObj_p = (LaTestEnvMsgParams_t *)pK_MSG_DATA(pMsg);

			/*Generrate link adaptaion msg*/
			IEEE_ADDR testedMacAddress = {{0x0, 0x0, 0x0, 0x0, 0x0, 0x0}};

			/*Save desired MAC address*/
			MEMCPY(linkAdaptationTestObj->testedStaMacAddress.au8Addr, testedMacAddress.au8Addr, IEEE_ADDR_LEN);
			/*Test type*/
			linkAdaptationTestObj_p->testType = (TestType_e)umiDbgCliReq_p->data1;
			linkAdaptationTestObj_p->rateIndex = umiDbgCliReq_p->data2;
			linkAdaptationTestObj_p->requiredPer = umiDbgCliReq_p->data3;
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_RUN_TEST_REQ, TASK_LINK_ADAPTATION, pMsg, VAP_0);	
			break;
		}
#endif
#ifdef ENET_INC_ARCH_WAVE600B
		case 15:
		{
			// Trigger TOMI			STA ID							OMCtrl_RxNSS					OMCtrl_ChnlWidth
			StaDB_debug_TriggerTomi((StaId)umiDbgCliReq_p->data1, (uint8)umiDbgCliReq_p->data2, (uint8)umiDbgCliReq_p->data3);
			break;
		}
#endif //ENET_INC_ARCH_WAVE600B
		
		case 16:
			StaDB_debug_SetBWlimit((uint8)umiDbgCliReq_p->data1, (uint8)umiDbgCliReq_p->data2, (uint8)umiDbgCliReq_p->data3);
			break;
#ifdef ENET_INC_ARCH_WAVE600			
		/* cases 17-18 are used for RxDC configuration while WRX600 BU */
		case 17:
		{
			/* Analog Calibration config */
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(RxDcConfig_t));
			RxDcConfig_t *rxDcConfig = (RxDcConfig_t *)pK_MSG_DATA(pMsg);
			
			rxDcConfig->integratorBw     = umiDbgCliReq_p->data1;
			rxDcConfig->analogCalTimeout = umiDbgCliReq_p->data2;
			OSAL_SEND_MESSAGE(HDK_RXDC_ANALOG_CONFIG_CLI, TASK_HDK, pMsg, kMsg_p->header.vapId);	
			break;
		}
		case 18:
		{
			/* Digital Calibration config */
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(RxDcConfig_t));
			RxDcConfig_t *rxDcConfig = (RxDcConfig_t *)pK_MSG_DATA(pMsg);
			
			rxDcConfig->accumNos 		 = umiDbgCliReq_p->data1;
			rxDcConfig->accumTimeout     = umiDbgCliReq_p->data2;
			rxDcConfig->digSuccessThreshold = (umiDbgCliReq_p->data3 & 0xFFFF);			
			rxDcConfig->maxTries            = ((umiDbgCliReq_p->data3 & 0xFFFF0000) >> 16);
			OSAL_SEND_MESSAGE(HDK_RXDC_DIGITAL_CONFIG_CLI, TASK_HDK, pMsg, kMsg_p->header.vapId);	
			break;
		}
#endif
		case 19: /*Fixed power */
		{
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedPowerParams_t));
			LaFixedPowerParams_t *linkAdaptationFixedPower_p = (LaFixedPowerParams_t *)pK_MSG_DATA(pMsg);

			linkAdaptationFixedPower_p->vapId = INVALID_VAP;
			linkAdaptationFixedPower_p->stationId = umiDbgCliReq_p->data1;
			linkAdaptationFixedPower_p->powerVal = umiDbgCliReq_p->data2;
			linkAdaptationFixedPower_p->changeType = (LaPacketType_e)umiDbgCliReq_p->data3;
			linkAdaptationFixedPower_p->retTask = TASK_UM_IF_TASK;
			linkAdaptationFixedPower_p->retMsg = UMI_DBG_SET_FIXED_RATE_CFM;
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FIXED_POWER, TASK_LINK_ADAPTATION, pMsg, VAP_0);	
			break;
		}
		case 22: 
		{
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaProtectionParams_t));
			LaProtectionParams_t *protectionConfig_p = (LaProtectionParams_t *)pK_MSG_DATA(pMsg);
		
			protectionConfig_p->configurationIndex = umiDbgCliReq_p->data1; 
			protectionConfig_p->value = umiDbgCliReq_p->data2; 
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_PROTECTION_THRESH_REQ, TASK_LINK_ADAPTATION, pMsg, VAP_0);		
			break;
		}
		case 23: /*Fixed Ant selection */
		{
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LinkAdaptationFixedAntennaSelection_t));
			LinkAdaptationFixedAntennaSelection_t *linkAdaptationFixedAntSel_p = (LinkAdaptationFixedAntennaSelection_t *)pK_MSG_DATA(pMsg);
		
			linkAdaptationFixedAntSel_p->mode = (AntSelectionMode_e)umiDbgCliReq_p->data1;
			linkAdaptationFixedAntSel_p->vapId = INVALID_VAP;
			linkAdaptationFixedAntSel_p->stationId = umiDbgCliReq_p->data2;
			linkAdaptationFixedAntSel_p->mask = umiDbgCliReq_p->data3;
			linkAdaptationFixedAntSel_p->retTask = TASK_UM_IF_TASK;
			linkAdaptationFixedAntSel_p->retMsg = UMI_DBG_SET_FIXED_RATE_CFM;
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_ANTENNA_SELECTION_REQ, TASK_LINK_ADAPTATION, pMsg, VAP_0);	
			break;
    	}
		case 24: /*BW configuration modified */
	//		HDK_setSsbParameters(umiDbgCliReq_p->data1, (HdkSSB20MhzParameters_e)umiDbgCliReq_p->data2);
			
			break;

		case 26: /*Scp short preamble */
		{
			/* 
			data1: STA ID
			data2: CyclicPrefixMode_e you want to set
			data3: VAP ID
			*/
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedScpParams_t));
			LaFixedScpParams_t *linkAdaptationFixedScpShortPreamble_p = (LaFixedScpParams_t *)pK_MSG_DATA(pMsg);
		
			linkAdaptationFixedScpShortPreamble_p->isAuto = 0;
			linkAdaptationFixedScpShortPreamble_p->stationId = umiDbgCliReq_p->data1;
			linkAdaptationFixedScpShortPreamble_p->getSetOperation = API_SET_OPERATION; //Get operation used only with Driver
			linkAdaptationFixedScpShortPreamble_p->cpMode = (CyclicPrefixMode_e)umiDbgCliReq_p->data2;
			linkAdaptationFixedScpShortPreamble_p->psMsg = NULL; //Originaly contain the msg from driver, in this case leave it NULL
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_SCP_SHORT_PREAMBLE_REQ, TASK_LINK_ADAPTATION, pMsg, umiDbgCliReq_p->data3); //Pay attention to which band and VAP you need to use
			break;
		}
		case 27:
		{
			break;
		}			
  		case 28: /*Beamforming */
		{
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedBeamformingParams_t));
			LaFixedBeamformingParams_t *linkAdaptationFixedBfMode_p = (LaFixedBeamformingParams_t *)pK_MSG_DATA(pMsg);
		
			linkAdaptationFixedBfMode_p->stationId = umiDbgCliReq_p->data1;
			linkAdaptationFixedBfMode_p->beamformingMode= umiDbgCliReq_p->data2;
			linkAdaptationFixedBfMode_p->maxNssNdp = ((umiDbgCliReq_p->data3)&0xF);
			linkAdaptationFixedBfMode_p->periodicBfReq = (((umiDbgCliReq_p->data3)&0x10)>>4);
			linkAdaptationFixedBfMode_p->staticBfEnable= !(((umiDbgCliReq_p->data3)&0x100)>>8);
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_BF_MODE_REQ, TASK_LINK_ADAPTATION, pMsg, VAP_0);
			break;
  		}
		case 29: 
			statisticsManagerResetAllStatistics();
			break;


		case 32: /*CDD fixed value */
		{
#ifndef ENET_INC_ARCH_WAVE600
			K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedCddParams_t));
			LaFixedCddParams_t *linkAdaptationFixedCdd= (LaFixedCddParams_t *)pK_MSG_DATA(pMsg);

			linkAdaptationFixedCdd->stationId = umiDbgCliReq_p->data1;
			linkAdaptationFixedCdd->cddVal = umiDbgCliReq_p->data2;
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FIXED_CDD_REQ, TASK_LINK_ADAPTATION, pMsg, VAP_0);
			break;
#endif
		}	
		
#ifdef TRAINING_DEBUG_CLI
	case 34:
	{
		/*Trigger Training Manager to start training on specified stations according to bitmap*/
		TrainingManagerStartTrainingReq();
		break;
	}
	case 35:
	{
		/*Change Training Weights for group mark calculation*/
		//sum should be 100%
		ASSERT((umiDbgCliReq_p->data1 + umiDbgCliReq_p->data2 + umiDbgCliReq_p->data3) == 100);
		//data1 is throughput weight, data2 is num of Stations weight, data3 is total Nsts weight
		TrainingManagerSetGroupMarkWeights((uint8)umiDbgCliReq_p->data1, (uint8)umiDbgCliReq_p->data2, (uint8)umiDbgCliReq_p->data3);
		break;
	}
	
	case 36:
	{
		/*Change Training Minimal Group Mark*/
		//data1 is the new minimal group mark
		TrainingManagerSetMinimalGroupMark((uint16)umiDbgCliReq_p->data1);
		break;
	}

	case 37:
	{
		/*Change FIRST_PHASE_POOL_ID criteria*/				
		switch(umiDbgCliReq_p->data1)
		{
		//change minimal MCS
		case 0: 
		{
			ASSERT(umiDbgCliReq_p->data2 < NUM_OF_MCS);
			TrainingManagerSetMinimalMcsForFirstPhasePool((mcs_e)(umiDbgCliReq_p->data2));
			break;
		}
		
		//change maximal NSS
		case 1:
		{
			ASSERT(umiDbgCliReq_p->data2 < SPATIAL_STREAM_NUM);
			TrainingManagerSetMaximalNssForFirstPhasePool((SpatialStreamNum_e)(umiDbgCliReq_p->data2));
			break;
		}
		
		default:
			ASSERT(0);
		}
		break;
	}	

	case 38:
	{
		/*Stop training*/
		switch(umiDbgCliReq_p->data1)
		{
			case 0: 
			{
				TrainingManagerStopTrainingReq();
				break;
			}
			case 1:
			{
				TrainingManagerHaltStaParams_t haltStaParams;
				haltStaParams.staId = umiDbgCliReq_p->data2;
				TrainingManagerHaltStaReq(&haltStaParams);
				break;
			}
			case 2: 
			{
				TrainingManagerStopStaParams_t stopStaParams;
				stopStaParams.staId = umiDbgCliReq_p->data2;
				TrainingManagerStopStaReq(&stopStaParams);
				break;
			}
			default:
				ASSERT(0);
		}
		break;
	}
#endif //TRAINING_DEBUG_CLI

	case 40:
	{
		K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaTxopDurationParams_t));
		LaTxopDurationParams_t *linkAdaptationTxopTimeThreshold = (LaTxopDurationParams_t *)pK_MSG_DATA(pMsg);

		//the desired duration can't be bigger than max allowed in Agg builder/Pre Agg
		
#ifdef ENET_INC_ARCH_WAVE600
		DEBUG_ASSERT((umiDbgCliReq_p->data1 <= 0x1) && (umiDbgCliReq_p->data2 <= PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_LIMIT));
#else
		DEBUG_ASSERT((umiDbgCliReq_p->data1 <= 0x1) && (umiDbgCliReq_p->data2 <= AGGREGATION_BUILDER_TXOP_AIR_TIME_DURATION_LIMIT));
#endif //ENET_INC_ARCH_WAVE600
		linkAdaptationTxopTimeThreshold->isMu = umiDbgCliReq_p->data1;
		//calculate minimal time threshold according to the desired duration

#ifdef ENET_INC_ARCH_WAVE600		
		linkAdaptationTxopTimeThreshold->txopTimeThreshold = (uint16)(PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_LIMIT - umiDbgCliReq_p->data2);
#else
		linkAdaptationTxopTimeThreshold->txopTimeThreshold = (uint16)(AGGREGATION_BUILDER_TXOP_AIR_TIME_DURATION_LIMIT - umiDbgCliReq_p->data2);
#endif //ENET_INC_ARCH_WAVE600
		ASSERT(ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_SINGLE_BAND); // This API doesn't support dual band mode

		OSAL_SEND_MESSAGE(LINK_ADAPTATION_TXOP_TIME_LIMIT_CONFIG_REQ, TASK_LINK_ADAPTATION, pMsg, VAP_ID_DO_NOT_CARE);
		break;		
	}
	
	case 41:
	{
		TxSender_ScratchPadApiParams_t *pScratchPadApiParams = NULL;
		
		DEBUG_ASSERT((umiDbgCliReq_p->data1 <= 64) && (umiDbgCliReq_p->data1 >= 1));
#ifdef ENET_INC_ARCH_WAVE600
		pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(B0_MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));
#else
		pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));
#endif
		pScratchPadApiParams->minimumMpduCountForTxop = umiDbgCliReq_p->data1;
	}
	break;

	case 42:
	{
		extern uint8 GroupDb_MuNumOfMpdusInAmpdu;
		K_MSG *kMsg2_p = OSAL_GET_MESSAGE(sizeof(LaMpduInAmpduConfigMsg_t));
		LaMpduInAmpduConfigMsg_t *body = (LaMpduInAmpduConfigMsg_t *)pK_MSG_DATA(kMsg2_p);
		
		body->suMpduInAmpdu = (uint8)umiDbgCliReq_p->data1;
		//change mu max mpdu in ampdu
		GroupDb_MuNumOfMpdusInAmpdu = (uint8)umiDbgCliReq_p->data2;
		
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_MPDU_IN_AMPDU_LIMIT_CONFIG_REQ, TASK_LINK_ADAPTATION, kMsg2_p, VAP_0);
	}
	break;

	case 43:
	{
#ifdef ENET_INC_ARCH_WAVE600
		uint32 band = umiDbgCliReq_p->data1;
		TxSender_ScratchPadApiParams_t *pScratchPadApiParams = NULL;

		switch (band)
		{
			case 0: //write to band0
				pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(B0_MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));
				pScratchPadApiParams->enableTcrRcrLogs = (umiDbgCliReq_p->data2 & 0x1);
				break;
			case 1: //write to band1
				pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(B1_MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));
				pScratchPadApiParams->enableTcrRcrLogs = (umiDbgCliReq_p->data2 & 0x1);
				break;
			case 2: //write to both band0 and band1
				pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(B0_MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));
				pScratchPadApiParams->enableTcrRcrLogs = (umiDbgCliReq_p->data2 & 0x1);
				pScratchPadApiParams = (TxSender_ScratchPadApiParams_t *)(B1_MAC_GENRISC_TX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START << 0x2));
				pScratchPadApiParams->enableTcrRcrLogs = (umiDbgCliReq_p->data2 & 0x1);
				break;
			default:
				break;
		}
#endif //ENET_INC_ARCH_WAVE600
	}
	break;

#if defined (MU_MIMO_STATIC_GROUP_ENABLED)
	case 49:
		GroupManager_EnableDynamicModeWithStaticMode();
		break;
        
    case 50:
    {
        /*create static group*/
        K_MSG *kMsg_local_p = OSAL_GET_MESSAGE(sizeof(GroupManager_CreateStaticGroup_t));
        GroupManager_CreateStaticGroup_t *groupManager_msg = (GroupManager_CreateStaticGroup_t *)pK_MSG_DATA(kMsg_local_p);

		//KW_FIX_FW_G MEMCPY macro points to memcpy_s, we cannot use banned memcpy function.
        MEMCPY(&groupManager_msg->staIds[0], &umiDbgCliReq_p->data1, sizeof(uint32));
#ifdef ENET_INC_ARCH_WAVE600
        MEMCPY(&groupManager_msg->staIds[2], &umiDbgCliReq_p->data2, sizeof(uint32));
#endif
        MEMCPY(groupManager_msg->nssPerUsp, &umiDbgCliReq_p->data3, sizeof(groupManager_msg->nssPerUsp));

        OSAL_SEND_MESSAGE(GROUP_MANAGER_CREATE_MU_STATIC_GROUP, TASK_GROUP_MANAGER, kMsg_local_p, 0);
        break;
    }
    
	case 51:
		/*Change Static Group Tx Mode:  data1 - new Tx mode*/
		ASSERT(umiDbgCliReq_p->data1 <= TX_SELECTOR_BF_WITH_DATA);
		GroupManager_UpdateMuStaticGroupTxMode((TxSelectorGroupTxMode_e)umiDbgCliReq_p->data1);
		break;

	case 52:
		OSAL_SEND_NO_DATA_MESSAGE(GROUP_MANAGER_DELETE_MU_STATIC_GROUP, TASK_GROUP_MANAGER,0);
		break;
		
	case 54:
		ASSERT(umiDbgCliReq_p->data1 <= MCS_9);
		GroupManager_UpdateMuStaticGroupInitialMcs((mcs_e)umiDbgCliReq_p->data1);
		break;
		
	case 56: 
		DEBUG_ASSERT(umiDbgCliReq_p->data1 <= 1);
		GroupManager_UpdateMuGroupTxopMode(umiDbgCliReq_p->data1); 
		break;

	case 57:
		GroupManager_UpdateMuConfigParams((GroupManagerConfigurationParamType_e)umiDbgCliReq_p->data1, (uint8)umiDbgCliReq_p->data2);
		break;

#endif //MU_MIMO_STATIC_GROUP_ENABLED

#ifdef RXH_MAILBOX_TEST
	case 60: /*RxH test type: iwpriv wlan0 sDoSimpleCLI 0x3c 0x00010001 */
	{		
		K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(uint32));
		uint32 *pRxhMailboxTestMsg_t = (uint32 *)pK_MSG_DATA(pMsg);
		*pRxhMailboxTestMsg_t = umiDbgCliReq_p->data1;

		SERIAL_TRACE("Rx Handler test - start", 0, 0, 0);
		
		OSAL_SEND_MESSAGE(PAC_MANAGER_RXH_MAILBOX_TEST, TASK_PAC_MANAGER, pMsg, 0); 
		break;	
	}
#endif // RXH_MAILBOX_TEST	

	case 61:
	{
		/* 
		data1: modify HOST_INTERFACE_ACCELERATOR_FREE_PDS_THRESHOLD
		data2: modify QOS_DEFAULT_FREE_PDS_HYSTERESIS
		data3: modify QOS_PD_THRESHOLD_TIMEOUT
		*/
		QosSetAgerParams(umiDbgCliReq_p->data1,  umiDbgCliReq_p->data2, umiDbgCliReq_p->data3);
		break;
	}
	case 62: /*11nProtection */
	{
		K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(ProtectionFixed_t));
		ProtectionFixed_t *protection = (ProtectionFixed_t *)pK_MSG_DATA(pMsg);
		protection->vapId= umiDbgCliReq_p->data1;
		protection->event= umiDbgCliReq_p->data2;
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_FIXED_PROTECTION_REQ, TASK_LINK_ADAPTATION, pMsg,  kMsg_p->header.vapId);	
		break;
	}
	case 63:
	{
        loggerActiveMode = umiDbgCliReq_p->data1;
		break;
	}	
	case 64: /*Adaptive sensetivity thresholds */
	{
#if defined RADAR_DETECTION_ENABLED

		K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(RadarAdaptiveSensParams_t));
		RadarAdaptiveSensParams_t *adaptiveSensTh = (RadarAdaptiveSensParams_t *)pK_MSG_DATA(pMsg);
		adaptiveSensTh->nonAssoDataPacketsTh = umiDbgCliReq_p->data1;
		adaptiveSensTh->InterferernceRadarRatio = umiDbgCliReq_p->data2;
		adaptiveSensTh->disableFeature = umiDbgCliReq_p->data3;
		
		OSAL_SEND_MESSAGE(HDK_SET_RADAR_ADAPTIVE_SENS_PARAMS_REQ, TASK_HDK, pMsg, VAP_0);
#endif		
		break;
	}
	case 65: /*Collision detection threshold */
	{
		K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedCollisionDetectionParams_t));
		LaFixedCollisionDetectionParams_t *linkAdaptaionCollisionDetectionParams= (LaFixedCollisionDetectionParams_t *)pK_MSG_DATA(pMsg);

		linkAdaptaionCollisionDetectionParams->collisionDetectionTh = umiDbgCliReq_p->data1;
		
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_COLLISION_DETECTION_TH, TASK_LINK_ADAPTATION, pMsg, VAP_0);
		break;
	}	
	case 66: /*Fixed rates */
	{
		/* Allocate and fill msg for LA */
		LaFixedRateParams_t* pLinkAdaptationFixedRateParams;
		K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedRateParams_t));
		pLinkAdaptationFixedRateParams = (LaFixedRateParams_t *)pK_MSG_DATA(pMsg);
		pLinkAdaptationFixedRateParams->fixedRateType = FIXED_RATE_FOR_STATION;
		pLinkAdaptationFixedRateParams->stationIndex = 0xff;
		pLinkAdaptationFixedRateParams->vapId = INVALID_VAP;
		pLinkAdaptationFixedRateParams->disableTimers = 0;
		pLinkAdaptationFixedRateParams->retTask = TASK_UM_IF_TASK;
		pLinkAdaptationFixedRateParams->retMsg = UMI_MC_MAN_FIXED_RATE_CONFIG_CFM;
		pLinkAdaptationFixedRateParams->backToAutoRate = (Bandwidth_e)umiDbgCliReq_p->data1;
		pLinkAdaptationFixedRateParams->phyMode = PHY_MODE_11AC;
		pLinkAdaptationFixedRateParams->bandwidth = (Bandwidth_e)umiDbgCliReq_p->data2;
		pLinkAdaptationFixedRateParams->cpMode = CP_MODE_MED_CP_SHORT_LTF;
		pLinkAdaptationFixedRateParams->changeType = LA_PACKET_TYPE_DATA;
		pLinkAdaptationFixedRateParams->rate = umiDbgCliReq_p->data3;
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FIXED_RATE, TASK_LINK_ADAPTATION, pMsg, VAP_0);

		break;
	}	
#ifdef ENET_INC_ARCH_WAVE600
#if defined (ENABLE_PIE_TEST)
	case 69:
	{
//		uint32 load = 0;
		/* User sends delay in [uSec] which is used to stall PDs before they enter the TX Q 
		umiDbgCliReq_p->data1 = On\Off
		umiDbgCliReq_p->data2 = delay in [uSec]
		umiDbgCliReq_p->data3 = not used
		*/
		TxPacketClassifier_AddDelayStoreValue(umiDbgCliReq_p->data1,  umiDbgCliReq_p->data2, umiDbgCliReq_p->data3);
//		load = statisticsManagerCpuLoadTriggerRequest();
		//SERIAL_TRACE("cpu load = [uSec]", load, 0, 0);	
		//ILOG0_D("[AGER_POC] cpu load = %d", load);		
		break;
	}
#endif	
	case 70:
	{
		K_MSG *laMsg0 = OSAL_GET_MESSAGE(sizeof(LaGroupFixedRateParams_t));
		LaGroupFixedRateParams_t *pLaGroupFixedRateParams0 = (LaGroupFixedRateParams_t *)pK_MSG_DATA(laMsg0);
		
		pLaGroupFixedRateParams0->fixedRateGroupsFlag = umiDbgCliReq_p->data1;
		/* notify LA about fixed rate for OFDMA */
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_MU_GROUP_FIXED_RATE, TASK_LINK_ADAPTATION, laMsg0, ConfigurationManager_GetFirstVapForBand0());
		if (ConfigurationManager_GetBandConfigurationMode() != CONFIGURATION_MODE_SINGLE_BAND) 
		{
			K_MSG *laMsg1 = OSAL_GET_MESSAGE(sizeof(LaGroupFixedRateParams_t));			
			LaGroupFixedRateParams_t *pLaGroupFixedRateParams1 = (LaGroupFixedRateParams_t *)pK_MSG_DATA(laMsg1);

			pLaGroupFixedRateParams1->fixedRateGroupsFlag = umiDbgCliReq_p->data1;
			OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_MU_GROUP_FIXED_RATE, TASK_LINK_ADAPTATION, laMsg1, ConfigurationManager_GetFirstVapForBand1());
		}

		break;
	}	
	case 71:
	{
		
		K_MSG *pMsgEnSerialTrace = OSAL_GET_MESSAGE(sizeof(radarSerialTraceEnable_t));
		radarSerialTraceEnable_t* params = (radarSerialTraceEnable_t*)pK_MSG_DATA(pMsgEnSerialTrace);

		params->enableserialTrace = umiDbgCliReq_p->data1;

		OSAL_SEND_MESSAGE(HDK_RADAR_ADAPTIVE_SENS_ENABLE_SERIAL_TRACE, TASK_HDK, pMsgEnSerialTrace, kMsg_p->header.vapId);

		break;
	}	
	
#endif //ENET_INC_ARCH_WAVE600
	case 72:
	{
		
		K_MSG *pTxWindowSizeMsg = OSAL_GET_MESSAGE(sizeof(txWindowSize_t));
		txWindowSize_t* params = (txWindowSize_t*)pK_MSG_DATA(pTxWindowSizeMsg);
		params->sindowSizeOption = umiDbgCliReq_p->data1;

		OSAL_SEND_MESSAGE(HDK_SET_TX_WINDOW_SIZE, TASK_HDK, pTxWindowSizeMsg, kMsg_p->header.vapId);
		break;
	}	
#ifdef ENET_INC_ARCH_WAVE600B
	case 73:
	{

		RegHostIfAccPdThreshold_u freePdsThresholdRegister;

		freePdsThresholdRegister.val = 0;

		if (umiDbgCliReq_p->data1)
		{
			//config ager to start single shot as soon as 7/8 of the PDs are consumed
			freePdsThresholdRegister.bitFields.pdThres = HOST_INTERFACE_ACCELERATOR_FREE_PDS_THRESHOLD;
		}
		else
		{
			//use default configuration: start single shot as soon as all of the PDs are consumed
			freePdsThresholdRegister.bitFields.pdThres = HOST_INTERFACE_ACCELERATOR_FREE_PDS_THRESHOLD_DISABLED;
		}

		RegAccess_Write(REG_HOST_IF_ACC_PD_THRESHOLD,freePdsThresholdRegister.val);
		break;
	}	
#endif //ENET_INC_ARCH_WAVE600B

	case 74:
	{

		K_MSG *dutyCycleMsg = OSAL_GET_MESSAGE(sizeof(UMI_DCSet_t));
		UMI_DCSet_t *dutyCycleMsg_p = (UMI_DCSet_t *)pK_MSG_DATA(dutyCycleMsg);

		dutyCycleMsg_p->isDutyCycleEnable = umiDbgCliReq_p->data1;
		dutyCycleMsg_p->radioOffTimeInMsecs = (uint16)umiDbgCliReq_p->data2;
		dutyCycleMsg_p->radioOnTimeInMsecs =  (uint16)umiDbgCliReq_p->data3;
		dutyCycleMsg ->header.vapId =kMsg_p->header.vapId;
			
		ILOG0_D("UmDbgCliReq() dutyCycleMsg vapId: %d ", kMsg_p->header.vapId);
		OSAL_SEND_MESSAGE(HDK_DUTY_CYCLE_SET_REQ, TASK_HDK, dutyCycleMsg, dutyCycleMsg ->header.vapId);

		break;
	}
    case 75:
    {
        K_MSG *pHeGmConfigNumOfStaInGroup  = OSAL_GET_MESSAGE(sizeof(ConfigNumOfStaInGroupMsg_t));
		ConfigNumOfStaInGroupMsg_t* params = (ConfigNumOfStaInGroupMsg_t*)pK_MSG_DATA(pHeGmConfigNumOfStaInGroup);
		params->maxStationsInGroup         = umiDbgCliReq_p->data1;
        params->minStationsInGroup         = umiDbgCliReq_p->data2;

		OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_SET_MAX_MIN_NUM_OF_STA_IN_GROUP, TASK_HE_GROUP_MANAGER, pHeGmConfigNumOfStaInGroup, kMsg_p->header.vapId);
        break;   
    } 
	
	case 76:
	{

		K_MSG *erpMsg = OSAL_GET_MESSAGE(sizeof(UMI_ERPSet_t));
		UMI_ERPSet_t* erpMsg_p = (UMI_ERPSet_t*)pK_MSG_DATA(erpMsg);

		erpMsg_p->staConnectionTimeInSeconds = 10;
		erpMsg_p->isErpEnable = umiDbgCliReq_p->data1;
		erpMsg_p->radioOffTimeInMsecs = (uint16)umiDbgCliReq_p->data2;
		erpMsg_p->radioOnTimeInMsecs = (uint16)umiDbgCliReq_p->data3;
		erpMsg_p->Status = 0;
		erpMsg->header.vapId =kMsg_p->header.vapId;
			
		ILOG0_D("UmDbgCliReq() erpMsg vapId: %d ", kMsg_p->header.vapId);
		OSAL_SEND_MESSAGE(HDK_ERP_SET_REQ, TASK_HDK, erpMsg, erpMsg->header.vapId);

		break;
	}

	
	default:
		break;
	}


	if(sendDbgCliCfm)
	{
    	UMSTAT_INC_DBG_CFM_ARR(UMSTAT_DBG_CLI_REQ_CFM);
    	vUMI_SendToMC(MC_DBG_CLI_CFM, kMsg_p);
	}
#else
	umiDbgCliReq_p->Status = UMI_NOT_SUPPORTED;
	vUMI_SendToMC(MC_DBG_CLI_CFM, kMsg_p);
#endif
}

/****************************************************************************
**
** NAME:            UmDbgTraceInd
**
** PARAMETERS:      psMsg - contains information of the related message
**
** RETURN VALUES:   none
**
** DESCRIPTION:     Handle MC_MAN_TRACE_IND message
**
****************************************************************************/
static void McDbgTraceInd(K_MSG *kMsg_p)
{
    UMSTAT_INC_MAN_IND_ARR(UMSTAT_DBG_TRACE_IND_RES);
    vUMI_SendToMC(MC_MAN_TRACE_IND, kMsg_p);
}

/****************************************************************************
**
** NAME:            UmDbgTraceRes
**
** PARAMETERS:      psMsg - contains information of the related message
**
** RETURN VALUES:   none
**
** DESCRIPTION:     Handle UM_MAN_TRACE_RES message
**
****************************************************************************/
static void UmDbgTraceRes(K_MSG *kMsg_p)
{
    UMSTAT_INC_MAN_RES_ARR(UMSTAT_DBG_TRACE_IND_RES); 
    LoggerApi_HandleDbgTraceRes(kMsg_p);
}

/****************************************************************************
**
** NAME:			vUM_MAN_STA_ADD_REQ
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		used for adding a STA to the FW DB after a succsessful association 
**
****************************************************************************/
static void vUMI_MAN_STA_ADD_REQ(K_MSG *psMsg)
{
	UMI_STA_ADD* pStaAdd = (UMI_STA_ADD*)psMsg->abData;

	pStaAdd->Status = UMI_OK;

	VALIDATE_PARAM(pStaAdd->u8ListenInterval,STA_ADD_LISTEN_INTRVL_MIN, STA_ADD_LISTEN_INTRVL_MAX, pStaAdd->u8Status);

	VALIDATE_PARAM(pStaAdd->u8UAPSD_Queues,STA_ADD_UAPSD_QUEUES_MIN, STA_ADD_UAPSD_QUEUES_MAX, pStaAdd->u8Status);
	VALIDATE_PARAM(pStaAdd->u8Max_SP, STA_ADD_MAX_SP_MIN, STA_ADD_MAX_SP_MAX, pStaAdd->u8Status);
	//WDS_client_type:-->PEER_AP, WPA_WDS
	VALIDATE_PARAM(pStaAdd->u8WDS_client_type, STA_ADD_WDS_CLIENT_TYPE_MIN, STA_ADD_WDS_CLIENT_TYPE_MAX, pStaAdd->u8Status);
	
	
	if (pStaAdd->Status == UMI_OK)
	{
#if defined (ENET_INC_ARCH_WAVE600)
#if defined (ENET_INC_ARCH_WAVE600B) && defined (ENET_INC_HW_FPGA)
		/* override mu_beamformee_capable field in VHT capabilities in case of WDS, as this bit is set by driver only if the AP is also mu_beamformee_capable */
		bool isWds = MTLK_BFIELD_GET(pStaAdd->u8Flags, STA_ADD_FLAGS_WDS);
		sVHT_CAPABILITIES_INFO* pVhtCap = (sVHT_CAPABILITIES_INFO*)&pStaAdd->u32VHT_Cap_Info;
		if (isWds == TRUE)
		{
			pVhtCap->mu_beamformee_capable = 1;
		}
#endif //(ENET_INC_ARCH_WAVE600B) && (ENET_INC_HW_FPGA)
		// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
		// Need to define if FW continue to do this override or driver do it instead.
		pStaAdd->u8VapIndex = psMsg->header.vapId;
		pStaAdd->u8SecondaryVapIndex = ConfigurationManager_ConvertVapAndRadioToActualVap(ConfigurationManager_GetBandForVap(pStaAdd->u8VapIndex), pStaAdd->u8SecondaryVapIndex);


#endif //ENET_INC_ARCH_WAVE600

		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_STA_ADD_REQ_CFM);
#ifdef BEEROCK_DEBUG
		ILOG0_V("[vUMI_MAN_STA_ADD_REQ]");
#endif
	    OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_ADD_STA, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC( MC_MAN_STA_ADD_CFM, psMsg );		
	}	
}

/****************************************************************************
**
** NAME:			vUM_MAN_STA_ADD_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION:		used for adding a STA to the FW DB after a succsessful association 
**
****************************************************************************/
static void vUMI_MAN_STA_ADD_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_STA_ADD_REQ_CFM);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[vUMI_MAN_STA_ADD_CFM]");
#endif	
	vUMI_SendToMC( MC_MAN_STA_ADD_CFM, psMsg );
}

/****************************************************************************
**
** NAME:			vUM_MAN_STA_REMOVE_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used for premoving a STA from the FW DB 
**
****************************************************************************/
static void vUMI_MAN_STA_REMOVE_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_STA_REMOVE_REQ_CFM);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[vUMI_MAN_STA_REMOVE_REQ]");
#endif
	OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_CLOSE_STA, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:			vUM_MAN_STA_REMOVE_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used for premoving a STA from the FW DB 
**
****************************************************************************/
static void vUMI_MAN_STA_REMOVE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_STA_REMOVE_REQ_CFM);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[vUMI_MAN_STA_REMOVE_CFM]");
#endif	
	vUMI_SendToMC( MC_MAN_STA_REMOVE_CFM, psMsg );
}

/****************************************************************************
**
** NAME:			vUMI_MAN_SET_BEACON_TEMPLATE_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used for providing a new beacon template by hostapd and driver.
**
****************************************************************************/
static void vUMI_MAN_SET_BEACON_TEMPLATE_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_BEACON_TEMPLATE_REQ_CFM);

	OSAL_SEND_MESSAGE(BSS_MANAGER_SET_BEACON_TEMPLATE_REQ, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);	
}

/****************************************************************************
**
** NAME:			vUMI_MAN_SET_BEACON_TEMPLATE_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used for providing a new beacon template by hostapd and driver.
**
****************************************************************************/
static void vUMI_MAN_SET_BEACON_TEMPLATE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_BEACON_TEMPLATE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_BEACON_TEMPLATE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUMI_MAN_BEACON_TEMPLATE_WAS_SET_IND

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		usedto indicate to driver that the new beacon template was saved in FW.
**
****************************************************************************/
static void vUMI_MAN_BEACON_TEMPLATE_WAS_SET_IND(K_MSG *psMsg)
{
	K_MSG *psMsgShram = NULL;
    UMI_BEACON_SET *pUmiBeaconSet = NULL;

	psMsgShram = OSAL_DEQUEUE_MSG(&sUmiIndFreeQueue);
	ASSERT(psMsgShram); // IF assert is not necessary, use boIF_TrySendingMsg instead of vIF_SendMsg.
	pUmiBeaconSet = (UMI_BEACON_SET *)pK_MSG_DATA(psMsgShram);
	psMsgShram->header.vapId = psMsg->header.vapId;

#if defined (ENET_INC_ARCH_WAVE600)
	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	uint8 bandId;
	pUmiBeaconSet->u8vapIndex = ConfigurationManager_ConvertActualVapToVapAndRadio(psMsg->header.vapId, &bandId);
#else		
	pUmiBeaconSet->u8vapIndex = psMsg->header.vapId;
#endif



	pUmiBeaconSet->u8Status = UMI_OK;
	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_BEACON_TEMPLATE_WAS_SET_IND_RES);
    vUMI_SendToMC(MC_MAN_BEACON_TEMPLATE_WAS_SET_IND, psMsgShram);
}


/****************************************************************************
**
** NAME:			vUMI_MAN_BEACON_TEMPLATE_WAS_SET_RES

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		usedto indicate to driver that the new beacon template was saved in FW.
**
****************************************************************************/
static void vUMI_MAN_BEACON_TEMPLATE_WAS_SET_RES(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_BEACON_TEMPLATE_WAS_SET_IND_RES);
	OSAL_QUEUE_MSG(&sUmiIndFreeQueue,psMsg);
}

/****************************************************************************
**
** NAME:			vUMI_MC_MAN_SET_MIB_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		setting MIB values
**
****************************************************************************/
void vUMI_MC_MAN_SET_MIB_CFM(K_MSG *psMsg)
{
    vUMI_SendToMC(MC_MAN_SET_MIB_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUMI_MC_MAN_GET_MIB_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		getting MIB values
**
****************************************************************************/
void  vUMI_MC_MAN_GET_MIB_CFM(K_MSG *psMsg)
{
    vUMI_SendToMC(MC_MAN_GET_MIB_CFM, psMsg);	
}

/*********************************************************************************
Method:       vUMI_MC_MAN_GET_MAC_VERSION_CFM
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
void  vUMI_MC_MAN_GET_MAC_VERSION_CFM(K_MSG *psMsg)
{
    vUMI_SendToMC(MC_MAN_GET_MAC_VERSION_CFM, psMsg);		
}

/*********************************************************************************
Method:       vUMI_MC_MAN_GENERIC_MAC_CFM
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
void  vUMI_MC_MAN_GENERIC_MAC_CFM(K_MSG *psMsg)
{
    vUMI_SendToMC(MC_MAN_GENERIC_MAC_CFM, psMsg);		
}

/*********************************************************************************
Method:       vUMI_MC_MAN_SW_RESET_MAC_CFM
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
void  vUMI_MC_MAN_SW_RESET_MAC_CFM(K_MSG *psMsg)
{
    vUMI_SendToMC(MC_MAN_SW_RESET_MAC_CFM, psMsg);		
}

/*********************************************************************************
Method:       vUMI_MC_MAN_SET_KEY_CFM
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
void  vUMI_MC_MAN_SET_KEY_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_KEY_REQ_CFM);
    vUMI_SendToMC(MC_MAN_SET_KEY_CFM, psMsg);		
}

/*********************************************************************************
Method:       vUM_DBG_DUT_MSG_REQ
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
static void vUM_DBG_DUT_MSG_REQ(K_MSG *psMsg)
{
	// Add Statistics
#ifdef DEBUG_UM_INTERFACE
	OSAL_SEND_MESSAGE(DUT_MSG_REQ, TASK_DUT, psMsg, psMsg->header.vapId);
#else
	vUMI_SendToMC(MC_DBG_DUT_MSG_CFM, psMsg);
#endif
}

/*********************************************************************************
Method:       vMC_DBG_DUT_MSG_CFM
Description:  
Parameter:    K_MSG * psMsg
Returns:      void
*********************************************************************************/
static void vMC_DBG_DUT_MSG_CFM(K_MSG *psMsg)
{
	// Add Statistics
	vUMI_SendToMC(MC_DBG_DUT_MSG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:         vUMI_MAN_SET_11B_ANT_REQ  
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_SET_11B_ANT_REQ(K_MSG* psMsg)
{
	UMI_ANT_SELECTION_11B *AntSelection11B;

	AntSelection11B = (UMI_ANT_SELECTION_11B *)pK_MSG_DATA(psMsg);

	AntSelection11B->Status = UMI_OK;
	
	if (AntSelection11B->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(AntSelection11B->txAnt, ANT_SEL_11B_TX_MIN, ANT_SEL_11B_TX_MAX, AntSelection11B->Status);
		VALIDATE_PARAM(AntSelection11B->rxAnt, ANT_SEL_11B_RX_MIN, ANT_SEL_11B_RX_MAX, AntSelection11B->Status);
		VALIDATE_PARAM(AntSelection11B->rate, ANT_SEL_11B_RATE_MIN, ANT_SEL_11B_RATE_MAX, AntSelection11B->Status);
	}
		
	if(AntSelection11B->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SEND_11B_SET_ANT_REQ_CFM);	
		OSAL_SEND_MESSAGE(HDK_SET_11B_ANT_SEL_REQ, TASK_HDK, psMsg,psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SEND_11B_SET_ANT_CFM, psMsg);
	}
	
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_11B_ANT_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_SET_11B_ANT_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SEND_11B_SET_ANT_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SEND_11B_SET_ANT_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUM_MAN_SetDataPathParams    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SetDataPathParams(K_MSG *psMsg)
{
	UMI_DATA_PATH_INIT_PARAMS* pInitParams = (UMI_DATA_PATH_INIT_PARAMS*) pK_MSG_DATA(psMsg);
    HwQueueManagerRequestParams_t hwQueueManagerRequestParams;	
	RxHandler_ScratchPadApiParams_t *pRxhScratchPadApiParams = (RxHandler_ScratchPadApiParams_t *)(B0_MAC_GENRISC_RX_SPRAM_BASE_ADDR + (SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START << 0x2));	
	uint32 maxDriverDataRdNum;
	uint32 maxDriverMgmtRdNum;
	uint32 hwLoggerNumOfShramBuffers;
	uint8 bandId;

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_DATA_PATH_INIT_REQ_CFM);

	LoggerApi_SetLoggerStationIndex(pInitParams->loggerRxSid);

	//SLOG0(0, 0, UMI_DATA_PATH_INIT_PARAMS, pInitParams);

	//initialize PDs - put only the amount requested by driver to free list
	DEBUG_ASSERT(pInitParams->numOfAllocatedTxHds <= NUM_OF_TX_DESC);

    // put PDs into the DLM queues
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_TX_LISTS_DLM;
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;
	
	// Push PDs to free Data PD Pool
	hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_TX_POOL_LIST_DATA_PD;
	hwQueueManagerRequestParams.pHeadDesc = &PdDescPools.DataDescPool[0];
    hwQueueManagerRequestParams.pTailDesc= &PdDescPools.DataDescPool[pInitParams->numOfAllocatedTxHds-1];
	HwQManager_PushPacketListToTail(&hwQueueManagerRequestParams);

    ErrorHandler_SetFwInterfaceId(pInitParams->FWinterface);
	hwQueueManagerRequestParams.dlmNum = HW_Q_MANAGER_RX_LISTS_DLM;	
	hwQueueManagerRequestParams.regIfNum = HW_Q_MANAGER_REG_IF_NUM_ONE;

	
	/* Make sure Driver initialized the DRAM pointers for management ring before you place them in the FREE MGMT list */
	ASSERT(HostRxDescriptorsPool[INDEX_OF_MANAGEMENT_FIRST_RX_DESCRIPTOR].dramPointer != 0x0);

    hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_RX_FREE_MANAGEMENT_RDS_LIST;
    hwQueueManagerRequestParams.pHeadDesc = &HostRxDescriptorsPool[INDEX_OF_MANAGEMENT_FIRST_RX_DESCRIPTOR];
    hwQueueManagerRequestParams.pTailDesc= &HostRxDescriptorsPool[INDEX_OF_MANAGEMENT_FIRST_RX_DESCRIPTOR + NUM_OF_MANAGEMENT_RX_DESCRIPTORS -1];
    HwQManager_PushPacketListToTail(&hwQueueManagerRequestParams);
	maxDriverMgmtRdNum = NUM_OF_MANAGEMENT_RX_DESCRIPTORS;

	/* Put RDs on Forwarding Q*/
	hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_RX_FREE_FORWARD_RDS_LIST;
	hwQueueManagerRequestParams.pHeadDesc = &HostRxDescriptorsPool[INDEX_OF_FORWARD_FIRST_RX_DESCRIPTOR];
	hwQueueManagerRequestParams.pTailDesc= &HostRxDescriptorsPool[INDEX_OF_FORWARD_FIRST_RX_DESCRIPTOR + NUM_OF_FORWARD_RX_DESCRIPTORS -1];
	HwQManager_PushPacketListToTail(&hwQueueManagerRequestParams);

	if ((pInitParams->dataPathMode == DATA_PATH_MODE_DC_NONE) || (pInitParams->dataPathMode == DATA_PATH_MODE_DC_MODE_1) || (pInitParams->dataPathMode == DATA_PATH_MODE_DC_MODE_2))
	{
		/*supporting dynamic RDs allocation (20K RDs in Gen6), push to Rx In temp list in order for all RDs to get initialized with DDR address (driver doesn't do it anymore).
		When Host Genrisc will be activated, Rx in path would be first think happened and all RDs will path through host if ACC converter
		and get valid DRAM pointer. This is done to enable dynamic HDs allocation, and driver will not init the DDR pointer as part of its 
		init flow in case of DC_DP mode1*/		
		hwQueueManagerRequestParams.pHeadDesc = &HostRxDescriptorsPool[INDEX_OF_HOST_DATA_AND_LOGGER_FIRST_RX_DESCRIPTOR];
		hwQueueManagerRequestParams.pTailDesc= &HostRxDescriptorsPool[INDEX_OF_HOST_DATA_AND_LOGGER_FIRST_RX_DESCRIPTOR + NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS -1];
		hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_RX_HOST_INTERFACE_TEMP_LIST;
		maxDriverDataRdNum = NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS;
		
	}
	else
	{
		//push number of RDs as requested and initialized already by driver. GSWIP doesn't support the dynamic buffer allocation, so in GSWIP it must be ther size of ring (2K)

		DEBUG_ASSERT(pInitParams->numOfAllocatedRxHds <= NUM_OF_HOST_DATA_AND_LOGGER_RX_DESCRIPTORS);

		/* Put RDs on Data free Q*/
		hwQueueManagerRequestParams.dplIndex = HW_Q_MANAGER_RX_FREE_HOST_RDS_LIST;
		hwQueueManagerRequestParams.pHeadDesc = &HostRxDescriptorsPool[INDEX_OF_HOST_DATA_AND_LOGGER_FIRST_RX_DESCRIPTOR];
	    hwQueueManagerRequestParams.pTailDesc= &HostRxDescriptorsPool[INDEX_OF_HOST_DATA_AND_LOGGER_FIRST_RX_DESCRIPTOR + pInitParams->numOfAllocatedRxHds - 1];
		maxDriverDataRdNum = pInitParams->numOfAllocatedRxHds;
	}

	hwLoggerNumOfShramBuffers = HwLoggerResourceAllocation(pInitParams->loggerMaxStreamNumber);  // allocate the Hw logger resources
	

	//update rxh with the max RD values before pushing the RDs to free or pending list index to insure rxh will not start to handle rds
	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands() ; bandId++)
	{
		pRxhScratchPadApiParams->maxDriverDataRdNum = maxDriverDataRdNum;
		pRxhScratchPadApiParams->maxDriverMgmtRdNum = maxDriverMgmtRdNum;
#if defined (ENET_INC_ARCH_WAVE600) && !defined (ENET_INC_ARCH_WAVE600D2)
		pRxhScratchPadApiParams->minimumRdsInHostDataFreeList = hwLoggerNumOfShramBuffers + MAX_NUM_OF_HOST_FREE_LIST_POP_USERS; //rx handler need to make sure at list this amount of RDs are in free list before it popps new RD, in order to protect logger from popping NULL
#endif // defined (ENET_INC_ARCH_WAVE600) && !defined (ENET_INC_ARCH_WAVE600D2

		//this is pre-defiend value since it was already done in FW init and not related to this driver set data path message
		pRxhScratchPadApiParams->maxFwMgmtRdNum = NUM_OF_FW_RX_DESCRIPTORS;

		//update ptr to next possible band		
		pRxhScratchPadApiParams = (RxHandler_ScratchPadApiParams_t *)((uint32)pRxhScratchPadApiParams + (B1_MAC_GENRISC_RX_SPRAM_BASE_ADDR - B0_MAC_GENRISC_RX_SPRAM_BASE_ADDR));
	}


	HwQManager_PushPacketListToTail(&hwQueueManagerRequestParams);


	HostIfAcc_ConfigureRingsSize(pInitParams);
	HostGenRisc_Initialize(pInitParams);
	HostInterfaceRings_SetRingsParams(pInitParams);

	
#if defined (ENET_INC_ARCH_WAVE600)
    SpAvailabilityManager_Initialize(); 
#endif
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_DATA_PATH_INIT_REQ_CFM);
    vUMI_SendToMC(MC_MAN_DATA_PATH_INIT_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_REQUEST_SID_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    On AR10 FW will allocate SID from STA_DB and provide it to driver.
**				On WAVE500, SID should be provided by HW machine. Not exist yet.
**
****************************************************************************/
static void vUMI_MAN_REQUEST_SID_REQ(K_MSG* psMsg)
{
#ifndef ENET_INC_ARCH_WAVE600

	UMI_REQUEST_SID* pUmiSidRequest = (UMI_REQUEST_SID*)psMsg->abData;
#endif //#ifndef ENET_INC_ARCH_WAVE600

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_REQUEST_SID_REQ_CFM);

	
	// In wave600 the MAC2INDEX driver is in the LM and in wave500 it's in UM.
	// So - in wave600 we send a MSG to PAC MANAGER in the correct band and in wave500 we call it directly

#ifndef ENET_INC_ARCH_WAVE600

	pUmiSidRequest->u16SID = Mac2Index_AddStation(&pUmiSidRequest->sAddr);
	pUmiSidRequest->Status = UMI_OK;
	/*Set Frame Class*/
	RxClassifier_SetStaFrameClass(pUmiSidRequest->u16SID, FRAME_CLASS_3);	
	
	/*Set VAP to Association State*/
	TxSelector_SetStationToVapAssocState(pUmiSidRequest->u16SID, psMsg->header.vapId);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[vUMI_MAN_REQUEST_SID_REQ]");
#endif	
	OSAL_SEND_MESSAGE(UMI_MC_MAN_REQUEST_SID_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

#else // #ifndef ENET_INC_ARCH_WAVE600

	// Send MSG to PAC Manager in LM to request the sid
	OSAL_SEND_MESSAGE(PAC_MANAGER_REQUEST_SID_REQ, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);

#endif // #ifndef ENET_INC_ARCH_WAVE600

}

/****************************************************************************
**
** NAME:       vUMI_MAN_REQUEST_SID_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return confirmation and allocated SID to host
**
****************************************************************************/
static void vUMI_MAN_REQUEST_SID_CFM(K_MSG* psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)
	UMI_REQUEST_SID* pUmiSidRequest = (UMI_REQUEST_SID*)psMsg->abData;
#endif

	// In wave600 the MAC2INDEX driver is in the LM and in wave500 it's in UM.
	// So - in wave500 we called TX Selector and RX Classifier in "vUMI_MAN_REQUEST_SID_REQ" since we had the SID.
	// In wave600 we call it here since only now we have the SID

	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_REQUEST_SID_REQ_CFM);

#if defined (ENET_INC_ARCH_WAVE600)
	
	/*Set VAP to Association State*/
	TxSelector_SetStationToVapAssocState(pUmiSidRequest->u16SID, psMsg->header.vapId);
	StaDb_setStaStat(pUmiSidRequest->u16SID,STA_STATE_SID_ALLOCATED); //use for class 3 indication

#endif

	vUMI_SendToMC(MC_MAN_REQUEST_SID_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_REMOVE_SID_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_REMOVE_SID_REQ(K_MSG* psMsg)
{
	StaId stationId;
	K_MSG *kMsg_p = OSAL_GET_MESSAGE(sizeof(LaRemoveSid_t));
	LaRemoveSid_t *laRemoveSid_p = (LaRemoveSid_t *)pK_MSG_DATA(kMsg_p);
	UMI_REMOVE_SID* pUmiSidRemove = (UMI_REMOVE_SID*)psMsg->abData;	
	uint32 rxhScpadSecondaryVapTableAddr;
	uint32 stationMask;	
	uint8 bandId;
	uint8 sidLocation;
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_REMOVE_SID_REQ_CFM);
	stationId = pUmiSidRemove->u16SID;

	//invalidate secondary vap for the removed station
	sidLocation = CONVERT_BYTES_TO_BIT_INDEX(stationId & FOUR_BYTE_ALIGNED_MASK);
	stationMask = MAX_UINT8 << sidLocation;

	//table entry = scpad base address + secondary vap base + sid/NUM_OF_BYTES_IN_WORD converted to bytes
	rxhScpadSecondaryVapTableAddr = B0_MAC_GENRISC_RX_SPRAM_BASE_ADDR + CONVERT_WORDS_TO_BYTES(SCPAD_ADDRESS_RX_HANDLER_SECONDARY_VAP_ID_PER_STATION_TABLE + (stationId >> 0x2));
	
	for (bandId = CONFIGURATION_MANAGER_BAND_0 ; bandId < ConfigurationManager_GetNumOfActiveBands(); bandId++)
	{
		RegAccess_WriteMaskedPerBand(rxhScpadSecondaryVapTableAddr, stationMask, stationMask, bandId);
	} 
		
	// In wave600 the MAC2INDEX driver is in the LM and in wave500 it's in UM.
	// So - in wave600 we send a MSG to PAC MANAGER in the correct band and in wave500 we call it directly
	
#ifndef ENET_INC_ARCH_WAVE600

	Mac2Index_RemoveStationById(stationId);
	pUmiSidRemove->Status = UMI_OK;
	/*Clear STA activity*/
	Pac_RxcGetAndClearStationActivity(stationId);   
	/*Set Frame Class*/
	RxClassifier_SetStaFrameClass(stationId, FRAME_CLASS_2);  	
	/*Set TX Selector VAP to disassociate*/
	TxSelector_ClearStationFromVapAssocState(stationId, psMsg->header.vapId);
	SLOG0(0, 0, UMI_REMOVE_SID, pUmiSidRemove);
	/* Request from LA to Clear SMPS flags and Operating Mode Notification for only SID allocated stations */
	laRemoveSid_p->stationIndex = stationId;	
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_REMOVE_SID_REQ, TASK_LINK_ADAPTATION, kMsg_p, psMsg->header.vapId);
	
	OSAL_SEND_MESSAGE(UMI_MC_MAN_REMOVE_SID_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

#else // #ifndef ENET_INC_ARCH_WAVE600

	/* Request from LA to Clear SMPS flags and Operating Mode Notification for only SID allocated stations */
	laRemoveSid_p->stationIndex = stationId;
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_REMOVE_SID_REQ, TASK_LINK_ADAPTATION, kMsg_p, psMsg->header.vapId);

	// Send MSG to PAC Manager in LM to remove the sid
	OSAL_SEND_MESSAGE(PAC_MANAGER_REMOVE_SID_REQ, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);
	
#endif // #ifndef ENET_INC_ARCH_WAVE600
}

/****************************************************************************
**
** NAME:       vUM_MAN_QAMPLUS_ACTIVATE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_QAMPLUS_ACTIVATE_REQ(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_QAMPLUS_REQ_CFM);
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_QAMPLUS_ACTIVATE_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       vUM_MAN_TS_VAP_CONFIGURE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_TS_VAP_CONFIGURE_REQ(K_MSG *psMsg)
{
	UMI_TS_VAP_CONFIGURE *pTsVapConfig = (UMI_TS_VAP_CONFIGURE *)pK_MSG_DATA(psMsg);

#if defined (ENET_INC_ARCH_WAVE600)

	// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
	// Need to define if FW continue to do this override or driver do it instead.
	pTsVapConfig->vapId = psMsg->header.vapId;
#endif
	pTsVapConfig->Status = UMI_OK;

	if ((pTsVapConfig->getSetOperation == API_SET_OPERATION) && (pTsVapConfig->enableBa) && (WINDOW_SIZE_NO_CHANGE != pTsVapConfig->windowSize))
	{
		VALIDATE_PARAM(pTsVapConfig->windowSize, TS_MANAGER_MIN_BUFFER_SIZE, TS_MANAGER_MAX_BUFFER_SIZE, pTsVapConfig->Status);
	}
	
	if(pTsVapConfig->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_TS_VAP_CONFIGURE_REQ_CFM);
		OSAL_SEND_MESSAGE(TS_MANAGER_CONFIGURE_VAP, TASK_TS_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_TS_VAP_CONFIGURE_CFM, psMsg);
	}
}


/****************************************************************************
**
** NAME:       vUM_MAN_MSDU_IN_AMSDU_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_MSDU_IN_AMSDU_CONFIG_REQ(K_MSG *psMsg)
{
	UMI_MSDU_IN_AMSDU_CONFIG *pLaMsduInAmsduConfigMsg = (UMI_MSDU_IN_AMSDU_CONFIG*)pK_MSG_DATA(psMsg);
	pLaMsduInAmsduConfigMsg->Status = UMI_OK;

	if(pLaMsduInAmsduConfigMsg->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(pLaMsduInAmsduConfigMsg->htMsduInAmsdu, HT_MSDU_IN_AMSDU_MIN, HT_MSDU_IN_AMSDU_MAX, pLaMsduInAmsduConfigMsg->Status);
		VALIDATE_PARAM(pLaMsduInAmsduConfigMsg->vhtMsduInAmsdu, VHT_MSDU_IN_AMSDU_MIN, VHT_MSDU_IN_AMSDU_MAX, pLaMsduInAmsduConfigMsg->Status);
		VALIDATE_PARAM(pLaMsduInAmsduConfigMsg->heMsduInAmsdu, HE_MSDU_IN_AMSDU_MIN, HE_MSDU_IN_AMSDU_MAX, pLaMsduInAmsduConfigMsg->Status);
	}
	
	if(pLaMsduInAmsduConfigMsg->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_MSDU_IN_AMSDU_CONFIG_REQ_CFM);
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_MSDU_IN_AMSDU_CONFIG_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_MSDU_IN_AMSDU_CONFIG_CFM, psMsg);
	}
}


/****************************************************************************
**
** NAME:       vUM_MAN_MU_STATIC_PLAN_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_MU_STATIC_PLAN_CONFIG_REQ(K_MSG *psMsg)
{
#ifdef ENET_INC_ARCH_WAVE600

	UMI_STATIC_PLAN_CONFIG*	pMuPlanConfig = (UMI_STATIC_PLAN_CONFIG*)psMsg->abData;
	uint8					loopIndex;
	StaId					stationIndex; 
	bool					areAllStationsConnected = TRUE; 
	bool					areAllStationsHeCapable = TRUE; 
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_STATIC_PLAN_CONFIG_REQ_CFM);
	
	SLOG0(0, 0, UMI_STATIC_PLAN_CONFIG, pMuPlanConfig);

	if(pMuPlanConfig->commonSection.planOnOff == TRUE)  // if plan activation requested 
	{
		// check if station are valid
		for(loopIndex = 0; loopIndex < pMuPlanConfig->commonSection.numOfParticipatingStations; loopIndex++)
		{
			stationIndex = pMuPlanConfig->perUserParameters[loopIndex].uspStationIndexes; 
			if(!(StaDB_IsStationConnected(stationIndex)))  
			{
				areAllStationsConnected = FALSE; 
				break; 
			}
			if(!(TsManager_IsStaHe(stationIndex)))
			{
				areAllStationsHeCapable = FALSE; 
				break; 
			}
		
			
		}
		if((areAllStationsConnected == TRUE) && (areAllStationsHeCapable == TRUE))
		{
			//forward message to group manager 
			OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_SET_STATIC_PLAN_REQ, TASK_HE_GROUP_MANAGER, psMsg, psMsg->header.vapId);
		}
		else
		{
			if(areAllStationsConnected == TRUE)
			{
				SERIAL_TRACE("Wrong station configuration for static HE group! station is not HE capable!",0,0,0);
				ILOG0_V("[vUM_MAN_MU_STATIC_PLAN_CONFIG_REQ] Wrong station configuration for static HE group! station is not HE capable!");
			}
			else
			{
				SERIAL_TRACE("Wrong station configuration for static HE group! station not connected",0,0,0);
				ILOG0_V("[vUM_MAN_MU_STATIC_PLAN_CONFIG_REQ] Wrong station configuration for static HE group! station not connected");
			}
			OSAL_SEND_MESSAGE(UM_MAN_STATIC_PLAN_CONFIG_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
		}
	}
	else  // plan request with operation bit off -  plan deactivation requested 
	{
		//forward message to group manager 
		OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_REMOVE_STATIC_PLAN_REQ, TASK_HE_GROUP_MANAGER, psMsg, psMsg->header.vapId);
	}
#else
	ASSERT(0); // this MSG should not be sent in Gen6.
#endif 
	
}


/****************************************************************************
**
** NAME:       vUM_MAN_MU_STATIC_PLAN_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
static void vUM_MAN_MU_STATIC_PLAN_CONFIG_CFM(K_MSG *psMsg)
{
	/* Send confirmation to host */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_STATIC_PLAN_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_STATIC_PLAN_CONFIG_CFM, psMsg);
}
#endif 

/****************************************************************************
**
** NAME:       vUM_MAN_HE_MU_OPERATION_CONFIG_CFM   
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600
static void vUM_MAN_HE_MU_OPERATION_CONFIG_CFM(K_MSG *psMsg)
{
	/* Send confirmation to host */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HE_MU_OPERATION_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_HE_MU_OPERATION_CONFIG_CFM, psMsg);
}
#endif 

/****************************************************************************
**
** NAME:       vUM_MAN_MU_OPERATION_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_MU_OPERATION_CONFIG_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_MU_OPERATION_CONFIG_REQ_CFM);
	
#if defined (ENET_INC_ARCH_WAVE600) && !defined (ENET_INC_ARCH_WAVE600B)
	//we never enable VHT MU MIMO in wave600, just send confirm to host
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_MU_OPERATION_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_MU_OPERATION_CONFIG_CFM, psMsg);
#else
	OSAL_SEND_MESSAGE(GROUP_MANAGER_SET_MULTI_USER_OPERATION_REQ, TASK_GROUP_MANAGER, psMsg, psMsg->header.vapId);
#endif //defined (ENET_INC_ARCH_WAVE600) && !defined (ENET_INC_ARCH_WAVE600B)
}
/****************************************************************************
**
** NAME:       vUM_MAN_SET_RTS_MODE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_RTS_MODE_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_RTS_MODE_CONFIG_REQ_CFM);
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_RTS_MODE_CONFIG_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       vUM_MAN_SET_MAX_MPDU_LENGTH_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_MAX_MPDU_LENGTH_REQ(K_MSG *psMsg)
{
	UMI_MAX_MPDU* pMpsuLen = (UMI_MAX_MPDU*)psMsg->abData;
	pMpsuLen->Status = UMI_OK;
	
	if (pMpsuLen->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(pMpsuLen->maxMpduLength, MAX_MPDU_LENGTH_OPTION1_HT, MAX_MPDU_LENGTH_OPTION3_VHT, pMpsuLen->Status);
	}

	if(pMpsuLen->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_MAX_MPDU_LEN_REQ_CFM);
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_MAX_MPDU_LEN_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_MAX_MPDU_LENGTH_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_MAX_MPDU_LENGTH_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_SET_MAX_MPDU_LENGTH_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_MAX_MPDU_LEN_REQ_CFM);	
	vUMI_SendToMC(MC_MAN_MAX_MPDU_LENGTH_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUM_MAN_FIXED_RATE_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_FIXED_RATE_CONFIG_CFM(K_MSG *psMsg)
{
	UNUSED_PARAM(psMsg);	
}

static void vUM_MAN_LTF_AND_GI_CONFIG_CFM(K_MSG *psMsg)
{
	vUMI_SendToMC(MC_MAN_FIXED_LTF_AND_GI_CFM, psMsg);
}

/***********************************************************************
* vUM_MAN_BEACON_IND
* 
* Description:
* ------------
* 
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void vUM_MAN_BEACON_IND(K_MSG *psMsg)
{
	K_MSG *psMsgShram = NULL;
    UMI_Beacon_Block_t *pUmiBeaconSet = NULL;
	UMI_Beacon_Block_t *psmsgBeaconBlock = NULL;
	
	psMsgShram = OSAL_DEQUEUE_MSG(&sUmiIndFreeQueue);
	ASSERT(psMsgShram); // IF assert is not necessary, use boIF_TrySendingMsg instead of vIF_SendMsg.
	psMsgShram->header.vapId = psMsg->header.vapId;
	pUmiBeaconSet = (UMI_Beacon_Block_t *)pK_MSG_DATA(psMsgShram);
	psmsgBeaconBlock = (UMI_Beacon_Block_t *)pK_MSG_DATA(psMsg);
	pUmiBeaconSet->beaconBlock = psmsgBeaconBlock->beaconBlock;
	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_BEACON_IND_RES);
    vUMI_SendToMC(MC_MAN_BEACON_BLOCKED_IND, psMsgShram);
}
   
/***********************************************************************
* vUM_MAN_BEACON_RES
* 
* Description:
* ------------
* 
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void vUM_MAN_BEACON_RES(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_BEACON_IND_RES);
	OSAL_QUEUE_MSG(&sUmiIndFreeQueue, psMsg);
}


/***********************************************************************
* vUM_MAN_HE_MU_DBG_IND
* 
* Description:
* ------------
* 
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600

static void vUM_MAN_HE_MU_DBG_IND(K_MSG *psMsg)
{
	K_MSG *psMsgShram = NULL;

	psMsgShram = OSAL_DEQUEUE_MSG(&sUmiIndFreeQueue);
	ASSERT(psMsgShram); // IF assert is not necessary, use boIF_TrySendingMsg instead of vIF_SendMsg.
	psMsgShram->header.vapId = psMsg->header.vapId;
	MEMCPY(pK_MSG_DATA(psMsgShram),pK_MSG_DATA(psMsg),sizeof(UMI_DBG_HE_MU_GROUP_STATS)); 

	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_HE_MU_DBG_IND_RES);
	vUMI_SendToMC(MC_MAN_HE_MU_DBG_IND, psMsgShram);
}
#endif 

/***********************************************************************
* vUM_MAN_HE_MU_DBG_RES
* 
* Description:
* ------------
* 
* 
* Input:
* ------
* None
* 
* Output:
* -------
* None
* 
* Returns:
* --------
* None
* 
************************************************************************/
static void vUM_MAN_HE_MU_DBG_RES(K_MSG* psMsg)
{
#ifdef ENET_INC_ARCH_WAVE600	
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_HE_MU_DBG_IND_RES);
	OSAL_QUEUE_MSG(&sUmiIndFreeQueue, psMsg);
#else
	ASSERT(0); // We shouldn't get this MSG in Gen6.
#endif
}

/****************************************************************************
**
** NAME:       UMI_TEST_BUS_EN_REQ    
**
** RETURN VALUES:  API to enable/disable MAC/PHY IF recording to test bus
**
** DESCRIPTION:    
**
****************************************************************************/
uint8 UMI_TESTBUS_NUM_CFMS = 0;
K_MSG* TESTBUS_MSG;

static void UMI_TEST_BUS_EN_REQ(K_MSG * psMsg)
{
#ifdef DEBUG_UM_INTERFACE
#ifdef ENET_INC_ARCH_WAVE600
	K_MSG* msg1;

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_TEST_BUS_ENABLE_REQ_CFM);
	ASSERT(UMI_TESTBUS_NUM_CFMS == 0);
	TESTBUS_MSG = psMsg;

	msg1 = OSAL_GET_MESSAGE(sizeof(UMI_testBusEn_t));
	MEMCPY(msg1->abData, psMsg->abData, sizeof(UMI_testBusEn_t));
	msg1->header.tKMsgType = psMsg->header.tKMsgType;
	OSAL_SEND_MESSAGE(HDK_TEST_BUS_EN_REQ, TASK_HDK, msg1, ConfigurationManager_GetFirstVapForBand(CONFIGURATION_MANAGER_BAND_0));
	UMI_TESTBUS_NUM_CFMS++;
	if (ConfigurationManager_GetBandConfigurationMode() == CONFIGURATION_MODE_DUAL_BAND)
	{
		msg1 = OSAL_GET_MESSAGE(sizeof(UMI_testBusEn_t));
		MEMCPY(msg1->abData, psMsg->abData, sizeof(UMI_testBusEn_t));
		msg1->header.tKMsgType = psMsg->header.tKMsgType;
		OSAL_SEND_MESSAGE(HDK_TEST_BUS_EN_REQ, TASK_HDK, msg1, ConfigurationManager_GetFirstVapForBand(CONFIGURATION_MANAGER_BAND_1));
		UMI_TESTBUS_NUM_CFMS++;
	}
#else
	ASSERT(0); // This MSG should be sent only in Gen6
#endif
#else
	vUMI_SendToMC(MC_MAN_TEST_BUS_EN_CFM, psMsg);
#endif
}

#ifdef DEBUG_UM_INTERFACE
#ifdef ENET_INC_ARCH_WAVE600
static void UMI_TEST_BUS_EN_CFM(K_MSG * psMsg)
{
	UNUSED_PARAM(psMsg);	
	UMI_TESTBUS_NUM_CFMS--;
	if (UMI_TESTBUS_NUM_CFMS == 0)
	{
		ASSERT(TESTBUS_MSG);
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_TEST_BUS_ENABLE_REQ_CFM);
		vUMI_SendToMC(MC_MAN_TEST_BUS_EN_CFM, TESTBUS_MSG);
	}
}
#endif
#endif

/****************************************************************************
**
** NAME:       vUM_MAN_BF_MODE_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_BF_MODE_CONFIG_REQ(K_MSG *psMsg)
{
	UMI_BF_MODE_CONFIG *pBfModeConfig = NULL;
	K_MSG *pMsg = NULL;
	LaFixedBeamformingParams_t *pLinkAdaptationFixedBfMode = NULL;
	bool staticBfEnable = FALSE;
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_BF_MODE_CONFIG_REQ_CFM);

	pBfModeConfig = (UMI_BF_MODE_CONFIG *)pK_MSG_DATA(psMsg);
	
	pBfModeConfig->Status = UMI_OK;
	
	if(pBfModeConfig->bfMode != BF_STATE_AUTO_MODE)
	{
		VALIDATE_PARAM(pBfModeConfig->bfMode, BF_STATE_EXPLICIT, BF_STATE_NON_BF, pBfModeConfig->Status);
	}
	
	if(pBfModeConfig->Status == UMI_OK)
	{
		if (pBfModeConfig->bfMode != BF_STATE_AUTO_MODE)
		{
			staticBfEnable = TRUE;
		}

		pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedBeamformingParams_t));
		pLinkAdaptationFixedBfMode = (LaFixedBeamformingParams_t *)pK_MSG_DATA(pMsg);
		pLinkAdaptationFixedBfMode->stationId = DB_INVALID_SID;
		pLinkAdaptationFixedBfMode->beamformingMode = pBfModeConfig->bfMode;
		pLinkAdaptationFixedBfMode->maxNssNdp = 0xF;
		if (pLinkAdaptationFixedBfMode->beamformingMode == BF_STATE_EXPLICIT)
		{
			pLinkAdaptationFixedBfMode->periodicBfReq = TRUE;
		}

		pLinkAdaptationFixedBfMode->staticBfEnable = staticBfEnable;	
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_BF_MODE_REQ, TASK_LINK_ADAPTATION, pMsg, psMsg->header.vapId);
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_BF_MODE_CONFIG_REQ_CFM);
	}

	vUMI_SendToMC(MC_MAN_BF_MODE_CONFIG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUM_MAN_FIXED_RATE_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_FIXED_RATE_CONFIG_REQ(K_MSG *psMsg)
{
	UMI_FIXED_RATE_CONFIG* pFixedRateCfg = NULL;
	pFixedRateCfg = (UMI_FIXED_RATE_CONFIG *)pK_MSG_DATA(psMsg);
#ifdef DEBUG_UM_INTERFACE
	K_MSG *pMsg = NULL;
	LaFixedRateParams_t *pLinkAdaptationFixedRateParams = NULL;

	pFixedRateCfg->Status = UMI_OK;
	
	if(pFixedRateCfg->stationIndex != INVALID_STA_INDEX)
	{
		VALIDATE_PARAM(pFixedRateCfg->stationIndex, STATION_ID_MIN, STATION_ID_MAX, pFixedRateCfg->Status);
	}
	VALIDATE_PARAM(pFixedRateCfg->bw, BW_MIN, BW_MAX, pFixedRateCfg->Status);
	VALIDATE_PARAM(pFixedRateCfg->phyMode, PHY_MODE_MIN, PHY_MODE_MAX, pFixedRateCfg->Status);
	VALIDATE_PARAM(pFixedRateCfg->nss, NSS_MIN, NSS_MAX, pFixedRateCfg->Status);
	VALIDATE_PARAM(pFixedRateCfg->mcs, MCS_MIN, MCS_MAX, pFixedRateCfg->Status);
	VALIDATE_PARAM(pFixedRateCfg->cpMode, CP_MODE_MIN, CP_MODE_MAX, pFixedRateCfg->Status);
	
	if(pFixedRateCfg->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_FIXED_RATE_CONFIG_REQ_CFM);	
#ifdef ENET_INC_ARCH_WAVE600
		SLOG0(0, 0, UMI_FIXED_RATE_CONFIG, pFixedRateCfg);
#endif
		/* Allocate and fill msg for LA */
		pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedRateParams_t));
		pLinkAdaptationFixedRateParams = (LaFixedRateParams_t *)pK_MSG_DATA(pMsg);
		pLinkAdaptationFixedRateParams->fixedRateType = FIXED_RATE_FOR_STATION;
		pLinkAdaptationFixedRateParams->stationIndex = pFixedRateCfg->stationIndex;
		pLinkAdaptationFixedRateParams->vapId = INVALID_VAP;
		pLinkAdaptationFixedRateParams->disableTimers = 0;
		pLinkAdaptationFixedRateParams->retTask = TASK_UM_IF_TASK;
		pLinkAdaptationFixedRateParams->retMsg = UMI_MC_MAN_FIXED_RATE_CONFIG_CFM;
		pLinkAdaptationFixedRateParams->backToAutoRate = pFixedRateCfg->isAutoRate;
		pLinkAdaptationFixedRateParams->phyMode = (PhyMode_e)pFixedRateCfg->phyMode;
		pLinkAdaptationFixedRateParams->bandwidth = (Bandwidth_e)pFixedRateCfg->bw;
		pLinkAdaptationFixedRateParams->cpMode = (CyclicPrefixMode_e)pFixedRateCfg->cpMode;
		pLinkAdaptationFixedRateParams->changeType = (LaPacketType_e)pFixedRateCfg->changeType;
#ifdef ENET_INC_ARCH_WAVE600D2
		pLinkAdaptationFixedRateParams->heExtRuSizeMng = (HeSuExtRuSize_e)pFixedRateCfg->heExtPartialBwMng;
		pLinkAdaptationFixedRateParams->heExtRuSizeData = (HeSuExtRuSize_e)pFixedRateCfg->heExtPartialBwData;
#endif //ENET_INC_ARCH_WAVE600D2

		if (pFixedRateCfg->phyMode < PHY_MODE_11AC)
		{
			pLinkAdaptationFixedRateParams->rate = pFixedRateCfg->mcs;
		}
		else
		{
			pLinkAdaptationFixedRateParams->rate = RATE_PARAMS_TO_TCR_VAL_VHT_HE(pFixedRateCfg->mcs, pFixedRateCfg->nss - 1, pFixedRateCfg->dcm);
		}	
		/* Send LA msg */					
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FIXED_RATE, TASK_LINK_ADAPTATION, pMsg, psMsg->header.vapId);
		/* Send confirmation to host */
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_FIXED_RATE_CONFIG_REQ_CFM);
	}
	vUMI_SendToMC(MC_MAN_FIXED_RATE_CONFIG_CFM, psMsg);
#else
	pFixedRateCfg->Status = UMI_NOT_SUPPORTED;
	vUMI_SendToMC(MC_MAN_FIXED_RATE_CONFIG_CFM, psMsg);
#endif
}

/****************************************************************************
**
** NAME:       vUM_MAN_SET_TXOP_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_TXOP_CONFIG_REQ(K_MSG *psMsg)
{
	UMI_SET_TXOP_CONFIG* pSetTxopConfig = (UMI_SET_TXOP_CONFIG*)psMsg->abData;
	pSetTxopConfig->Status = UMI_OK;
	
	if (pSetTxopConfig->getSetOperation == API_SET_OPERATION)
	{
		if(pSetTxopConfig->staId != INVALID_STA_INDEX)
		{
			VALIDATE_PARAM(pSetTxopConfig->staId, STATION_ID_MIN, STATION_ID_MAX, pSetTxopConfig->Status);
		}
		VALIDATE_PARAM(pSetTxopConfig->mode, UMI_TXOP_MODE_DISABLED, UMI_TXOP_MODE_ENABLED, pSetTxopConfig->Status);
		VALIDATE_PARAM(pSetTxopConfig->txopDuration, PRE_AGGREGATOR_TXOP_AIR_TIME_LOWER_LIMIT, PRE_AGGREGATOR_TXOP_AIR_TIME_DURATION_LIMIT, pSetTxopConfig->Status);
		VALIDATE_PARAM(pSetTxopConfig->maxNumOfStas, STATION_ID_MIN, (STATION_ID_MAX+1), pSetTxopConfig->Status); // 0 is like disabling TxOP
	}

	if(pSetTxopConfig->Status == UMI_OK)
	{
		StaDb_setTxopMode(pSetTxopConfig->staId, pSetTxopConfig->mode);	
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_TXOP_CONFIG_REQ_CFM);
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_TXOP_CONFIG_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_TXOP_CONFIG_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       vUM_MAN_SET_TXOP_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_TXOP_CONFIG_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_TXOP_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_TXOP_CONFIG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUM_MAN_SET_BEACON_INTERVAL_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_BEACON_INTERVAL_REQ(K_MSG *psMsg)
{
	K_MSG *pMsg = NULL;
	UMI_BEACON_INTERVAL_t* pSetBeaconInterval = NULL;
	UMI_BEACON_INTERVAL_t *pQosSetBeaconInterval = NULL;

	pSetBeaconInterval = (UMI_BEACON_INTERVAL_t *)pK_MSG_DATA(psMsg);
	pSetBeaconInterval->Status = UMI_OK;

	VALIDATE_PARAM(pSetBeaconInterval->beaconInterval, BEACON_INERVAL_MIN, BEACON_INERVAL_MAX, pSetBeaconInterval->Status);
	VALIDATE_PARAM(pSetBeaconInterval->vapID, VAP_ID_MIN, VAP_ID_MAX, pSetBeaconInterval->Status);

	if(pSetBeaconInterval->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_BEACON_INTERVAL_REQ_CFM);	
		pMsg = OSAL_GET_MESSAGE(sizeof(UMI_BEACON_INTERVAL_t));
		pQosSetBeaconInterval = (UMI_BEACON_INTERVAL_t *)pK_MSG_DATA(pMsg);
		pQosSetBeaconInterval->beaconInterval = pSetBeaconInterval->beaconInterval;
		pQosSetBeaconInterval->vapID = pSetBeaconInterval->vapID;	
		OSAL_SEND_MESSAGE(QOS_SET_BEACON_INTERVAL, TASK_QOS, pMsg, psMsg->header.vapId);
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_BEACON_INTERVAL_REQ_CFM);
	}
	vUMI_SendToMC(MC_MAN_SET_BEACON_INTERVAL_CFM, psMsg);
}


/****************************************************************************
**
** NAME:       vUM_MAN_SET_AP_BEACON_INFO_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/


static void vUM_MAN_SET_AP_BEACON_INFO_REQ(K_MSG *psMsg)
{

	UMI_SET_AP_BEACON_INFO* setApBeaconInfoStructurePtr = (UMI_SET_AP_BEACON_INFO*)pK_MSG_DATA(psMsg);		

	setApBeaconInfoStructurePtr->Status = UMI_OK;

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_AP_BEACON_INFO_REQ_CFM);

	VALIDATE_PARAM(setApBeaconInfoStructurePtr->beaconInterval, BSS_SET_BEACON_INTVL_MIN, BSS_SET_BEACON_INTVL_MAX, setApBeaconInfoStructurePtr->Status);
	VALIDATE_PARAM(setApBeaconInfoStructurePtr->dtimInterval, BSS_SET_DTIM_INTVL_MIN, BSS_SET_DTIM_INTVL_MAX, setApBeaconInfoStructurePtr->Status);
	VALIDATE_PARAM(setApBeaconInfoStructurePtr->mbssIdNumOfVapsInGroup, BSS_SET_MBSS_NUM_VAPS_IN_GRP_MIN, BSS_SET_MBSS_NUM_VAPS_IN_GRP_MAX, setApBeaconInfoStructurePtr->Status);

	if(setApBeaconInfoStructurePtr->Status == UMI_OK)
	{
		// Driver sends the vap index not as actual vap but as offset from 0 in the same band.
		// Need to define if FW continue to do this override or driver do it instead.
		setApBeaconInfoStructurePtr->vapId = psMsg->header.vapId;

		OSAL_SEND_MESSAGE(PAC_MANAGER_SET_AP_BEACON_INFO_REQ, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUM_MAN_SET_AP_BEACON_INFO_CFM(psMsg);
	}

}

/****************************************************************************
**
** NAME:       vUM_MAN_SET_AP_BEACON_INFO_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_AP_BEACON_INFO_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_AP_BEACON_INFO_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_AP_BEACON_INFO_CFM, psMsg);	
}

/****************************************************************************
**
** NAME:       vUM_MAN_ATF_QUOTAS_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_ATF_QUOTAS_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_ATF_QUOTAS_REQ_CFM);
	OSAL_SEND_MESSAGE(ATF_MANAGER_START_REQ, TASK_ATF, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       vUM_MAN_ATF_QUOTAS_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_ATF_QUOTAS_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_ATF_QUOTAS_REQ_CFM);
	vUMI_SendToMC(UM_MAN_ATF_QUOTAS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUM_MAN_SET_IRE_SWITCH_B_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_IRE_SWITCH_B_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_IRE_SWITCH_B_REQ_CFM);
#ifdef DEBUG_UM_INTERFACE
	OSAL_SEND_MESSAGE(HDK_IRE_SWITCH_B_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
#else
	vUMI_SendToMC(MC_MAN_SET_IRE_SWITCH_B_CFM, psMsg); 
#endif
}

#ifdef DEBUG_UM_INTERFACE
/****************************************************************************
**
** NAME:       vUM_MAN_SET_IRE_SWITCH_B_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_IRE_SWITCH_B_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_IRE_SWITCH_B_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_IRE_SWITCH_B_CFM, psMsg); 
	//HDK_PLATFORM_TABLE_REQ;
}
#endif

/****************************************************************************
**
** NAME:       vUM_MAN_BEACON_BLOCKED_INTERVAL_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_BEACON_BLOCKED_INTERVAL_REQ(K_MSG *psMsg)
{

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_BEACON_BLOCKING_INTERVAL_REQ_CFM);	
	OSAL_SEND_MESSAGE(PAC_MANAGER_BEACON_BLOCKING_SET, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       vMC_MAN_BEACON_BLOCKED_INTERVAL_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vMC_MAN_BEACON_BLOCKED_INTERVAL_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_BEACON_BLOCKING_INTERVAL_REQ_CFM);

	vUMI_SendToMC(MC_MAN_BEACON_BLOCKED_INTERVAL_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_GET_CCA_TH_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_GET_CCA_TH_REQ(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_CCA_TH_CFM);
	OSAL_SEND_MESSAGE(HDK_GET_CCA_TH_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       UMI_SLOW_PROBING_MASK_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SLOW_PROBING_MASK_REQ(K_MSG *psMsg)
{
	UMI_DisablePowerAdapt_t *pDisablePowerAdapt = (UMI_DisablePowerAdapt_t *)pK_MSG_DATA(psMsg);
#ifdef DEBUG_UM_INTERFACE
	pDisablePowerAdapt->Status = UMI_OK;
	
	if (pDisablePowerAdapt->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(pDisablePowerAdapt->slowProbingMask, SLOW_PROBING_MASK_MIN, SLOW_PROBING_MASK_MAX, pDisablePowerAdapt->Status);
	}
	if (pDisablePowerAdapt->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SLOW_PROBING_MASK_REQ_CFM);
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_EN_DIS_SLOW_PROBING_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SLOW_PROBING_MASK_CFM, psMsg);
	}
#else
	pDisablePowerAdapt->Status = UMI_NOT_SUPPORTED;
	vUMI_SendToMC(MC_MAN_SLOW_PROBING_MASK_CFM, psMsg);
#endif
}

#ifdef DEBUG_UM_INTERFACE
/****************************************************************************
**
** NAME:       UMI_SLOW_PROBING_MASK_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SLOW_PROBING_MASK_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SLOW_PROBING_MASK_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SLOW_PROBING_MASK_CFM, psMsg);
}
#endif

/****************************************************************************
**
** NAME:       UMI_ERP_SET_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_ERP_SET_REQ(K_MSG *psMsg)
{
	UMI_ERPSet_t* param = (UMI_ERPSet_t*)pK_MSG_DATA(psMsg);
	param->Status = UMI_OK;

	VALIDATE_PARAM(param->staConnectionTimeInSeconds, 0, MAX_UINT32, param->Status);
	VALIDATE_PARAM(param->radioOffTimeInMsecs, 0, MAX_UINT16, param->Status);
	VALIDATE_PARAM(param->radioOnTimeInMsecs, 0, MAX_UINT16, param->Status);	
	VALIDATE_PARAM(param->numberOfStationThreshold, 0, MAX_UINT8, param->Status);

	if (param->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_ERP_SET_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_ERP_SET_REQ, TASK_HDK, psMsg, psMsg->header.vapId);	
	}
	else
	{
		UMI_ERP_SET_CFM(psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_ERP_SET_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_ERP_SET_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_ERP_SET_REQ_CFM);	
	vUMI_SendToMC(MC_MAN_ERP_SET_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_DMR_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_DMR_CONFIG_REQ(K_MSG *psMsg)
{
	UmiDmrConfig_t* pDmrConfig = (UmiDmrConfig_t*)pK_MSG_DATA(psMsg);
	pDmrConfig->Status = UMI_OK;
	
    UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_DMR_CONFIG_REQ_CFM);

	OSAL_SEND_MESSAGE(LINK_ADAPTATION_DMR_CONFIG_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);	
}

/****************************************************************************
**
** NAME:       UMI_DMR_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_DMR_CONFIG_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_DMR_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_DMR_CONFIG_CFM, psMsg);
}




static void UMI_REG_DOMAIN_CONFIG_REQ(K_MSG *psMsg)
{
	UMI_REG_DOMAIN_CONFIG* pRegDomainConfig = (UMI_REG_DOMAIN_CONFIG*)pK_MSG_DATA(psMsg);
	pRegDomainConfig->Status = UMI_OK;
	
    UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_REG_DOMAIN_CONFIG_REQ_CFM);
#ifdef ENET_INC_ARCH_WAVE600
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_REG_DOMAIN_CONFIG_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);	
#else	//Supported by wave600 only 
	UMI_REG_DOMAIN_CONFIG_CFM(psMsg);
#endif 
}

static void UMI_REG_DOMAIN_CONFIG_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_REG_DOMAIN_CONFIG_REQ_CFM);
	
	vUMI_SendToMC(MC_MAN_SET_REG_DOMAIN_CONFIG_CFM, psMsg);
}


/****************************************************************************
**
** NAME:       UMI_FAST_DROP_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_FAST_DROP_CONFIG_REQ(K_MSG *psMsg)
{
	UMI_FAST_DROP_CONFIG_REQ_t* pFastDropCfg = (UMI_FAST_DROP_CONFIG_REQ_t*)pK_MSG_DATA(psMsg);
	pFastDropCfg->Status = UMI_OK;
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_FAST_DROP_CONFIG_REQ_CFM);	
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_FAST_DROP_CONFIG_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
}

static void UMI_FIXED_LTF_AND_GI_REQ(K_MSG *psMsg)
{	
	UMI_FIXED_LTF_AND_GI_REQ_t *umiFixedLtfAndGiMsg = (UMI_FIXED_LTF_AND_GI_REQ_t *)pK_MSG_DATA(psMsg);
	K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedScpParams_t));
	LaFixedScpParams_t *linkAdaptationFixedScpShortPreamble_p = (LaFixedScpParams_t *)pK_MSG_DATA(pMsg);
	
	umiFixedLtfAndGiMsg->Status = UMI_OK;
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_FIXED_LTF_AND_GI_REQ_CFM);
	
	if(umiFixedLtfAndGiMsg->getSetOperation == API_SET_OPERATION)
	{
		 VALIDATE_PARAM((umiFixedLtfAndGiMsg->isAuto), 0, 1, (umiFixedLtfAndGiMsg->Status));		 
 	     VALIDATE_PARAM((CyclicPrefixMode_e)(umiFixedLtfAndGiMsg->ltfAndGi), CP_MODE_SHORT_CP_SHORT_LTF, CP_MODE_LONG_CP_LONG_LTF, (umiFixedLtfAndGiMsg->Status));
	}

	 
	if(umiFixedLtfAndGiMsg->Status == UMI_OK)
	{
		linkAdaptationFixedScpShortPreamble_p->isAuto = umiFixedLtfAndGiMsg->isAuto;
		linkAdaptationFixedScpShortPreamble_p->stationId = INVALID_STA_INDEX;
		linkAdaptationFixedScpShortPreamble_p->cpMode = (CyclicPrefixMode_e)umiFixedLtfAndGiMsg->ltfAndGi;
		linkAdaptationFixedScpShortPreamble_p->getSetOperation = umiFixedLtfAndGiMsg->getSetOperation;
		linkAdaptationFixedScpShortPreamble_p->psMsg = psMsg;
	
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_FIXED_LTF_AND_GI_REQ_CFM);
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_SCP_SHORT_PREAMBLE_REQ, TASK_LINK_ADAPTATION, pMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_FIXED_LTF_AND_GI_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_FAST_DROP_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_FAST_DROP_CONFIG_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_FAST_DROP_CONFIG_REQ_CFM);	
	vUMI_SendToMC(MC_MAN_FAST_DROP_CONFIG_CFM, psMsg);
}


/****************************************************************************
**
** NAME:       UMI_DC_SET_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/

static void UMI_DUTY_CYCLE_SET_REQ (K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_DUTY_CYCLE_SET_REQ_CFM);
	OSAL_SEND_MESSAGE(HDK_DUTY_CYCLE_SET_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       UMI_DC_SET_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_DUTY_CYCLE_SET_CFM (K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_DUTY_CYCLE_SET_REQ_CFM);
	vUMI_SendToMC(MC_MAN_DUTY_CYCLE_SET_CFM, psMsg);
}


/****************************************************************************
**
** NAME:       UMI_GET_CCA_TH_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_GET_CCA_TH_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_CCA_TH_CFM);
	vUMI_SendToMC(MC_MAN_GET_CCA_TH_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
** MSG: UM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG
****************************************************************************/
static void vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG(K_MSG *psMsg)
{
	UMI_RADAR_DETECTION_RSSI_TH_CONFIG* pRadarDetectionRssiTh = (UMI_RADAR_DETECTION_RSSI_TH_CONFIG*)psMsg->abData;
	pRadarDetectionRssiTh->Status = UMI_OK;
	
	if (pRadarDetectionRssiTh->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(pRadarDetectionRssiTh->radarDetectionRssiTh, RADAR_DETECTION_RSSI_TH_MIN, RADAR_DETECTION_RSSI_TH_MAX, pRadarDetectionRssiTh->Status);
	}

	if(pRadarDetectionRssiTh->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_RADAR_DETECTION_RSSI_TH_CONFIG_REQ, TASK_HDK, psMsg,psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM, psMsg);
	}

}
/****************************************************************************
**
** NAME:       vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
** MSG: UM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG
****************************************************************************/
static void vUM_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM(K_MSG *psMsg)
{
    UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_REQ_CFM);
    vUMI_SendToMC(MC_MAN_RADAR_DETECTION_RSSI_TH_CONFIG_CFM, psMsg);
}


/****************************************************************************
**
** NAME:       vUMI_MAN_REMOVE_SID_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_REMOVE_SID_CFM(K_MSG* psMsg)
{
#if defined (ENET_INC_ARCH_WAVE600)
		UMI_REMOVE_SID* pUmiSidRequest = (UMI_REMOVE_SID*)psMsg->abData;
#endif
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_REMOVE_SID_REQ_CFM);

	// In wave600 the MAC2INDEX driver is in the LM and in wave500 it's in UM.
	// So - in wave500 we called TX Selector and RX Classifier in "vUMI_MAN_REMOVE_SID_REQ" since we already removed the SID.
	// In wave600 we call it here since only now we finished removing the SID


#if defined (ENET_INC_ARCH_WAVE600)
	/*Clear STA activity*/
	Pac_RxcGetAndClearStationActivity(pUmiSidRequest->u16SID);
    
	/*Set TX Selector VAP to disassociate*/
	TxSelector_ClearStationFromVapAssocState(pUmiSidRequest->u16SID, psMsg->header.vapId);
	StaDb_setStaStat(pUmiSidRequest->u16SID,STA_STATE_FREE); //use for class 3 indication
#endif

	vUMI_SendToMC(MC_MAN_REMOVE_SID_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_STOP_TRAFFIC_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_STOP_TRAFFIC_REQ(K_MSG* psMsg)
{

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_STOP_TRAFFIC_REQ_CFM);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[vUMI_MAN_STOP_TRAFFIC_REQ]");
#endif
	OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_STOP_TRAFFIC, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_STOP_TRAFFIC_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_STOP_TRAFFIC_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_STOP_TRAFFIC_REQ_CFM);
#ifdef BEEROCK_DEBUG
	ILOG0_V("[vUMI_MAN_STOP_TRAFFIC_CFM]");
#endif
	vUMI_SendToMC(MC_MAN_STOP_TRAFFIC_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			MC_MAN_CLASS3_ERROR_IND
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used to indicate to driver thatClass 3 error violation was detected for a STA.
**
****************************************************************************/
static void vUMI_MAN_CLASS3_ERROR_IND(K_MSG *psMsg)
{

	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_CLASS3_ERROR_IND_RES);
    vUMI_SendToMC(MC_MAN_CLASS3_ERROR_IND, psMsg );
}
	
/****************************************************************************
**
** NAME:			UM_MAN_CLASS3_ERROR_RES

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used to indicate to driver thatClass 3 error violation was detected for a STA.
**
****************************************************************************/
static void vUMI_MAN_CLASS3_ERROR_RES(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_CLASS3_ERROR_IND_RES);
	OSAL_QUEUE_MSG(&sUmiIndFreeQueue,psMsg);
}

/****************************************************************************
**
** NAME:			MC_MAN_TKIP_MIC_FAILURE_IND
**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used to indicate to driver of TKIP MIC failure
**
****************************************************************************/
static void vUMI_MAN_TKIP_MIC_FAILURE_IND(K_MSG *psMsg)
{

	UMSTAT_INC_MAN_IND_ARR(UMSTAT_MAN_TKIP_MIC_FAILURE_IND_RES);
    vUMI_SendToMC(MC_MAN_TKIP_MIC_FAILURE_IND, psMsg );
}

/****************************************************************************
**
** NAME:			vUMI_MAN_TKIP_MIC_FAILURE_RES

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		used to indicate to driver of TKIP MIC failure
**
****************************************************************************/
static void vUMI_MAN_TKIP_MIC_FAILURE_RES(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_RES_ARR(UMSTAT_MAN_TKIP_MIC_FAILURE_IND_RES);	
	OSAL_QUEUE_MSG(&sUmiIndFreeQueue,psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_WMM_PARAMETERS_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_SET_WMM_PARAMETERS_REQ(K_MSG* psMsg)
{

	UMI_SET_WMM_PARAMETERS *setWmmStructurePtr; 
	uint8 i;  
	
	setWmmStructurePtr =(UMI_SET_WMM_PARAMETERS*)pK_MSG_DATA(psMsg);	

	setWmmStructurePtr->vapId = psMsg->header.vapId;	

	{
		setWmmStructurePtr->u8Status = UMI_OK;
		
  	    for (i=0;i<MAX_USER_PRIORITIES;i++)
  	    {
			VALIDATE_PARAM((setWmmStructurePtr->wmmParamsPerAc[i].u16CWmax), AC_WMM_PARAM_CWMAX_MIN, AC_WMM_PARAM_CWMAX_MAX, (setWmmStructurePtr->u8Status));
			VALIDATE_PARAM((setWmmStructurePtr->wmmParamsPerAc[i].u16CWmin), AC_WMM_PARAM_CWMIN_MIN, AC_WMM_PARAM_CWMIN_MAX, (setWmmStructurePtr->u8Status));
			VALIDATE_PARAM((setWmmStructurePtr->wmmParamsPerAc[i].u16TXOPlimit), AC_WMM_PARAM_TXOPLIMIT_MIN, AC_WMM_PARAM_TXOPLIMIT_MAX, (setWmmStructurePtr->u8Status));
			VALIDATE_PARAM((setWmmStructurePtr->wmmParamsPerAc[i].u8Aifsn), AC_WMM_PARAM_AIFSN_MIN, AC_WMM_PARAM_AIFSN_MAX, (setWmmStructurePtr->u8Status));
			VALIDATE_PARAM((setWmmStructurePtr->wmmParamsPerAc[i].acm_flag), AC_WMM_PARAM_ACM_FLAG_MIN, AC_WMM_PARAM_ACM_FLAG_MAX, (setWmmStructurePtr->u8Status));
  	    }
	}

	if (setWmmStructurePtr->u8Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_WMM_PARAMETERS_REQ_CFM);
		OSAL_SEND_MESSAGE(BSS_MANAGER_SET_WMM_REQ, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_WMM_PARAMETERS_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_WMM_PARAMETERS_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_SET_WMM_PARAMETERS_CFM(K_MSG* psMsg)
{
	UMI_SET_WMM_PARAMETERS* pWmmParameters;

	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_WMM_PARAMETERS_REQ_CFM);	
	pWmmParameters = (UMI_SET_WMM_PARAMETERS*)psMsg->abData;		
	vUMI_SendToMC(MC_MAN_SET_WMM_PARAMETERS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_DEFAULT_KEY_INDEX_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_SET_DEFAULT_KEY_INDEX_REQ(K_MSG* psMsg)
{
	UMI_DEFAULT_KEY_INDEX* pDefaultKey = (UMI_DEFAULT_KEY_INDEX*)psMsg->abData;

	pDefaultKey->u16Status  = UMI_OK;
	
	VALIDATE_PARAM(pDefaultKey->u16KeyIndex, KEY_INDEX_MIN, KEY_INDEX_MAX, pDefaultKey->u16Status);
	if(pDefaultKey->u16SID != INVALID_STA_INDEX)
	{
		VALIDATE_PARAM(pDefaultKey->u16SID, STATION_ID_MIN, STATION_ID_MAX, pDefaultKey->u16Status);
	}
	
	if(pDefaultKey->u16Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_DEFAULT_KEY_INDEX_REQ_CFM);
		AAA_DEBUG_KERNEL_SCHEDULER_MACRO(SET_KEY_INDEX,((pDefaultKey->u16KeyIndex & 0xf) | (0xf & pDefaultKey->u16KeyType) << 4), pDefaultKey->u16SID);
		
		if (pDefaultKey->u16KeyType == UMI_RSN_GROUP_KEY)
		{
			OSAL_SEND_MESSAGE(ENCRYPTION_SET_VAP_INDEX, TASK_ENCRYPTION, psMsg, psMsg->header.vapId);
		}
		else
		{
			OSAL_SEND_MESSAGE(ENCRYPTION_SET_STA_INDEX, TASK_ENCRYPTION, psMsg, psMsg->header.vapId);
		}
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_DEFAULT_KEY_INDEX_CFM,psMsg);
	}
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_DEFAULT_KEY_INDEX_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_SET_DEFAULT_KEY_INDEX_CFM(K_MSG* psMsg)
{
	UMI_DEFAULT_KEY_INDEX* pDefaultKey = (UMI_DEFAULT_KEY_INDEX*)psMsg->abData;

	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_DEFAULT_KEY_INDEX_REQ_CFM);
	pDefaultKey->u16Status = UMI_OK;
	vUMI_SendToMC(MC_MAN_SET_DEFAULT_KEY_INDEX_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       		UMI_FIXED_POWER_REQ    
**
** RETURN VALUES:  	none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_FIXED_POWER_REQ(K_MSG *psMsg)
{
	FixedPower_t *fixedPower_p = (FixedPower_t *)pK_MSG_DATA(psMsg);
#ifdef DEBUG_UM_INTERFACE
	K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaFixedPowerParams_t));
	LaFixedPowerParams_t *linkAdaptationFixedPower_p = (LaFixedPowerParams_t *)pK_MSG_DATA(pMsg);

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_FIXED_POWER_REQ_CFM);
	linkAdaptationFixedPower_p->vapId = fixedPower_p->vapId;
	linkAdaptationFixedPower_p->stationId = fixedPower_p->stationId;
	linkAdaptationFixedPower_p->powerVal = fixedPower_p->powerVal;
	linkAdaptationFixedPower_p->changeType = (LaPacketType_e)fixedPower_p->changeType;
	linkAdaptationFixedPower_p->retTask = TASK_UM_IF_TASK;
	linkAdaptationFixedPower_p->retMsg = UMI_DBG_SET_FIXED_RATE_CFM;
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_FIXED_POWER, TASK_LINK_ADAPTATION, pMsg, linkAdaptationFixedPower_p->vapId);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_FIXED_POWER_REQ_CFM);
#else
	fixedPower_p->Status = UMI_NOT_SUPPORTED;
#endif
	vUMI_SendToMC(MC_MAN_FIXED_POWER_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       		UMI_OPERATING_MODE_REQ    
**
** RETURN VALUES:  	none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_OPERATING_MODE_REQ(K_MSG *psMsg)
{
	OperatingMode_t *operationMode_p = (OperatingMode_t *)pK_MSG_DATA(psMsg);
	K_MSG *pMsg = OSAL_GET_MESSAGE(sizeof(LaOperatingModeNotificationMsg_t));
	LaOperatingModeNotificationMsg_t *linkAdaptationOperatingMode_p = (LaOperatingModeNotificationMsg_t *)pK_MSG_DATA(pMsg);

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_OPERATING_MODE_REQ_CFM);
	linkAdaptationOperatingMode_p->channelWidth = operationMode_p->channelWidth;
	linkAdaptationOperatingMode_p->rxNss = CONVERT_MAX_NUM_OF_ANTENNAS_TO_MAX_NUM_OF_NSS(operationMode_p->rxNss);
	linkAdaptationOperatingMode_p->stationId = operationMode_p->stationId;
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_OPERATING_MODE_NOTIFICATION_REQ, TASK_LINK_ADAPTATION, pMsg, psMsg->header.vapId);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_OPERATING_MODE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_OPERATING_MODE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       		vUM_MAN_SET_QOS_PD_THRESH_REQ    
**
** RETURN VALUES:  	none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_QOS_PD_THRESH_REQ(K_MSG *psMsg)
{
	UMI_SET_PD_THRESH* pRestrictedAc = (UMI_SET_PD_THRESH*)pK_MSG_DATA(psMsg);

	pRestrictedAc->Status = UMI_OK;
	
	if(pRestrictedAc->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM((pRestrictedAc->minPdDiff), QOS_PD_THRESH_PD_DIFF_MIN, QOS_PD_THRESH_PD_DIFF_MAX, (pRestrictedAc->Status));
		VALIDATE_PARAM((QoSPdThresholdMode_e)(pRestrictedAc->mode), QOS_PD_THRESH_MODE_MIN, QOS_PD_THRESH_MODE_MAX, (pRestrictedAc->Status));
		VALIDATE_PARAM((pRestrictedAc->minPdAmount), QOS_PD_THRESH_MIN_PD_AMT_MIN, QOS_PD_THRESH_MIN_PD_AMT_MAX, (pRestrictedAc->Status));		 
	}

	if (pRestrictedAc->Status == UMI_OK)
	{
	 	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_QOS_PD_THRESH_REQ_CFM);
		OSAL_SEND_MESSAGE(QOS_PD_THRESHOLD_CONFIG, TASK_QOS, psMsg, psMsg->header.vapId);
	}
	else
	{
		// Send confirmation to host
		vUMI_SendToMC(MC_MAN_QOS_PD_THRESH_CFM, psMsg);
	}

}

/****************************************************************************
**
** NAME:       		vUM_MAN_SET_QOS_PD_THRESH_CFM    
**
** RETURN VALUES:  	none
**
** DESCRIPTION:    	Return status to host
**
****************************************************************************/
static void vUM_MAN_SET_QOS_PD_THRESH_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_QOS_PD_THRESH_REQ_CFM);
	vUMI_SendToMC(MC_MAN_QOS_PD_THRESH_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       		vUM_MAN_SET_RESTRICTED_AC_MODE_REQ    
**
** RETURN VALUES:  	none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUM_MAN_SET_RESTRICTED_AC_MODE_REQ(K_MSG *psMsg)
{
	UMI_SET_RESTRICTED_AC* pSetREstrictedAc = (UMI_SET_RESTRICTED_AC*)pK_MSG_DATA(psMsg);	
	pSetREstrictedAc->Status = UMI_OK;
	
	if (pSetREstrictedAc->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(pSetREstrictedAc->acRestrictedBitmap, RES_AC_BITMAP_MIN, RES_AC_BITMAP_MAX, pSetREstrictedAc->Status);
		VALIDATE_PARAM(pSetREstrictedAc->restrictedAcThreshEnter, RES_AC_THR_ENTER_MIN, RES_AC_THR_ENTER_MAX, pSetREstrictedAc->Status);
		VALIDATE_PARAM(pSetREstrictedAc->restrictedAcThreshExit, RES_AC_THR_EXIT_MIN, RES_AC_THR_EXIT_MAX, pSetREstrictedAc->Status);
	}
	
	if (pSetREstrictedAc->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_RESTRICTED_AC_MODE_REQ_CFM);
		OSAL_SEND_MESSAGE(HIM_SET_RESTRICTED_AC_MODE, TASK_HIM, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_RESTRICTED_AC_MODE_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       		vUM_MAN_SET_RESTRICTED_AC_MODE_CFM    
**
** RETURN VALUES:  	none
**
** DESCRIPTION:    	Return status to host
**
****************************************************************************/
static void vUM_MAN_SET_RESTRICTED_AC_MODE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_RESTRICTED_AC_MODE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_RESTRICTED_AC_MODE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_TPC_ANT_PARAMS_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_TPC_ANT_PARAMS_REQ(K_MSG * psMsg)
{
	uint8 i;
	tpcAntParams_t* params = (tpcAntParams_t*)pK_MSG_DATA(psMsg);
	params->Status = UMI_OK;

	if((params->tpcFreqLen != 9) && (params->tpcFreqLen != 14) && ( params->tpcFreqLen != 20))
	{
		params->Status = UMI_BAD_PARAMETER;
	}

	VALIDATE_PARAM(params->ant, TPC_ANT_MIN, TPC_ANT_MAX, params->Status);

	for(i = 0; i < TPC_FREQ_STR_NUM; i++)
	{
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1s2dNoCal.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1s2dNoCal.ultimateEVMgain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2s2dNoCal.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2s2dNoCal.ultimateEVMgain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3s2dNoCal.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3s2dNoCal.ultimateEVMgain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1s2d.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2s2d.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2s2d.ultimateEVMgain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3s2d.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3s2d.ultimateEVMgain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1Region.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1Region.bw, TPC_BW_MIN, TPC_BW_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1Region.maxp, TPC_MAX_POWER_MIN, TPC_MAX_POWER_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1Region.uevm_index, TPC_ULTI_EVM_INDEX_MIN, TPC_ULTI_EVM_INDEX_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq1Region.uevm_gain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2Region.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2Region.bw, TPC_BW_MIN, TPC_BW_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2Region.maxp, TPC_MAX_POWER_MIN, TPC_MAX_POWER_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2Region.uevm_index, TPC_ULTI_EVM_INDEX_MIN, TPC_ULTI_EVM_INDEX_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq2Region.uevm_gain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3Region.chID, TPC_CH_ID_MIN, TPC_CH_ID_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3Region.bw, TPC_BW_MIN, TPC_BW_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3Region.maxp, TPC_MAX_POWER_MIN, TPC_MAX_POWER_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3Region.uevm_index, TPC_ULTI_EVM_INDEX_MIN, TPC_ULTI_EVM_INDEX_MAX, params->Status);
		VALIDATE_PARAM(params->tpcParams.tpcFreq[i].tpcFreq3Region.uevm_gain, TPC_ULTI_EVM_GAIN_MIN, TPC_ULTI_EVM_GAIN_MAX, params->Status);
	}
	

	if(params->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_TPC_ANT_PARAMS_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_SET_TPC_ANT_PARAMS_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_TPC_ANT_PARAMS_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_SET_TPC_ANT_PARAMS_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_TPC_ANT_PARAMS_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_TPC_ANT_PARAMS_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_TPC_ANT_PARAMS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_TPC_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_TPC_CONFIG_REQ(K_MSG * psMsg)
{
	uint8 i,power;
	tpcConfig_t* params = (tpcConfig_t*)pK_MSG_DATA(psMsg);
	params->Status = UMI_OK;

	if(params->getSetOperation == API_SET_OPERATION)
	{
		for(i = 0; i < MAXIMUM_BANDWIDTHS_GEN6; i++)
		{
			power = params->regulationLimit[i] >> (GAIN_RESOLUTION - 1);
			VALIDATE_PARAM(power, REGULATION_LIMIT_MIN, REGULATION_LIMIT_MAX, params->Status);
			power = params->regulationLimitBF[i] >> (GAIN_RESOLUTION - 1);
			VALIDATE_PARAM(power, REGULATION_LIMIT_BF_MIN, REGULATION_LIMIT_BF_MAX, params->Status);
			power = params->regulationLimitMU[i] >> (GAIN_RESOLUTION - 1);
			VALIDATE_PARAM(power, REGULATION_LIMIT_MU_MIN, REGULATION_LIMIT_MU_MAX, params->Status);
		}
		power = params->powerLimit11b >> (GAIN_RESOLUTION - 1);
		VALIDATE_PARAM(params->powerLimit11b, POWER_LIMIT_11B_MIN, POWER_LIMIT_11B_MAX, params->Status);
		VALIDATE_PARAM(params->tpcLoopType, TPC_LOOP_TYPE_MIN, TPC_LOOP_TYPE_MAX, params->Status);
	}

	if(params->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_TPC_CONFIG_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_SET_TPC_CONFIG_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_TPC_CONFIG_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_SET_TPC_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_TPC_CONFIG_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_TPC_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_TPC_CONFIG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_HDK_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_HDK_CONFIG_REQ(K_MSG * psMsg)
{
	UMI_HDK_CONFIG* params = (UMI_HDK_CONFIG*)pK_MSG_DATA(psMsg);
	params->Status = UMI_OK;

	if(params->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(params->hdkConf.band, BAND_MIN, BAND_MAX, params->Status);
	}

	if(params->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HDK_CONFIG_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_SET_HDK_CONFIG_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_HDK_CONFIG_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_SET_HDK_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_HDK_CONFIG_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HDK_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_HDK_CONFIG_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_AFE_CALIBRATION_DATA_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_AFE_CALIBRATION_DATA_REQ(K_MSG * psMsg)
{
	afe_calibration_data_t* params = (afe_calibration_data_t*)pK_MSG_DATA(psMsg);
	params->Status = UMI_OK;
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_AFE_CAL_DATA_REQ_CFM);
#if defined (HDK_REL_2_0)
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_AFE_CALIBRATION_DATA_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
#else
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_SET_AFE_CAL_DATA, TASK_HDK_CDB_MANAGER, psMsg, psMsg->header.vapId);
#endif
}

/****************************************************************************
**
** NAME:       UMI_SET_AFE_CALIBRATION_DATA_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_AFE_CALIBRATION_DATA_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_AFE_CAL_DATA_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_AFE_CALIBRATION_DATA_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_RFIC_CALIBRATION_DATA_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RFIC_CALIBRATION_DATA_REQ(K_MSG * psMsg)
{
	rfic_calibration_data_t* params = (rfic_calibration_data_t*)pK_MSG_DATA(psMsg);
	params->Status = UMI_OK;
	
	VALIDATE_PARAM(params->rficCisSize, RFIC_CIS_SIZE_MIN, RFIC_CIS_SIZE_MAX, params->Status);
	
	if(params->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_RFIC_CAL_DATA_REQ_CFM);
#if defined (HDK_REL_2_0)
		OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_RFIC_CALIBRATION_DATA_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
#else
		OSAL_SEND_MESSAGE(HDK_RFIC_SET_CALIBRATION_DATA, TASK_HDK, psMsg, psMsg->header.vapId);
#endif
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_RFIC_CALIBRATION_DATA_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_SET_RFIC_CALIBRATION_DATA_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RFIC_CALIBRATION_DATA_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RFIC_CAL_DATA_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_RFIC_CALIBRATION_DATA_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_RSSI_CAL_PARAMS_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RSSI_CAL_PARAMS_REQ(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_RSSI_CAL_REQ_CFM);
#if defined (HDK_REL_2_0)
	OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_RSSI_CAL_DATA_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
#else
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_SET_RSSI_CAL_DATA, TASK_HDK_CDB_MANAGER, psMsg, psMsg->header.vapId);
#endif
}

/****************************************************************************
**
** NAME:       UMI_SET_RFIC_CALIBRATION_DATA_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RSSI_CAL_DATA_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RSSI_CAL_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_RSSI_CAL_PARAMS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_ENABLE_RADIO_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_ENABLE_RADIO_REQ(K_MSG * psMsg)
{
	UMI_ENABLE_RADIO* params = (UMI_ENABLE_RADIO*)pK_MSG_DATA(psMsg);
	params->Status = UMI_OK;
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_ENABLE_RADIO_REQ_CFM);	
	OSAL_SEND_MESSAGE(HDK_CHANGE_RADIO_STATE_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       UMI_ENABLE_RADIO_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_ENABLE_RADIO_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_ENABLE_RADIO_REQ_CFM);
	vUMI_SendToMC(MC_MAN_ENABLE_RADIO_CFM, psMsg);
}

/****************************************************************************
**
** NAME:    UMI_SET_AGG_RATE_LIMIT_REQ       
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_AGG_RATE_LIMIT_REQ(K_MSG * psMsg)
{
	UMI_AGG_RATE_LIMIT* pAggRateLimit = (UMI_AGG_RATE_LIMIT*)pK_MSG_DATA(psMsg);
	pAggRateLimit->Status = UMI_OK;
	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_AGG_RATE_LIMIT_REQ_CFM);
	OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_AGG_RATE_LIMIT_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);	
}

/****************************************************************************
**
** NAME:      UMI_SET_AGG_RATE_LIMIT_CFM     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_AGG_RATE_LIMIT_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_AGG_RATE_LIMIT_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_AGG_RATE_LIMIT_CFM, psMsg);
}

/****************************************************************************
**
** NAME:      UMI_SET_POWER_SELECTION_REQ     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_POWER_LIMIT_REQ(K_MSG * psMsg)
{
	UMI_TX_POWER_LIMIT* powerLimitParams = (UMI_TX_POWER_LIMIT*)pK_MSG_DATA(psMsg);
	powerLimitParams->Status = UMI_OK;
	
	if(powerLimitParams->getSetOperation == API_SET_OPERATION)
	{
		if( (powerLimitParams->powerLimitOffset !=  0) &&
			(powerLimitParams->powerLimitOffset !=  3) &&
			(powerLimitParams->powerLimitOffset !=  6) &&
			(powerLimitParams->powerLimitOffset !=  9))
		{
			powerLimitParams->Status = UMI_BAD_PARAMETER;
		}
	}
	
	if(powerLimitParams->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_POWER_LIMIT_REQ_CFM);
		OSAL_SEND_MESSAGE(HDK_SET_POWER_SELECTION, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_POWER_LIMIT_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:      UMI_SET_ADMISSION_CAPACITY_REQ     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_ADMISSION_CAPACITY_REQ(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_ADMISSION_CAPACITY_REQ_CFM);
#if defined (ENET_INC_ARCH_WAVE600)
	OSAL_SEND_MESSAGE(PAC_MANAGER_UPDATE_ADMISSION_CAPACITY, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);
#else
	OSAL_SEND_MESSAGE(STATISTICS_MANAGER_UPDATE_ADMISSION_CAPACITY, TASK_STATISTICS_MANAGER, psMsg, psMsg->header.vapId);
#endif
}

/****************************************************************************
**
** NAME:      UMI_SET_POWER_SELECTION_CFM     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_POWER_LIMIT_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_POWER_LIMIT_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_POWER_LIMIT_CFM, psMsg);
}

/****************************************************************************
**
** NAME:	  UMI_SET_ADMISSION_CAPACITY_CFM	  
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_ADMISSION_CAPACITY_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_ADMISSION_CAPACITY_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_ADMISSION_CAPACITY_CFM, psMsg);
}

/****************************************************************************
**
** NAME:      UMI_GET_TEMPERATURE_REQ     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_HDK_USER_DEMAND_REQ(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_USER_DEMAND_REQ_CFM);
	OSAL_SEND_MESSAGE(HDK_USER_DEMAND_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:      UMI_GET_TEMPERATURE_CFM     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_HDK_USER_DEMAND_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_USER_DEMAND_REQ_CFM);
	vUMI_SendToMC(MC_MAN_HDK_USER_DEMAND_CFM, psMsg);
}

/****************************************************************************
**
** NAME:      UMI_CCA_TH_REQ     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_CCA_TH_REQ(K_MSG * psMsg)
{
	UMI_CCA_TH_t* params = (UMI_CCA_TH_t*)pK_MSG_DATA(psMsg);
	params->Status = UMI_OK;
	
	VALIDATE_PARAM(params->primaryChCCA, PRIMARY_CH_CCA_MIN, PRIMARY_CH_CCA_MAX, params->Status);
	VALIDATE_PARAM(params->secondaryChCCA, SECONDARY_CH_CCA_MIN, SECONDARY_CH_CCA_MAX, params->Status);
	VALIDATE_PARAM(params->sec40CcaTh, SEC_40_CCA_TH_MIN, SEC_40_CCA_TH_MAX, params->Status);
	VALIDATE_PARAM(params->sec80CcaTh, SEC_80_CCA_TH_MIN, SEC_80_CCA_TH_MAX, params->Status);
	
	if(params->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_CCA_TH_CFM);
		OSAL_SEND_MESSAGE(HDK_CCA_TH_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_CCA_TH_CFM, psMsg);
	}

}

/****************************************************************************
**
** NAME:      UMI_CCA_TH_CFM     
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_CCA_TH_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_CCA_TH_CFM);
	vUMI_SendToMC(MC_MAN_CCA_TH_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_RX_TH_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RX_TH_REQ(K_MSG * psMsg)
{
	UMI_RX_TH* pRxThMsg = (UMI_RX_TH*)pK_MSG_DATA(psMsg);
	
	if (pRxThMsg->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(pRxThMsg->rxThValue, RX_TH_VALUE_MIN, RX_TH_VALUE_MAX, pRxThMsg->Status);
	}
	if(pRxThMsg->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_RX_TH_REQ_CFM);
#if defined (ENET_INC_ARCH_WAVE600)
		OSAL_SEND_MESSAGE(HDK_SET_RX_TH_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
#else	
		OSAL_SEND_MESSAGE(STATISTICS_MANAGER_SET_RX_TH_REQ, TASK_STATISTICS_MANAGER, psMsg, psMsg->header.vapId);
#endif
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_RX_TH_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_SET_RX_DUTY_CYCLE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RX_DUTY_CYCLE_REQ(K_MSG * psMsg)
{
	UMI_RX_DUTY_CYCLE* pRxDutyCycleMsg = (UMI_RX_DUTY_CYCLE*)pK_MSG_DATA(psMsg);
	pRxDutyCycleMsg->Status = UMI_OK;
	
	if (pRxDutyCycleMsg->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(pRxDutyCycleMsg->onTime, ON_TIME_MIN, ON_TIME_MAX, pRxDutyCycleMsg->Status);
		VALIDATE_PARAM(pRxDutyCycleMsg->offTime, OFF_TIME_MIN, OFF_TIME_MAX, pRxDutyCycleMsg->Status);
	}

	if(pRxDutyCycleMsg->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_RX_DUTY_CYCLE_CFM);	
		OSAL_SEND_MESSAGE(HDK_SET_RX_DUTY_CYCLE_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_RX_DUTY_CYCLE_CFM, psMsg);
	}

}

/****************************************************************************
**
** NAME:       UMI_SET_RX_TH_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RX_TH_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RX_TH_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_RX_TH_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_SET_RX_DUTY_CYCLE_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_SET_RX_DUTY_CYCLE_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RX_DUTY_CYCLE_CFM);
	vUMI_SendToMC(MC_MAN_SET_RX_DUTY_CYCLE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_DEFAULT_KEY_INDEX_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void vUMI_MAN_SET_802_1X_FILTER_REQ(K_MSG* psMsg)
{
	UMI_802_1X_FILTER* p8021xFilter = (UMI_802_1X_FILTER*)psMsg->abData;
	
	p8021xFilter->u16Status  = UMI_OK;

	VALIDATE_PARAM(p8021xFilter->u16SID, STATION_ID_MIN, STATION_ID_MAX, p8021xFilter->u16Status);
	
	if(p8021xFilter->u16Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_802_1X_FILTER_REQ_CFM);
		if (p8021xFilter->u8IsFilterOpen == TRUE)
		{
			OSAL_SEND_MESSAGE(BSS_MANAGER_STA_MANAGER_SET_FILTER, TASK_BSS_MANAGER, psMsg, psMsg->header.vapId);
			SLOG0(0, 0, UMI_802_1X_FILTER, p8021xFilter);
		}
		else
		{
			OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_802_1X_FILTER_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);
		}
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_802_1X_FILTER_CFM,psMsg);
	}
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_DEFAULT_KEY_INDEX_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_SET_802_1X_FILTER_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_802_1X_FILTER_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_802_1X_FILTER_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUMI_MAN_HW_LOGGER_ADD_STREAM_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		
**
****************************************************************************/
static void vUMI_MAN_HW_LOGGER_ADD_STREAM_REQ(K_MSG *psMsg)
{
	UMI_ADD_STREAM_REQ_t* addStreamStructurePtr = (UMI_ADD_STREAM_REQ_t*) pK_MSG_DATA(psMsg);
	addStreamStructurePtr->u16Status = UMI_OK;

	VALIDATE_PARAM(addStreamStructurePtr->streamId, STREAM_ID_MIN, STREAM_ID_MAX, addStreamStructurePtr->u16Status);
	VALIDATE_PARAM(addStreamStructurePtr->bufferThreshold, BUFFER_THRESHOLD_ID_MIN, BUFFER_THRESHOLD_ID_MAX, addStreamStructurePtr->u16Status);
	VALIDATE_PARAM(addStreamStructurePtr->assignedFifosId, ASSIGNED_FIFOID_MIN, ASSIGNED_FIFOID_MAX, addStreamStructurePtr->u16Status);

	if(addStreamStructurePtr->u16Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HW_LOGGER_ADD_STREAM_REQ_CFM);
		HwLogger_AddStreamReq(psMsg);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_HW_LOGGER_ADD_STREAM_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:			vUMI_MAN_HW_LOGGER_ADD_STREAM_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		
**
****************************************************************************/
static void vUMI_MAN_HW_LOGGER_ADD_STREAM_CFM(K_MSG *psMsg)
{
	UMI_ADD_STREAM_REQ_t* addStreamStructurePtr = (UMI_ADD_STREAM_REQ_t*) pK_MSG_DATA(psMsg);

	addStreamStructurePtr->u16Status = UMI_OK; 
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HW_LOGGER_ADD_STREAM_REQ_CFM);
	vUMI_SendToMC(MC_MAN_HW_LOGGER_ADD_STREAM_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       umiDbgSetFixedRatecFm    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void umiDbgSetFixedRateCfm(K_MSG * psMsg)
{
	UNUSED_PARAM(psMsg);	
}

/****************************************************************************
**
** NAME:			vUMI_MAN_HW_LOGGER_REMOVE_STREAM_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		
**
****************************************************************************/
static void vUMI_MAN_HW_LOGGER_REMOVE_STREAM_REQ(K_MSG *psMsg)
{
	UMI_REMOVE_STREAM_REQ_t* removeStreamStructurePtr = (UMI_REMOVE_STREAM_REQ_t*) pK_MSG_DATA(psMsg);

	removeStreamStructurePtr->u16Status = UMI_OK;

	VALIDATE_PARAM(removeStreamStructurePtr->streamId, STREAM_ID_MIN, STREAM_ID_MAX,removeStreamStructurePtr->u16Status);
	if(removeStreamStructurePtr->u16Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HW_LOGGER_REMOVE_STREAM_REQ_CFM);
		HwLogger_RemoveStreamReq(removeStreamStructurePtr->streamId); 

		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HW_LOGGER_REMOVE_STREAM_REQ_CFM);
	}
	
	vUMI_SendToMC(MC_MAN_HW_LOGGER_REMOVE_STREAM_CFM, psMsg);
}


/****************************************************************************
**
** NAME:			vUMI_MAN_HW_LOGGER_ADD_FILTER_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		
**
****************************************************************************/
static void vUMI_MAN_HW_LOGGER_ADD_FILTER_REQ(K_MSG *psMsg)
{
	UMI_ADD_FIFO_FILTER_REQ_t* addFilterStructurePtr = (UMI_ADD_FIFO_FILTER_REQ_t*) pK_MSG_DATA(psMsg);
	addFilterStructurePtr->u16Status = UMI_OK;

	VALIDATE_PARAM(addFilterStructurePtr->logLevel, LOG_LEVEL_MIN, LOG_LEVEL_MAX, addFilterStructurePtr->u16Status);
	VALIDATE_PARAM(addFilterStructurePtr->fifosBitmap, FIFO_BITMAP_MIN, FIFO_BITMAP_MAX, addFilterStructurePtr->u16Status);
	
	if(addFilterStructurePtr->u16Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HW_LOGGER_ADD_FILTER_REQ_CFM);
		HwLogger_AddFifoFilterReq(addFilterStructurePtr);
		addFilterStructurePtr->u16Status = UMI_OK; 
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HW_LOGGER_ADD_FILTER_REQ_CFM);
	}
	vUMI_SendToMC(MC_MAN_HW_LOGGER_ADD_FILTER_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUMI_MAN_HW_LOGGER_REMOVE_FILTER_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		
**
****************************************************************************/
static void vUMI_MAN_HW_LOGGER_REMOVE_FILTER_REQ(K_MSG *psMsg)
{
	UMI_REMOVE_FIFO_FILTER_REQ_t* removeFilterStructurePtr = (UMI_REMOVE_FIFO_FILTER_REQ_t*) pK_MSG_DATA(psMsg);
	removeFilterStructurePtr->u16Status = UMI_OK;
	
	VALIDATE_PARAM(removeFilterStructurePtr->logLevel, LOG_LEVEL_MIN, LOG_LEVEL_MAX, removeFilterStructurePtr->u16Status);
	VALIDATE_PARAM(removeFilterStructurePtr->fifosBitmap, FIFO_BITMAP_MIN, FIFO_BITMAP_MAX, removeFilterStructurePtr->u16Status);
	
	if(removeFilterStructurePtr->u16Status == UMI_OK)
	{
	
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HW_LOGGER_REMOVE_FILTER_REQ_CFM);
		HwLogger_RemoveFifoFilterReq(removeFilterStructurePtr); 
	
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HW_LOGGER_REMOVE_FILTER_REQ_CFM);
	}

	vUMI_SendToMC(UM_MAN_HW_LOGGER_REMOVE_FILTER_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUMI_MAN_HW_LOGGER_SET_TRIGGER_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		
**
****************************************************************************/
static void vUMI_MAN_HW_LOGGER_SET_TRIGGER_REQ(K_MSG *psMsg)
{
	UMI_SET_TRIGGER_REQ_t* setTriggerStructurePtr = (UMI_SET_TRIGGER_REQ_t*) pK_MSG_DATA(psMsg);
	setTriggerStructurePtr->u16Status = UMI_OK;
	
	if(setTriggerStructurePtr->u16Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HW_LOGGER_SET_TRIGGER_REQ_CFM);
		HwLogger_SetHdrTriggerReq(setTriggerStructurePtr);
		setTriggerStructurePtr->u16Status = UMI_OK;
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HW_LOGGER_SET_TRIGGER_REQ_CFM);
	}

	vUMI_SendToMC(UM_MAN_HW_LOGGER_SET_TRIGGER_CFM, psMsg);
}

/****************************************************************************
**
** NAME:			vUMI_MAN_HW_LOGGER_RESET_TRIGGER_REQ

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		
**
****************************************************************************/
static void vUMI_MAN_HW_LOGGER_RESET_TRIGGER_REQ(K_MSG *psMsg)
{
	UMI_RESET_TRIGGER_REQ_t* resetTriggerStructurePtr = (UMI_RESET_TRIGGER_REQ_t*) pK_MSG_DATA(psMsg);

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_HW_LOGGER_RESET_TRIGGER_REQ_CFM);
	HwLogger_ResetHdrTriggerReq(resetTriggerStructurePtr); 	
	resetTriggerStructurePtr->u16Status = UMI_OK; 
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_HW_LOGGER_RESET_TRIGGER_REQ_CFM);
	vUMI_SendToMC(UM_MAN_HW_LOGGER_RESET_TRIGGER_CFM, psMsg);
}


/****************************************************************************
**
** NAME:           vUM_MAN_SET_BCL_VALUE_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_SET_BCL_VALUE_REQ message
**                 Determine the memory required and set its value
**
****************************************************************************/
void vUM_MAN_SET_BCL_VALUE_REQ(K_MSG *psmsg)
{
    UMI_BCL_REQUEST  *psbcl = (UMI_BCL_REQUEST *) pK_MSG_DATA(psmsg);
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_BCL_VALUE_REQ_CFM);

#if defined (ENET_INC_UMAC)
	if (((psbcl->Address & OTHER_CPU_BIT) != 0) && (IS_ADDRESS_IN_IRAM(psbcl->Address) == TRUE))
	{
		// Address is in LM
		CLEAR_OTHER_CPU_BIT(psbcl->Address);	
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_BCL_REQ, TASK_LINK_ADAPTATION, psmsg, psmsg->header.vapId);		
	}
	else
	{
		MT_vUM_CommonManSetBclValueReq(psbcl);
		/* send to MC */
		OSAL_SEND_MESSAGE(UMI_MC_MAN_SET_BCL_CFM, TASK_UM_IF_TASK, psmsg, psmsg->header.vapId);	
	}
#endif
}

/****************************************************************************
**
** NAME:           vUM_MAN_QUERY_BCL_VALUE_REQ
**
** PARAMETERS:
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Handle UM_MAN_QUERY_BCL_VALUE_REQ message
**                 Read the memory required 
**
****************************************************************************/
void vUM_MAN_QUERY_BCL_VALUE_REQ(K_MSG *psmsg)
{
	UMI_BCL_REQUEST  *psbcl = (UMI_BCL_REQUEST *) pK_MSG_DATA(psmsg);
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_QUERY_BCL_VALUE_REQ_CFM);

#if defined (ENET_INC_UMAC)
	if (((psbcl->Address & OTHER_CPU_BIT) != 0) && (IS_ADDRESS_IN_IRAM(psbcl->Address) == TRUE))
	{
		// Address is in LM
		CLEAR_OTHER_CPU_BIT(psbcl->Address);
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_GET_BCL_REQ, TASK_LINK_ADAPTATION, psmsg, psmsg->header.vapId);		
	}
	else
	{
		MT_vUM_CommonManQueryBclValueReq(psbcl);
		/* send to MC */
		OSAL_SEND_MESSAGE(UMI_MC_MAN_QUERY_BCL_CFM, TASK_UM_IF_TASK, psmsg, psmsg->header.vapId);	
	}
#endif
}

/****************************************************************************
**
** NAME:			vUMI_MC_MAN_SET_BCL_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		setting BCL values
**
****************************************************************************/
void  vUMI_MC_MAN_SET_BCL_CFM(K_MSG *psMsg)
{
	/* confirm sent when calling vUM_ReportTransparent inside OSAL_SEND_DIRECT */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_BCL_VALUE_REQ_CFM);
    vUMI_SendToMC(MC_MAN_SET_BCL_CFM, psMsg);			
}

/****************************************************************************
**
** NAME:			vUMI_MC_MAN_QUERY_BCL_CFM

**
** PARAMETERS:		psMsg - contains information of the related message
**
** RETURN VALUES:	none
**
** DESCRIPTION: 		getting BCL values
**
****************************************************************************/
void  vUMI_MC_MAN_QUERY_BCL_CFM(K_MSG *psMsg)
{
	/* confirm sent when calling vUM_ReportTransparent inside OSAL_SEND_DIRECT */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_QUERY_BCL_VALUE_REQ_CFM);
    vUMI_SendToMC(MC_MAN_QUERY_BCL_CFM, psMsg);		
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_MULTICAST_MODE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_SET_MULTICAST_MODE_REQ(K_MSG* psMsg)
{
	UMI_MULTICAST_MODE* pMulticastMode = (UMI_MULTICAST_MODE*)pK_MSG_DATA(psMsg);
	pMulticastMode->Status = UMI_OK;
	
	VALIDATE_PARAM(pMulticastMode->u8VapID, 0, HW_NUM_OF_VAPS-1, pMulticastMode->Status);
	
	if(pMulticastMode->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_MULTICAST_MODE_REQ_CFM);
		OSAL_SEND_MESSAGE(HIM_SET_MULTICAST_MODE, TASK_HIM, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_SET_MULTICAST_MODE_CFM, psMsg);
	}
}


/****************************************************************************
**
** NAME:       vUMI_MAN_SET_MULTICAST_MODE_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_SET_MULTICAST_MODE_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_MULTICAST_MODE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_MULTICAST_MODE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_MULTICAST_ACTION_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_SET_MULTICAST_ACTION_REQ(K_MSG* psMsg)
{
	UMI_MULTICAST_ACTION* 	pMulticastAction = (UMI_MULTICAST_ACTION*)pK_MSG_DATA(psMsg);
	pMulticastAction->Status = UMI_OK;


	VALIDATE_PARAM(pMulticastAction->u16StaID, STATION_ID_MIN, STATION_ID_MAX, pMulticastAction->Status);
	VALIDATE_PARAM(pMulticastAction->u8GroupID, GROUP_ID_MIN, GROUP_ID_MAX, pMulticastAction->Status);
	
	if(pMulticastAction->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_MULTICAST_ACTION_REQ_CFM);
		OSAL_SEND_MESSAGE(MULTICAST_HANDLER_GROUP_ACTION, TASK_TX_MANAGER, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_MULTICAST_ACTION_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       vUMI_MAN_SET_MULTICAST_ACTION_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void vUMI_MAN_SET_MULTICAST_ACTION_CFM(K_MSG* psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_MULTICAST_ACTION_REQ_CFM);
	vUMI_SendToMC(MC_MAN_MULTICAST_ACTION_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       vUMI_AllocAndSendToMC    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
void vUMI_AllocAndSendToMC(FwUtils_queue_t *psFreeQueue, K_MSG_TYPE msgType, K_MSG *psKmsg)
{
	K_MSG *psMsgShram = OSAL_DEQUEUE_MSG(psFreeQueue);

	ASSERT(psMsgShram); // IF assert is not necessary, use boIF_TrySendingMsg instead of vIF_SendMsg.
	ASSERT(psKmsg->header.payloadSize < psFreeQueue->maxPayload);

	psMsgShram->header.vapId 		= psKmsg->header.vapId;
    psMsgShram->header.tKMsgType 	= msgType;
    psMsgShram->header.payloadSize	= psKmsg->header.payloadSize;

	// Copy stack based parameters to allocated area
	MEMCPY(pK_MSG_DATA(psMsgShram), pK_MSG_DATA(psKmsg), psKmsg->header.payloadSize);
	
	OSAL_SET_MESSAGE_ORIGINATOR(psMsgShram); 
	
    /* Return message with result that copy has suceeded */
	vHIM_SendMsgToHost(psMsgShram);
}
/****************************************************************************
**
** NAME:       UMI_MAN_SSB_MODE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    sets SSB configuration mode
**
****************************************************************************/
static void UMI_MAN_SSB_MODE_REQ(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SSB_MODE_REQ_CFM);

	OSAL_SEND_MESSAGE(HDK_SET_SSB_MODE_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}
/****************************************************************************
**
** NAME:       UMI_MAN_SSB_MODE_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    sets SSB configuration mode
**
****************************************************************************/

static void UMI_MAN_SSB_MODE_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SSB_MODE_REQ_CFM);	

	vUMI_SendToMC(MC_MAN_SSB_MODE_CFM, psMsg);
}
/****************************************************************************
**
** NAME:       UMI_FREQ_JUMP_MODE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_FREQ_JUMP_MODE_REQ(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_FREQ_JUMP_MODE_REQ_CFM);	
	OSAL_SEND_MESSAGE(HDK_FREQ_JUMP_MODE_REQ, TASK_HDK, psMsg, psMsg->header.vapId);
}

/****************************************************************************
**
** NAME:       UMI_FREQ_JUMP_MODE_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_FREQ_JUMP_MODE_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_FREQ_JUMP_MODE_REQ_CFM);
	vUMI_SendToMC(MC_MAN_FREQ_JUMP_MODE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_PVT_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_PVT_REQ(K_MSG * psMsg)
{
#ifdef ENET_INC_ARCH_WAVE600	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_PVT_READ_REQ_CFM);
	OSAL_SEND_MESSAGE(HDK_CDB_MAN_PVT_READ, TASK_HDK_CDB_MANAGER, psMsg, psMsg->header.vapId);
#else
	ASSERT(0); // This MSG should be sent only in Gen6.
#endif
}

/****************************************************************************
**
** NAME:       UMI_PVT_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
#ifdef ENET_INC_ARCH_WAVE600	
static void UMI_PVT_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_PVT_READ_REQ_CFM);
	vUMI_SendToMC(MC_MAN_PVT_READ_CFM, psMsg);
}
#endif

/****************************************************************************
 **
 ** NAME:		UMI_MAN_2_4GHZ_COEX_REQ	
 **
 ** RETURN VALUES:	none
 **
 ** DESCRIPTION:	sets 2.4GHz co-existance configuration 
 **
 ****************************************************************************/
static void UMI_MAN_2_4GHZ_COEX_REQ(K_MSG *psMsg)
{
		
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_2_4GHZ_COEX_REQ_CFM);	
#ifdef PTA_BUILD_IN_PLAT		
	/* Send message to PTA task */
	OSAL_SEND_MESSAGE(PTA_SET_2_4_G_COEX, TASK_PTA, psMsg, psMsg->header.vapId);
#endif
}
/****************************************************************************
 **
 ** NAME:		UMI_MAN_2_4GHZ_COEX_CFM	
 **
 ** RETURN VALUES:	none
 **
 ** DESCRIPTION:	sets 2.4GHz co-existance configuration 
 **
 ****************************************************************************/
static void UMI_MAN_2_4GHZ_COEX_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_2_4GHZ_COEX_REQ_CFM);
	vUMI_SendToMC(MC_MAN_2_4GHZ_COEX_CFM, psMsg);
}
/****************************************************************************
 **
 ** NAME:		UMI_MAN_CPU_LOAD_REQ	
 **
 ** RETURN VALUES:	none
 **
 ** DESCRIPTION:	
 **
 ****************************************************************************/
static void UMI_MAN_CPU_LOAD_REQ(K_MSG *pMsg)
{
	ILOG0_V("[CPU LOAD] UMI_MAN_CPU_LOAD_REQ");
	/* Add Driver request to stats */
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_CPU_LOAD_REQ_CFM);
	/* Send message to statistics manager */
	OSAL_SEND_MESSAGE(STATISTICS_MANAGER_CPU_LOAD_REQ, TASK_STATISTICS_MANAGER, pMsg, pMsg->header.vapId);
}

/****************************************************************************
 **
 ** NAME:		UMI_MAN_CPU_LOAD_CFM	
 **
 ** RETURN VALUES:	none
 **
 ** DESCRIPTION:	 
 **
 ****************************************************************************/
static void UMI_MAN_CPU_LOAD_CFM(K_MSG *pMsg)
{
	ILOG0_V("[CPU LOAD] UMI_MAN_CPU_LOAD_CFM");
	/* Add Driver request to stats */
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_CPU_LOAD_REQ_CFM);
	/* Send confirmation to Driver */
	vUMI_SendToMC(MC_MAN_CPU_LOAD_CFM, pMsg);
}



/****************************************************************************
**
** NAME:      vUMI_ERROR_FUNC     
**
** RETURN VALUES:  none
**
** DESCRIPTION:   Catch error in host IF msgs 
**
****************************************************************************/
static void vUMI_ERROR_FUNC(K_MSG* psMsg)
{
	UNUSED_PARAM(psMsg);	
	// This MSG shouldn't have been sent in this configuration of AP/STA.
	ASSERT(0);
}



/*IPC test */
void UMI_IPC_TEST(K_MSG *pMsg)
{
	UNUSED_PARAM(pMsg);	
	SERIAL_TRACE("ipc test - ended suecssfuly", 0, 0, 0);
	
}
/*IPC test */

#ifdef RXH_MAILBOX_TEST

/*RxH Mailbox test */
void UMI_RXH_MAILBOX_TEST(K_MSG *pMsg)
{
	
	SERIAL_TRACE("Rx Handler test - ended successfully", 0, 0, 0);
	
}
/*RxH Mailbox test */
#endif // RXH_MAILBOX_TEST
/****************************************************************************
**
** NAME:       UMI_SET_HDK_ANT_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_ANT_CONFIG_REQ(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_ANT_CFG_REQ_CFM);

	OSAL_SEND_MESSAGE(HDK_CDB_MAN_SET_ANT_CONFIG_REQ, TASK_HDK_CDB_MANAGER, psMsg, psMsg->header.vapId);
}
/****************************************************************************
**
** NAME:       UMI_SET_HDK_ANT_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_SET_ANT_CONFIG_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_ANT_CFG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_HDK_ANT_CONFIG_CFM, psMsg);
}
/****************************************************************************
**
** NAME:       UMI_SET_HDK_ANT_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/
static void UMI_PREPARE_ANT_CONFIG_REQ(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_PREPARE_ANT_CFG_REQ_CFM);

	OSAL_SEND_MESSAGE(HDK_CDB_MAN_PREPARE_ANT_CONFIG_REQ, TASK_HDK_CDB_MANAGER, psMsg, psMsg->header.vapId);
}
/****************************************************************************
**
** NAME:       UMI_SET_HDK_ANT_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    Return status to host
**
****************************************************************************/

static void UMI_PREPARE_ANT_CONFIG_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_PREPARE_ANT_CFG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_HDK_PREPARE_ANT_CONFIG_CHANGE_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_PROTECTION_RATE_CONFIG_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_PROTECTION_RATE_CONFIG_REQ(K_MSG * psMsg)
{
	UMI_Protection_Rate_Config_t* param = (UMI_Protection_Rate_Config_t*)pK_MSG_DATA(psMsg);
	param->Status = UMI_OK;
	
	if (param->getSetOperation == API_SET_OPERATION)
	{
		VALIDATE_PARAM(param->cutoffPoint, CUT_OFF_POINT_MIN, CUT_OFF_POINT_MAX, param->Status);
	}
	
	if(param->Status == UMI_OK)
	{
		UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_PROTECTION_RATE_CONFIG_REQ_CFM);
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_RTS_RATE_CONFIG, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
	}
	else
	{
		vUMI_SendToMC(MC_MAN_RTS_RATE_SET_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_PROTECTION_RATE_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_PROTECTION_RATE_CONFIG_CFM(K_MSG * psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_PROTECTION_RATE_CONFIG_REQ_CFM);
	vUMI_SendToMC(MC_MAN_RTS_RATE_SET_CFM, psMsg);
}

void UMI_SetPsdProgmodelShramAddress(void)
{
	K_MSG* psdPMShramAddressMsg;
	PsdProgmodelShramAddressIndMsg_t* params;
	psdPMShramAddressMsg = OSAL_GET_MESSAGE(sizeof(PsdProgmodelShramAddressIndMsg_t));
	params = (PsdProgmodelShramAddressIndMsg_t*)pK_MSG_DATA(psdPMShramAddressMsg);
	params->psdProgmodelSramAdd = p32PsdProgmodelShramAddress;

	OSAL_SEND_MESSAGE(HDK_CDB_MAN_SET_PSD_PM_ADDRESS_REQ, TASK_HDK_CDB_MANAGER, psdPMShramAddressMsg, VAP_ID_DO_NOT_CARE);
}
/****************************************************************************
**
** NAME:       UMI_NFRP_CONFIG_REQ    
**
** RETURN VALUES:  none
**
**
****************************************************************************/
static void UMI_NFRP_CONFIG_REQ(K_MSG * psMsg)
{	
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_NFRP_CONFIG_REQ_CFM);
	UMI_NFRP_CONFIG_CFM(psMsg);
}

/****************************************************************************
**
** NAME:       UMI_NFRP_CONFIG_CFM    
**
** RETURN VALUES:  none
**
** comment:      
**
****************************************************************************/
static void UMI_NFRP_CONFIG_CFM(K_MSG * psMsg)
{
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_NFRP_CONFIG_REQ_CFM);
#ifdef NFRP_DEBUG
		ILOG0_V("[UMI_NFRP_CONFIG_CFM]");
#endif	
		vUMI_SendToMC(UM_MAN_NFRP_CONFIG_CFM, psMsg );
}



/****************************************************************************
**
** NAME:       UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_REQ(K_MSG *psMsg)
{
	UMI_DYNAMIC_MU_TYPE* pParams = NULL;
	pParams = (UMI_DYNAMIC_MU_TYPE *)pK_MSG_DATA(psMsg);
	SLOG0(0, 0, UMI_DYNAMIC_MU_TYPE, pParams);

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_HE_DYNAMIC_MU_TYPE_REQ_CFM);

	OSAL_SEND_MESSAGE(HE_GROUP_MANAGER_ENABLE_DYNAMIC_MU, TASK_HE_GROUP_MANAGER, psMsg, psMsg->header.vapId);



}

/****************************************************************************
**
** NAME:       UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_HE_DYNAMIC_MU_TYPE_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_HE_DYNAMIC_MU_TYPE_REQ_CFM);
	vUMI_SendToMC(UM_MAN_SET_DYNAMIC_MU_TYPE_CFM, psMsg);
}
/****************************************************************************
**
** NAME:       vUM_MAN_SET_HE_DYNAMIC_MU_FIXED_PARAMETERS_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_HE_MU_FIXED_PARAMETERS_REQ(K_MSG *psMsg)
{
	UMI_HE_MU_FIXED_PARAMTERS* pParams = NULL;
	pParams = (UMI_HE_MU_FIXED_PARAMTERS *)pK_MSG_DATA(psMsg);
	SLOG0(0, 0, UMI_HE_MU_FIXED_PARAMTERS, pParams);

	if (pParams->getSetOperation == 1)
	{
		pParams->muSequence = 0xFF;
		pParams->ltf_GI = 0xFF;
		pParams->codingType = 0xFF;
		pParams->heRate = 0xFF;
	}

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_HE_MU_FIXED_PARAMETERS_REQ_CFM);
	OSAL_SEND_MESSAGE(UMI_MC_SET_HE_MU_FIXED_PARAMETERS_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);


}
/****************************************************************************
**
** NAME:       vUM_MAN_SET_HE_DYNAMIC_MU_FIXED_PARAMETERS_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_HE_MU_FIXED_PARAMETERS_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_HE_MU_FIXED_PARAMETERS_REQ_CFM);
	vUMI_SendToMC(UM_MAN_SET_HE_MU_FIXED_PARAMETERS_CFM, psMsg);

}
/****************************************************************************
**
** NAME:       UMI_MAN_SET_HE_MU_DURATION_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_HE_MU_DURATION_REQ(K_MSG *psMsg)
{
	UMI_HE_MU_DURATION* pParams = NULL;
	pParams = (UMI_HE_MU_DURATION *)pK_MSG_DATA(psMsg);
	SLOG0(0, 0, UMI_HE_MU_DURATION, pParams);

	if (pParams->getSetOperation == 1)
	{
		pParams->PpduDuration = 0;
		pParams->TxopDuration = 0;
		pParams->TfLength = 0;
		pParams->NumberOfRepetitions = 0xFF;
	}


	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_HE_MU_DURATION_REQ_CFM);
	OSAL_SEND_MESSAGE(UMI_MC_SET_HE_MU_DURATION_CFM, TASK_UM_IF_TASK, psMsg, psMsg->header.vapId);

}
/****************************************************************************
**
** NAME:       vUM_MAN_SET_HE_DYNAMIC_MU_FIXED_PARAMETERS_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_HE_MU_DURATION_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_HE_MU_DURATION_REQ_CFM);
	vUMI_SendToMC(UM_MAN_SET_HE_MU_DURATION_CFM, psMsg);
}
/****************************************************************************
**
** NAME:       UMI_MAN_GET_TWT_PARAMS_REQ    
**
** RETURN VALUES:  
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_GET_TWT_PARAMS_REQ(K_MSG *psMsg)
{
	UMI_GET_TWT_PARAMS* pParams = NULL;
	twtStaParams_t twtParams;
	StaId staIdx;
	
	pParams = (UMI_GET_TWT_PARAMS *)pK_MSG_DATA(psMsg);
	staIdx = pParams->staId;
		
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_TWT_PARAMS_REQ_CFM);
	memset(pParams, 0, sizeof(UMI_GET_TWT_PARAMS));
	TwtManager_TwtGetStaParameters(&twtParams, staIdx);
	
	switch(twtParams.agreementType)
	{	
		case(TWT_AGREEMENT_TYPE_NONE):
			break;
		case(TWT_AGREEMENT_TYPE_INDIVIDUAL):

			pParams->isImplicit = twtParams.operation.isImplicit;
			pParams->isAnnounced = twtParams.operation.isAnnounced;
			pParams->isTriggerEnabled = twtParams.operation.isTriggerEnabled;
			pParams->agreementType = twtParams.agreementType;

			pParams->individualWakeTime = twtParams.agreement.individual.wakeTime;
			pParams->individualWakeInterval = twtParams.agreement.individual.wakeInterval;
			pParams->individualMinWakeDuration = twtParams.agreement.individual.minWakeDuration;
			pParams->individualChannel = twtParams.agreement.individual.channel;
			break;
		case(TWT_AGREEMENT_TYPE_BROADCAST):		// broadcast is not supported
			
			pParams->isImplicit = twtParams.operation.isImplicit;
			pParams->isAnnounced = twtParams.operation.isAnnounced;
			pParams->isTriggerEnabled = twtParams.operation.isTriggerEnabled;
			pParams->agreementType = twtParams.agreementType;

			pParams->BroadcastTargetBeacon = (uint8)NULL;
			pParams->BroadcastListenInterval = (uint8)NULL;
			break;
	}
	SLOG0(0, 0, UMI_GET_TWT_PARAMS, pParams);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_TWT_PARAMS_REQ_CFM);
	vUMI_SendToMC(UM_MAN_GET_TWT_PARAMS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_MAN_GET_AX_DEFAULT_PARAMS_REQ    
**
** RETURN VALUES:  
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_GET_AX_DEFAULT_PARAMS_REQ(K_MSG *psMsg)
{
	UMI_GET_TWT_PARAMS* pParams = NULL;
	pParams = (UMI_GET_TWT_PARAMS *)pK_MSG_DATA(psMsg);
	twtStaParams_t twtParams;
	memset(pParams, 0, sizeof(UMI_GET_TWT_PARAMS));

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_GET_AX_DEFAULT_PARAMS_REQ_CFM);
	TwtManager_TwtGetDefaultParameters(&twtParams);
	//default parametters
	pParams->isImplicit = twtParams.operation.isImplicit;
	pParams->isTriggerEnabled = twtParams.operation.isTriggerEnabled;
	pParams->agreementType = twtParams.agreementType;

	SLOG0(0, 0, UMI_GET_TWT_PARAMS, pParams);
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_GET_AX_DEFAULT_PARAMS_REQ_CFM);
	vUMI_SendToMC(UM_MAN_GET_AX_DEFAULT_PARAMS_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UM_MAN_SET_ETSI_PPDU_DURATION_LIMITS_REQ    
**
** RETURN VALUES:  
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_ETSI_PPDU_DURATION_LIMITS_REQ(K_MSG * psMsg)
{
	UMI_SET_ETSI_PPDU_DURATION_LIMITS_REQ_PARAMS	*setEtsi = NULL;
	K_MSG											*pacMngMsg = NULL;
	PacMngPreAggEtsiPpduDurationLimitsReq_t			*params = NULL;

	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_ETSI_PPDU_DURATION_LIMITS_REQ);

	setEtsi = (UMI_SET_ETSI_PPDU_DURATION_LIMITS_REQ_PARAMS*) pK_MSG_DATA(psMsg);
	pacMngMsg = OSAL_GET_MESSAGE(sizeof(PacMngPreAggEtsiPpduDurationLimitsReq_t));
	params = (PacMngPreAggEtsiPpduDurationLimitsReq_t*)pK_MSG_DATA(pacMngMsg);
	params->PreAggSetNonEtsiPpduDurationLimitsReq = setEtsi->setEtsiPpduDuration;
	OSAL_SEND_MESSAGE(PAC_MANAGER_PRE_AGG_ETSI_PPDU_DURATION_LIMIT_REQ, TASK_PAC_MANAGER, pacMngMsg, psMsg->header.vapId);
	
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_ETSI_PPDU_DURATION_LIMITS_REQ);
	vUMI_SendToMC(UM_MAN_SET_ETSI_PPDU_DURATION_LIMITS_CFM, psMsg);
}


/****************************************************************************
**
** NAME:       UMI_MAN_SET_RTS_THRESHOLD_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_RTS_THRESHOLD_REQ(K_MSG *psMsg)
{
	UMI_SET_RTS_THRESHOLD* pSetRtsThreshold = (UMI_SET_RTS_THRESHOLD*)psMsg->abData;
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_RTS_THRESHOLD_REQ_CFM);
	VALIDATE_PARAM(pSetRtsThreshold->isDisabled, RTS_THRESHOLD_PPDU_SIZE_OFF, RTS_THRESHOLD_PPDU_SIZE_ON, pSetRtsThreshold->Status);

	pSetRtsThreshold->vapId = psMsg->header.vapId;
	
	if(UMI_OK == pSetRtsThreshold->Status)
	{
		OSAL_SEND_MESSAGE(LINK_ADAPTATION_SET_RTS_THRESHOLD_REQ, TASK_LINK_ADAPTATION, psMsg, psMsg->header.vapId);
	}
	else // UMI_BAD_PARAMETER
	{
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RTS_THRESHOLD_REQ_CFM);
		vUMI_SendToMC(MC_MAN_SET_RTS_THRESHOLD_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_MAN_SET_RTS_THRESHOLD_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_RTS_THRESHOLD_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RTS_THRESHOLD_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_RTS_THRESHOLD_CFM, psMsg);
}

/****************************************************************************
**
** NAME:       UMI_MAN_SET_RETRY_LIMIT_REQ    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_RETRY_LIMIT_REQ(K_MSG *psMsg)
{
	UMI_SET_RETRY_LIMIT* pSetRetryLimit = (UMI_SET_RETRY_LIMIT*)psMsg->abData;
	UMSTAT_INC_MAN_REQ_ARR(UMSTAT_MAN_SET_RETRY_LIMIT_REQ_CFM);
	VALIDATE_PARAM(pSetRetryLimit->txRetryLimit, MIN_RETRY_LIMIT, MAX_RETRY_LIMIT, pSetRetryLimit->Status);
	if(UMI_OK == pSetRetryLimit->Status)
	{
		OSAL_SEND_MESSAGE(PAC_MANAGER_TX_PD_ACC_SET_RETRY_LIMIT_REQ, TASK_PAC_MANAGER, psMsg, psMsg->header.vapId);
	}
	else // UMI_BAD_PARAMETER
	{
		UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RETRY_LIMIT_REQ_CFM);
		vUMI_SendToMC(MC_MAN_SET_RETRY_LIMIT_CFM, psMsg);
	}
}

/****************************************************************************
**
** NAME:       UMI_MAN_SET_RETRY_LIMIT_CFM    
**
** RETURN VALUES:  none
**
** DESCRIPTION:    
**
****************************************************************************/
static void UMI_MAN_SET_RETRY_LIMIT_CFM(K_MSG *psMsg)
{
	UMSTAT_INC_MAN_CFM_ARR(UMSTAT_MAN_SET_RETRY_LIMIT_REQ_CFM);
	vUMI_SendToMC(MC_MAN_SET_RETRY_LIMIT_CFM, psMsg);
}


