#ifndef ALPHA_FILTER_H_
#define ALPHA_FILTER_H_

/***************************************************************************/
/***                       	Include Files                              							  ***/
/***************************************************************************/
#include "System_GlobalDefinitions.h"

/***************************************************************************/
/* 					Constants                                                  				     */
/***************************************************************************/

#define TSF_RESOLUTION_512_USEC_SHIFT 9	//Resolution of 512 usec
#define TSF_RESOLUTION_SHIFT_ALPHA_FILTER TSF_RESOLUTION_512_USEC_SHIFT 
#define TSF_RANGE_ALPHA_FILTER		(1 << 14 ) // the actual range is 2^13, because only half of the range is in use, range of 8192 (2^13) => 8192*0.5msec = 4096msec ~4sec
#define TSF_INVALID   MAX_UINT16

#define BETA_CALC_NUMBER_OF_FRAC_BITS 11
#define LN2_INV_11BIT_FRACTION 0xB8B
#define BETA_CALC_INTERMEDIATE_MULTIPLY_FACTOR_SHIFT 6
#define FILTER_RESULT_NUMBER_OF_FRAC_BITS 11
#define DIFF_TSF_NUMBER_OF_FRC_BITS 11
#define AVERAGE_DT_INIT_VAL 10 //5msec
#define CONST_ALPHA_FILTER_FOR_DT_AVERAGE 2 //alpha = 1/4
#define DT_AVERAGE_FACTOR 3	//resolution of 1/8 (3 binaries digits after point)

/*value defines the average value acccording to this equation, average = ALPHA_FILTER_RESOLUTION<<AVERAGE_PACKETS_TIME_SHIFT,
	for example if shift == 1, then average time = 512E-6 *2 = 1msec*/
//#define AVERAGE_PACKETS_TIME_SHIFT 1  
/***************************************************************************/
/* 					Macros  definitions  						                  	     */
/***************************************************************************/

#define CALC_TSF_FOR_ALPHA_FILTER( TSFlow )	( ( TSFlow >> TSF_RESOLUTION_SHIFT_ALPHA_FILTER ) & (TSF_RANGE_ALPHA_FILTER-1) )
#define NORMELIZE_ALPHA_FILTER_RESULT(FilterRestult) (FilterRestult >> FILTER_RESULT_NUMBER_OF_FRAC_BITS)

/***************************************************************************/
/***                     	Structure declarations                       						     */
/***************************************************************************/
typedef struct 
{
	uint32 filterResult;
	uint16 alpha;
	uint16 lastPacketTsf;
}AdaptiveAlphaFilterParams_t;

/***************************************************************************/
/*  			               Function prototypes                                					     */
/***************************************************************************/
void AlphaFilter_Init(AdaptiveAlphaFilterParams_t* pFilterParams, uint16* dTAverage);
void AlphaFilter_updateFilter(AdaptiveAlphaFilterParams_t* pFilterParams, uint8 filterInput, int16 lnBeta, uint8 constAlphaForDtAverage,uint16* dTAverage, bool updateDtAverage) ;
bool AlphaFilter_isFilterResultValid (AdaptiveAlphaFilterParams_t* pFilterParams, uint32 maxValidTsfDiff);
uint8 AlphaFilter_GetFilterResult(AdaptiveAlphaFilterParams_t* pFilterParams);

#endif //ALPHA_FILTER_H_
