/***********************************************************************************
 File:			CalendarWheel_Api.h
 Module:		Calendar wheel 
 Purpose: 		To create a module which supply scheduling events ability
 Description:   This file is the API of the Calendar wheel module 
				which is responsible of organizing events to be scheduled 
				each module that use calendar wheel should create its own istance
************************************************************************************/
#ifndef CALENDAR_WHEEL_API_H_
#define CALENDAR_WHEEL_API_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define CALENDAR_WHEEL_CALENDAR_INDEX_MASK (0x8000)
#define CALENDAR_WHEEL_NULL_ENTRY_INDEX (0xFFFF)
#define CALENDAR_WHEEL_SLOT_SIZE (sizeof(uint16))

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
/* add offset to slot index so that during remove of single entry from linked list of slot it will be easy to identify slot index from real entry wheel index*/

#define CALENDAR_WHEEL_CONVERT_SLOT_INDEX_INTO_CALENDAR_INDEX(x)(x | CALENDAR_WHEEL_CALENDAR_INDEX_MASK) 
#define CALENDAR_WHEEL_CONVERT_CALENDAR_INDEX_INTO_SLOT_INDEX(x)(x & (~CALENDAR_WHEEL_CALENDAR_INDEX_MASK))

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef uint16 (*CalendarWheelDivFunc)(uint32 distanceFromBase);


typedef struct CalendarWheelEntry
{
	uint16 nextIndex;
	uint16 previousIndex;
}CalendarWheelEntry_t;


typedef struct CalendarWheelParameters
{
	uint16 *slots; // base address of slots array
	uint32 baseAddress; // address of begining of memory block of entries to calendar wheel
	
	uint16 currentSlot; // current index to slots array
	uint16 size; // number of slots in calendar wheel

	uint8  entrySize; // size of entry in calendar wheel
	uint8  reserved[3]; // padding - to make sure all entries of the same size

	CalendarWheelDivFunc divFunc; // division function based on size of specific entry
} CalendarWheelParameters_t;



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------
void CalendarWheel_Initialize(CalendarWheelParameters_t *calendarWheel, uint16 size, uint16 *slotsAddress, uint32 baseAddress, uint8 entrySize);
void CalendarWheel_AddEntry(CalendarWheelParameters_t *calendarWheel, CalendarWheelEntry_t *newEntry, uint16 timeToSchedule);
void CalendarWheel_RemoveEntry(CalendarWheelParameters_t *calendarWheel, CalendarWheelEntry_t *entry);
void CalendarWheel_RescheduleEntry(CalendarWheelParameters_t *calendarWheel, CalendarWheelEntry_t *entry, uint16 timeToSchedule);
uint16 CalendarWheel_TimerEvent(CalendarWheelParameters_t *calendarWheel);


#endif /* CALENDAR_WHEEL_API_H_ */

