/*******************************************************************************
*    
*   Source File:
*       MT_Math.h
*	
*	AUTHOR: Amir Hitron
*
*   Description:Driver to the Rfic 
*       
*   Copyright: 
*       (C) Metalink Ltd.
*       All rights are strictly reserved. Reproduction or divulgence in any 
*       form whatsoever is not permitted without written authority from the 
*       copyright owner. Issued by Metalink Transmission Devices Ltd in 
*       Israel - 11/94.
*   Revision History:
*
*******************************************************************************/
#ifndef MT_MATH_H
#define MT_MATH_H
/******************************************************************************/
/***						Include Files									***/
/******************************************************************************/

/******************************************************************************/
/***                        Constant Defines                                ***/
/******************************************************************************/
#define LOG_LUT_OFFSET 5
/******************************************************************************/
/***						Macros									***/
/******************************************************************************/

/* Calculate the average of two integers */
#define Avrg(a,b)	((a)+(b))>>1
#define DIVIDE_AND_ROUND(VALUE,DIV) (((VALUE) + ((DIV)>>1))/(DIV))

/******************************************************************************/
/***						Public Function Declaration						***/
/*****************************************************************************/
extern int32 Abs(int32 x) ;
extern int64 Abs64(int64 x);
extern int16 MATH_10Log10(uint32 x);
extern int16 MATH_10Log10Res(uint32 x, uint8 n);
int32 MATH_CalcAbsoluteValue(int32 x);
uint32 MATH_Sqrt(uint32 x);

/*************************************************************************************
Name: void MATH_LongDivision(int32 inNumeratorInt,int32 inDenominatorInt,int32 inFractionBits,int32 *outResult_p)

Input:
	1. inNumeratorInt	: the numerator  (int32)
	2. inDenominatorInt	: the denominator  (int32)
	3. inFractionBits	: the number of bits used after the decimal point for the result (int32)
	
Output: 
	1. outResult_p		: result from the division (type - int32)


Description:	This function returns an integer (int32) fraction-
				the division between 2 integer (int32) numbers. 
				The calculation uses extension to 64 bits of the numerator and division 
				by the denominator
 
*************************************************************************************/
void MATH_LongDivision(int32 inNumeratorInt,int32 inDenominatorInt,int32 inFractionBits,int32 *outResult_p);
void MATH_LongDivision_DenomUint(int32 inNumeratorInt,uint32 inDenominatorInt,int32 inFractionBits,int32 *outResult_p);
//************************************
// Method:    MATH_PowerRes
// Purpose:   Calculate x^a, with n resolution bits
// Parameters: int16 x, int16 a, uint8 n
// Returns:   int16 - n resolution bits
//************************************
int16 MATH_PowerRes(int32 x, int16 a, uint8 n);

//************************************
// Method:    MATH_ArctanRes
// Purpose:   Calculate arctan(x) by third order Taylor series expansion
// Parameters: int16 x (n resolution bit), uint8 n 
// Returns:   int16 (n resolution bit)
//************************************
int16 MATH_ArctanRes(int16 x, uint8 n);

//************************************
// Method:    MATH_Sin
// Purpose:   Calculate sin(x) by Taylor approximation
// Parameters: int16 x
// Returns:   int16
//************************************
int16 MATH_Sin(int16 x);

//************************************
// Method:    MATH_Cos
// Purpose:   Calculate cos(x) by Taylor approximation
// Parameters: int16 x (n resolution bit), uint8 n
// Returns:   int16 (n resolution bit)
//************************************
int16 MATH_Cos(int16 x, uint8 n);
int64 MATH_PowerRes_64(int64 x, int16 a, uint8 n);
int32 MATH_ArctanRes_32(int32 x, uint8 n);
int32 MATH_Cos_64(int32 x, uint8 n);
uint64 MATH_Sqrt_64(uint64 x);


int32 cyclicMinusOperator(uint32 inputA, uint32 inputB, bool abs, uint32 range);


#endif//MT_MATH_H
