/************************************************************************************
*    
*    File:		  Utils_Api.h
*    Class/Module: 
*    Description:  A detailed description of the Module, its  purpose attributes and
*		 	  whatever information the user & maintainer might find valuable.
*
*    COPYRIGHT: 
*        (C) Lantiq Israel Ltd.
*        All rights are strictly reserved. Reproduction or divulgence in any   
* 	  form whatsoever is not permitted without written authority from the 
*        copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef UTILS_API_H
#define UTILS_API_H


#include "mhi_umi.h"
#include "OSAL_Api.h"
#include "DmaManager_Api.h"
#include "HwMemoryMap.h"

extern char _eend_of_ram[];

#define FIRST_VHT_MIMO_BF_INDEX		(0)
#define FIRST_HE_MIMO_BF_INDEX		(4)


#define SYSTEM_NUMBER_OF_MIPS_TICKS_IN_1uSec	(240) /*assuming CPU is running @ 240Mhz*/

#define IS_ADDRESS_IN_HOST_IF(addr)		((addr  == HOST_IF_COUNTERS_BASE_ADDR) ? TRUE : FALSE)
#define IS_ADDRESS_IN_RXCOUNTERS(addr)		((addr  == RX_PP_COUNTERS_BASE_ADDR) ? TRUE : FALSE)
#define IS_ADDRESS_IN_BAACOUNTERS(addr)	((addr  == BA_ANALYZER_COUNTER_BASE_ADDR) ? TRUE : FALSE)
#define IS_ADDRESS_IN_BSRCOUNTERS(addr)	((addr  == BSRC_CNT_MEM_BASE_ADDR) ? TRUE : FALSE)

#ifdef ENET_INC_ARCH_WAVE600D2
#define IS_ADDRESS_IN_HOST_IF_QOS(addr)		((addr  == HOST_IF_QOS_COUNTERS_BASE_ADDR) ? TRUE : FALSE)
#define IS_ADDRESS_IN_RX_COOR_COUNTERS(addr)		((addr  == RX_COORDINATOR_COUNTERS_BASE_ADDR) ? TRUE : FALSE)
#endif

#define CONVERT_USP_INDEX_TO_HE_MU_BF_INDEX(uspIndex)	(uspIndex + FIRST_HE_MIMO_BF_INDEX)	 
#define CONVERT_USP_INDEX_TO_VHT_MU_BF_INDEX(uspIndex)	(uspIndex + FIRST_VHT_MIMO_BF_INDEX)	 



#if defined (CPU_MIPS)
#define IRAM_BASE_ADDRESS				(0x80000000)
#define IS_ADDRESS_IN_IRAM(addr)		(((addr & 0xF0000000) == IRAM_BASE_ADDRESS) ? TRUE : FALSE)
#endif

#if defined (CPU_ARC)
// IRAM in Gen6 starts at address 0x0 and of size 1.5Mb
#define IS_ADDRESS_IN_IRAM(addr) 		(((addr) < CPU_IRAM_SIZE)  ? TRUE : FALSE)
#endif

#define IS_ADDRESS_IN_SHRAM(addr)		((((addr) >= (uint32)SHARED_RAM_BASE_ADDR) && ((addr) < ((uint32)SHARED_RAM_BASE_ADDR + SHARED_RAM_SIZE)))  ? TRUE : FALSE)
#define IS_ADDRESS_IN_TX_RECIPES_B1(addr)		((((addr) >= (uint32)B1_TX_RECIPES_BASE_ADDR) && ((addr) < ((uint32)B1_TX_RECIPES_BASE_ADDR + B1_TX_RECIPES_SIZE)))  ? TRUE : FALSE)


typedef enum 
{
	SOURCE_IRAM = 0,	
	SOURCE_SHRAM,
#ifdef ENET_INC_ARCH_WAVE600D2
	SOURCE_HOST_IF_QOS_COUNTERS,		
#endif
	SOURCE_HOST_IF_COUNTERS,		
#ifdef ENET_INC_ARCH_WAVE600D2
	SOURCE_RX_COORDINATOR_COUNTERS,
#endif
	SOURCE_RX_COUNTERS,
	SOURCE_BAACOUNTERS,
	SOURCE_BSRCOUNTERS,
} SourceType_e;


typedef enum TidBitmap
{
	TID_BITMAP_TID_0 			= 0x1,
	TID_BITMAP_TID_1 			= 0x2,
	TID_BITMAP_TID_2 			= 0x4,
	TID_BITMAP_TID_3 			= 0x8,
	TID_BITMAP_TID_4 			= 0x10,
	TID_BITMAP_TID_5 			= 0x20,
	TID_BITMAP_TID_6 			= 0x40,
	TID_BITMAP_TID_7 			= 0x80,
	TID_BITMAP_ALL_DATA_TIDS 	= 0xFF,
	TID_BITMAP_TID_8 			= 0x100,
	TID_BITMAP_TID_MGMT 		= TID_BITMAP_TID_8,
	TID_BITMAP_ALL_TIDS  		= 0x1FF,
} TidBitmap_e;


int32	Utils_FindFirstSet(uint32 num); 
uint32	Utils_CountLeadingZeros(uint32 num); 
uint32	Utils_CountTrailingZeros	(uint32 num); 
uint32 Utils_FindFirstSetAndClear(uint32 *bitmap);
uint32 Utils_FindLastSet(uint32 *bitmap, uint16 numOfBitsInBitmap);
uint32 Utils_FindLastSetAndClear(uint32 *bitmap, uint16 numOfBitsInBitmap);
uint16 Utils_CountTrailZeroBitmap(uint32* Bitmap,uint8 offset , uint8 BitmapSize);
void Utils_ZeroBitInBitmap(uint32* Bitmap,uint16 index);
void Utils_SetBitInBitmap(uint32* Bitmap,uint16 index);
uint16 Utils_RoundRobinBitmap(uint32* Bitmap,uint8 offset , uint8 BitmapSizeInBytes);
uint8 Utils_GetBitFromBitmap(uint32* Bitmap,uint16 index);
bool Utils_IsBitmapNotEmpty(uint32* Bitmap, uint16 numOfBitsInBitmap);
//void Utils_Shift32bitArrayRight(uint32  *s,uint32  *d, uint32 l, uint32 shift);
void Utils_Shift32bitArrayLeft(uint32  *s,uint32  *d, uint32 l, uint32 shift);
dmaDirection_e  Utils_determineSourceTypeAndDmaDirection (uint32 addr, dmaDirection_e *direction, SourceType_e *sourceType);
uint8 Utils_GetNumAntsFromMask(uint8 mask);
uint8 Utils_GetPrimaryChannel(uint8 low_chan_num, uint8 low_chan_num2, uint8 chan_width, uint8 primary_chan_idx);
uint32 orOperator64Bit(uint32* inputA, uint32* inputB, uint32* result);
uint32 notOperator64Bit(uint32* inputA, uint32* result);
uint8 Utils_CountNumOfOnes(uint32 num);



/*--------------------------------------------------------------------------
 * Macro:       ZERO        - Zero a variable (quickly)
 *    Given the name of a "C" variable,   zeroes it (sets all to zero).
 *--------------------------------------------------------------------------*/
#define MIN(x,y)		((x) < (y) ? (x) : (y))
#define MAX(x,y)		((x) > (y) ? (x) : (y))


#define ABS_DIFFERENCE(x,y) ((x > y) ? x-y : y-x)
#define ZERO(var)					memset(&(var), 0, sizeof(var))

// find a byte offset of a struct memeber (pre-compile)
#define OFFSETOF(type,id)	(((uint32)&(((type *)0)->id)))
//#define UNUSED_PARAM(var)   (var = var)

/* Macro to ensure round a value up to the next multiple of 4 */
/* for ensuring we have 4-byte alignment for the ARM.         */
#define ALIGN4(X)    ((X + 3) & ~0x03)

#define SWITCH_ENDIANESS_TYPE_SHORT(X)	((X >> 8) | (X<< 8))


#define SWITCH_ENDIANESS_TYPE_LONG(X)												\
			(((X>>24) & 0x000000ff) 				| 	/* move byte 3 to byte 0 */	\
		     ((X<<8)  & 0x00ff0000)					| 	/* move byte 1 to byte 2*/	\
		     ((X>>8)  & 0x0000ff00) 				| 	/*move byte 2 to byte 1*/	\
		     ((X<<24) & 0xff000000)) 					/* byte 0 to byte 3*/		\
			/*end SWITCH_ENDIANESS_TYPE_LONG*/

// alpha formula is ((1-aplha)*current + (alpha*prev))
// SHAPE_POWER(KOEF) is (1-aplha) or for e.g. 
// alpha is 1/8,then
// ((1/8)*current + prev*(1-1/8))
#define SHAPE_POWER(KOEF)                           ((1<<KOEF)-1) 
#define PHY_SHAPED_FORMULA(A,B,KOEF)	            ((A + ( B* (SHAPE_POWER(KOEF))))>>(KOEF))


#endif //UTILS_API_H

