#ifndef ABB_TB_DEFINES_H
#define ABB_TB_DEFINES_H

#define NR_OF_ANTENNAS 5
#define GPIO_PORT_WIDTH    512

// defines for fcsi access functions
#define MAX_PORT_COUNT NR_OF_ANTENNAS+1
#define MAX_PORT_MASK ((1<<MAX_PORT_COUNT)-1)

// DUT Ports
#define FCSI2_RST_N          15
#define FCSI2_FORCE_DEFAULT  16

// direct control signals
#define lcpll_pup_d2a			0
#define pd_clk_sc_d2a			1
#define op_freq_sel_sc_d2a		2
#define SC2FC_FC2SC			3
#define lcpll_div_d2a			4
#define spare_config_i_d2a		5
//					6
//					7
//					8
//					9
//					10
//					11
//					12
#define lcpll_resn_d2a			13

// gpio clock enable signals
#define ENABLE_CLK_IN			22
#define ENABLE_FSYS			23
#define ENABLE_BB_CLKIN			24

// gpio burst and dump signals
#define BB_CLKSRC			25
#define burst_resetn			27
#define burst_enable			40
#define burst_on_rx			41
#define burst_on_tx			42
#define burst_on_ssi			46
#define dump_tx				43
#define dump_ssi			44
#define dump_rx				45

// assertion signals
#define ASSERT_clk_sc_a2d_640m			28
#define ASSERT_clk_sc_a2d_320m			29
#define ASSERT_clk_sc_a2d_160m			30
#define ASSERT_clk_sc_a2d_80m			31
#define ASSERT_clk_sc_a2d_480m			32
#define ASSERT_ant2_ibias_iptat			14
#define ASSERT_ant2_ldoa_ldod			33
#define ASSERT_ant2_clk2g56_dac_p_o_2g56 	15
#define ASSERT_ant2_clk2g56_adc_p_o_2g56 	16
#define ASSERT_ant2_strb160m_adc_o_160m 	17
#define ASSERT_ant2_strb160m_dac_o_160m 	18
#define ASSERT_ant2_clk640m_ssi_o_640m 		19
#define ASSERT_clk_o_se_s_160m 			20
#define ASSERT_clk_o_p_s_2g56 			21
#define ASSERT_lcpll_lock_a2d			26

// general purpose flags
#define FLAG_gp_1				47

// FCSI
#define FCSI2_RST_N_0               250
#define FCSI2_RST_N_1               251
#define FCSI2_RST_N_2               252
#define FCSI2_RST_N_3               253
#define FCSI2_RST_N_C               254

#define FCSI2_FORCE_DEFAULT_0       260
#define FCSI2_FORCE_DEFAULT_1       261
#define FCSI2_FORCE_DEFAULT_2       262
#define FCSI2_FORCE_DEFAULT_3       263
#define FCSI2_FORCE_DEFAULT_C       264

#endif
