function ABB_DIR_CTRL_WRITES(param1,param2,param3)
% history
% 19.3.2018 adjusted secure writes
%  9.4.2018 added debug_disp function ("DISABLE_DEBUGS")

X = sprintf('param:  0x%04x  width: 0x%04x data: 0x%04x', param1, param2, param3);
debug_disp(X);

regAddress = 0;
bitPosition = 0;
bitInv = 0;
bitMask = 0;

sec_write = 0;

 % abb_tb_defines.h
 %
 % #define op_freq_sel_sc_d2a	2 (len=2)
 % #define spare_config_i_d2a	5 (len=8)

switch(param1)
    case 2 % op_freq_sel_sc_d2a
        regAddress = 'h00220040';    %%%
        bitPosition = 2;            %%%
        bitLength =  2;
        sec_write = 1;              %%%
        dir_ctrl_name = 'op_freq_sel_sc_d2a';
        
        %%% TODO
        data = bitand(hex2dec('B'),param3);
        data = bitset(data,3,bitget(param3,5));
        data = bitset(data,5,bitget(param3,3));
        param3 = data;

    case 5 % spare_config_i_d2a
        regAddress = 'h00220044';    %%%
        bitPosition = 0;            %%%
        bitLength =  8;
        sec_write = 1;              %%%
        dir_ctrl_name = 'spare_config_i_d2a';       

    otherwise
        error('spi_writeS : dir_cntrl_name not found')
end   

bitMask = power(2,bitPosition+bitLength)-power(2,bitPosition);
bitData =param3; % bitshift(param3,bitPosition);
 
        if sec_write == 1
            debug_disp([dir_ctrl_name ' r:' regAddress ' m:' dec2hex(bitMask) ' d:' dec2hex(bitData) ' - secure' ]);
            %secure_write(regAddress,bitData,bitMask);
            bbswrite(sprintf('@secureWrite(0,%s,h%x,%x)',regAddress,bitMask,bitData))
        else
            debug_disp([dir_ctrl_name ' r:' regAddress ' m:' dec2hex(bitMask) ' d:' dec2hex(bitData)])
            %hyp_write(regAddress,bitData,bitMask) ;
            bbswrite(sprintf('@hypwrite(0,%s,h%x,%x)',regAddress,bitMask,bitData)) ;

        end
        
end