function ABB_DIR_CTRL_WRITE(param1,param2)
% history
% 19.3.2018 adjusted secure writes
%  9.4.2018 added debug_disp function ("DISABLE_DEBUGS")

X = sprintf('param:  0x%04x  data: 0x%04x ', param1, param2);
debug_disp(X);

regAddress = 0;
bitPosition = 0;
bitInv = 0;
bitMask = 0;

sec_write = 0;

% abb_tb_defines.h
%
% #define lcpll_pup_d2a			0
% #define pd_clk_sc_d2a			1
% #define lcpll_div_d2a			4
% #define lcpll_resn_d2a		13
%
% #define FCSI2_RST_N_0            250
% #define FCSI2_RST_N_1            251
% #define FCSI2_RST_N_2            252
% #define FCSI2_RST_N_3            253
% #define FCSI2_RST_N_C            254
% 
% #define FCSI2_FORCE_DEFAULT_0    260
% #define FCSI2_FORCE_DEFAULT_1    261
% #define FCSI2_FORCE_DEFAULT_2    262
% #define FCSI2_FORCE_DEFAULT_3    263
% #define FCSI2_FORCE_DEFAULT_C    264

switch(param1)
    case 0    %lcpll_pup_d2a
        regAddress = 'h00000048';    %%%
        bitPosition = 7;            %%%
        sec_write = 1;              %%%
        dir_ctrl_name = 'lcpll_pup_d2a';
        
    case 1    %pd_clk_sc_d2a
        regAddress = 'h00000044';    %%%
        bitPosition = 1;            %%%
        sec_write = 1;              %%%
        dir_ctrl_name = 'pd_clk_sc_d2a';   
        
   case 4    %lcpll_div_d2a
        regAddress = '0';    %%%
        bitPosition = 0;            %%%
        sec_write = 0;              %%%
        dir_ctrl_name = 'lcpll_div_d2a';   
       
   case 13    %lcpll_resn_d2a
        regAddress = 'h00000048';    %%%
        bitPosition = 8;            %%%
        sec_write = 1;              %%%
        dir_ctrl_name = 'lcpll_resn_d2a';          

   case 250    %FCSI2_RST_N_0
        regAddress = 'hb6012c';    %%%
        bitPosition = 0;            %%%
        sec_write = 0;              %%%
        dir_ctrl_name = 'FCSI2_RST_N_0';                 
        
   case 251    %FCSI2_RST_N_1
        regAddress = 'hb6412c';    %%%
        bitPosition = 0;            %%%
        sec_write = 0;              %%%
        dir_ctrl_name = 'FCSI2_RST_N_1';       
        
   case 252    %FCSI2_RST_N_2
        regAddress = 'hb6812c';    %%% 
        bitPosition = 0;            %%% 
        sec_write = 0;              %%% 
        dir_ctrl_name = 'FCSI2_RST_N_2';                 
        
   case 253    %FCSI2_RST_N_3
        regAddress = 'hb6c12c';    %%% 
        bitPosition = 0;            %%% 
        sec_write = 0;              %%% 
        dir_ctrl_name = 'FCSI2_RST_N_3';       

   case 254    %FCSI2_RST_N_C
        regAddress = 'h238170';    %%% 
        bitPosition = 0;            %%% 
        sec_write =0;              %%% 
        dir_ctrl_name = 'FCSI2_RST_N_C';       
        
   case 260    %FCSI2_FORCE_DEFAULT_0
        regAddress = '00000048';    %%% 
        bitPosition = 9;            %%% 
        sec_write = 1;              %%% 
        dir_ctrl_name = 'FCSI2_FORCE_DEFAULT_0';               

    case 261    %FCSI2_FORCE_DEFAULT_1
        regAddress = '00000048';    %%% 
        bitPosition = 9;            %%% 
        sec_write = 1;              %%% 
        dir_ctrl_name = 'FCSI2_FORCE_DEFAULT_1';             
        
     case 262    %FCSI2_FORCE_DEFAULT_2
        regAddress = '00000048';    %%% 
        bitPosition = 9;            %%% 
        sec_write = 1;              %%% 
        dir_ctrl_name = 'FCSI2_FORCE_DEFAULT_2';              

     case 263    %FCSI2_FORCE_DEFAULT_3
        regAddress = '00000048';    %%% 
        bitPosition = 9;            %%% 
        sec_write = 1;              %%% 
        dir_ctrl_name = 'FCSI2_FORCE_DEFAULT_3';        
        
     case 264    %FCSI2_FORCE_DEFAULT_C
        regAddress = '00000048';    %%% 
        bitPosition = 9;            %%% 
        sec_write = 1;              %%% 
        dir_ctrl_name = 'FCSI2_FORCE_DEFAULT_C';        
        
    otherwise
        error('ABB_DIR_CTRL_WRITE : dir_cntrl_name not found')
end   

bitMask = bitshift(1,bitPosition);
bitData = param2; %bitshift(param2,bitPosition);

        if sec_write == 1
            %adds 0x00180000 automatically
            debug_disp([dir_ctrl_name ' r:' regAddress ' m:' dec2hex(bitMask) ' d:' dec2hex(bitData) ' - secure' ]);
            sprintf('@secure_write(0,%s,h%x,%x)',regAddress,bitMask,bitData);
            bbswrite(sprintf('@securewrite(0,%s,h%x,%x)',regAddress,bitMask,bitData))
        else
            debug_disp([dir_ctrl_name ' r:' regAddress ' m:' dec2hex(bitMask) ' d:' dec2hex(bitData)])
            bbswrite(sprintf('@hypwrite(0,%s,h%x,%x)',regAddress,bitMask,bitData)) ;
        end
        
end


