% Testbench
addpath('..\api_mex')

% Test all API functions

%API c-code debugs
%ABB_API('enable_debugs');
ABB_API('disable_debugs');

%matlab script debugs (FCSI & DIRECT)
global DISABLE_DEBUGS
%DISABLE_DEBUGS=0
DISABLE_DEBUGS=1

ABB_API('version');

fuse = zeros(1,19);
dsmsel = 0; 
count_calc = 445;   % nominal =471
rctune = 12;        % default = 14
ant_mask =  1;      % 1 2 4 8
abb_mode = 80;      % 80 160 20 0
trim = 3;           % generic trim value
qtrim = 0;          % 0 1 2
vref =0;            % default
iptat = 8;          % default
ibias = 0;          % default
polarity=0;
ssion=1;
txon=1;
rxon=1;

ABB_API('abb_api_version');

%// ---------------------------------------------------------
%// Section: DRIVER API Functions
%// ---------------------------------------------------------

ABB_API('abb_central_fusing',fuse);
ABB_API('abb_central_init_pll');
ABB_API('abb_central_init_clkd');

%// ---------------------------------------------------------
%// Section: FW API Functions
%// ---------------------------------------------------------

ABB_API('abb_fcsirf',1,0,0);

%dsmsel=0
disp(ABB_API('abb_rcmeas',0));
%count_calc=475
ABB_API('abb_adctune',445);
disp(ABB_API('abb_rx_rctune',fuse));
ABB_API('abb_antenna_init',ant_mask);
ABB_API('abb_antenna_fusing',ant_mask, fuse);
ABB_API('abb_antenna_rx_calibration',ant_mask);
%abb_mode=80/160/20/0
ABB_API('abb_antenna_config',ant_mask, 80, rctune, qtrim);
ABB_API('abb_antenna_pd',ant_mask);


%// ---------------------------------------------------------
%// Section: LL API Functions
%// ---------------------------------------------------------

ABB_API('abb_api_fcsiwrite_softisolation_central');
display(ABB_API('abb_api_fcsiread_softisolation_central'));

ABB_API('abb_api_fcsiwrite_softisolation_antenna', ant_mask);
display(ABB_API('abb_api_fcsiread_softisolation_antenna', ant_mask));

%//central fsys
ABB_API('abb_api_central_trim_ldo0v95fsys',trim);


%//central pll
ABB_API('abb_api_init_central_pll_enable');
ABB_API('abb_api_init_central_pll_bypass');
ABB_API('abb_api_init_central_pll_enable_fcsicontrol');
ABB_API('abb_api_central_trim_ldo0v95ref',trim);
ABB_API('abb_api_central_trim_ldo0v95post',trim);
ABB_API('abb_api_central_trim_vreg1v8hv',trim);


%//central bias
ABB_API('abb_api_central_trim_bias',vref,  iptat,  ibias);

%//central clkd
ABB_API('abb_api_init_central_pup_clkd');
ABB_API('abb_api_init_central_pd_clkd');
ABB_API('abb_api_central_trim_ldo0v95clkd', trim);


%//central fcsi
disp(ABB_API('abb_api_read_central_version'));
disp(ABB_API('abb_api_read_lcpll_lock'));
disp(ABB_API('abb_api_read_lcpll_prelock'));


%//central rcmeas
ABB_API('abb_api_rcmeas_start', polarity,  dsmsel);
ABB_API('abb_api_rcmeas_default');
disp(ABB_API('abb_api_rcmeas_running'));
disp(ABB_API('abb_api_rcmeas_finished'));
disp(ABB_API('abb_api_read_rcmeas'));


%//antenna
ABB_API('abb_api_init_ant', ant_mask);
ABB_API('abb_api_ant_trim_daclb', ant_mask,  trim);
ABB_API('abb_api_ant_trim_ldo0v95a',ant_mask,  trim);
ABB_API('abb_api_ant_trim_ldo0v95d',ant_mask,  trim);
disp(ABB_API('abb_api_read_antenna_version',ant_mask));
ABB_API('abb_api_pd_ant',ant_mask);


%//tx
ABB_API('abb_api_start_tx',ant_mask);
ABB_API('abb_api_start_tx_lp',ant_mask);
ABB_API('abb_api_standby_tx',ant_mask);


%//rx
ABB_API('abb_api_trim_rx_rctune',ant_mask,  rctune);
disp(ABB_API('abb_api_read_rx_qt',ant_mask));
disp(ABB_API('abb_api_read_rx_qtcaldone',ant_mask));

ABB_API('abb_api_set_rx_rctune_qtrim',ant_mask,  rctune,  qtrim);
ABB_API('abb_api_start_rx_11ax',ant_mask,  rctune,  qtrim);
ABB_API('abb_api_start_rx_ssb',ant_mask,  rctune,  qtrim);
ABB_API('abb_api_start_rx_lp',ant_mask,  rctune,  qtrim);
ABB_API('abb_api_start_rx_loopback',ant_mask,  rctune,  qtrim);
ABB_API('abb_api_start_rx_lfsr',ant_mask);
ABB_API('abb_api_start_rx_ts_lfsr',ant_mask);

ABB_API('abb_api_standby_rx',ant_mask,  rctune,  qtrim);


%//ssi
ABB_API('abb_api_start_ssi',ant_mask);
ABB_API('abb_api_start_ssi_lfsr',ant_mask);
ABB_API('abb_api_standby_ssi',ant_mask);
disp(ABB_API('abb_api_read_ssi_cal_comp',ant_mask));
ABB_API('abb_api_ssi_enable_exton',ant_mask);
ABB_API('abb_api_ssi_set_extssion',ant_mask,  ssion);
ABB_API('abb_api_ssi_set_exttxon',ant_mask,  txon);
ABB_API('abb_api_ssi_set_extrxon',ant_mask,  rxon);
ABB_API('abb_api_ssi_disable_exton',ant_mask);


%//dft
ABB_API('abb_api_anamux_centralbias_RFIC1V8_atITRIM');
ABB_API('abb_api_anamux_centralbias_ICONST_atITRIM');
ABB_API('abb_api_anamux_centralbias_IPTAT_atITRIM');
ABB_API('abb_api_anamux_centralbias_VBGP_atITRIM');
ABB_API('abb_api_anamux_centralbias_disable');

ABB_API('abb_api_anamux_clkd_VREFLDO_atVREF');
ABB_API('abb_api_anamux_clkd_LDO0V95CLKD_atVREF');
ABB_API('abb_api_anamux_clkd_disable');

ABB_API('abb_api_anamux_lcpll_VREG1V8HV_atVREF');
ABB_API('abb_api_anamux_lcpll_LDO0V95PLLREF_atVREF');
ABB_API('abb_api_anamux_lcpll_LDO0V95PLLPOST_atVREF');
ABB_API('abb_api_anamux_lcpll_ATESTOUT_atVREF');
ABB_API('abb_api_anamux_lcpll_disable');

ABB_API('abb_api_anamux_clkin_VREFLDO_atVREF');
ABB_API('abb_api_anamux_clkin_LDO0V95FSYS_atVREF');
ABB_API('abb_api_anamux_clkin_disable');

ABB_API('abb_api_anamux_antbias_VREF0V95_atVREF',ant_mask);
ABB_API('abb_api_anamux_antbias_LDO0V95A_atVREF',ant_mask);
ABB_API('abb_api_anamux_antbias_LDO0V95D_atVREF',ant_mask);
ABB_API('abb_api_anamux_antbias_VSSAANT_atVREF',ant_mask);
ABB_API('abb_api_anamux_antbias_disable',ant_mask);

ABB_API('abb_api_anamux_antssi_vrefp_atVREF',ant_mask);
ABB_API('abb_api_anamux_antssi_vrefn_atVREF',ant_mask);
ABB_API('abb_api_anamux_antssi_vcm_r_atVREF',ant_mask);
ABB_API('abb_api_anamux_antssi_vcm_atVREF',ant_mask);
ABB_API('abb_api_anamux_antssi_disable',ant_mask);

%Sequences
prelock = 0;op_freq= 2;div = 0;
ABB_API('abb_sequence_read_central_fcsi');
ABB_API('abb_sequence_read_antenna_fcsi', ant_mask);
ABB_API('abb_sequence_central_pll_active', prelock);
ABB_API('abb_sequence_central_pll_bypass');
ABB_API('abb_sequence_dft');
ABB_API('abb_sequence_clock_reprogramming', op_freq, div);

%unload mex function
%clear ABB_API; 
%rmpath('..\api_mex')


