#include <stdint.h>
#include "fcsi_access_functions.h"

void ABB_FCSI_WRITE(uint16_t block, uint16_t address, uint16_t value)
{
    mxArray  *input_array[3];
    
    input_array[0]=mxCreateDoubleScalar((double)block);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0, NULL, 3, &input_array[0], "ABB_FCSI_WRITE");

    mxDestroyArray(input_array[2]);
    mxDestroyArray(input_array[1]);
    mxDestroyArray(input_array[0]);
}

void ABB_FCSI_RMW(uint16_t block, uint16_t address, uint16_t mask, uint16_t value)
{
    mxArray  *input_array[4];
    
    input_array[0]=mxCreateDoubleScalar((double)block);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)mask);
    input_array[3]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0, NULL, 4, &input_array[0], "ABB_FCSI_RMW");

    mxDestroyArray(input_array[3]);
    mxDestroyArray(input_array[2]);
    mxDestroyArray(input_array[1]);
    mxDestroyArray(input_array[0]);
}

void ABB_FCSI_READ(uint16_t block, uint16_t address, uint16_t *rdata)
{
    mxArray  *input_array[2];
    mxArray  *output_array[1];
    double_t *read_par;

    input_array[0]=mxCreateDoubleScalar((double)block);
    input_array[1]=mxCreateDoubleScalar((double)address);
    
    mexCallMATLAB(1, output_array, 2, &input_array[0],"ABB_FCSI_READ");    
    
    read_par = mxGetPr(output_array[0]);
    rdata[0]=(uint16_t)read_par[0];
    rdata[1]=(uint16_t)read_par[1];
    rdata[2]=(uint16_t)read_par[2];
    rdata[3]=(uint16_t)read_par[3];
    rdata[4]=(uint16_t)read_par[4];
    
//    mxDestroyArray(read_par[0]);
    mxDestroyArray(input_array[1]);
    mxDestroyArray(input_array[0]);

    return;
}

void ABB_DIR_CTRL_WRITE(uint32_t Port, uint32_t Value)
{
    mxArray  *input_array[2];
//     mxArray  *output_array[1];
//    double_t *read_par;

    input_array[0]=mxCreateDoubleScalar((double)Port);
    input_array[1]=mxCreateDoubleScalar((double)Value);
    
    mexCallMATLAB(0, NULL, 2, &input_array[0],"ABB_DIR_CTRL_WRITE");    
    
    mxDestroyArray(input_array[1]);
    mxDestroyArray(input_array[0]);

    return;
}

void ABB_DIR_CTRL_WRITES(uint32_t Port, uint32_t Mask, uint32_t Value)
{
    mxArray  *input_array[3];
//     mxArray  *output_array[1];
//    double_t *read_par;

    input_array[0]=mxCreateDoubleScalar((double)Port);
    input_array[1]=mxCreateDoubleScalar((double)Mask);
    input_array[2]=mxCreateDoubleScalar((double)Value);
    
    mexCallMATLAB(0, NULL, 3, &input_array[0],"ABB_DIR_CTRL_WRITES");    
    
    mxDestroyArray(input_array[2]);
    mxDestroyArray(input_array[1]);
    mxDestroyArray(input_array[0]);

    return;
}


void ABB_wait_us(uint32_t time)
{
//    _NOP();
}

