// ###############################################
// #####-------------------------------------#####
// #####------- DATABASE FUNCTIONS ----------#####
// #####-------------------------------------#####
// ###############################################
function hasAttributes (spectool2Element) {
  if (spectool2Element.attributes.constant !== undefined
      || spectool2Element.attributes.generic !== undefined
      || spectool2Element.attributes.parameter !== undefined
      || spectool2Element.attributes.enumeration !== undefined
      || spectool2Element.attributes.limitation !== undefined) {
    return (true);
  } else {
    return (false);
  }
}

function hasDebugMessages (spectool2Element) {
  if (spectool2Element.debugMessages.length > 0) {
    return (true);
  } else {
    if (spectool2Element.type == "register") {
      for (var idx = 0; idx < spectool2Element.fields.length; idx++) {
        var field = window [spectool2Element.fields [idx]];
        if (field.debugMessages.length > 0) {
          return (true);
        }
      }
    } else if (spectool2Element.type == "system") {
      return (spectool2Element.allDebugMessages.length > 0);
    }
    return (false);
  }
}

function getViewAddrStart (spectool2Element, viewName) {
  var hierarchyArray = spectool2Element.hierarchies [viewName];
  var addr = 0;
  for (node in hierarchyArray) {
    // console.log ("hierarchyArray[node]="+hierarchyArray[node]);
    addr += vlogb2int (window [hierarchyArray [node]].addrStart [viewName]);
  }
  return (addr);
}

function getViewAddrEnd (spectool2Element, viewName) {
  var hierarchyArray = spectool2Element.hierarchies [viewName];
  var addr = 0;
  for (var i=0; i<(hierarchyArray.length-1); i++) {
      addr += vlogb2int (window [hierarchyArray [i]].addrStart [viewName]);
  }
  addr += vlogb2int (spectool2Element.addrEnd [viewName]);
  if (addr > 0xffffffff) {
    addr = 0xffffffff - (vlogb2int (spectool2Element.dataWidth [viewName]) / vlogb2int (window [viewName].addrBase));
  }
  return (addr);
}

function getAddrStart (array, viewName) {
  return (vlogb2int (array.addrStart [viewName]));
}

function getAddrEnd (array, viewName) {
  return (vlogb2int (array.addrEnd [viewName]));
}

function getAddrSpace (array, viewName) {
  return (vlogb2int (array.addrSpace [viewName]));
}

function getAliasContextName (spectool2Element, longName) {
  var name = spectool2Element.aliasName;
  var connect = "_";
  var counter;
  if (longName === true) {
    counter = 100000;
  } else {
    if (spectool2Element.type == "module") {
      counter = 0;
    } else if (spectool2Element.type == "port"
        || spectool2Element.type == "iaport" || spectool2Element.type == "bus") {
      counter = 1;
    } else if (spectool2Element.type == "register") {
      counter = 2;
    } else if (spectool2Element.type == "rfield") {
      counter = 3;
    } else {
      counter = 0;
    }
  }
  var parent = spectool2Element;
  while (counter > 0) {
    if (parent.parent.length>0) {
      parent = window [parent.parent];
    } else {
      parent = undefined;
    }
    if (parent !== undefined) {
      name = parent.aliasName + connect + name;
      counter--;
    } else {
      counter = 0;
    }
  }
  return (name);
}

function getContextName (spectool2Element, longName) {
  var name = spectool2Element.instName;
  var connect = "_";
  var counter;
  if (longName === true) {
    counter = 100000;
  } else {
    if (spectool2Element.type == "module") {
      counter = 0;
    } else if (spectool2Element.type == "port") {
      counter = 1;
    } else if (spectool2Element.type == "register") {
      counter = 2;
    } else if (spectool2Element.type == "rfield") {
      counter = 3;
    } else {
      counter = 0;
    }
  }
  var parent = spectool2Element;
  while (counter > 0) {
    parent = window [parent.parent];
    if (parent !== undefined) {
      name = parent.instName + connect + name;
      counter--;
    } else {
      counter = 0;
    }
  }
  return (name);
}
