/**
 * 
 */

// Body on load
document.body.onload = function() {
	initial ();
};

// INITIAL
function initial () {
	var locationSearch = window.location.search;
	var keys = locationSearch.split('?', 2);
	var viewName = keys[1];
	var view = window[viewName];

	createTitle(view);
	createPortMap(view);
	createFooter(view);
	
	initChapter("ports", 1);
	
	scaleObjects();
	window.onresize=scaleObjects;
}


function createPortMap (view) {
	var head = document.getElementById("portsHead");
	var body = document.getElementById("portsBody0");
	
	head.innerHTML += createToggleImage("ports");
	
	//for (var idx=0; idx<view.)
}

function createInnerPortMap (module, viewName) {
	// Description
	var body = document.getElementById("infoBody0");
	
	var row;
	var cell;
	var link;	

	// Table Headers
	var headerCells = ["Parameter", "Value"];
	row = document.createElement("tr");
	for (idx in headerCells) {
		cell = document.createElement("th");
		cell.innerHTML = headerCells[idx];
		row.appendChild(cell);
	}
	body.appendChild(row);
	
	// Table Body
	// Row: Module
	row = document.createElement("tr");
	row.className = "interleave";
	cell = document.createElement("td");
	cell.innerHTML = "Module";
	row.appendChild(cell);
	cell = document.createElement("td");
	cell.innerHTML  = module.aliasName;
	cell.innerHTML += " ("+module.baseName+")";
	row.appendChild(cell);
	body.appendChild(row);
	// Row: Module Parent
	row = document.createElement("tr");
	cell = document.createElement("td");
	cell.innerHTML = "Module Parent";
	row.appendChild(cell);
	cell = document.createElement("td");
	if (module.parent.length>0) {
		cell.innerHTML  = window[module.parent].aliasName;
		cell.innerHTML += " ("+window[module.parent].baseName+")";
	} else {
		cell.innerHTML  = "-";
	}
	row.appendChild(cell);
	body.appendChild(row);
	// Row: Number of Modules
	row = document.createElement("tr");
	row.className = "interleave";
	cell = document.createElement("td");
	cell.innerHTML  = "Number of Sub-Modules";
	row.appendChild(cell);
	cell = createNrTableCell(module.modules.length, 32, "dec");
	row.appendChild(cell);
	body.appendChild(row);
	// Row: Number of Ports
	row = document.createElement("tr");
	cell = document.createElement("td");
	cell.innerHTML  = "Number of Ports";
	row.appendChild(cell);
	cell = createNrTableCell(module.ports.length, 32, "dec");
	row.appendChild(cell);
	body.appendChild(row);
	// Row: Number of Buses
	row = document.createElement("tr");
	row.className = "interleave";
	cell = document.createElement("td");
	cell.innerHTML  = "Number of Buses";
	row.appendChild(cell);
	cell = createNrTableCell(module.buses.length, 32, "dec");
	row.appendChild(cell);
	body.appendChild(row);
	// Row: Has Mutations ...
	row = document.createElement("tr");
	cell = document.createElement("td");
	cell.innerHTML = "Mutations By Attributes";
	row.appendChild(cell);
	cell = document.createElement("td");
	if (module.hasMutationsByAttributes=="true") {
		cell.innerHTML = "YES";
	} else {
		cell.innerHTML = "NO";
	}
	row.appendChild(cell);
	body.appendChild(row);
}

