/**
 *
 */
// INITIAL
function initial () {
  var locationSearch = window.location.search;
  var keys = locationSearch.split ('?', 3);
  var portName = keys [1];
  var viewName = keys [2];
  var port = window [portName];

  createTitle (port);
  createDescription (port);
  createViewsTable (port, viewName);
  createHierarchy (port, viewName);
  genInfo (port, viewName);
  createAttributesTable (port, viewName);
  createMasterPortTable (port, viewName);
  createSlavePortTable (port, viewName);
  createRegisterTable (port, viewName);
  createDebugMsgTable (port, viewName);
  createFooter (port);

  initChapter ("description", 0);
  initChapter ("views", 0);
  initChapter ("hierarchy", 1);
  initChapter ("info", 0);
  initChapter ("attributes", 0);
  initChapter ("masterPorts", 0);
  initChapter ("slavePorts", 1);
  initChapter ("registers", 1);
  initChapter ("debugmsg", 1);

  scaleObjects ();
  window.onresize = scaleObjects;
}

function createMasterPortTable (port, viewName) {
  var masterBus = window [port.masterBus];

  if (masterBus == undefined) {
    hideBundle ("masterPortsBody", undefined);
    return;
  }

  var refName = "masterPorts" + Math.ceil (Math.random () * 1000).toString ();
  masterBus.slavePorts.jsName = refName;
  window [refName] = masterBus.masterPorts;
  createPortsTable0Init (masterBus.masterPorts, viewName, "masterPorts");
}
function createSlavePortTable (port, viewName) {
  var slaveBus = window [port.slaveBus];

  if (slaveBus == undefined) {
    hideBundle ("slavePortsBody", undefined);
    return;
  }
  var refName = "slavePorts" + Math.ceil (Math.random () * 1000).toString ();
  slaveBus.slavePorts.jsName = refName;
  window [refName] = slaveBus.slavePorts;
  createPortsTable0Init (slaveBus.slavePorts, viewName, "slavePorts");
}
function createRegisterTable (port, viewName) {
  var head = document.getElementById ("registersHead");

  if (port.registers.length === 0) {
    hideBundle ("registersBody", undefined);
    return;
  }

  // head.innerHTML += createToggleImage("registers");

  var refName = "registers" + Math.ceil (Math.random () * 1000).toString ();
  port.registers.jsName = refName;
  window [refName] = port.registers;
  createRegistersTable0Init (port.registers, viewName, "registers");

}

function genInfo (port, viewName) {
  var head = document.getElementById ("infoHead");

  head.innerHTML += createToggleImage ("info");

  genInfo0 (port, viewName);
}

function genInfo0 (port, viewName) {
  var masterBus = window [port.masterBus];
  var slaveBus = window [port.slaveBus];
  var view = window [viewName];
  // Description
  var body = document.getElementById ("infoBody0");
  // Table Caption
  // <caption><sup>M</sup>Module <sup>P</sup>Port <sup>B</sup>Bus
  // <sup>R</sup>Register</caption>
  var caption = document.createElement ("caption");
  var one = document.createElement ("sup");
  one.innerHTML = "1";
  caption.appendChild (one.cloneNode(true));
  caption.appendChild (document.createTextNode ("According to the current view's addressing scheme (Addr.base="
      + int2dec (vlogb2int (view.addrBase)) + " / Data width="
      + int2dec (vlogb2int (view.dataWidth [viewName]))));
  body.appendChild (caption);

  var row;
  var cell;
  var link;

  // Table Headers
  var headerCells = [ "Parameter", "Value" ];
  row = document.createElement ("tr");
  for (idx in headerCells) {
    cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  // Row: Module
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Module";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = window [port.parent].aliasName;
  cell.innerHTML += " (" + window [port.parent].baseName + ")";
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Base
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Interface Address Base";
  cell.title = "Smallest amount of data bits addressible by address lines";
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (port.addrBase), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Data Width
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Interface Data Width";
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (port.dataWidth [port.jsName]), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Data Width
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Interface Data Width"));
  cell.appendChild (one.cloneNode (true))
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (port.dataWidth [viewName]), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Offset as View (native)
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Offset as View";
  row.appendChild (cell);
  if (port.isView === true) {
    cell = createNrTableCell (port.offsetAsView, 32, "hex");
  } else {
    cell = document.createElement ("td");
    cell.innerHTML = "-";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: View Offset
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("View Offset"));
  cell.appendChild (one.cloneNode(true))
  row.appendChild (cell);
  cell = createNrTableCell (getViewAddrStart (port, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Local Offset
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Local Offset"));
  cell.appendChild (one.cloneNode(true))
  row.appendChild (cell);
  cell = createNrTableCell (getAddrStart (port, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Local Offset (native)
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Local Offset";
  row.appendChild (cell);
  cell = createNrTableCell (getAddrStart (port, port.jsName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Space
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Occupied Address Space"));
  cell.appendChild (one.cloneNode(true))
  row.appendChild (cell);
  cell = createNrTableCell (getAddrSpace (port, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Space (native)
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Occupied Address Space";
  row.appendChild (cell);
  cell = createNrTableCell (getAddrSpace (port, port.jsName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Access
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "View Access";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = port.access [viewName];
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Access (native)
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Local Access";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = port.access [port.jsName];
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Master Ports connected via bus
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Number of Master Ports Connected"));
  cell.appendChild (document.createElement ("br"))
  cell.appendChild (document.createTextNode ("via "));
  if (masterBus !== undefined) {
    cell.appendChild (document.createTextNode (getAliasContextName (masterBus, false)));
  } else {
    cell.appendChild (document.createTextNode ("-"));
    cell.innerHTML += "-";
  }
  row.appendChild (cell);
  if (masterBus !== undefined) {
    cell = createNrTableCell (masterBus.masterPorts.length, 32, "dec");
  } else {
    cell = document.createElement ("td");
    cell.innerHTML = "-";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Slave Ports connected via bus
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Number of Slave Ports Connected"));
  cell.appendChild (document.createElement ("br"))
  cell.appendChild (document.createTextNode ("via "));
  if (slaveBus !== undefined) {
    cell.appendChild (document.createTextNode (getAliasContextName (slaveBus, false)));
  } else {
    cell.appendChild (document.createTextNode ("-"));
    cell.innerHTML += "-";
  }
  row.appendChild (cell);
  if (slaveBus !== undefined) {
    cell = createNrTableCell (slaveBus.slavePorts.length, 32, "dec");
  } else {
    cell = document.createElement ("td");
    cell.innerHTML = "-";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Registers
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Registers Connected";
  row.appendChild (cell);
  cell = createNrTableCell (port.registers.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Protocol towards master port
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Master Bus Protocol";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = port.masterBusProtocol;
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Protocol towards master port
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Slave Bus Protocol";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = port.slaveBusProtocol;
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Is Bridge
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Protocol Bridge";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (port.isBridge == "true") {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Is Default Slave
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Default Slave";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (port.isDefaultSlave == "true") {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Is Default Slave
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Mutations By Attributes";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (port.hasMutationsByAttributes == "true") {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Is Default Slave
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Indirect Access Port";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (port.isIndirectAccessPort == "true") {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Allow Address Overlap
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Allow Address Overlap";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (port.allowAddrOverlap === true) {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Lossless Connection
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Lossless Connection";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (port.isLossless === true) {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: References
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  row.className = "interleave";
  cell.innerHTML = "References";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateReference(cell, port, port.jsName, false);
  row.appendChild (cell);
  body.appendChild (row);
  //Enabled and Disabled Exporters
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  var title1 = "Enabled";
  var title2 = "Disabled";
  cell.innerHTML = title1.fontcolor("green");
  cell.innerHTML += " /" + title2.fontcolor("red");
  cell.innerHTML += " Exporters";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateEnDisTypes (cell, port);
  row.appendChild (cell);
  body.appendChild (row);
  //Row: Source File
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Source file";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = port.sourceFile;
  row.appendChild (cell);
  body.appendChild (row);
  //Aliases
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Aliases";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateAliases (cell, port);
  row.appendChild (cell);
  body.appendChild (row);

}
