
function createButtonHook (tableReference, cellReference, spectool2Element, viewName, tableStatus) {
  // hookTable4Sort (bodyName, tableStatusName, dataSourceName, viewName, sortPos)
  cellReference.setAttribute ("onclick", "hookTable4Button (\""
      + tableReference.id + "\", \"" + tableStatus.id + "\", \""
      + spectool2Element.jsName + "\", \"" + viewName + "\")");
}

function hookTable4Button (bodyName, tableStatusName, dataSourceName, viewName) {
  var body = document.getElementById (bodyName);
  var tableStatus = window [tableStatusName];
  var f = window [tableStatus.hookFunctionName];
  var dataSource = window [dataSourceName];

  // console.log ("sort:functionName="+functionName);
  // console.log ("filterRowId="+tStatus.filterRowId);
  if (tableStatus.filterRowId!=="") {
    tableStatus.filterRow = document.getElementById (tableStatus.filterRowId).cloneNode (true);
  }

  body.innerHTML = "";

  if (tableStatus.showScheme == true) {
    tableStatus.showScheme = false;
  } else {
    tableStatus.showScheme = true;
  }
  // console.log ("sort:dataSourceName="+dataSourceName);
  // console.log ("sort:f (body="+body+", dataSource="+dataSource+",
  // viewName="+viewName+", tStatus="+tStatus+", row=??"+",inputCopy=???)");

  f (body, dataSource, viewName, tableStatus);
}

//###############################################
//#####-------------------------------------#####
//#####--------- REGISTER TABLES -----------#####
//#####-------------------------------------#####
//###############################################
function createRegistersTable0Init (registerArray, viewName, identifier,
    searchRegExp) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");
  if (head !== undefined) {
    head.innerHTML += createToggleImage (identifier);
  }

  var tableStatus = new TableStatus (7);
  // TABLE: | View Addresses {START & END} | Local Addresses {START & END} |
  // RegisterName | Long Name | Reset | IAP | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  // tableStatus.sortEnabled [X] = false;
  tableStatus.sortTypes [0] = "number";
  tableStatus.sortTypes [1] = "number";
  tableStatus.sortTypes [4] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  // tableStatus.filterEnabled [X] = false;
  tableStatus.filterTypes [0] = "number";
  tableStatus.filterTypes [1] = "number";
  tableStatus.filterTypes [4] = "number";
  tableStatus.filterSet [0] = ">=0";
  tableStatus.filterSet [1] = ">=0";
  tableStatus.filterSet [4] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
//  tableStatus.combineCell [2] = true;
  tableStatus.combineCell [4] = true;

  tableStatus.hookFunctionName = "hookRegisterTable0";

  tableStatus.enableModuleColumn = false;

  window [tableStatus.id] = tableStatus;

  hookRegisterTable0 (body, registerArray, viewName, tableStatus, searchRegExp);
}

function createRegistersTable01Init (registerArray, viewName, identifier, searchRegExp) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");
  if (head !== undefined) {
    head.innerHTML += createToggleImage (identifier);
  }

  window [identifier + "TableStatus"] = new TableStatus (8);
  var tableStatus = window [identifier + "TableStatus"];
  // TABLE: | View Addresses | Local Addresses |
  // Module/Port | RegisterName | Long Name | Reset | IAP | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  // tableStatus.sortEnabled [X] = false;
  tableStatus.sortTypes [0] = "number";
  tableStatus.sortTypes [1] = "number";
  tableStatus.sortTypes [5] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  // tableStatus.filterEnabled [X] = false;
  tableStatus.filterTypes [0] = "number";
  tableStatus.filterTypes [1] = "number";
  tableStatus.filterTypes [5] = "number";
  tableStatus.filterSet [0] = ">=0";
  tableStatus.filterSet [1] = ">=0";
  tableStatus.filterSet [5] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  tableStatus.combineCell [2] = true;
  tableStatus.combineCell [5] = true;

  tableStatus.hookFunctionName = "hookRegisterTable0";

  tableStatus.enableModuleColumn = true;
  tableStatus.showScheme = false;

  hookRegisterTable0 (body, registerArray, viewName, tableStatus, searchRegExp);
}

function hookRegisterTable0 (tableReference, registerArray, viewName,
    tableStatus, searchRegExp) {
  // generate data array
  var bodyArray = buildRegisterTable0Array (registerArray, viewName, tableStatus);
  // generate table
  createRegisterTable0 (tableReference, bodyArray, registerArray, viewName, tableStatus, searchRegExp);
}

function buildRegisterTable0Array (registerArray, viewName, tableStatus) {
  // TABLE: Module Register Long Name Master Bus Slave Bus Local Addresses
  // {START & END} View Addresses {START & END}
  var bodyArray = new Array;
  /*
   * var view = window[viewName]; var port = window[registerArray[0].parent];
   * var portStart = 0; var portEnd = vlogb2int (port.addrSpace
   * [viewName])-(vlogb2int (view.dataWidth [viewName])/vlogb2int (view.addrBase));
   */
  // build bodyArray
  var odx = 0; // "out" index
  for (var idx = registerArray.length - 1; idx >= 0; idx--) {
    bodyArray [odx] = new Array;
    // apply register data
    var register = window [registerArray [idx]];
    // View Address START
    var pos = 0;
    bodyArray [odx] [pos] = "32'b"
        + getViewAddrStart (register, viewName).toString (2);
    // Local Address START
    pos++;
    bodyArray [odx] [pos] = register.addrStart [register.jsName];
    // Name
    pos++;
    if (tableStatus.enableModuleColumn === true) {
      bodyArray [odx] [pos] = getAliasContextName (window [register.parent],
          false);
      pos++;
    }
    bodyArray [odx] [pos] = register.aliasName;
    // Long Name
    pos++;
    bodyArray [odx] [pos] = register.longName;
    // Reset
    pos++;
    bodyArray [odx] [pos] = register.resetVal;
    // IndirectAccessPort
    pos++;
    if (register.indirectAccessPort.length > 0) {
      bodyArray [odx] [pos] = getAliasContextName (
          window [register.indirectAccessPort], false);
    } else {
      bodyArray [odx] [pos] = "";
    }
    // Description
    pos++;
    bodyArray [odx] [pos] = register.description;
    // Register reference
    pos++;
    bodyArray [odx] [pos] = register;

    odx++;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus, viewName)
  return (tableStatus.tableArray);
}

function createRegisterTable0 (tableReference, bodyCells, registerArray,
    viewName, tableStatus, searchRegExp) {
  var body = tableReference;
  var row;
  var row1;
  var row2;
  var cell;
  var link;
  // BUTTON
  row = document.createElement ("tr");
  body.appendChild (row);
  row.style.borderTop = "hidden";
  row.style.borderLeft = "hidden";
  row.style.borderRight = "hidden";
  cell = document.createElement ("td");
  row.appendChild (cell);
  cell.className = "hide";
  if (tableStatus.showScheme)
    cell.colSpan = 5;
  else
    cell.colSpan = 8;
  //cell.align = "center";
  var button = document.createElement ("input");
  cell.appendChild (button);
  button.type = "button";
  button.value = "SWITCH VIEW";
  button.style.marginBottom = "5px";

  createButtonHook (body, button, registerArray, viewName, tableStatus);

  // TABLE
  var headerCellNames;
  var headerCellTitles;
  if (tableStatus.showScheme) {
    tableStatus.sortEnabled [4] = false;
    tableStatus.filterEnabled [4] = false;
    headerCellNames = [ "View Address Start", "Local Address Start", "Name", "Scheme" ];
    headerCellTitles = [ "", "", "", "", "" ];
  } else {
    tableStatus.sortEnabled [4] = true;
    tableStatus.filterEnabled [4] = true;
    headerCellNames = [ "View Address Start", "Local Address Start", "Name", "Long Name", "Reset<br/>(4-state/2-state)", "IAP", "Description" ];
    headerCellTitles = [ "", "", "", "", "", "Controlled Indirect Access Port", "" ];
  }
  var addrStart;

  if (tableStatus.enableModuleColumn === true) {
    headerCellNames.splice (2, 0, "Module/Port");
    headerCellTitles.splice (2, 0, "");
  }

  // create header
  row = document.createElement ("tr");
  for (pos in headerCellNames) {
    cell = document.createElement ("th");
    cell.className = tableStatus.sortClassNames [pos];
    cell.title = headerCellTitles [pos];
    cell.innerHTML = headerCellNames [pos];
    if (tableStatus.sortEnabled [pos] === true) {
      createSortHook (body, cell, pos, registerArray, viewName, tableStatus);
    }
    row.appendChild (cell);
  }
  body.appendChild (row);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    // function createFilterInput (tableReference, tableRefreshFunctionName,
    // spectool2Element, viewName, registersTableStatus)
    createFilterInput (body, registerArray, viewName, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    // function refreshFilterInput2 (tableReference, filterRow)
    refreshFilterInput2 (body, tableStatus);
  }
  if (tableStatus.filterRowId!=="") row = document.getElementById (tableStatus.filterRowId);
  else row = null
  if (row!==null) {
    if (tableStatus.showScheme) {
      for (var i=0; i<3; ++i) {
        row.childNodes [row.childNodes.length-i-1].style.display = "none";
      }
    } else {
      for (var i=0; i<3; ++i) {
        row.childNodes [row.childNodes.length-i-1].style.display = "";
      }
    }
  }
  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var register = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];

    row = document.createElement ("tr");
    if (register.reserved === true) {
      row.className = "reserved";
    } else if (line % 2 === 0) {
      row.className = "interleave";
    }

    // View Start Address START
    var pos = 0;
    addrStart = vlogb2bin (bodyCells [line] [pos]);
    cell = createNrTableCell (addrStart, 32, "hex");
    row.appendChild (cell);
    // Local Start Address START
    pos++;
    addrStart = vlogb2bin (bodyCells [line] [pos]);
    cell = createNrTableCell (addrStart, 32, "hex");
    row.appendChild (cell);
    // Name
    pos++;
    if (tableStatus.enableModuleColumn === true) {
      if (rowSpans [pos] !== null) {
        cell = document.createElement ("td");
        cell.rowSpan = rowSpans [pos];
        if (register.reserved === false) {
          link = document.createElement ("a");
          link.href = "port.html?" + register.parent + "?" + viewName;
          link.title = getAliasContextName (window [register.parent], true);
          link.innerHTML = bodyCells [line] [pos];
          cell.className = classNames [pos];
          cell.appendChild (link);
        } else {
          cell.innerHTML = bodyCells [line] [pos];
        }
        row.appendChild (cell);
      }
      pos++;
    }
    // if (colSpans[pos]>1) console.log (register.aliasName+"="+colSpans [pos]);
    cell = document.createElement ("td");
    if (register.reserved === false) {
      link = document.createElement ("a");
      link.className = "row_link";
      link.href = "register.html?" + register.jsName + "?" + viewName;
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
    } else {
      cell.innerHTML = "reserved"; // bodyCells[line][pos];
    }
    row.appendChild (cell);

    if (tableStatus.showScheme) {
      var home = "register.html?" + register.jsName + "?" + register.views [0];
      // Scheme
      pos++;
      cell = document.createElement ("td");
      var tableSlave = document.createElement ("table");
      tableSlave.className = "scheme";
      createRegisterSchemeVALID (tableSlave, register, register.views [0], undefined, home, 0);
      cell.appendChild (tableSlave);
      row.appendChild (cell);
    } else {
      // Long Name
      pos++;
      cell = document.createElement ("td");
      cell.innerHTML = bodyCells [line] [pos];
      row.appendChild (cell);
      // Reset
      pos++;
      if (rowSpans [pos] !== null || register.reserved === true) {
        var reset = vlogb2bin (bodyCells [line] [pos]);
        cell = createNrTableCellDuo (reset, 0, "hex");
        if (register.reserved !== true) {
          cell.className = classNames [pos];
          cell.rowSpan = rowSpans [pos];
         }
        row.appendChild (cell);
      }
      // IAP
      pos++;
      cell = document.createElement ("td");
      if (register.indirectAccessPort.length > 0) {
        var iap = window [register.indirectAccessPort];
        link = document.createElement ("a");
        link.href = "port.html?" + iap.jsName + "?" + iap.jsName;
        link.innerHTML = bodyCells [line] [pos];
        cell.appendChild (link);
      }
      row.appendChild (cell);
      // Description
      pos++;
      cell = document.createElement ("td");
      cell.innerHTML = bodyCells [line] [pos];
      cell.appendChild (document.createElement ("br"));
      generateReference (cell, register, register.jsName);
      row.appendChild (cell);
    }

    // Append ROW
    var spaceFactor = Math.floor (vlogb2int (window [viewName].dataWidth [viewName])/vlogb2int (window [viewName].addrBase));
    var regAddrSpace2 = Math.floor (vlogb2int (register.addrSpace [viewName])/spaceFactor);
    if (regAddrSpace2 > 2) {
      row2 = row.cloneNode (true);
      for (var i = 0; i < row.cells.length; i++) {
        row2.cells [i].innerHTML = "...";
      }
      var validSegment = vlogb2int (register.addrSpace [viewName])/vlogb2int (register.addrSpace [register.jsName])-1;
      row1 = row.cloneNode (true);
      var new_cell = createNrTableCell (vlogb2bin (register.addrEnd [register.jsName]), 32, "hex");
      row1.cells [1].innerHTML = new_cell.innerHTML;
      row1.cells [1].title = new_cell.title;
      new_cell = createNrTableCell (getViewAddrEnd (register, viewName).toString (2), 32, "hex");
      row1.cells [0].innerHTML = new_cell.innerHTML;
      row1.cells [0].title = new_cell.title;
      try {
        link = row.getElementsByClassName ("row_link")[0];
        link.href += "?0";
        link = row1.getElementsByClassName ("row_link")[0];
        link.href += "?"+validSegment;
      }
      catch (err) {}
      if (tableStatus.showScheme) {
        var tableSlave;
        try {
          tableSlave = row1.getElementsByClassName("scheme")[0];
          while (tableSlave.hasChildNodes()) {
            tableSlave.removeChild(tableSlave.lastChild);
          }
          createRegisterSchemeVALID (tableSlave, register, register.views [0], undefined, home, validSegment);
        }
        catch(err) {}
      }
      if ( (tableStatus.currentSortPos == 1 || tableStatus.currentSortPos == 0)
          && tableStatus.currentSortDir == "down") {
        for (var i=0; i<row.cells.length; i++) {
          if (row.cells [i].rowSpan!==undefined && parseInt(row.cells [i].rowSpan,10)>1) {
            row.deleteCell(i);
            row2.deleteCell(i);
          }
        }
        body.appendChild (row1);
        body.appendChild (row2);
        body.appendChild (row);
      } else {
        for (var i=0; i<row1.cells.length; i++) {
          if (row1.cells [i].rowSpan!==undefined && parseInt(row1.cells [i].rowSpan,10)>1) {
              row1.deleteCell(i);
              row2.deleteCell(i);
          }
        }
        body.appendChild (row);
        body.appendChild (row2);
        body.appendChild (row1);
      }
    } else if (regAddrSpace2 > 1) {
      var validSegment = vlogb2int (register.addrSpace [viewName])/vlogb2int (register.addrSpace [register.jsName])-1;
      row1 = row.cloneNode (true);
      var new_cell = createNrTableCell (vlogb2bin (register.addrEnd [register.jsName]), 32, "hex");
      row1.cells [1].innerHTML = new_cell.innerHTML;
      row1.cells [1].title = new_cell.title;
      new_cell = createNrTableCell (getViewAddrEnd (register, viewName).toString (2), 32, "hex");
      row1.cells [0].innerHTML = new_cell.innerHTML;
      row1.cells [0].title = new_cell.title;
      try {
        link = row.getElementsByClassName ("row_link")[0];
        link.href += "?0";
        link = row1.getElementsByClassName ("row_link")[0];
        link.href += "?"+validSegment;
      }
      catch (err) {}
      if (tableStatus.showScheme) {
        var tableSlave;
        try {
          tableSlave = row1.getElementsByClassName("scheme")[0];
          while (tableSlave.hasChildNodes()) {
            tableSlave.removeChild(tableSlave.lastChild);
          }
          createRegisterSchemeVALID (tableSlave, register, register.views [0], undefined, home, validSegment);
        }
        catch(err) {}
      }
      if ( (tableStatus.currentSortPos == 1 || tableStatus.currentSortPos == 0)
          && tableStatus.currentSortDir == "down") {
        for (var i=0; i<row.cells.length; i++) {
          if (row.cells [i].rowSpan!==undefined && parseInt(row.cells [i].rowSpan,10)>1) {
            row.deleteCell(i);
          }
        }
        body.appendChild (row1);
        body.appendChild (row);
      } else {
        for (var i=0; i<row1.cells.length; i++) {
          if (row1.cells [i].rowSpan!==undefined && parseInt(row1.cells [i].rowSpan,10)>1) {
            row1.deleteCell(i);
          }
        }
        body.appendChild (row);
        body.appendChild (row1);
      }
    } else {
      body.appendChild (row);
    }
  }
}

function createRegistersTable1Init (registerArray, identifier, searchRegExp) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");
  if (head !== null) {
    head.innerHTML += createToggleImage (identifier);
  }
  var tableStatus = new TableStatus (8);
  // TABLE: | Module | Port | Name | Long Name | Views on this Register | Reset
  // | IAP | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  tableStatus.sortEnabled [4] = false;
  tableStatus.sortEnabled [7] = false;
  tableStatus.sortTypes [4] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  // tableStatus.filterEnabled [X] = false;
  tableStatus.filterTypes [4] = "number";
  tableStatus.filterSet [4] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  tableStatus.combineCell [1] = true;
  tableStatus.combineCell [2] = true;
  tableStatus.combineCell [5] = true;

  tableStatus.hookFunctionName = "hookRegisterTable1";

  hookRegisterTable1 (body, registerArray, null, tableStatus, searchRegExp);
}

function hookRegisterTable1 (tableReference, registerArray, viewName, tableStatus, searchRegExp) {
  // generate data array
  var bodyArray = buildRegisterTable1Array (registerArray, viewName, tableStatus);
  // generate table
  createRegisterTable1 (tableReference, bodyArray, registerArray, viewName, tableStatus, searchRegExp);
}

function buildRegisterTable1Array (registerArray, viewName, tableStatus) {
  // TABLE: | Module | Port | Name | Long Name | Views on this Register | Reset
  // | IAP | Description |
  var bodyArray = new Array;
  // build bodyArray
  for (var idx = registerArray.length - 1; idx >= 0; idx--) {
    bodyArray [idx] = new Array;
    var register = window [registerArray [idx]];
    var port = window [register.parent];
    var module = window [port.parent];
    // Module
    var pos = 0;
    bodyArray [idx] [pos] = module.aliasName;
    // Port
    pos++;
    bodyArray [idx] [pos] = port.aliasName;
    // Name
    pos++;
    bodyArray [idx] [pos] = register.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = register.longName;
    // Reset
    pos++;
    bodyArray [idx] [pos] = register.resetVal;
    // Views on this Register
    pos++;
    for (var j = 0; j < register.views.length; j++) {
      bodyArray [idx] [pos] = getAliasContextName (window [register.views [j]],
          false);
      if ( (j + 1) < register.views.length) {
        bodyArray [idx] [pos] = "";
      }
    }
    // IndirectAccessPort
    pos++;
    if (register.indirectAccessPort.length > 0) {
      bodyArray [idx] [pos] = getAliasContextName (
          window [register.indirectAccessPort], false);
    } else {
      bodyArray [idx] [pos] = "";
    }
    // Description
    pos++;
    bodyArray [idx] [pos] = register.description;
    // Register reference
    pos++;
    bodyArray [idx] [pos] = register;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createRegisterTable1 (tableReference, bodyCells, registerArray, viewName, tableStatus, searchRegExp) {
  var body = tableReference;
  // Module Port Name Long Name "Views on this Register" IAP Description Reset
  var headerCellNames = [ "Module", "Port", "Name", "Long Name",
      "Reset<br/>(4-state/2-state)", "Views on this Register", "IAP",
      "Description" ];
  var headerCellTitles = [ "", "", "", "", "", "",
      "Controlled Indirect Access Port", "" ];
  var row;
  var cell;
  var link;
  // create header
  row = document.createElement ("tr");
  for (pos in headerCellNames) {
    cell = document.createElement ("th");
    cell.className = tableStatus.sortClassNames [pos];
    cell.title = headerCellTitles [pos];
    cell.innerHTML = headerCellNames [pos];
    if (tableStatus.sortEnabled [pos] === true) {
      createSortHook (body, cell, pos, registerArray, viewName, tableStatus);
    }
    row.appendChild (cell);
  }
  body.appendChild (row);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    // function createFilterInput (tableReference, tableRefreshFunctionName,
    // spectool2Element, viewName, registersTableStatus)
    createFilterInput (body, registerArray, viewName, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    // function refreshFilterInput2 (tableReference, filterRow)
    refreshFilterInput2 (body, tableStatus);
  }
  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var register = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];

    var port = window [register.parent];
    var module = window [port.parent];
    row = document.createElement ("tr");
    if (line % 2 === 0) {
      row.className = "interleave";
    }
    // Module
    var pos = 0;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.rowSpan = rowSpans [pos];
      cell.className = classNames [pos];
      link = document.createElement ("a");
      link.href = "module.html?" + module.jsName;
      link.title = getAliasContextName (module, true);
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
      row.appendChild (cell);
    }
    // Port
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Name
    pos++;
    cell = document.createElement ("td");
    cell.className = "emph";
    if (register.reserved === true) {
      cell.innerHTML = "reserved"; // bodyCells[line][pos];
    } else if (searchRegExp !== undefined) {
      cell.innerHTML = highlightSearch (bodyCells [line] [pos], searchRegExp);
    } else {
      cell.innerHTML = bodyCells [line] [pos];
    }
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Reset
    pos++;
    if (rowSpans [pos] !== null) {
      var reset = vlogb2bin (bodyCells [line] [pos]);
      cell = createNrTableCellDuo (reset, 0, "hex");
      cell.rowSpan = rowSpans [pos];
      cell.className = classNames [pos];
      row.appendChild (cell);
    }
    // Views on this Register
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = "";
    if (register.reserved === false) {
      for (var idx = 0; idx < register.views.length; idx++) {
        var bold = document.createElement ("b");
        bold.innerHTML = getAliasContextName (window [register.views [idx]],
            false);
        link = document.createElement ("a");
        link.appendChild (bold);
        link.appendChild (document.createTextNode ("." + getAliasContextName (register, false)));
        link.href = "register.html?" + register.jsName + "?" + register.views [idx];
        cell.appendChild (link);
        if ( (idx + 1) < register.views) {
          cell.innerHTML += "<br/>";
        }
      }
    }
    row.appendChild (cell);
    // IAP
    pos++;
    cell = document.createElement ("td");
    if (register.indirectAccessPort.length > 0) {
      var iap = window [register.indirectAccessPort];
      link = document.createElement ("a");
      link.href = "iap.html?" + iap.jsName + "?" + iap.jsName;
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
    }
    row.appendChild (cell);
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.appendChild (document.createElement ("br"));
    generateReference (cell, register, register.jsName);
    row.appendChild (cell);
    // Append ROW
    body.appendChild (row);
  }
}

// ###############################################
// #####-------------------------------------#####
// #####--- REGISTER SCHEME / FIELD DESC. ---#####
// #####-------------------------------------#####
// ###############################################

function createRegisterScheme (table, register, viewName, searchRegExp, home) {
  var view = window [viewName];
  var viewDataWidth = vlogb2int (view.dataWidth [viewName]);
  if (viewDataWidth > 32) {
    viewDataWidth = 32;
  }
  var registerDataWidth0 = vlogb2int (register.dataWidth [register.jsName]);
  var registerDataWidth1 = vlogb2int (register.dataWidth [viewName]);
  var limit = Math.ceil (registerDataWidth1/viewDataWidth);
  var arrayOfArrays = splitFieldsArray (register.fields, registerDataWidth0, viewDataWidth);
  var valid;
  for (var outerIdx = arrayOfArrays.length - 1; outerIdx >= 0; outerIdx--) {
    if (outerIdx<limit) valid = true;
    else valid = false;
    createRegisterSchemeLine (table, arrayOfArrays [outerIdx], viewName,
                              viewDataWidth * (outerIdx + 1) - 1, viewDataWidth * outerIdx,
                              searchRegExp, home, valid);
  }
}
function createRegisterSchemeVALID (table, register, viewName, searchRegExp, home, validIdx) {
  var view = window [viewName];
  var viewDataWidth = vlogb2int (view.dataWidth [viewName]);
  var scaleIdx;
  if (viewDataWidth > 32) {
    scaleIdx = Math.ceil(viewDataWidth/32);
    viewDataWidth = 32;
  } else {
    scaleIdx = 1;
  }
  var registerDataWidth0 = vlogb2int (register.dataWidth [register.jsName]);
  //var registerDataWidth1 = vlogb2int (register.dataWidth [viewName]);
  //var limit = Math.ceil (registerDataWidth1/viewDataWidth);
  var arrayOfArrays = splitFieldsArray (register.fields, registerDataWidth0, viewDataWidth);
  var valid;
  for (var outerIdx = arrayOfArrays.length - 1; outerIdx >= 0; outerIdx--) {
    if (Math.floor(outerIdx/scaleIdx)==validIdx) valid = true;
    else valid = false;
    createRegisterSchemeLine (table, arrayOfArrays [outerIdx], viewName,
                              viewDataWidth * (outerIdx + 1) - 1, viewDataWidth * outerIdx,
                              searchRegExp, home, valid);
  }
}
function createRegisterSchemeLine (table, fieldsArray, viewName, posEnd,
    posStart, searchRegExp, home, valid) {
  var row;
  var cell;
  var idx;
  var _posEnd = posEnd;
  if (home === undefined) {
    home = "";
  }
  // create first numbering row
  // <tr class="schemenr"><td>31</td>...</tr>
  row = document.createElement ("tr");
  row.className = "schemenr";
  for (idx = _posEnd; idx >= posStart; idx--) {
    cell = document.createElement ("td");
    cell.innerHTML = idx.toString ();
    row.appendChild (cell);
  }
  table.appendChild (row);
  //////////////////////////
  // create scheme-top
  // <tr class="schemetop">
  // ...
  // <td class="field"></td>
  // <td class="field"></td>
  // <td class="resfield"></td>
  // <td class="resfield"></td>
  // ...
  // <tr class="schemetop">
  _posEnd = posEnd;
  row = document.createElement ("tr");
  row.className = "schemetop";
  for (idx = fieldsArray.length - 1; idx >= 0; idx--) {
    var field = window [fieldsArray [idx]];
    var fend = vlogb2int (field.addrEnd);
    var fstart = vlogb2int (field.addrStart);
    // check for reserved field (resfield)
    while (_posEnd > fend) {
      cell = document.createElement ("td");
      cell.className = "resfield";
      row.appendChild (cell);
      _posEnd--;
    }
    // generate field
    while (_posEnd >= fstart) {
      cell = document.createElement ("td");
      cell.className = "field";
      row.appendChild (cell);
      _posEnd--;
    }
  }
  // check for reserved field (resfield)
  while (_posEnd >= posStart) {
    cell = document.createElement ("td");
    cell.className = "resfield";
    row.appendChild (cell);
    _posEnd--;
  }
  table.appendChild (row);
  //////////////////////////
  // create scheme-inner
  // </tr>
  // <tr class="schemeinner">
  // <td class="field" colspan="10"><a href="#FREQ">FREQ</a></td>
  // <td class="resfield" colspan="20"></td>
  // <td class="field" colspan="1"><a href="#LOCK">LOCK</a></td>
  // <td class="field" colspan="1"><a href="#OFFHOOK">OFFHOOK</a></td>
  // </tr>
  _posEnd = posEnd;
  row = document.createElement ("tr");
  row.className = "schemeinner";
  if (valid==false) {
    row.className += "Invalid";
  }
  for (idx = fieldsArray.length - 1; idx >= 0; idx--) {
    field = window [fieldsArray [idx]];
    fend = vlogb2int (field.addrEnd);
    fstart = vlogb2int (field.addrStart);
    // check for reserved field (resfield)
    if (_posEnd > fend) {
      cell = document.createElement ("td");
      cell.className = "resfield";
      cell.colSpan = (_posEnd - fend).toString ();
      row.appendChild (cell);
      _posEnd -= _posEnd - fend;
    }
    // generate field
    cell = document.createElement ("td");
    cell.className = "field";
    cell.colSpan = (_posEnd - fstart + 1).toString ();
    var link = document.createElement ("a");
    link.href = home + "#" + field.aliasName;
    if (searchRegExp !== undefined) {
      link.innerHTML = highlightSearch (field.aliasName, searchRegExp);
    } else {
      link.innerHTML = field.aliasName;
    }
    cell.appendChild (link);
    row.appendChild (cell);
    _posEnd -= _posEnd - fstart + 1;
  }
  // check for reserved field (resfield)
  if (_posEnd >= posStart) {
    cell = document.createElement ("td");
    cell.className = "resfield";
    cell.colSpan = (_posEnd - posStart + 1).toString ();
    row.appendChild (cell);
    _posEnd = 0;
  }
  table.appendChild (row);
  //////////////////////////
  // create scheme-top
  // <tr class="schemebottom">
  // ...
  // <td class="field"></td>
  // <td class="field"></td>
  // <td class="resfield"></td>
  // <td class="resfield"></td>
  // ...
  // <tr class="schemetop">
  _posEnd = posEnd;
  row = document.createElement ("tr");
  row.className = "schemebottom";
  for (idx = fieldsArray.length - 1; idx >= 0; idx--) {
    field = window [fieldsArray [idx]];
    fend = vlogb2int (field.addrEnd);
    fstart = vlogb2int (field.addrStart);
    // check for reserved field (resfield)
    while (_posEnd > fend) {
      cell = document.createElement ("td");
      cell.className = "resfield";
      row.appendChild (cell);
      _posEnd--;
    }
    // generate field
    while (_posEnd >= fstart) {
      cell = document.createElement ("td");
      cell.className = "field";
      row.appendChild (cell);
      _posEnd--;
    }
  }
  // check for reserved field (resfield)
  while (_posEnd >= posStart) {
    cell = document.createElement ("td");
    cell.className = "resfield";
    row.appendChild (cell);
    _posEnd--;
  }
  table.appendChild (row);
  //////////////////////////
  // create scheme-ACCESS
  // </tr>
  // <tr class="schemenr">
  // <td colspan="10">RW</td>
  // <td colspan="20"></td>
  // <td colspan="1">W</td>
  // <td colspan="1">RH</td>
  // </tr>
  _posEnd = posEnd;
  row = document.createElement ("tr");
  row.className = "schemenr";
  fstart = 0;
  for (idx = fieldsArray.length - 1; idx >= 0; idx--) {
    field = window [fieldsArray [idx]];
    fend = vlogb2int (field.addrEnd);
    fstart = vlogb2int (field.addrStart);
    // check for reserved field (resfield)
    if (_posEnd > fend) {
      cell = document.createElement ("td");
      cell.colSpan = (_posEnd - fend).toString ();
      row.appendChild (cell);
      _posEnd -= _posEnd - fend;
    }
    // generate field
    cell = document.createElement ("td");
    cell.colSpan = (_posEnd - fstart + 1).toString ();
    cell.innerHTML = field.accessProperties [viewName].split (",", 2) [0];
    row.appendChild (cell);
    _posEnd -= _posEnd - fstart + 1;
  }
  // check for reserved field (resfield)
  if (_posEnd >= posStart) {
    cell = document.createElement ("td");
    cell.colSpan = (_posEnd - fstart + 1).toString ();
    row.appendChild (cell);
    _posEnd = 0;
  }
  table.appendChild (row);
  // RESET
  if (true) {
    //////////////////////////
    // create scheme-RESET
    // </tr>
    // <tr class="schemenr">
    // <td colspan="10">RW</td>
    // <td colspan="20"></td>
    // <td colspan="1">W</td>
    // <td colspan="1">RH</td>
    // </tr>
    _posEnd = posEnd;
    row = document.createElement ("tr");
    row.className = "schemenr";
    for (idx = fieldsArray.length - 1; idx >= 0; idx--) {
      field = window [fieldsArray [idx]];
      fend = vlogb2int (field.addrEnd);
      fstart = vlogb2int (field.addrStart);
      // check for reserved field (resfield)
      if (_posEnd > fend) {
        cell = document.createElement ("td");
        cell.colSpan = (_posEnd - fend).toString ();
        row.appendChild (cell);
        _posEnd -= _posEnd - fend;
      }
      // generate field
      cell = document.createElement ("td");
      cell.colSpan = (_posEnd - fstart + 1).toString ();
      cell.innerHTML = vlogb2bin (field.resetVal);
      row.appendChild (cell);
      _posEnd -= _posEnd - fstart + 1;
    }
    // check for reserved field (resfield)
    if (_posEnd >= posStart) {
      cell = document.createElement ("td");
      cell.colSpan = (_posEnd - fstart + 1).toString ();
      row.appendChild (cell);
      _posEnd = 0;
    }
    table.appendChild (row);
  }
  return;
}

function splitFieldsArray (_fieldsArray, widthOld, widthNew) {
  if (widthOld <= widthNew) {
    return (new Array (_fieldsArray));
  } else {
    var idx;
    var fieldsArray = new Array ();
    for (idx = 0; idx < _fieldsArray.length; idx++) {
      fieldsArray.push (_fieldsArray [idx]);
    }
    var arrays = new Array ();
    for (idx = 0; idx < Math.ceil (widthOld / widthNew); idx++) {
      arrays.push (new Array ());
    }
    var limit = 50;

    for (idx = 0; idx < fieldsArray.length; idx++) {
      var field = window [fieldsArray [idx]];
      var fstart = parseInt (vlogSplit (field.addrStart) [1], 2);
      var fend = parseInt (vlogSplit (field.addrEnd) [1], 2);
      // console.log("field="+fieldsArray[idx]+" fstart="+fstart.toString()+"
      // fend="+fend.toString());
      var posStart = Math.floor (fstart / widthNew);
      var posEnd = Math.floor (fend / widthNew);
      if (posStart == posEnd) {
        // console.log("add field");
        arrays [posStart].push (fieldsArray [idx]);
      } else {
        var newAddrEnd = (widthNew * (posStart + 1) - 1);
        var newAddrStart = (widthNew * (posStart + 1));

        // copy field array
        window [fieldsArray [idx] + "0"] = deepCopy (window [fieldsArray [idx]]);
        window [fieldsArray [idx] + "1"] = deepCopy (window [fieldsArray [idx]]);
        // set new values
        window [fieldsArray [idx] + "0"].addrEnd = "32'b"
            + padString (newAddrEnd.toString (2), "0", 32);
        window [fieldsArray [idx] + "0"].dataWidth = newAddrEnd
            - vlogb2int (window [fieldsArray [idx] + "0"].addrStart) + 1;
        window [fieldsArray [idx] + "1"].addrStart = "32'b"
            + padString (newAddrStart.toString (2), "0", 32);
        window [fieldsArray [idx] + "1"].dataWidth = vlogb2int (window [fieldsArray [idx]
            + "1"].addrEnd)
            - newAddrStart + 1;
        fieldsArray.splice (idx + 1, 0, fieldsArray [idx] + "1");
        fieldsArray [idx] = fieldsArray [idx] + "0";
        arrays [posStart].push (fieldsArray [idx]);
        limit--;
        if (limit === 0) {
          console.log ("LIMIT");
          return (arrays);
        }
      }
    }
    // console.log(fieldsArray);
    // console.log(arrays);
    return (arrays);
  }
}
