#ifndef LIB_ABB_API_H
#define LIB_ABB_API_H

// ----------------------------------------------------------------------------
// Copyright (c) 2018 Intel GmbH
// ----------------------------------------------------------------------------
// Revisions  :
// Date        Description
// 2017-05-02  D1p1
// 2017-05-16  D1p2
// 2017-09-25  D2p0
// 2017-10-25  D2p01
// 2018-02-16  LA1p1
// 2018-03-14  LA1p11
// 2018-04-12  LA1p2
// 2018-05-08  LA1p21
// 2018-05-24  LA1p3
// 2018-10-09  LA1p341
// 2019-01-14  LA1p351
// 2019-01-31  LA1p361

// ----------------------------------------------------------------------------

#include <stdint.h>

uint16_t abb_api_version(void);

// ---------------------------------------------------------
// Section: API DRIVER Functions
// ---------------------------------------------------------

void abb_central_fusing(uint8_t *fuse);
void abb_central_init_pll(void);
void abb_central_init_clkd(void);

// ---------------------------------------------------------
// Section: API FW Functions
// ---------------------------------------------------------

void abb_fcsirf(uint8_t sr, uint8_t smt, uint8_t drvstrength);
int16_t abb_rcmeas(int16_t *rccount, uint8_t dsmsel);
int8_t abb_adctune(int16_t count_calc, int8_t *rctune);
int8_t abb_rx_rctune(uint8_t *fuse);
void abb_antenna_init(uint16_t _ant_mask);
void abb_antenna_fusing(uint16_t _ant_mask, uint8_t *fuse);
int8_t abb_antenna_rx_calibration(uint16_t _ant_mask );
void abb_antenna_config(uint16_t _ant_mask, uint8_t abb_mode, int8_t rctune, int8_t qtrim);
void abb_antenna_rxoff_11ax(uint16_t _ant_mask);
void abb_antenna_rxoff2_11ax(uint16_t _ant_mask);
void abb_antenna_pd(uint16_t _ant_mask);
void abb_api_recal_ssi(uint16_t _ant_mask);

// ---------------------------------------------------------
// Section: LL API Functions
// ---------------------------------------------------------


//fcsi coverage central
void abb_api_fcsiwrite_softisolation_central(void);
int16_t abb_api_fcsiread_softisolation_central(void);


//fcsi coverage antenna
void abb_api_fcsiwrite_softisolation_antenna(uint16_t _ant_mask);
uint16_t abb_api_fcsiread_softisolation_antenna(uint16_t _ant_mask);


//central fsys
void abb_api_central_trim_ldo0v95fsys(uint8_t trim);


//central pll
void abb_api_init_central_pll_enable(void);
void abb_api_init_central_pll_bypass(void);
void abb_api_init_central_pll_enable_fcsicontrol(void);
void abb_api_central_trim_ldo0v95ref(uint8_t trim);
void abb_api_central_trim_ldo0v95post(uint8_t trim);
void abb_api_central_trim_vreg1v8hv(uint8_t trim);


//central bias
void abb_api_central_trim_bias(uint8_t vref, uint8_t iptat, uint8_t ibias);

//central clkd
void abb_api_init_central_pup_clkd(void);
void abb_api_init_central_pd_clkd(void);
void abb_api_central_trim_ldo0v95clkd(uint8_t trim);


//central fcsi
uint16_t abb_api_read_central_version(void);
uint16_t abb_api_read_lcpll_lock(void);
uint16_t abb_api_read_lcpll_prelock(void);


//central rcmeas
void abb_api_rcmeas_start(uint8_t polarity, uint8_t dsmsel);
void abb_api_rcmeas_default(void);
uint16_t abb_api_rcmeas_running(void);
uint16_t abb_api_rcmeas_finished(void);
uint16_t abb_api_read_rcmeas(void);


//antenna
void abb_api_init_ant(uint16_t _ant_mask);
void abb_api_ant_trim_daclb(uint16_t _ant_mask, uint8_t trim);
void abb_api_ant_trim_ldo0v95a(uint16_t _ant_mask, uint8_t trim);
void abb_api_ant_trim_ldo0v95d(uint16_t _ant_mask, uint8_t trim);
uint16_t abb_api_read_antenna_version(uint16_t _ant_mask);
void abb_api_pd_ant(uint16_t _ant_mask);


//tx
void abb_api_start_tx(uint16_t _ant_mask);
void abb_api_start_tx_lp(uint16_t _ant_mask);
void abb_api_standby_tx(uint16_t _ant_mask);


//rx
void abb_api_trim_rx_rctune(uint16_t _ant_mask, int8_t rctune);
uint16_t abb_api_read_rx_qt(uint16_t _ant_mask);
uint16_t abb_api_read_rx_qtcaldone(uint16_t _ant_mask);
uint16_t abb_api_read_rx_qtcalactive(uint16_t _ant_mask);
void abb_api_rx_set_mask_reset_overload(uint16_t _ant_mask, int8_t enable_mask_reset);
void abb_api_set_rx_rctune_qtrim(uint16_t _ant_mask, int8_t rctune, int8_t qtrim);
void abb_api_start_rx_11ax(uint16_t _ant_mask, int8_t rctune, int8_t qtrim);
void abb_api_start_rx_ssb(uint16_t _ant_mask, int8_t rctune, int8_t qtrim);
void abb_api_start_rx_lp(uint16_t _ant_mask, int8_t rctune, int8_t qtrim);
void abb_api_start_rx_loopback(uint16_t _ant_mask);
void abb_api_start_rx_lfsr(uint16_t _ant_mask);
void abb_api_start_rx_ts_lfsr(uint16_t _ant_mask);

void abb_api_standby_rx(uint16_t _ant_mask, int8_t rctune, int8_t qtrim);


//ssi
void abb_api_start_ssi(uint16_t _ant_mask);
void abb_api_start_ssi_lfsr(uint16_t _ant_mask);
void abb_api_standby_ssi(uint16_t _ant_mask);
int16_t abb_api_read_ssi_cal_comp(uint16_t _ant_mask);
void abb_api_ssi_enable_exton(uint16_t _ant_mask);
void abb_api_ssi_set_extssion(uint16_t _ant_mask, uint8_t ssion);
void abb_api_ssi_set_exttxon(uint16_t _ant_mask, uint8_t txon);
void abb_api_ssi_set_extrxon(uint16_t _ant_mask, uint8_t rxon);
void abb_api_ssi_disable_exton(uint16_t _ant_mask);


//dft
void abb_api_anamux_centralbias_RFIC1V8_atITRIM(void);
void abb_api_anamux_centralbias_ICONST_atITRIM(void);
void abb_api_anamux_centralbias_IPTAT_atITRIM(void);
void abb_api_anamux_centralbias_VBGP_atITRIM(void);
void abb_api_anamux_centralbias_disable(void);

void abb_api_anamux_clkd_VREFLDO_atVREF(void);
void abb_api_anamux_clkd_LDO0V95CLKD_atVREF(void);
void abb_api_anamux_clkd_disable(void);

void abb_api_anamux_lcpll_VREG1V8HV_atVREF(void);
void abb_api_anamux_lcpll_LDO0V95PLLREF_atVREF(void);
void abb_api_anamux_lcpll_LDO0V95PLLPOST_atVREF(void);
void abb_api_anamux_lcpll_ATESTOUT_atVREF(void);
void abb_api_anamux_lcpll_disable(void);

void abb_api_anamux_clkin_VREFLDO_atVREF(void);
void abb_api_anamux_clkin_LDO0V95FSYS_atVREF(void);
void abb_api_anamux_clkin_disable(void);

void abb_api_anamux_antbias_VREF0V95_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antbias_LDO0V95A_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antbias_LDO0V95D_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antbias_VSSAANT_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antbias_disable(uint8_t _ant_mask);

void abb_api_anamux_antssi_vrefp_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antssi_vrefn_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antssi_vcm_r_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antssi_vcm_atVREF(uint8_t _ant_mask);
void abb_api_anamux_antssi_disable(uint8_t _ant_mask);


#endif

