//###############################################
//#####-------------------------------------#####
//#####------ PORTS TABLE -------------#####
//#####-------------------------------------#####
//###############################################
function createBusesTable0Init (busArray, viewName, identifier) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");

  head.innerHTML += createToggleImage (identifier);

  var tableStatus = new TableStatus (9);
  // TABLE: | View Addresses {START & END} | Local Addresses {START & END} |
  // Module | BusName | Long Name | Bus protocol | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  tableStatus.sortEnabled [1] = false;
  tableStatus.sortEnabled [3] = false;
  tableStatus.sortTypes [0] = "number";
  tableStatus.sortTypes [2] = "number";
  tableStatus.sortClassNames [1] = "hiddenCell";
  tableStatus.sortClassNames [3] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  tableStatus.filterEnabled [1] = false;
  tableStatus.filterEnabled [3] = false;
  tableStatus.filterTypes [0] = "number";
  tableStatus.filterTypes [2] = "number";
  tableStatus.filterSet [0] = ">=0";
  tableStatus.filterSet [2] = ">=0";
  tableStatus.filterClassNames [1] = "hiddenCell";
  tableStatus.filterClassNames [3] = "hiddenCell";
  // combine
  tableStatus.combineCell [4] = true;
  tableStatus.combineCell [7] = true;

  tableStatus.hookFunctionName = "hookBusTable0";

  tableStatus.enableModuleColumn = false;

  window [tableStatus.id] = tableStatus;

  hookBusTable0 (body, busArray, viewName, tableStatus);
}

function hookBusTable0 (tableReference, busArray, viewName, tableStatus) {
  // generate data array
  buildBusTable0Array (busArray, viewName, tableStatus);
  // generate table
  createBusTable0 (tableReference, busArray, viewName, tableStatus);
}

function buildBusTable0Array (busArray, viewName, tableStatus) {
  // TABLE: | View Addresses {START & END} | Local Addresses {START & END} |
  // Module | BusName | Long Name | Bus protocol | Description |
  var bodyArray = new Array;
  // build bodyArray
  for (var idx = busArray.length - 1; idx >= 0; idx--) {
    bodyArray [idx] = new Array;
    var bus = window [busArray [idx]];
    // View Address START
    var pos = 0;
    bodyArray [idx] [pos] = "32'b" + getViewAddrStart (bus, viewName).toString (2);
    // View Address END
    pos++;
    bodyArray [idx] [pos] = "32'b" + getViewAddrEnd (bus, viewName).toString (2);
    // Local Address START
    pos++;
    bodyArray [idx] [pos] = bus.addrStart [busArray [idx]];
    // Local Address END
    pos++;
    bodyArray [idx] [pos] = bus.addrEnd [busArray [idx]];
    // Module
    pos++;
    bodyArray [idx] [pos] = window [bus.parent].aliasName;
    // Name
    pos++;
    bodyArray [idx] [pos] = bus.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = bus.longName;
    // Bus Protocol
    pos++;
    bodyArray [idx] [pos] = bus.busProtocol;
    // Description
    pos++;
    bodyArray [idx] [pos] = bus.description;
    // Bus reference
    pos++;
    bodyArray [idx] [pos] = bus;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createBusTable0 (tableReference, busArray, viewName, tableStatus) {
  // TABLE: | View Addresses {START & END} | Local Addresses {START & END} |
  // Module | BusName | Long Name | Bus protocol | Description |
  var body = tableReference;
  var bodyCells = tableStatus.tableArray;
  var headerCells = [ "View Address<br/>Start:End", "", "Local Address<br/>Start:End", "",
                      "Module", "Name", "Long Name", "Bus Protocol", "Description"];
  var row;
  var cell;
  var link;
  // create header
  createSortableHeader (body, headerCells, busArray, viewName, tableStatus);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    createFilterInput (body, busArray, viewName, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    refreshFilterInput2 (body, tableStatus);
  }

  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var bus = bodyCells [line] [bodyCells [line].length - 4];
    var isView = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];
    var addrStart;
    var addrEnd;
    row = document.createElement ("tr");
    if (line % 2 === 0) {
      row.className = "interleave";
    }

    // View Start Address START:END
    var pos = 0;
    addrStart = vlogb2bin (bodyCells [line] [pos]);
    addrEnd = vlogb2bin (bodyCells [line] [pos + 1]);
    cell = createNrTableCellRange (addrEnd, addrStart, 32, "hex");
    // cell.className = bodyCells[line][pos];
    row.appendChild (cell);
    // HIDDEN CELL
    pos++;
    cell = document.createElement ("td");
    cell.className = "hiddenCell";
    row.appendChild (cell);
    // Local Start Address START:END
    pos++;
    addrStart = vlogb2bin (bodyCells [line] [pos]);
    addrEnd = vlogb2bin (bodyCells [line] [pos + 1]);

    cell = createNrTableCellRange (addrEnd, addrStart, 32, "hex");
    // cell.className = bodyCells[line][pos];
    row.appendChild (cell);
    // HIDDEN CELL
    pos++;
    cell = document.createElement ("td");
    cell.className = "hiddenCell";
    row.appendChild (cell);
    // Module
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      link = document.createElement ("a");
      link.href = "module.html?" + window [bus.parent].jsName;
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
      row.appendChild (cell);
    }
    // Name
    pos++;
    cell = document.createElement ("td");
    if (bus.isCollapsedIntoPort) {
      cell.innerHTML = bodyCells [line] [pos];
    } else {
      cell.className = "emph";
      link = document.createElement ("a");
      link.href = "bus.html?" + bus.jsName + "?" + viewName;
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
    }
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Bus Protocol
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = bodyCells [line] [pos];
      row.appendChild (cell);
    }
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.appendChild (document.createElement ("br"));
    generateReference (cell, bus, bus.jsName);
    row.appendChild (cell);

    // Append ROW
    body.appendChild (row);
  }
}

function createBusesTable1Init (busArray, identifier) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");

  if (head !== null) {
    head.innerHTML += createToggleImage (identifier);
  }

  var tableStatus = new TableStatus (8);
  // TABLE: | Module | BusName | Long Name | Views on this Bus
  //        | Bus protocol | #MPs | #SPs | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  tableStatus.sortEnabled [3] = false;
  tableStatus.sortTypes [5] = "number";
  tableStatus.sortTypes [6] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  tableStatus.filterEnabled [5] = false;
  tableStatus.filterEnabled [6] = false;
  // tableStatus.filterTypes [X] = "number";
  // tableStatus.filterSet [X] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  tableStatus.combineCell [0] = true;
  tableStatus.combineCell [4] = true;

  tableStatus.hookFunctionName = "hookBusTable1";

  tableStatus.enableModuleColumn = false;

  window [tableStatus.id] = tableStatus;

  hookBusTable1 (body, busArray, null, tableStatus);
}

function hookBusTable1 (tableReference, busArray, viewName, tableStatus) {
  // generate data array
  buildBusTable1Array (busArray, viewName, tableStatus);
  // generate table
  createBusTable1 (tableReference, busArray, tableStatus);
}

function buildBusTable1Array (busArray, viewName, tableStatus) {
  // TABLE: | Module | BusName | Long Name | Views on this Bus
  //        | Bus protocol | #MPs | #SPs | Description |
  var bodyArray = new Array;

  // build bodyArray
  for (var idx = busArray.length - 1; idx >= 0; idx--) {

    var bus = window [busArray [idx]];

    if (bus === undefined) {
      console.log ("HERE A DEBUG MESSAGE MUST BE CREATED TO INFORM THE USER THAT THE BUS IS NOT IN ANY VIEW");
      continue;
    }

    bodyArray [idx] = new Array;
    // Module
    var pos = 0;
    bodyArray [idx] [pos] = window [bus.parent].aliasName;
    // Name
    pos++;
    bodyArray [idx] [pos] = bus.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = bus.longName;
    // Views on this Bus
    pos++;
    bodyArray [idx] [pos] = "";
    for (var i = 0; i < bus.views.length; i++) {
      bodyArray [idx] [pos] += getAliasContextName (window [bus.views [i]], false);
      if ( (i + 1) < bus.views.length) {
        bodyArray [idx] [pos] += " ";
      }
    }
    // Bus Protocol
    pos++;
    bodyArray [idx] [pos] = bus.busProtocol;
    // Number of Master Ports
    pos++;
    bodyArray [idx] [pos] = bus.masterPorts.length.toString ();
    // Number of Slave Ports
    pos++;
    bodyArray [idx] [pos] = bus.slavePorts.length.toString ();
    // Description
    pos++;
    bodyArray [idx] [pos] = bus.description;
    // Bus reference
    pos++;
    bodyArray [idx] [pos] = bus;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createBusTable1 (tableReference, busArray, tableStatus) {
  // TABLE: | Module | BusName | Long Name | Views on this Bus
  //        | Bus protocol | #MPs | #SPs | Description |
  var body = tableReference;
  var bodyCells = tableStatus.tableArray;

  var one = document.createElement ("sup");
  one.innerHTML = "1";
  var two = document.createElement ("sup");
  two.innerHTML = "2";
  // Module Name Long Name "Views on this Bus" #MPs #SPs Description
  var container0 = document.createElement ("span");
  container0.appendChild (document.createTextNode ("MPs"));
  container0.appendChild (one);
  var container1 = document.createElement ("span");
  container1.appendChild (document.createTextNode ("SPs"));
  container1.appendChild (two);
  var headerCellNames = [ "Module", "Name", "Long Name", "Views on this Bus",
      "Bus Protocol", container0.innerHTML, "SPs" + container1.innerHTML,
      "Description" ];
  var headerCellTitles = [ "", "", "", "", "", "Number of Master Ports",
      "Number of Slave Ports", "" ];
  var row;
  var cell;
  var link;
  // create caption
  var caption = document.createElement ("caption");
  caption.appendChild (one);
  caption.appendChild (document.createTextNode ("Number of Master Ports "));
  caption.appendChild (two);
  caption.appendChild (document.createTextNode ("Number of Slave Ports "));
  body.appendChild (caption);

  // create header
  row = document.createElement ("tr");
  for (pos in headerCellNames) {
    cell = document.createElement ("th");
    cell.className = tableStatus.sortClassNames [pos];
    cell.title = headerCellTitles [pos];
    cell.innerHTML = headerCellNames [pos];
    if (tableStatus.sortEnabled [pos] === true) {
      createSortHook (body, cell, pos, busArray, null, tableStatus);
    }
    row.appendChild (cell);
  }
  body.appendChild (row);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    createFilterInput (body, busArray, null, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    refreshFilterInput2 (body, tableStatus);
  }

  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    if (bodyCells [line] [0] === undefined) {
      continue;
    }
    var bus = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];

    row = document.createElement ("tr");
    if (line % 2 === 0) {
      row.className = "interleave";
    }

    // Module
    var pos = 0;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.title = getAliasContextName (window [bus.parent], true);
      link = document.createElement ("a");
      link.href = "module.html?" + window [bus.parent].jsName;
      link.innerHTML = bodyCells [line] [pos];
      cell.appendChild (link);
      row.appendChild (cell);
    }
    // Name
    pos++;
    cell = document.createElement ("td");
    cell.className = "emph";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Views on this Bus
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = "";
      if (bus.isCollapsedIntoPort == false) {
        for (var idx = 0; idx < bus.views.length; idx++) {
          var bold = document.createElement ("b");
          bold.innerHTML = getAliasContextName (window [bus.views [idx]], false);
          link = document.createElement ("a");
          link.appendChild (bold);
          link.appendChild (document.createTextNode ("." + getAliasContextName (bus, false)));
          link.href = "bus.html?" + bus.jsName + "?" + bus.views [idx];
          cell.appendChild (link);
          if ( (idx + 1) < bus.views.length) {
            cell.innerHTML += "<br/>";
          }
        }
      }
      row.appendChild (cell);
    }
    // Bus Protocol
    pos++;
    if (rowSpans [pos] !== null) {
      cell = document.createElement ("td");
      cell.className = classNames [pos];
      cell.rowSpan = rowSpans [pos];
      cell.innerHTML = bodyCells [line] [pos];
      row.appendChild (cell);
    }
    // Number of Master Ports
    pos++;
    cell = document.createElement ("td");
    cell.style.textAlign = "right";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Number of Slave Ports
    pos++;
    cell = document.createElement ("td");
    cell.style.textAlign = "right";
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.appendChild (document.createElement ("br"));
    generateReference (cell, bus, bus.jsName);
    row.appendChild (cell);
    // Append ROW
    body.appendChild (row);
  }
}
