// ----------------------------------------------------------------------------
// Project    : WAVE600
// ----------------------------------------------------------------------------
// File       : lib_abb_tb.c
// Author     : Pridnig Peter
// Created    : 2017-03-24
// Standard   : Sytem Verilog
// ----------------------------------------------------------------------------
// Copyright (c) 2016 Intel GmbH
// ----------------------------------------------------------------------------
// Revisions  :
// Date        Version  Author    Description
// 2017-05-02  1.0      Pridnig   D1p1
// ----------------------------------------------------------------------------
// History    :
// 2017-05-26 updated op_freq_sel_sc_d2a DIRECT_WRITES bus access

#include <stdint.h>
#include <stdio.h>
#include "target.h"
#include "fcsvtb_fcsi2_n_dpi.h"  // defines for "_config"
#include "abb_tb_defines.h"
#include "interface_abb.h"

// Register Mirror Dummy
void *ABB_fcsi_mirror = 0; 

void tb_set_all_gp_outs(int Value)
{
  int i_max     = GPIO_PORT_WIDTH / 32;
  int remainder = GPIO_PORT_WIDTH % 32;

  for (int i = 0; i < i_max; i++) {
    _ports_set(32*i, 32, Value);
    debug_printf("imax: %d, rem: %d, loop: %d\n", i_max, remainder, i);

  }
  while (remainder > 0) {
    _port_set(GPIO_PORT_WIDTH-remainder, Value);
    remainder--;
  }
}


void init_abb_tb (void)
{

  // Configuring printouts
  dpi_io_config(DPI_CFG_PRINT_IDX,0); // switch off detailed io printout from C
  dpi_io_v_config(0);                 // switch off detailed io printout from Verilog !

  /*_config_set(FCSI2_N_CONFIG_IDX_RDDELAY,1);

  _out_n_cfg(NR_OF_ANTENNAS); // this must match with SV parameter amount of fcsi "ports"

  _config_set(FCSI2_N_CONFIG_IDX_ENABMASK,(1<<NR_OF_ANTENNAS)-1);*/

//  tb_set_all_gp_outs(0);
//  _wait(1, T_USEC);

  
 //DEACTIVATE ASSERTIONS 
 ABB_DIR_CTRL_WRITE(ASSERT_clk_sc_a2d_640m,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_clk_sc_a2d_320m,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_clk_sc_a2d_160m,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_clk_sc_a2d_80m,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_clk_sc_a2d_480m,0x0);
 
 ABB_DIR_CTRL_WRITE(ASSERT_ant2_clk2g56_dac_p_o_2g56,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_ant2_clk2g56_adc_p_o_2g56,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_ant2_strb160m_adc_o_160m,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_ant2_strb160m_dac_o_160m,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_ant2_clk640m_ssi_o_640m,0x0); 
 ABB_DIR_CTRL_WRITE(ASSERT_ant2_ibias_iptat,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_ant2_ldoa_ldod,0x0);
 
 ABB_DIR_CTRL_WRITE(ASSERT_clk_o_se_s_160m,0x0);
 ABB_DIR_CTRL_WRITE(ASSERT_clk_o_p_s_2g56,0x0);
 
 //RESET FLAGS
 ABB_DIR_CTRL_WRITE(FLAG_gp_1,0x0);
  
 //FCSI FORCE DEFAULT
 ABB_DIR_CTRL_WRITE(FCSI2_FORCE_DEFAULT_0,0);
 ABB_DIR_CTRL_WRITE(FCSI2_FORCE_DEFAULT_1,0);
 ABB_DIR_CTRL_WRITE(FCSI2_FORCE_DEFAULT_2,0);
 ABB_DIR_CTRL_WRITE(FCSI2_FORCE_DEFAULT_3,0);
 ABB_DIR_CTRL_WRITE(FCSI2_FORCE_DEFAULT_C,0); 
 _wait(0.1,T_USEC);
  
 //FCSI RESET
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_0,0);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_1,0);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_2,0);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_3,0);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_C,0);
 _wait(0.8,T_USEC);

 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_0,1);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_1,1);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_2,1);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_3,1);
 ABB_DIR_CTRL_WRITE(FCSI2_RST_N_C,1);
 _wait(0.1,T_USEC); 

 //BURST CONTROL OFF
 ABB_DIR_CTRL_WRITE(burst_resetn,0x0);
 ABB_DIR_CTRL_WRITE(burst_enable,0x0);
 ABB_DIR_CTRL_WRITE(burst_on_tx,0x0);
 ABB_DIR_CTRL_WRITE(burst_on_rx,0x0);
 ABB_DIR_CTRL_WRITE(burst_on_ssi,0x0);
 
 //DUMP CONTROL OFF
 ABB_DIR_CTRL_WRITE(dump_tx,0x0);
 ABB_DIR_CTRL_WRITE(dump_ssi,0x0);
 ABB_DIR_CTRL_WRITE(dump_rx,0x0);
 
 //CLOCK ENABLES OFF
 ABB_DIR_CTRL_WRITE(ENABLE_CLK_IN,0x0);
 ABB_DIR_CTRL_WRITE(ENABLE_FSYS,0x0);
 ABB_DIR_CTRL_WRITE(BB_CLKSRC,0x0);
 ABB_DIR_CTRL_WRITE(ENABLE_BB_CLKIN,0x0);

 //DIRECT CONTROLS DEFAULT
 ABB_DIR_CTRL_WRITE(lcpll_pup_d2a,0x0);
 ABB_DIR_CTRL_WRITE(lcpll_resn_d2a,0x0);  
 ABB_DIR_CTRL_WRITE(pd_clk_sc_d2a,0x1);
 ABB_DIR_CTRL_WRITES(op_freq_sel_sc_d2a,2,0x0);
 ABB_DIR_CTRL_WRITE(lcpll_div_d2a,0x0);
 ABB_DIR_CTRL_WRITES(spare_config_i_d2a,8,0x0);
 
}
