#ifndef LIB_ABB11AC_API_H
#define LIB_ABB11AC_API_H

//#ifdef simulation
    #define DEL_PLLUP		15    // in us
    #define DEL_LCLOCKMIN	70    // in us; in worst case 500us; 
    #define DEL_LDOUP		2     // in us;
/*#else
    #define DEL_PLLUP		15    // in us
    #define DEL_LCLOCK		500    // in us; in worst case 500us; 
    #define DEL_LDOUP		2     // in us;
#endif*/

#include <stdint.h>





// central functions
void abb11ac_switchoff_lcpll_op_buf_pdn(void);
void abb11ac_init(void);
void abb11ac_release_resetn_fcsi(void);
void abb11ac_pllsettings(void);
void abb11ac_pll_pup(void);
void abb11ac_pll_release_reset(void);
void abb11ac_pup_clkldo(void);
void abb11ac_pup_clkdistribution(void);

// antenna functions
void abb11ac_init1_antenna(int antenna);
void abb11ac_init2_antenna(int antenna);

// TX-DAC functions
void abb11ac_pup_dacmatrix(int antenna);
void abb11ac_pup_dacbuf(int antenna);
void abb11ac_release_resetn_dac(int antenna);
void abb11ac_dac_11ac_mode(int antenna);
void abb11ac_release_resetn_txiq(int antenna);
void abb11ac_set_tx_on(int antenna);
void abb11ac_set_tx_data_valid(int antenna);
void abb11ac_TXDAC_default(int antenna);

// SSI functions
void abb11ac_SSI_init(int antenna);
void abb11ac_set_ssi_on(int antenna);
void abb11ac_SSIADC_default(int antenna);

// RX-ADC functions
void abb11ac_ensleep_on_rxadc(int antenna);
void abb11ac_config_rx_adc(int antenna, int ctune);
void abb11ac_release_resetn_rxiq(int antenna);
void abb11ac_set_rx_on(int antenna);
void abb11ac_RXADC_default(int antenna);

// rcmeas
int abb11ac_rcmeas(uint16_t *rccount);
uint16_t abb11ac_rcmeas_read_measdone(uint16_t *countval);
void abb11ac_rcmeas_default(void);
int abb11ac_adctune(uint16_t count_calc, uint16_t count_nom, uint16_t* ctune);
/*void abb11ac_rcmeas1(void);
uint16_t abb11ac_rcmeas2(void);
uint16_t abb11ac_rcmeas3(uint16_t countval1);*/

void abb11ac_observe_vref_iref(void);
void abb11ac_observe_biasldo(void);
void abb11ac_observe_pll(int diagmodsel);
void abb11ac_observe_mosmeas_vref_iref(void);
void abb11ac_observe_antldo(int antindex);
void abb11ac_observe_antssi_vref(int antindex);
void abb11ac_observe_antssi_vcm(int antindex);
void abb11ac_observe_fsysldo(void);
void abb11ac_observe_clkldo(void);
void abb11ac_observe_default(void);

void abb11ac_anamux_central_programming(int value);
void abb11ac_anamux_central_antsel(int value);

void abb11ac_bias_softfuse(int vref, int iref);

// void abb11ac_adc_efuse(int antenna, int ctune, int clkinv);

void abb11ac_antenna_default(int antenna);

void abb11ac_rffcsi(int value_smt, int value_sr, int value_e);
void abb11ac_rf_oen(int value);
void abb11ac_rf_usb(int value);

void abb11ac_anamux_ant_sel(int antenna, int value);

void abb11ac_ssi_test(int antenna);

void abb11ac_central_init(void);
void abb11ac_antenna_init(int antenna);

void abb11ac_ant_config(int antenna, int bandwidth, \
int ctune);

void abb11ac_ssi_se_mode(int antenna);

void abb11ac_ssi_diff_mode(int antenna);

void abb11ac_reset_FCSI_central();
void abb11ac_reset_FCSI_antenna();
void abb11ac_reset_FCSI();
void abb11ac_reset_pulse_dac(int antenna);

void abb11ac_antenna_fuse_values(int antenna, int adc_clkinv);
int abb11ac_fusing(uint8_t *fuse);

// sequences
int abb11ac_pllpup_sequence(void);
int abb11ac_ABB_pup_sequence(uint8_t * fuse);

#endif
