function SPI_WRITE(param1,param2)



%dir_ctrl_name = [param1 param2 param3]);

X = sprintf('param:  0x%04x  data: 0x%04x ', param1, param2);
disp(X);

regAddress = 0;
bitPosition = 0;
bitInv = 0;
bitMask = 0;
% param1 = 'lcpll_op_buf_pdn_d2a';
% param2 = '1F';

sec_write = 0;

switch(param1)
    case 193    %lcpll_bypass_d2a
        regAddress = '00000048';
        bitPosition = 9;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_bypass_d2a';
        
    case 194    %lcpll_pup_d2a
        regAddress = '00000048';
        bitPosition = 7;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_pup_d2a';
        
    case 203                             % clk1
        regAddress = '00000044';
        bitPosition = 0;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_op_buf_pdn_d2a_clk1';
    case 204                             % clk2
        regAddress = '00000044';
        bitPosition = 1;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_op_buf_pdn_d2a_clk2';
    case 205                             % clk3
        regAddress = '0000044';
        bitPosition = 4;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_op_buf_pdn_d2a_clk3';
    case 206                             % clk4
        regAddress = '0000044';
        bitPosition = 3;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_op_buf_pdn_d2a_clk4';
    case 207                             % clk5
        regAddress = '00000044';
        bitPosition = 2;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_op_buf_pdn_d2a_clk5';

    case 218    %lcpll_resetn_d2a
        regAddress = '00000048';
        bitPosition = 8;
        sec_write = 1;
        dir_ctrl_name = 'lcpll_resetn_d2a';

    case 'lcpll_divider_int_d2a'
        regAddress = '00180040';
        bitPosition = 16;

        dir_ctrl_name = 'lcpll_divider_int_d2a';
    case 'lcpll_divider_int_d2a'
        regAddress = '00180040';
        bitPosition = 16;

        dir_ctrl_name = 'lcpll_divider_int_d2a';
    case 'lcpll_op_buf_pdn_d2a'
        regAddress = '00180040';
        bitPosition = 16;

        dir_ctrl_name = 'lcpll_op_buf_pdn_d2a';
    case 250
        regAddress = '300104dc';
        bitPosition = 0;
        dir_ctrl_name = 'FCSI2_RST_N_0';

    case 251
        regAddress = '300104dc';
        bitPosition = 0;
        dir_ctrl_name = 'FCSI2_RST_N_1';

    case 252
        regAddress = '300104dc';
        bitPosition = 0;
        dir_ctrl_name = 'FCSI2_RST_N_2';

    case 253
        regAddress = '300104dc';
        bitPosition = 0;
        dir_ctrl_name = 'FCSI2_RST_N_3';

    case 254
        regAddress = '300104dc';
        bitPosition = 0;
        dir_ctrl_name = 'FCSI2_RST_N_C';

    otherwise
        error('spi_write : dir_cntrl_name not found')
end   

bitMask = bitshift(1,bitPosition);
bitData = bitshift(param2,bitPosition);



       
        %          195
        %   lcpll_op_buf_pdn_d2a        203
        %   lcpll_op_freq_sel_clk1_d2a  208
        %   lcpll_op_freq_sel_clk2_d2a  210
        %   lcpll_op_freq_sel_clk3_d2a  212
        %   lcpll_op_freq_sel_clk4_d2a  214
        %   lcpll_op_freq_sel_clk5_d2a  216
        %   lcpll_resetn_d2a            218
        %   usb_spnd_wup_d2a            219
        %   lcpll_scan_rstn             220
        %   lcpll_scan_enable           221
        %   lcpll_scan_mode             222
        %   lcpll_scan_clk              223
        %   fcsi_rf_dout0               224
        %   fcsi_rf_dout1               225
        %   fcsi_rf_dout2               226
        %   fcsi_rf_dout3               227
        %   fcsi_rf_en                  228
        %   fcsi_rf_oen                 229
        %   fcsi_rf_resetq              230
        %
        % % direct observe signals
        %   FCSI_CTLIFCLK               231
        %   FCSI_RESET_Q                232
        %   USB_SPND                    233
        %   lcpll_clkout1_cmos_a2d      234
        %   lcpll_clkout2_cmos_a2d      235
        %   lcpll_clkref_cml_p_a2d      236
        %   lcpll_clkref_cml_n_a2d      237
        %   clkref_cmos_a2d             238
        %   lcpll_lock_a2d              239

        if sec_write == 1
            %adds 0x00180000 automatically
            disp([dir_ctrl_name ' r:' regAddress ' m:' dec2hex(bitMask) ' d:' dec2hex(bitData) ' - secure' ]);
            secure_write(regAddress,bitData,bitMask);
        else
            disp([dir_ctrl_name ' r:' regAddress ' m:' dec2hex(bitMask) ' d:' dec2hex(bitData)])
            hyp_write(regAddress,bitData,bitMask) ;
        end
        
end