#include "mex.h"
#include <math.h>
#include "lib_abb11ac_api.c"
#include "lib_abb11ac_api.h"
// The gateway function
void mexFunction( int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[])
{
    double_t *lhparam;
    char *input_buf;
    int count_calc,count_nom, countvalue, countval1;
    int antenna;
    int value;
    int vref;
    int result;
    int iref, diagmodsel,antinex,antindex;
    int ctune[2];
    int value_smt, value_sr, value_e;
    int bandwidth, ctune40M,ctune20M, adc_clkinv;
    input_buf = mxArrayToString(prhs[0]);
    plhs[0] = mxCreateDoubleMatrix(1,3, mxREAL);
    lhparam = mxGetPr(plhs[0]);
    mexPrintf("Input Function: %s\n", input_buf );
    //***************central functions********************************
    if (0 == strcmp(input_buf,"abb11ac_switchoff_lcpll_op_buf_pdn"))// the strings are equal
    {
        mexPrintf("calling abb11ac_switchoff_lcpll_op_buf_pdn \n");
        abb11ac_switchoff_lcpll_op_buf_pdn();
        
    }
    else if (0 == strcmp(input_buf,"abb11ac_init"))// the strings are equal
    {
        mexPrintf("calling abb11ac_init \n");
        abb11ac_init();
    }
    else if (0 == strcmp(input_buf,"abb11ac_release_resetn_fcsi"))// the strings are equal
    {
        mexPrintf("abb11ac_release_resetn_fcsi\n");
        abb11ac_release_resetn_fcsi();
    }
    else if (0 == strcmp(input_buf,"abb11ac_pllsettings"))// the strings are equal
    {
        mexPrintf("abb11ac_pllsettings\n");
        abb11ac_pllsettings();
    }
    else if (0 == strcmp(input_buf,"abb11ac_pll_pup"))// the strings are equal
    {    mexPrintf("abb11ac_pll_pup\n");
         abb11ac_pll_pup();
    }
    else if (0 == strcmp(input_buf,"abb11ac_pll_release_reset"))// the strings are equal
    {      mexPrintf("abb11ac_pll_release_reset\n");
           abb11ac_pll_release_reset();
    }
    else if (0 == strcmp(input_buf,"abb11ac_pup_clkldo"))// the strings are equal
    {      mexPrintf("abb11ac_pup_clkldo\n");
           abb11ac_pup_clkldo();
    }
    else if (0 == strcmp(input_buf,"abb11ac_pup_clkdistribution"))// the strings are equal
    {      mexPrintf("abb11ac_pup_clkdistribution\n");
           abb11ac_pup_clkdistribution();
    }
    //**********************antenna functions*******************
    else if (0 == strcmp(input_buf,"abb11ac_init1_antenna"))// the strings are equal
    {      mexPrintf("abb11ac_init1_antenna\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_init1_antenna(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_init2_antenna"))// the strings are equal
    {      mexPrintf("abb11ac_init2_antenna\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_init2_antenna(antenna);
    }
    //********************TX-DAC functions****************************
    else if (0 == strcmp(input_buf,"abb11ac_pup_dacmatrix"))// the strings are equal
    {      mexPrintf("abb11ac_pup_dacmatrix\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_pup_dacmatrix(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_pup_dacbuf"))// the strings are equal
    {      mexPrintf("abb11ac_pup_dacbuf\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_pup_dacbuf(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_release_resetn_dac"))// the strings are equal
    {      mexPrintf("abb11ac_release_resetn_dac\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_release_resetn_dac(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_dac_11ac_mode"))// the strings are equal
    {      mexPrintf("abb11ac_dac_11ac_mode\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_dac_11ac_mode(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_release_resetn_txiq"))// the strings are equal
    {      mexPrintf("abb11ac_release_resetn_txiq\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_release_resetn_txiq(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_set_tx_on"))// the strings are equal
    {     mexPrintf("abb11ac_set_tx_on\n");
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_set_tx_on(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_set_tx_data_valid"))// the strings are equal
    {     mexPrintf("abb11ac_set_tx_data_valid\n");
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_set_tx_data_valid(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_TXDAC_default"))// the strings are equal
    {      mexPrintf("abb11ac_TXDAC_default\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_TXDAC_default(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_TXDAC_reset_pin_controls"))// the strings are equal
    {      mexPrintf("abb11ac_TXDAC_reset_pin_controls\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_TXDAC_reset_pin_controls(antenna);
    }
    //******************SSI functions************************
    else if (0 == strcmp(input_buf,"abb11ac_SSI_init"))// the strings are equal
    {     mexPrintf("abb11ac_SSI_init\n");
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_SSI_init(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_set_ssi_on"))// the strings are equal
    {     mexPrintf("abb11ac_set_ssi_on\n");
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_set_ssi_on(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_SSIADC_default"))// the strings are equal
    {     mexPrintf("abb11ac_SSIADC_default\n");
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_SSIADC_default(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_SSIADC_reset_pin_controls"))// the strings are equal
    {     mexPrintf("abb11ac_SSIADC_reset_pin_controls\n");
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_SSIADC_reset_pin_controls(antenna);
    }
    //***********RX-ADC functions***************************
    else if (0 == strcmp(input_buf,"abb11ac_ensleep_on_rxadc"))// the strings are equal
    {     mexPrintf("abb11ac_ensleep_on_rxadc\n");
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_ensleep_on_rxadc(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_config_rx_adc"))// the strings are equal
    {      mexPrintf("abb11ac_config_rx_adc\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_config_rx_adc(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_release_resetn_rxiq"))// the strings are equal
    {      mexPrintf("abb11ac_release_resetn_rxiq\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_release_resetn_rxiq(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_set_rx_on"))// the strings are equal
    {      mexPrintf("abb11ac_set_rx_on\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_set_rx_on(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_RXADC_default"))// the strings are equal
    {      mexPrintf("abb11ac_RXADC_default\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_RXADC_default(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_RXADC_reset_pin_controls"))// the strings are equal
    {      mexPrintf("abb11ac_RXADC_reset_pin_controls\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_RXADC_reset_pin_controls(antenna);
    }
    //**************** rcmeas *******************************
    else if (0 == strcmp(input_buf,"abb11ac_rcmeas1"))// the strings are equal
    {      mexPrintf("abb11ac_rcmeas1\n");
           abb11ac_rcmeas1();
    }
    else if (0 == strcmp(input_buf,"abb11ac_rcmeas2"))// the strings are equal
    {     mexPrintf("abb11ac_rcmeas2\n");
          countval1 = abb11ac_rcmeas2();
          lhparam[0] = countval1;
          mexPrintf("countval1: %d\n", count_calc );
          
    }
    else if (0 == strcmp(input_buf,"abb11ac_rcmeas3"))// the strings are equal
    {      mexPrintf("abb11ac_rcmeas3\n");
           countval1 = (int) mxGetScalar(prhs[1]);
           mexPrintf("countval1: %d\n", countval1 );
           count_calc = abb11ac_rcmeas3(countval1);
           lhparam[0] = count_calc;
           mexPrintf("count_calc: %d\n", count_calc );
           
    }
    else if (0 == strcmp(input_buf,"abb11ac_rcmeas_read_measdone"))// the strings are equal
    {
        mexPrintf("abb11ac_rcmeas_read_measdone\n");
        countvalue = abb11ac_rcmeas_read_measdone();
        lhparam[0] = countvalue;
        mexPrintf("countvalue : %d\n", countvalue );
        
    }
    else if (0 == strcmp(input_buf,"abb11ac_rcmeas_default"))// the strings are equal
    {     mexPrintf("abb11ac_rcmeas_default\n");
          abb11ac_rcmeas_default();
    }
    else if (0 == strcmp(input_buf,"abb11ac_adctune"))// the strings are equal
    {
        mexPrintf("abb11ac_adctune\n");
        count_calc = (int) mxGetScalar(prhs[1]);
        count_nom = (int) mxGetScalar(prhs[2]);
        
        mexPrintf("count_calc: %d count_nom: %d nlhs %d \n", count_calc, count_nom,nlhs );
        result =  abb11ac_adctune(count_calc,count_nom,&ctune);
        lhparam[0] = result;
        lhparam[1]= (int)ctune[0];
        lhparam[2]= (int)ctune[1];
        mexPrintf("result: %d \n", result);
        mexPrintf("ctune: %d ctune: %d\n", ctune[0], ctune[1]);
        
    }
    //***********************observe****************************
    else if (0 == strcmp(input_buf,"abb11ac_observe_vref_iref"))// the strings are equal
    {     mexPrintf("abb11ac_observe_vref_iref\n");
          abb11ac_observe_vref_iref();
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_biasldo"))// the strings are equal
    {     mexPrintf("abb11ac_observe_biasldo\n");
          abb11ac_observe_biasldo();
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_pll"))// the strings are equal
    {      mexPrintf("abb11ac_observe_pll\n");
           diagmodsel = (int) mxGetScalar(prhs[1]);
           mexPrintf("diagmodsel: %d\n", diagmodsel );
           abb11ac_observe_pll(diagmodsel);
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_mosmeas_vref_iref"))// the strings are equal
    {     mexPrintf("abb11ac_observe_mosmeas_vref_iref\n");
          abb11ac_observe_mosmeas_vref_iref();
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_antldo"))// the strings are equal
    {      mexPrintf("abb11ac_observe_antldo\n");
           antinex = (int) mxGetScalar(prhs[1]);
           mexPrintf("antinex: %d\n", antinex );
           abb11ac_observe_antldo(antinex);
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_antssi_vref"))// the strings are equal
    {      mexPrintf("abb11ac_observe_antssi_vref\n");
           antindex = (int) mxGetScalar(prhs[1]);
           mexPrintf("antindex: %d\n", antindex );
           abb11ac_observe_antssi_vref(antindex);
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_antssi_vcm"))// the strings are equal
    {      mexPrintf("abb11ac_observe_antssi_vcm\n");
           antindex = (int) mxGetScalar(prhs[1]);
           mexPrintf("antindex: %d\n", antindex );
           abb11ac_observe_antssi_vcm(antindex);
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_fsysldo"))// the strings are equal
    {     mexPrintf("abb11ac_observe_fsysldo\n");
          abb11ac_observe_fsysldo();
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_clkldo"))// the strings are equal
    {     mexPrintf("abb11ac_observe_clkldo\n");
          abb11ac_observe_clkldo();
    }
    else if (0 == strcmp(input_buf,"abb11ac_observe_default"))// the strings are equal
    {     mexPrintf("abb11ac_observe_default\n");
          abb11ac_observe_default();
    }
    //***************************************************
    /* else if (0 == strcmp(input_buf,"abb11ac_anamux_central_vref_imeas"))// the strings are equal
     * {      mexPrintf("abb11ac_anamux_central_vref_imeas\n");
     * abb11ac_anamux_central_vref_imeas();
     * }
     * else if (0 == strcmp(input_buf,"abb11ac_anamux_central_default"))// the strings are equal
     * {      mexPrintf("abb11ac_anamux_central_default\n");
     * abb11ac_anamux_central_default();
     * }*/
    else if (0 == strcmp(input_buf,"abb11ac_anamux_central_programming"))// the strings are equal
    {      mexPrintf("abb11ac_anamux_central_programming\n");
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_anamux_central_programming(value);
    }
    else if (0 == strcmp(input_buf,"abb11ac_anamux_central_antsel"))// the strings are equal
    {      mexPrintf("abb11ac_anamux_central_antsel\n");
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_anamux_central_antsel(value);
    }
    //*******************************************
    else if (0 == strcmp(input_buf,"abb11ac_bias_softfuse"))// the strings are equal
    {      mexPrintf("abb11ac_bias_softfuse\n");
           vref = (int) mxGetScalar(prhs[1]);
           iref = (int) mxGetScalar(prhs[2]);
           mexPrintf("vref: %d iref: %d\n", vref, iref );
           abb11ac_bias_softfuse(vref, iref);
    }
    else if (0 == strcmp(input_buf,"abb11ac_adc_efuse"))// the strings are equal
    {      mexPrintf("abb11ac_adc_efuse\n");
           /*antenna = (int) mxGetScalar(prhs[1]);
            * ctune = (int) mxGetScalar(prhs[2]);
            * clkinv = (int) mxGetScalar(prhs[3]);
            * mexPrintf("antenna: %d ctune: %d clkinv: %d\n", antenna, ctune, clkinv );
            * abb11ac_adc_efuse(antenna, ctune, clkinv);*/
    }
    else if (0 == strcmp(input_buf,"abb11ac_antenna_default"))// the strings are equal
    {      mexPrintf("abb11ac_antenna_default\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_antenna_default(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_rffcsi"))// the strings are equal
    {      mexPrintf("abb11ac_rffcsi\n");
           value_smt = (int) mxGetScalar(prhs[1]);
           value_sr = (int) mxGetScalar(prhs[2]);
           value_e = (int) mxGetScalar(prhs[3]);
           mexPrintf("value_smt: %d value_sr: %d value_e: %d\n", value_smt, value_sr, value_e );
           abb11ac_rffcsi(value_smt, value_sr, value_e);
    }
    else if (0 == strcmp(input_buf,"abb11ac_rf_oen"))// the strings are equal
    {      mexPrintf("abb11ac_rf_oen\n");
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_rf_oen(value);
    }
    else if (0 == strcmp(input_buf,"abb11ac_rf_usb"))// the strings are equal
    {      mexPrintf("abb11ac_rf_usb\n");
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_rf_usb(value);
    }
    else if (0 == strcmp(input_buf,"abb11ac_anamux_ant_sel"))// the strings are equal
    {      mexPrintf("abb11ac_anamux_ant_sel\n");
           antenna = (int) mxGetScalar(prhs[1]);
           value = (int) mxGetScalar(prhs[2]);
           mexPrintf("antenna: %d value: %d\n", antenna, value );
           abb11ac_anamux_ant_sel(antenna, value);
    }
    else if (0 == strcmp(input_buf,"abb11ac_ssi_test"))// the strings are equal
    {      mexPrintf("abb11ac_ssi_test\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_ssi_test(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_central_init"))// the strings are equal
    {      mexPrintf("abb11ac_central_init\n");
           abb11ac_central_init();
    }
    else if (0 == strcmp(input_buf,"abb11ac_antenna_init"))// the strings are equal
    {      mexPrintf("abb11ac_antenna_init\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_antenna_init(antenna);
    }
    else if (0 == strcmp(input_buf,"abb11ac_ant_config"))// the strings are equal
    {      mexPrintf("abb11ac_ant_config\n");
           antenna = (int) mxGetScalar(prhs[1]);
           bandwidth = (int) mxGetScalar(prhs[2]);
           ctune40M = (int) mxGetScalar(prhs[3]);
           ctune20M = (int) mxGetScalar(prhs[4]);
           adc_clkinv =(int) mxGetScalar(prhs[5]);
           mexPrintf("antenna: %d bandwidth: %d ctune40M: %d ctune20M: %d adc_clkinv: %d\n", antenna, bandwidth, ctune40M, ctune20M ,adc_clkinv);
           abb11ac_ant_config(antenna, bandwidth, ctune40M,ctune20M, adc_clkinv);
    }
        else if (0 == strcmp(input_buf,"abb11ac_ssi_se_mode"))// the strings are equal
    {      mexPrintf("abb11ac_ssi_se_mode\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_ssi_se_mode(antenna);
    }
            else if (0 == strcmp(input_buf,"abb11ac_ssi_diff_mode"))// the strings are equal
    {      mexPrintf("abb11ac_ssi_diff_mode\n");
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_ssi_diff_mode(antenna);
    }
    mxFree(input_buf);
    return;
}



void ABB_FCSI_Write_mex(uint16_t antenna,uint16_t  address,uint16_t value)

{
    mxArray  *input_array[3];
    
    input_array[0]=mxCreateDoubleScalar(antenna);
    input_array[1]=mxCreateDoubleScalar(address);
    input_array[2]=mxCreateDoubleScalar(value);
    
    mexCallMATLAB( 0,NULL, 3 ,&input_array[0],"BBS_ABB_FCSI_WRITE");
    
}
void ABB_FCSI_RMW_mex(uint16_t antenna,uint16_t  address,uint16_t mask, uint16_t value)

{
    mxArray  *input_array[4];
    
    input_array[0]=mxCreateDoubleScalar(antenna);
    input_array[1]=mxCreateDoubleScalar(address);
    input_array[2]=mxCreateDoubleScalar(mask);
    input_array[3]=mxCreateDoubleScalar(value);
    
    mexCallMATLAB( 0,NULL, 4 ,&input_array[0],"BBS_ABB_FCSI_RMW");
    
}

uint16_t ABB_FCSI_Read_mex(uint16_t antenna, uint16_t address, uint16_t *data)

{
    mxArray  *input_array[2];
    mxArray  *output_array[1];
    double_t *array_ptr_out;
    uint16_t out_param;
    
    input_array[0]=mxCreateDoubleScalar(antenna);
    input_array[1]=mxCreateDoubleScalar(address);
    
    mexCallMATLAB( 1, output_array, 2 ,&input_array[0],"BBS_ABB_FCSI_READ");
    
    array_ptr_out = mxGetPr(output_array[0]);
    out_param=(uint16_t)(*array_ptr_out);
    mexPrintf("param1_out: 0x%03x\n", out_param );
    return out_param;
    
}


void ABB_DIR_CTRL_WRITES_mex(uint16_t address ,uint16_t  mask ,uint16_t value)

{
    mxArray  *input_array[3];
    
    input_array[0]=mxCreateDoubleScalar(address);
    input_array[1]=mxCreateDoubleScalar(mask);
    input_array[2]=mxCreateDoubleScalar(value);
    
    mexCallMATLAB( 0,NULL, 3 ,&input_array[0],"SPI_WRITES");
    
}
void ABB_DIR_CTRL_WRITE_mex(uint16_t port_name, uint16_t value)

{
    mxArray  *input_array[2];
    
    input_array[0]=mxCreateDoubleScalar(port_name);
    input_array[1]=mxCreateDoubleScalar(value);
    
    mexCallMATLAB( 0,NULL, 2 ,&input_array[0],"SPI_WRITE");
    
    
}

uint16_t ABB_DIR_CTRL_READ_mex(uint16_t address)

{
    mxArray  *input_array[1];
    mxArray  *output_array[1];
    double_t *array_ptr_out;
    uint16_t out_param;
    input_array[0]=mxCreateDoubleScalar(address);
    
    mexCallMATLAB( 1, output_array, 1 ,&input_array[0],"SPI_READ");
    
    
    array_ptr_out = mxGetPr(output_array[0]);
    out_param=(uint16_t)(*array_ptr_out);
    mexPrintf("read output is: 0x%03x\n", out_param );
    return out_param;
}
