#include "mex.h"
#include <math.h>
#include "lib_abb11ac_api.c"



void check_parameter(int parameter1, int parameter2)
{
    if (parameter1 < parameter2+1)      //1- api_sting, 2-parameter1, 3-...
            mexErrMsgTxt("Wrong amount of parameters detected.");
}
            

// The gateway function
void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[])
{
    double      *lhparam0;
    char        *api_cmd;
    int         antenna;
    int         result;
    uint16_t    countvalue, ctune, rccount[3];
    uint16_t    count_calc,count_nom;
    int         diagmodsel;
    int         antenna_idx;
    int         value;
    int         vref, iref;
    int         value_smt, value_sr, value_e;
    int         bandwidth;
    int         clk_inv;
    double      *fuse_ptr;
    uint8_t     fuse[11];
    
    uint16_t    data[NR_OF_ANTENNAS];
    uint16_t    measdone;
    int         i;
    
   
    
    if (nrhs == 0)
        mexErrMsgTxt("No API command string assigned.");
 
    api_cmd = mxArrayToString(prhs[0]);

    plhs[0] = mxCreateDoubleMatrix(1,1, mxREAL);
//    plhs[1] = mxCreateDoubleMatrix(1,3, mxREAL);
    lhparam0 = mxGetPr(plhs[0]);
//    lhparam1 = mxGetPr(plhs[1]);
//    mexPrintf("Input Function: %s\n", api_cmd );

    

//***************central functions********************************
    if (0 == strcmp(api_cmd,"abb11ac_switchoff_lcpll_op_buf_pdn"))
    {
        mexPrintf("calling abb11ac_switchoff_lcpll_op_buf_pdn \n");
        abb11ac_switchoff_lcpll_op_buf_pdn();
    }

    else if (0 == strcmp(api_cmd,"abb11ac_init"))
    {
        mexPrintf("calling abb11ac_init \n");
        abb11ac_init();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_release_resetn_fcsi"))
    {
        mexPrintf("abb11ac_release_resetn_fcsi\n");
        abb11ac_release_resetn_fcsi();
    }

    else if (0 == strcmp(api_cmd,"abb11ac_pllsettings"))
    {
        mexPrintf("abb11ac_pllsettings\n");
        abb11ac_pllsettings();
    }

    else if (0 == strcmp(api_cmd,"abb11ac_pll_pup"))
    {    mexPrintf("abb11ac_pll_pup\n");
         abb11ac_pll_pup();
    }

    else if (0 == strcmp(api_cmd,"abb11ac_pll_release_reset"))
    {      mexPrintf("abb11ac_pll_release_reset\n");
           abb11ac_pll_release_reset();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_pup_clkldo"))
    {      mexPrintf("abb11ac_pup_clkldo\n");
           abb11ac_pup_clkldo();
    }
    else if (0 == strcmp(api_cmd,"abb11ac_pup_clkdistribution"))
    {      mexPrintf("abb11ac_pup_clkdistribution\n");
           abb11ac_pup_clkdistribution();
    }
    //**********************antenna functions*******************

    else if (0 == strcmp(api_cmd,"abb11ac_init1_antenna"))
    {      mexPrintf("abb11ac_init1_antenna ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_init1_antenna(antenna);
    }

    else if (0 == strcmp(api_cmd,"abb11ac_init2_antenna"))
    {      mexPrintf("abb11ac_init2_antenna ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_init2_antenna(antenna);
    }

    //********************TX-DAC functions****************************
    else if (0 == strcmp(api_cmd,"abb11ac_pup_dacmatrix"))
    {      mexPrintf("abb11ac_pup_dacmatrix ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_pup_dacmatrix(antenna);
    }

    else if (0 == strcmp(api_cmd,"abb11ac_pup_dacbuf"))
    {      mexPrintf("abb11ac_pup_dacbuf ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_pup_dacbuf(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_release_resetn_dac"))
    {      mexPrintf("abb11ac_release_resetn_dac ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_release_resetn_dac(antenna);
    }

    else if (0 == strcmp(api_cmd,"abb11ac_dac_11ac_mode"))
    {      mexPrintf("abb11ac_dac_11ac_mode");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_dac_11ac_mode(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_release_resetn_txiq"))
    {      mexPrintf("abb11ac_release_resetn_txiq ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_release_resetn_txiq(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_set_tx_on"))
    {     mexPrintf("abb11ac_set_tx_on ");
          check_parameter(nrhs,1);
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_set_tx_on(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_set_tx_data_valid"))
    {     mexPrintf("abb11ac_set_tx_data_valid ");
          check_parameter(nrhs,1);
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_set_tx_data_valid(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_TXDAC_default"))
    {      mexPrintf("abb11ac_TXDAC_default ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_TXDAC_default(antenna);
    }
    
    //******************SSI functions************************
    else if (0 == strcmp(api_cmd,"abb11ac_SSI_init"))
    {     mexPrintf("abb11ac_SSI_init ");
          check_parameter(nrhs,1);
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_SSI_init(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_set_ssi_on"))
    {     mexPrintf("abb11ac_set_ssi_on ");
          check_parameter(nrhs,1);
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_set_ssi_on(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_SSIADC_default"))
    {     mexPrintf("abb11ac_SSIADC_default ");
          check_parameter(nrhs,1);
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_SSIADC_default(antenna);
    }
    
    //***********RX-ADC functions***************************
    else if (0 == strcmp(api_cmd,"abb11ac_ensleep_on_rxadc"))
    {     mexPrintf("abb11ac_ensleep_on_rxadc ");
          check_parameter(nrhs,1);
          antenna = (int) mxGetScalar(prhs[1]);
          mexPrintf("antenna: %d\n", antenna );
          abb11ac_ensleep_on_rxadc(antenna);
    }

    else if (0 == strcmp(api_cmd,"abb11ac_config_rx_adc"))
    {      mexPrintf("abb11ac_config_rx_adc ");
           check_parameter(nrhs,2);
           antenna = (int) mxGetScalar(prhs[1]);
           ctune   = (int) mxGetScalar(prhs[2]);
           mexPrintf("antenna: %d ctune: %d\n", antenna, ctune );
           abb11ac_config_rx_adc(antenna, ctune);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_release_resetn_rxiq"))
    {      mexPrintf("abb11ac_release_resetn_rxiq ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_release_resetn_rxiq(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_set_rx_on"))
    {      mexPrintf("abb11ac_set_rx_on ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_set_rx_on(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_RXADC_default"))
    {      mexPrintf("abb11ac_RXADC_default ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_RXADC_default(antenna);
    }
    
    //**************** rcmeas *******************************
    else if (0 == strcmp(api_cmd,"abb11ac_rcmeas"))
    {      mexPrintf("abb11ac_rcmeas\n");
           result = abb11ac_rcmeas(&rccount[0]);

    }
/*
    else if (0 == strcmp(api_cmd,"abb11ac_rcmeas2"))
    {     mexPrintf("abb11ac_rcmeas2\n");
          countval1 = abb11ac_rcmeas2();
          lhparam[0] = countval1;
          mexPrintf("countval1: %d\n", count_calc );
          
    }
    else if (0 == strcmp(api_cmd,"abb11ac_rcmeas3"))
    {      mexPrintf("abb11ac_rcmeas3\n");
           countval1 = (int) mxGetScalar(prhs[1]);
           mexPrintf("countval1: %d\n", countval1 );
           count_calc = abb11ac_rcmeas3(countval1);
           lhparam[0] = count_calc;
           mexPrintf("count_calc: %d\n", count_calc );
           
    }
 */
    else if (0 == strcmp(api_cmd,"abb11ac_rcmeas_read_measdone"))
    {
        mexPrintf("abb11ac_rcmeas_read_measdone\n");
        result = abb11ac_rcmeas_read_measdone(&countvalue);
        *lhparam0 = (double) result;
        //lhparam2[0] = (double) countvalue;
        //mexPrintf("countvalue : %d\n", countvalue );
        mexPrintf("result     : %d\n", result );
        
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_rcmeas_default"))
    {     mexPrintf("abb11ac_rcmeas_default\n");
          abb11ac_rcmeas_default();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_adctune"))
    {
        mexPrintf("abb11ac_adctune\n");
        check_parameter(nrhs,2);
        count_calc = (int) mxGetScalar(prhs[1]);
        count_nom = (int) mxGetScalar(prhs[2]);
        
        mexPrintf("count_calc: %d count_nom: %d nlhs %d \n", count_calc, count_nom,nlhs );

        result =  abb11ac_adctune(count_calc,count_nom,&ctune);
        *lhparam0 = (double) ctune;
        //lhparam1[0]= (int)ctune[0];
        //lhparam1[1]= (int)ctune[1];
        mexPrintf("result: %d ctune: %d \n", result, ctune);
    }

    //***********************observe****************************
    else if (0 == strcmp(api_cmd,"abb11ac_observe_vref_iref"))
    {     mexPrintf("abb11ac_observe_vref_iref\n");
          abb11ac_observe_vref_iref();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_biasldo"))
    {     mexPrintf("abb11ac_observe_biasldo\n");
          abb11ac_observe_biasldo();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_pll"))
    {      mexPrintf("abb11ac_observe_pll ");
           check_parameter(nrhs,1);
           diagmodsel = (int) mxGetScalar(prhs[1]);
           mexPrintf("diagmodsel: %d\n", diagmodsel );
           abb11ac_observe_pll(diagmodsel);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_mosmeas_vref_iref"))
    {     mexPrintf("abb11ac_observe_mosmeas_vref_iref\n");
          abb11ac_observe_mosmeas_vref_iref();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_antldo"))
    {      mexPrintf("abb11ac_observe_antldo ");
           check_parameter(nrhs,1);
           antenna_idx = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna_idx: %d\n", antenna_idx );
           abb11ac_observe_antldo(antenna_idx);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_antssi_vref"))
    {      mexPrintf("abb11ac_observe_antssi_vref ");
           check_parameter(nrhs,1);
           antenna_idx = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna_idx: %d\n", antenna_idx );
           abb11ac_observe_antssi_vref(antenna_idx);
    }
    else if (0 == strcmp(api_cmd,"abb11ac_observe_antssi_vcm"))
    {      mexPrintf("abb11ac_observe_antssi_vcm ");
           check_parameter(nrhs,1);
           antenna_idx = (int) mxGetScalar(prhs[1]);
           mexPrintf("antindex: %d\n", antenna_idx );
           abb11ac_observe_antssi_vcm(antenna_idx);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_fsysldo"))
    {     mexPrintf("abb11ac_observe_fsysldo\n");
          abb11ac_observe_fsysldo();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_clkldo"))
    {     mexPrintf("abb11ac_observe_clkldo\n");
          abb11ac_observe_clkldo();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_observe_default"))
    {     mexPrintf("abb11ac_observe_default\n");
          abb11ac_observe_default();
    }
    //***************************************************
    /* else if (0 == strcmp(api_cmd,"abb11ac_anamux_central_vref_imeas"))
     * {      mexPrintf("abb11ac_anamux_central_vref_imeas\n");
     * abb11ac_anamux_central_vref_imeas();
     * }
     * else if (0 == strcmp(api_cmd,"abb11ac_anamux_central_default"))
     * {      mexPrintf("abb11ac_anamux_central_default\n");
     * abb11ac_anamux_central_default();
     * }*/
    
    else if (0 == strcmp(api_cmd,"abb11ac_anamux_central_programming"))
    {      mexPrintf("abb11ac_anamux_central_programming ");
           check_parameter(nrhs,1);
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_anamux_central_programming(value);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_anamux_central_antsel"))
    {      mexPrintf("abb11ac_anamux_central_antsel ");
           check_parameter(nrhs,1);
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_anamux_central_antsel(value);
    }

    //*******************************************
    else if (0 == strcmp(api_cmd,"abb11ac_bias_softfuse"))
    {      mexPrintf("abb11ac_bias_softfuse ");
           check_parameter(nrhs,2);
           vref = (int) mxGetScalar(prhs[1]);
           iref = (int) mxGetScalar(prhs[2]);
           mexPrintf("vref: %d iref: %d\n", vref, iref );
           abb11ac_bias_softfuse(vref, iref);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_adc_efuse"))
    {      mexPrintf("abb11ac_adc_efuse\n");
           /*antenna = (int) mxGetScalar(prhs[1]);
            * ctune = (int) mxGetScalar(prhs[2]);
            * clkinv = (int) mxGetScalar(prhs[3]);
            * mexPrintf("antenna: %d ctune: %d clkinv: %d\n", antenna, ctune, clkinv );
            * abb11ac_adc_efuse(antenna, ctune, clkinv);*/
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_antenna_default"))
    {      mexPrintf("abb11ac_antenna_default ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_antenna_default(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_rffcsi"))
    {      mexPrintf("abb11ac_rffcsi ");
           check_parameter(nrhs,3);
           value_smt = (int) mxGetScalar(prhs[1]);
           value_sr  = (int) mxGetScalar(prhs[2]);
           value_e   = (int) mxGetScalar(prhs[3]);
           mexPrintf("value_smt: %d value_sr: %d value_e: %d\n", value_smt, value_sr, value_e );
           abb11ac_rffcsi(value_smt, value_sr, value_e);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_rf_oen"))
    {      mexPrintf("abb11ac_rf_oen ");
           check_parameter(nrhs,1);
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_rf_oen(value);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_rf_usb"))
    {      mexPrintf("abb11ac_rf_usb\n");
           check_parameter(nrhs,1);
           value = (int) mxGetScalar(prhs[1]);
           mexPrintf("value: %d\n", value );
           abb11ac_rf_usb(value);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_anamux_ant_sel"))
    {      mexPrintf("abb11ac_anamux_ant_sel ");
           check_parameter(nrhs,2);
           antenna = (int) mxGetScalar(prhs[1]);
           value   = (int) mxGetScalar(prhs[2]);
           mexPrintf("antenna: %d value: %d\n", antenna, value );
           abb11ac_anamux_ant_sel(antenna, value);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_ssi_test"))
    {      mexPrintf("abb11ac_ssi_test ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_ssi_test(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_central_init"))
    {      mexPrintf("abb11ac_central_init\n");
           abb11ac_central_init();
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_antenna_init"))
    {      mexPrintf("abb11ac_antenna_init ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_antenna_init(antenna);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_ant_config"))
    {      mexPrintf("abb11ac_ant_config ");
           check_parameter(nrhs,3);
           antenna = (int) mxGetScalar(prhs[1]);
           bandwidth = (int) mxGetScalar(prhs[2]);
           ctune   = (int) mxGetScalar(prhs[3]);
           mexPrintf("antenna: %d bandwidth: %d ctune: %d\n", antenna, bandwidth, ctune);
           abb11ac_ant_config(antenna, bandwidth, ctune);
    }
    
    else if (0 == strcmp(api_cmd,"abb11ac_ssi_se_mode"))
    {      mexPrintf("abb11ac_ssi_se_mode ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_ssi_se_mode(antenna);
    }
    else if (0 == strcmp(api_cmd,"abb11ac_ssi_diff_mode"))
    {      mexPrintf("abb11ac_ssi_diff_mode ");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_ssi_diff_mode(antenna);
    }
    else if (0 == strcmp(api_cmd,"abb11ac_antenna_fuse_values"))
    {      mexPrintf("abb11ac_antenna_fuse_values ");
           check_parameter(nrhs,2);
           antenna = (int) mxGetScalar(prhs[1]);
           clk_inv = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d clk_inv: %d\n", antenna, clk_inv);
           abb11ac_antenna_fuse_values(antenna, clk_inv);
    }
    else if (0 == strcmp(api_cmd,"abb11ac_fusing"))
    {      mexPrintf("abb11ac_fusing ");
           check_parameter(nrhs,1);
           fuse_ptr =  mxGetPr(prhs[1]);
           value = mxGetN(prhs[1]);     // number of rows
           mexPrintf(" array with %d elements detected\n", value);
           if (value <11)  mexErrMsgTxt("array size must be at least 11 paramters");
           
           //Matlab can handle only double as default -> cast 
           for(i=0; i<11; i++)  {
	          fuse[i] = (uint16_t)fuse_ptr[i];
           }

           result = abb11ac_fusing(fuse);
    }
    else if (0 == strcmp(api_cmd,"abb11ac_ABB_pup_sequence"))
    {      mexPrintf("abb11ac_ABB_pup_sequence ");
           check_parameter(nrhs,1);
           fuse_ptr =  mxGetPr(prhs[1]);
           value = mxGetN(prhs[1]);     // number of rows
           mexPrintf(" array with %d elements detected\n", value);
           if (value <11)  mexErrMsgTxt("array size must be at least 11 paramters");
           
           //Matlab can handle only double as default -> cast 
           for(i=0; i<11; i++)  {
	          fuse[i] = (uint8_t)fuse_ptr[i];
           }

           result = abb11ac_ABB_pup_sequence(fuse);
    }
    
    
    else if (0 == strcmp(api_cmd,"abb11ac_reset_FCSI"))
    {      mexPrintf("abb11ac_reset_FCSI\n");
           abb11ac_reset_FCSI();
    }
    else if (0 == strcmp(api_cmd,"abb11ac_reset_pulse_dac"))
    {      mexPrintf("abb11ac_reset_pulse_dac\n");
           check_parameter(nrhs,1);
           antenna = (int) mxGetScalar(prhs[1]);
           mexPrintf("antenna: %d\n", antenna );
           abb11ac_reset_pulse_dac(antenna);
    }
    else if (0 == strcmp(api_cmd,"abb11ac_pllpup_sequence"))
    {      mexPrintf("abb11ac_pllpup_sequence\n");
           result = abb11ac_pllpup_sequence();
    }

    // for debugging
    else if (0 == strcmp(api_cmd,"test"))
    {      mexPrintf("test\n");
           measdone =0;
           i=0;
           while ((measdone == 0) && (i < 15))
           {
                 ABB_FCSI_Read(ABB_CENTRAL, CENTRAL_FCSI_REG23RCMEASI, data); // expected low
	             measdone = CENTRAL_FCSI_REG23RCMEASI_RCTUNINGMEASDONE__GET(data[ABB_CENTRAL_INDEX]);
                 i = i+1;
                 mexPrintf(":%d %d\n", measdone, i );
           }
           
           result = i;

    }

    else
    {   mexPrintf("API command : %s\n", api_cmd );       
        mexErrMsgTxt("not found.");
    }
    
    *lhparam0 = (double) result;
    //lhparam1[0]= (double) rccount[0];
    //lhparam1[1]= (double) rccount[1];
    //lhparam1[2]= (double) rccount[2];
    
    
    mxFree(api_cmd);
    return;
}



void ABB_FCSI_Write_mex(uint16_t antenna, uint16_t  address, uint16_t value)
{
    mxArray  *input_array[3];
    
    input_array[0]=mxCreateDoubleScalar((double)antenna);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0, NULL, 3 ,&input_array[0], "BBS_ABB_FCSI_WRITE");
    
}

void ABB_FCSI_RMW_mex(uint16_t antenna,uint16_t address, uint16_t mask, uint16_t value)
{
    mxArray  *input_array[4];
    
    input_array[0]=mxCreateDoubleScalar((double)antenna);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)mask);
    input_array[3]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0,NULL, 4 , &input_array[0], "BBS_ABB_FCSI_RMW");
    
}

uint16_t ABB_FCSI_Read_mex(uint16_t antenna, uint16_t address, uint16_t *data)
{
    mxArray  *input_array[2];
    mxArray  *output_array[1];
    double_t *read_par;
    uint16_t out_param = 1;
    
    input_array[0]=mxCreateDoubleScalar((double)antenna);
    input_array[1]=mxCreateDoubleScalar((double)address);
    
    mexCallMATLAB(1, output_array, 2 , &input_array[0], "BBS_ABB_FCSI_READ");
    
    read_par = mxGetPr(output_array[0]);
    
    //casting of arrays has to be done manually
    data[0]=(uint16_t)read_par[0];
    data[1]=(uint16_t)read_par[1];
    data[2]=(uint16_t)read_par[2];
    data[3]=(uint16_t)read_par[3];
    data[4]=(uint16_t)read_par[4];
    
    //mexPrintf("D0: %x D1: %x D2: %x D3: %x D4: %x \n", data[0], data[1], data[2], data[3], data[4] );

    return out_param;
}

void ABB_DIR_CTRL_WRITES_mex(uint16_t address ,uint16_t  mask ,uint16_t value)
{
    mxArray  *input_array[3];
    
    input_array[0]=mxCreateDoubleScalar((double)address);
    input_array[1]=mxCreateDoubleScalar((double)mask);
    input_array[2]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0,NULL, 3 ,&input_array[0],"SPI_WRITES");
}

void ABB_DIR_CTRL_WRITE_mex(uint16_t port_name, uint16_t value)
{
    mxArray  *input_array[2];
    
    input_array[0]=mxCreateDoubleScalar((double)port_name);
    input_array[1]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0,NULL, 2 ,&input_array[0],"SPI_WRITE");
}

uint16_t ABB_DIR_CTRL_READ_mex(uint16_t address)
{
    mxArray  *input_array[1];
    mxArray  *output_array[1];
    double_t *array_ptr_out;
    uint16_t out_param;
    input_array[0]=mxCreateDoubleScalar((double)address);
    
    mexCallMATLAB( 1, output_array, 1 ,&input_array[0],"SPI_READ");
    
    array_ptr_out = mxGetPr(output_array[0]);
    out_param=(uint16_t) *array_ptr_out;
    return out_param;
}

void ABB_wait(uint32_t time, uint32_t unit)
{
//    _NOP();
}

