#ifndef _TARGET_H
#define _TARGET_H

//#include "tb_sysc_c_inf.h"
//#include "bench_sysc_c_inf.h"

//#include "ipvi_iobus_dpi.h"
//#include "io_sysc_c_inf.h"   // we have no jtag support yet !
//#include "jc_sysc_c_inf.h"

#include "lib_dpi.h"

#define io_write(addr, data)       _io_write(addr, data);
#define io_read(addr)              _io_read(addr);
#define get_time(unit)             _get_time(unit);

#define SUCCESS  0
#define FAILURE -1

#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
// for compatibility with old (VHDL) bus driver

#define _setport(portid, level)   _bench_write(portid, level);
#define _getport(portid)          _bench_read(portid);

// void _wait(int expr, int mode); // why was wait in here ?

#define _outh(data, addr)        _io_write(addr, data);
#define _outb(data, addr)        _io_write(addr, data);
#define _outw(data, addr)        _io_write(addr, data);
#define _inh(addr)               _io_read(addr);
#define _inb(addr)               _io_read(addr);
#define _inw(addr)               _io_read(addr);

#define T_PORT0   0x00
#define T_PORT1   0x01
#define T_PORT2   0x02
#define T_PORT3   0x03
#define T_PORT4   0x04
#define T_PORT5   0x05
#define T_PORT6   0x06
#define T_PORT7   0x07
#define T_PORT8   0x08
#define T_PORT9   0x09
#define T_PORT10  0x0A
#define T_PORT11  0x0B
#define T_PORT12  0x0C
#define T_PORT13  0x0D
#define T_PORT14  0x0E
#define T_PORT15  0x0F
#define T_PORT16  0x10
#define T_PORT17  0x11
#define T_PORT18  0x12
#define T_PORT19  0x13
#define T_PORT20  0x14
#define T_PORT21  0x15
#define T_PORT22  0x16
#define T_PORT23  0x17
#define T_PORT24  0x18
#define T_PORT25  0x19
#define T_PORT26  0x1A
#define T_PORT27  0x1B
#define T_PORT28  0x1C
#define T_PORT29  0x1D
#define T_PORT30  0x1E
#define T_PORT31  0x1F
#define T_PORT128 0x007F
#define T_PORT4096 0x0FFF

#define T_INT0    0x10C0
#define T_INT1    0x10C1
#define T_INT2    0x10C2
#define T_INT3    0x10C3
#define T_INT4    0x10C4
#define T_INT5    0x10C5
#define T_INT6    0x10C6
#define T_INT7    0x10C7
#define T_INT8    0x10C8
#define T_INT9    0x10C9
#define T_INT10   0x10CA
#define T_INT11   0x10CB
#define T_INT12   0x10CC
#define T_INT13   0x10CD
#define T_INT14   0x10CE
#define T_INT15   0x10CF

#ifndef T_MSEC
#define T_MSEC    0x20FE
#endif

#ifndef T_USEC
#define T_USEC    0x20FD
#endif

#ifndef T_NSEC
#define T_NSEC    0x20FC
#endif

#ifndef T_PSEC
#define T_PSEC    0x20FB
#endif

#ifndef T_CYCLES
#define T_CYCLES  0x20FF
#endif

//#ifndef SC_FS_C
// #define	SC_FS_C 0
// #define	SC_PS_C 1
 #define        SC_PS_C T_PSEC
 #define	SC_NS_C T_NSEC
 #define	SC_US_C T_USEC
 #define	SC_MS_C T_MSEC
// #define	SC_SEC_C 5
//#endif 

#endif 
