//###############################################
//#####-------------------------------------#####
//#####------ MODULES TABLE -------------#####
//#####-------------------------------------#####
//###############################################
function createModulesTable1Init (moduleArray, identifier, searchRegExp) {
  var head = document.getElementById (identifier + "Head");
  var body = document.getElementById (identifier + "Body0");

  if (head !== null) {
    head.innerHTML += createToggleImage (identifier);
  }

  var tableStatus = new TableStatus (6);
  // TABLE: | Module | Long Name | #sub-modules | #ports | #buses | Description |
  // init sort
  tableStatus.id = identifier + "TableStatus";
  // tableStatus.sortEnabled [X] = false;
  // tableStatus.sortTypes [X] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  tableStatus.filterEnabled [2] = false;
  tableStatus.filterEnabled [3] = false;
  tableStatus.filterEnabled [4] = false;
  // tableStatus.filterTypes [X] = "number";
  // tableStatus.filterSet [X] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  // tableStatus.combineCell [X] = true;

  tableStatus.hookFunctionName = "hookModuleTable1";

  window [tableStatus.id] = tableStatus;

  hookModuleTable1 (body, moduleArray, null, tableStatus, searchRegExp);
}

function hookModuleTable1 (tableReference, moduleArray, viewName, tableStatus, searchRegExp) {
  // generate data array
  buildModuleTable1Array (moduleArray, tableStatus);
  // generate table
  createModuleTable1 (tableReference, moduleArray, tableStatus, searchRegExp);
}

function buildModuleTable1Array (moduleArray, tableStatus) {
  // TABLE: | Module | Long Name | #sub-modules | #ports | #buses | Description |
  var bodyArray = new Array;
  // build bodyArray
  for (var idx = moduleArray.length - 1; idx >= 0; idx--) {
    bodyArray [idx] = new Array;
    var module = window [moduleArray [idx]];
    // Name
    var pos = 0;
    bodyArray [idx] [pos] = module.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = module.longName;
    // Sub-Modules
    pos++;
    bodyArray [idx] [pos] = module.modules.length.toString ();
    // Ports
    pos++;
    bodyArray [idx] [pos] = module.ports.length.toString ();
    // Buses
    pos++;
    bodyArray [idx] [pos] = module.buses.length.toString ();
    // Description
    pos++;
    bodyArray [idx] [pos] = module.description.toString ();
    // Module reference
    pos++;
    bodyArray [idx] [pos] = module;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createModuleTable1 (tableReference, moduleArray, tableStatus, searchRegExp) {
  // TABLE: | Module | Long Name | #sub-modules | #ports | #buses | Description |
  var body = tableReference;
  var bodyCells = tableStatus.tableArray;

  var one = document.createElement ("sup");
  one.innerHTML = "1";
  var two = document.createElement ("sup");
  two.innerHTML = "2";
  var three = document.createElement ("sup");
  three.innerHTML = "3";
  var four = document.createElement ("sup");
  four.innerHTML = "4";
  var five = document.createElement ("sup");
  five.innerHTML = "5";
  // TABLE: | Module | Long Name | #sub-modules | #ports | #buses | Description |
  var headerCellNames = [ "Name", "Long Name", "Sub-Modules", "Ports",
      "Buses", "Description" ];
  var headerCellTitles = [ "", "", "", "", "", "" ];
  var row;
  var cell;
  var link;

  // create header
  row = document.createElement ("tr");
  for (pos in headerCellNames) {
    cell = document.createElement ("th");
    cell.className = tableStatus.sortClassNames [pos];
    cell.title = headerCellTitles [pos];
    cell.innerHTML = headerCellNames [pos];
    if (tableStatus.sortEnabled [pos] === true) {
      createSortHook (body, cell, pos, moduleArray, "", tableStatus);
    }
    row.appendChild (cell);
  }
  body.appendChild (row);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    createFilterInput (body, moduleArray, "", tableStatus);
  } else if (tableStatus.filterRow !== null) {
    refreshFilterInput2 (body, tableStatus);
  }

  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var module = bodyCells [line] [bodyCells [line].length - 3];
    var isView = (module.isView == "true");
    row = document.createElement ("tr");
    if (isView === true) {
      row.className = "viewmodule";
    } else if (line % 2 === 0) {
      row.className = "interleave";
    }

    // Name
    var pos = 0;
    cell = document.createElement ("td");
    link = document.createElement ("a");
    // cell.className = "emph";
    link.href = "module.html?" + module.jsName;
    link.title = getAliasContextName (module, true);
    if (searchRegExp !== undefined) {
      link.innerHTML = highlightSearch (bodyCells [line] [pos], searchRegExp);
    } else {
      link.innerHTML = bodyCells [line] [pos];
    }
    cell.appendChild (link);
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // #Sub-Modules
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // #Ports
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // #Buses
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Append ROW
    body.appendChild (row);
  }
}
